/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.block.entity.FuelValues;

public interface SlotDisplay {
    public static final Codec<SlotDisplay> CODEC = BuiltInRegistries.SLOT_DISPLAY.byNameCodec().dispatch(SlotDisplay::type, Type::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, SlotDisplay> STREAM_CODEC = ByteBufCodecs.registry(Registries.SLOT_DISPLAY).dispatch(SlotDisplay::type, Type::streamCodec);

    public <T> Stream<T> resolve(ContextMap var1, DisplayContentsFactory<T> var2);

    public Type<? extends SlotDisplay> type();

    default public boolean isEnabled(FeatureFlagSet features) {
        return true;
    }

    default public List<ItemStack> resolveForStacks(ContextMap parameters) {
        return this.resolve(parameters, ItemStackContentsFactory.INSTANCE).toList();
    }

    default public ItemStack resolveForFirstStack(ContextMap context) {
        return this.resolve(context, ItemStackContentsFactory.INSTANCE).findFirst().orElse(ItemStack.EMPTY);
    }

    public static class ItemStackContentsFactory
    implements DisplayContentsFactory.ForStacks<ItemStack> {
        public static final ItemStackContentsFactory INSTANCE = new ItemStackContentsFactory();

        @Override
        @Override
        public ItemStack forStack(ItemStack itemStack) {
            return itemStack;
        }

        @Override
        public /* synthetic */ Object forStack(ItemStack stack) {
            return this.forStack(stack);
        }
    }

    public record WithRemainder(SlotDisplay input, SlotDisplay remainder) implements SlotDisplay
    {
        public static final MapCodec<WithRemainder> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("input").forGetter(WithRemainder::input), (App)CODEC.fieldOf("remainder").forGetter(WithRemainder::remainder)).apply((Applicative)instance, WithRemainder::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WithRemainder> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC, WithRemainder::input, STREAM_CODEC, WithRemainder::remainder, WithRemainder::new);
        public static final Type<WithRemainder> TYPE = new Type<WithRemainder>(MAP_CODEC, STREAM_CODEC);

        @Override
        public Type<WithRemainder> type() {
            return TYPE;
        }

        @Override
        @Override
        public <T> Stream<T> resolve(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.ForRemainders) {
                DisplayContentsFactory.ForRemainders forRemainders = (DisplayContentsFactory.ForRemainders)factory;
                List list = this.remainder.resolve(parameters, factory).toList();
                return this.input.resolve(parameters, factory).map(input -> forRemainders.addRemainder(input, list));
            }
            return this.input.resolve(parameters, factory);
        }

        @Override
        @Override
        public boolean isEnabled(FeatureFlagSet features) {
            return this.input.isEnabled(features) && this.remainder.isEnabled(features);
        }
    }

    public record Composite(List<SlotDisplay> contents) implements SlotDisplay
    {
        public static final MapCodec<Composite> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.listOf().fieldOf("contents").forGetter(Composite::contents)).apply((Applicative)instance, Composite::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Composite> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC.apply(ByteBufCodecs.list()), Composite::contents, Composite::new);
        public static final Type<Composite> TYPE = new Type<Composite>(MAP_CODEC, STREAM_CODEC);

        @Override
        public Type<Composite> type() {
            return TYPE;
        }

        @Override
        @Override
        public <T> Stream<T> resolve(ContextMap parameters, DisplayContentsFactory<T> factory) {
            return this.contents.stream().flatMap(display -> display.resolve(parameters, factory));
        }

        @Override
        @Override
        public boolean isEnabled(FeatureFlagSet features) {
            return this.contents.stream().allMatch(child -> child.isEnabled(features));
        }
    }

    public record TagSlotDisplay(TagKey<Item> tag) implements SlotDisplay
    {
        public static final MapCodec<TagSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter(TagSlotDisplay::tag)).apply((Applicative)instance, TagSlotDisplay::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TagSlotDisplay> STREAM_CODEC = StreamCodec.composite(TagKey.streamCodec(Registries.ITEM), TagSlotDisplay::tag, TagSlotDisplay::new);
        public static final Type<TagSlotDisplay> TYPE = new Type<TagSlotDisplay>(MAP_CODEC, STREAM_CODEC);

        @Override
        public Type<TagSlotDisplay> type() {
            return TYPE;
        }

        @Override
        @Override
        public <T> Stream<T> resolve(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)factory;
                HolderLookup.Provider provider = parameters.getOptional(SlotDisplayContext.REGISTRIES);
                if (provider != null) {
                    return provider.lookupOrThrow(Registries.ITEM).get(this.tag).map(tag -> tag.stream().map(forStacks::forStack)).stream().flatMap(values -> values);
                }
            }
            return Stream.empty();
        }
    }

    public record ItemStackSlotDisplay(ItemStack stack) implements SlotDisplay
    {
        public static final MapCodec<ItemStackSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("item").forGetter(ItemStackSlotDisplay::stack)).apply((Applicative)instance, ItemStackSlotDisplay::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackSlotDisplay> STREAM_CODEC = StreamCodec.composite(ItemStack.STREAM_CODEC, ItemStackSlotDisplay::stack, ItemStackSlotDisplay::new);
        public static final Type<ItemStackSlotDisplay> TYPE = new Type<ItemStackSlotDisplay>(MAP_CODEC, STREAM_CODEC);

        @Override
        public Type<ItemStackSlotDisplay> type() {
            return TYPE;
        }

        @Override
        @Override
        public <T> Stream<T> resolve(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)factory;
                return Stream.of(forStacks.forStack(this.stack));
            }
            return Stream.empty();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Override
        public boolean equals(Object object) {
            if (this == object) return true;
            if (!(object instanceof ItemStackSlotDisplay)) return false;
            ItemStackSlotDisplay itemStackSlotDisplay = (ItemStackSlotDisplay)object;
            if (!ItemStack.matches(this.stack, itemStackSlotDisplay.stack)) return false;
            return true;
        }

        @Override
        @Override
        public boolean isEnabled(FeatureFlagSet features) {
            return this.stack.getItem().isEnabled(features);
        }
    }

    public record ItemSlotDisplay(Holder<Item> item) implements SlotDisplay
    {
        public static final MapCodec<ItemSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.CODEC.fieldOf("item").forGetter(ItemSlotDisplay::item)).apply((Applicative)instance, ItemSlotDisplay::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemSlotDisplay> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.ITEM), ItemSlotDisplay::item, ItemSlotDisplay::new);
        public static final Type<ItemSlotDisplay> TYPE = new Type<ItemSlotDisplay>(MAP_CODEC, STREAM_CODEC);

        public ItemSlotDisplay(Item item) {
            this(item.builtInRegistryHolder());
        }

        @Override
        public Type<ItemSlotDisplay> type() {
            return TYPE;
        }

        @Override
        @Override
        public <T> Stream<T> resolve(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)factory;
                return Stream.of(forStacks.forStack(this.item));
            }
            return Stream.empty();
        }

        @Override
        @Override
        public boolean isEnabled(FeatureFlagSet features) {
            return this.item.value().isEnabled(features);
        }
    }

    public record SmithingTrimDemoSlotDisplay(SlotDisplay base, SlotDisplay material, SlotDisplay pattern) implements SlotDisplay
    {
        public static final MapCodec<SmithingTrimDemoSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("base").forGetter(SmithingTrimDemoSlotDisplay::base), (App)CODEC.fieldOf("material").forGetter(SmithingTrimDemoSlotDisplay::material), (App)CODEC.fieldOf("pattern").forGetter(SmithingTrimDemoSlotDisplay::pattern)).apply((Applicative)instance, SmithingTrimDemoSlotDisplay::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimDemoSlotDisplay> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC, SmithingTrimDemoSlotDisplay::base, STREAM_CODEC, SmithingTrimDemoSlotDisplay::material, STREAM_CODEC, SmithingTrimDemoSlotDisplay::pattern, SmithingTrimDemoSlotDisplay::new);
        public static final Type<SmithingTrimDemoSlotDisplay> TYPE = new Type<SmithingTrimDemoSlotDisplay>(MAP_CODEC, STREAM_CODEC);

        @Override
        public Type<SmithingTrimDemoSlotDisplay> type() {
            return TYPE;
        }

        @Override
        @Override
        public <T> Stream<T> resolve(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)factory;
                HolderLookup.Provider provider = parameters.getOptional(SlotDisplayContext.REGISTRIES);
                if (provider != null) {
                    RandomSource randomSource = RandomSource.create(System.identityHashCode(this));
                    List<ItemStack> list = this.base.resolveForStacks(parameters);
                    if (list.isEmpty()) {
                        return Stream.empty();
                    }
                    List<ItemStack> list2 = this.material.resolveForStacks(parameters);
                    if (list2.isEmpty()) {
                        return Stream.empty();
                    }
                    List<ItemStack> list3 = this.pattern.resolveForStacks(parameters);
                    if (list3.isEmpty()) {
                        return Stream.empty();
                    }
                    return Stream.generate(() -> {
                        ItemStack itemStack = (ItemStack)Util.getRandom(list, randomSource);
                        ItemStack itemStack2 = (ItemStack)Util.getRandom(list2, randomSource);
                        ItemStack itemStack3 = (ItemStack)Util.getRandom(list3, randomSource);
                        return SmithingTrimRecipe.applyTrim(provider, itemStack, itemStack2, itemStack3);
                    }).limit(256L).filter(stack -> !stack.isEmpty()).limit(16L).map(forStacks::forStack);
                }
            }
            return Stream.empty();
        }
    }

    public static class AnyFuel
    implements SlotDisplay {
        public static final AnyFuel INSTANCE = new AnyFuel();
        public static final MapCodec<AnyFuel> MAP_CODEC = MapCodec.unit((Object)INSTANCE);
        public static final StreamCodec<RegistryFriendlyByteBuf, AnyFuel> STREAM_CODEC = StreamCodec.unit(INSTANCE);
        public static final Type<AnyFuel> TYPE = new Type<AnyFuel>(MAP_CODEC, STREAM_CODEC);

        private AnyFuel() {
        }

        @Override
        public Type<AnyFuel> type() {
            return TYPE;
        }

        @Override
        public String toString() {
            return "<any fuel>";
        }

        @Override
        @Override
        public <T> Stream<T> resolve(ContextMap parameters, DisplayContentsFactory<T> factory) {
            if (factory instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)factory;
                FuelValues fuelValues = parameters.getOptional(SlotDisplayContext.FUEL_VALUES);
                if (fuelValues != null) {
                    return fuelValues.fuelItems().stream().map(forStacks::forStack);
                }
            }
            return Stream.empty();
        }
    }

    public static class Empty
    implements SlotDisplay {
        public static final Empty INSTANCE = new Empty();
        public static final MapCodec<Empty> MAP_CODEC = MapCodec.unit((Object)INSTANCE);
        public static final StreamCodec<RegistryFriendlyByteBuf, Empty> STREAM_CODEC = StreamCodec.unit(INSTANCE);
        public static final Type<Empty> TYPE = new Type<Empty>(MAP_CODEC, STREAM_CODEC);

        private Empty() {
        }

        @Override
        public Type<Empty> type() {
            return TYPE;
        }

        @Override
        public String toString() {
            return "<empty>";
        }

        @Override
        @Override
        public <T> Stream<T> resolve(ContextMap parameters, DisplayContentsFactory<T> factory) {
            return Stream.empty();
        }
    }

    public record Type<T extends SlotDisplay>(MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
    }
}

