/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;
import org.purpurmc.purpur.PurpurConfig;

public class ItemEnchantments
implements TooltipProvider {
    private static final Comparator<Holder<Enchantment>> ENCHANTMENT_ORDER = Comparator.comparing(Holder::getRegisteredName);
    public static final ItemEnchantments EMPTY = new ItemEnchantments((Object2IntAVLTreeMap<Holder<Enchantment>>)new Object2IntAVLTreeMap(ENCHANTMENT_ORDER), true);
    private static final Codec<Integer> LEVEL_CODEC = Codec.intRange((int)1, (int)(PurpurConfig.clampEnchantLevels ? 255 : Short.MAX_VALUE));
    private static final Codec<Object2IntAVLTreeMap<Holder<Enchantment>>> LEVELS_CODEC = Codec.unboundedMap(Enchantment.CODEC, LEVEL_CODEC).xmap(m -> {
        Object2IntAVLTreeMap map = new Object2IntAVLTreeMap(ENCHANTMENT_ORDER);
        map.putAll(m);
        return map;
    }, Function.identity());
    private static final Codec<ItemEnchantments> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LEVELS_CODEC.fieldOf("levels").forGetter(component -> component.enchantments), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(component -> component.showInTooltip)).apply((Applicative)instance, ItemEnchantments::new));
    public static final Codec<ItemEnchantments> CODEC = Codec.withAlternative(FULL_CODEC, LEVELS_CODEC, map -> new ItemEnchantments((Object2IntAVLTreeMap<Holder<Enchantment>>)map, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantments> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.map(v -> new Object2IntAVLTreeMap(ENCHANTMENT_ORDER), Enchantment.STREAM_CODEC, ByteBufCodecs.VAR_INT), component -> component.enchantments, ByteBufCodecs.BOOL, component -> component.showInTooltip, ItemEnchantments::new);
    final Object2IntAVLTreeMap<Holder<Enchantment>> enchantments;
    public final boolean showInTooltip;

    ItemEnchantments(Object2IntAVLTreeMap<Holder<Enchantment>> enchantments, boolean showInTooltip) {
        this.enchantments = enchantments;
        this.showInTooltip = showInTooltip;
        for (Object2IntMap.Entry entry : enchantments.object2IntEntrySet()) {
            int i = entry.getIntValue();
            if (i >= 0 && i <= (PurpurConfig.clampEnchantLevels ? 255 : Short.MAX_VALUE)) continue;
            throw new IllegalArgumentException("Enchantment " + String.valueOf(entry.getKey()) + " has invalid level " + i);
        }
    }

    public int getLevel(Holder<Enchantment> enchantment) {
        return this.enchantments.getInt(enchantment);
    }

    @Override
    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
        if (this.showInTooltip) {
            HolderLookup.Provider provider = context.registries();
            HolderSet<Enchantment> holderSet = ItemEnchantments.getTagOrEmpty(provider, Registries.ENCHANTMENT, EnchantmentTags.TOOLTIP_ORDER);
            for (Holder holder : holderSet) {
                int i = this.enchantments.getInt((Object)holder);
                if (i <= 0) continue;
                tooltip.accept(Enchantment.getFullname(holder, i));
            }
            for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
                Holder holder2 = (Holder)entry.getKey();
                if (holderSet.contains(holder2)) continue;
                tooltip.accept(Enchantment.getFullname((Holder)entry.getKey(), entry.getIntValue()));
            }
        }
    }

    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.Provider registries, ResourceKey<Registry<T>> registryRef, TagKey<T> tooltipOrderTag) {
        Optional<HolderSet.Named<T>> optional;
        if (registries != null && (optional = registries.lookupOrThrow(registryRef).get(tooltipOrderTag)).isPresent()) {
            return optional.get();
        }
        return HolderSet.direct(new Holder[0]);
    }

    public ItemEnchantments withTooltip(boolean showInTooltip) {
        return new ItemEnchantments(this.enchantments, showInTooltip);
    }

    public Set<Holder<Enchantment>> keySet() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<Enchantment>>> entrySet() {
        return Collections.unmodifiableSet(this.enchantments.object2IntEntrySet());
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof ItemEnchantments)) return false;
        ItemEnchantments itemEnchantments = (ItemEnchantments)object;
        if (this.showInTooltip != itemEnchantments.showInTooltip) return false;
        if (!this.enchantments.equals(itemEnchantments.enchantments)) return false;
        return true;
    }

    public int hashCode() {
        int i = this.enchantments.hashCode();
        return 31 * i + (this.showInTooltip ? 1 : 0);
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + String.valueOf(this.enchantments) + ", showInTooltip=" + this.showInTooltip + "}";
    }

    public static class Mutable {
        private final Object2IntAVLTreeMap<Holder<Enchantment>> enchantments = new Object2IntAVLTreeMap(ENCHANTMENT_ORDER);
        public boolean showInTooltip;

        public Mutable(ItemEnchantments enchantmentsComponent) {
            this.enchantments.putAll(enchantmentsComponent.enchantments);
            this.showInTooltip = enchantmentsComponent.showInTooltip;
        }

        public void set(Holder<Enchantment> enchantment, int level) {
            if (level <= 0) {
                this.enchantments.removeInt(enchantment);
            } else {
                this.enchantments.put(enchantment, Math.min(level, PurpurConfig.clampEnchantLevels ? 255 : Short.MAX_VALUE));
            }
        }

        public void upgrade(Holder<Enchantment> enchantment, int level) {
            if (level > 0) {
                this.enchantments.merge(enchantment, Math.min(level, PurpurConfig.clampEnchantLevels ? 255 : Short.MAX_VALUE), Integer::max);
            }
        }

        public void removeIf(Predicate<Holder<Enchantment>> predicate) {
            this.enchantments.keySet().removeIf(predicate);
        }

        public int getLevel(Holder<Enchantment> enchantment) {
            return this.enchantments.getOrDefault(enchantment, 0);
        }

        public Set<Holder<Enchantment>> keySet() {
            return this.enchantments.keySet();
        }

        public ItemEnchantments toImmutable() {
            return new ItemEnchantments(this.enchantments, this.showInTooltip);
        }
    }
}

