/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.phys.Vec3;

public record EnchantmentAttributeEffect(ResourceLocation id, Holder<Attribute> attribute, LevelBasedValue amount, AttributeModifier.Operation operation) implements EnchantmentLocationBasedEffect
{
    public static final MapCodec<EnchantmentAttributeEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(EnchantmentAttributeEffect::id), (App)Attribute.CODEC.fieldOf("attribute").forGetter(EnchantmentAttributeEffect::attribute), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(EnchantmentAttributeEffect::amount), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(EnchantmentAttributeEffect::operation)).apply((Applicative)instance, EnchantmentAttributeEffect::new));

    private ResourceLocation idForSlot(StringRepresentable suffix) {
        return this.id.withSuffix("/" + suffix.getSerializedName());
    }

    public AttributeModifier getModifier(int value, StringRepresentable suffix) {
        return new AttributeModifier(this.idForSlot(suffix), this.amount().calculate(value), this.operation());
    }

    @Override
    @Override
    public void onChangedBlock(ServerLevel world, int level, EnchantedItemInUse context, Entity user, Vec3 pos, boolean newlyApplied) {
        if (newlyApplied && user instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)user;
            livingEntity.getAttributes().addTransientAttributeModifiers((Multimap<Holder<Attribute>, AttributeModifier>)this.makeAttributeMap(level, context.inSlot()));
        }
    }

    @Override
    @Override
    public void onDeactivated(EnchantedItemInUse context, Entity user, Vec3 pos, int level) {
        if (user instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)user;
            livingEntity.getAttributes().removeAttributeModifiers((Multimap<Holder<Attribute>, AttributeModifier>)this.makeAttributeMap(level, context.inSlot()));
        }
    }

    private HashMultimap<Holder<Attribute>, AttributeModifier> makeAttributeMap(int level, EquipmentSlot slot) {
        HashMultimap hashMultimap = HashMultimap.create();
        hashMultimap.put(this.attribute, (Object)this.getModifier(level, slot));
        return hashMultimap;
    }

    @Override
    public MapCodec<EnchantmentAttributeEffect> codec() {
        return CODEC;
    }
}

