/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;

public record ArmorMaterial(int durability, Map<ArmorType, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient, ResourceLocation modelId) {
    public Item.Properties humanoidProperties(Item.Properties settings, ArmorType equipmentType) {
        return settings.durability(equipmentType.getDurability(this.durability)).attributes(this.createAttributes(equipmentType)).enchantable(this.enchantmentValue).component(DataComponents.EQUIPPABLE, Equippable.builder(equipmentType.getSlot()).setEquipSound(this.equipSound).setModel(this.modelId).build()).repairable(this.repairIngredient);
    }

    public Item.Properties animalProperties(Item.Properties settings, HolderSet<EntityType<?>> allowedEntities) {
        return settings.durability(ArmorType.BODY.getDurability(this.durability)).attributes(this.createAttributes(ArmorType.BODY)).repairable(this.repairIngredient).component(DataComponents.EQUIPPABLE, Equippable.builder(EquipmentSlot.BODY).setEquipSound(this.equipSound).setModel(this.modelId).setAllowedEntities(allowedEntities).build());
    }

    public Item.Properties animalProperties(Item.Properties settings, Holder<SoundEvent> equipSound, boolean damageOnHurt, HolderSet<EntityType<?>> allowedEntities) {
        if (damageOnHurt) {
            settings = settings.durability(ArmorType.BODY.getDurability(this.durability)).repairable(this.repairIngredient);
        }
        return settings.attributes(this.createAttributes(ArmorType.BODY)).component(DataComponents.EQUIPPABLE, Equippable.builder(EquipmentSlot.BODY).setEquipSound(equipSound).setModel(this.modelId).setAllowedEntities(allowedEntities).setDamageOnHurt(damageOnHurt).build());
    }

    private ItemAttributeModifiers createAttributes(ArmorType equipmentType) {
        int i = this.defense.getOrDefault(equipmentType, 0);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot(equipmentType.getSlot());
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace("armor." + equipmentType.getName());
        builder.add(Attributes.ARMOR, new AttributeModifier(resourceLocation, i, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourceLocation, this.toughness, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        if (this.knockbackResistance > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourceLocation, this.knockbackResistance, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        }
        return builder.build();
    }
}

