/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment.trim;

import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.trim.TrimPattern;

public class TrimPatterns {
    public static final ResourceKey<TrimPattern> SENTRY = TrimPatterns.registryKey("sentry");
    public static final ResourceKey<TrimPattern> DUNE = TrimPatterns.registryKey("dune");
    public static final ResourceKey<TrimPattern> COAST = TrimPatterns.registryKey("coast");
    public static final ResourceKey<TrimPattern> WILD = TrimPatterns.registryKey("wild");
    public static final ResourceKey<TrimPattern> WARD = TrimPatterns.registryKey("ward");
    public static final ResourceKey<TrimPattern> EYE = TrimPatterns.registryKey("eye");
    public static final ResourceKey<TrimPattern> VEX = TrimPatterns.registryKey("vex");
    public static final ResourceKey<TrimPattern> TIDE = TrimPatterns.registryKey("tide");
    public static final ResourceKey<TrimPattern> SNOUT = TrimPatterns.registryKey("snout");
    public static final ResourceKey<TrimPattern> RIB = TrimPatterns.registryKey("rib");
    public static final ResourceKey<TrimPattern> SPIRE = TrimPatterns.registryKey("spire");
    public static final ResourceKey<TrimPattern> WAYFINDER = TrimPatterns.registryKey("wayfinder");
    public static final ResourceKey<TrimPattern> SHAPER = TrimPatterns.registryKey("shaper");
    public static final ResourceKey<TrimPattern> SILENCE = TrimPatterns.registryKey("silence");
    public static final ResourceKey<TrimPattern> RAISER = TrimPatterns.registryKey("raiser");
    public static final ResourceKey<TrimPattern> HOST = TrimPatterns.registryKey("host");
    public static final ResourceKey<TrimPattern> FLOW = TrimPatterns.registryKey("flow");
    public static final ResourceKey<TrimPattern> BOLT = TrimPatterns.registryKey("bolt");

    public static void bootstrap(BootstrapContext<TrimPattern> registry) {
        TrimPatterns.register(registry, Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, SENTRY);
        TrimPatterns.register(registry, Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, DUNE);
        TrimPatterns.register(registry, Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, COAST);
        TrimPatterns.register(registry, Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE, WILD);
        TrimPatterns.register(registry, Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, WARD);
        TrimPatterns.register(registry, Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, EYE);
        TrimPatterns.register(registry, Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, VEX);
        TrimPatterns.register(registry, Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, TIDE);
        TrimPatterns.register(registry, Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, SNOUT);
        TrimPatterns.register(registry, Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, RIB);
        TrimPatterns.register(registry, Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, SPIRE);
        TrimPatterns.register(registry, Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, WAYFINDER);
        TrimPatterns.register(registry, Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, SHAPER);
        TrimPatterns.register(registry, Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, SILENCE);
        TrimPatterns.register(registry, Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, RAISER);
        TrimPatterns.register(registry, Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, HOST);
        TrimPatterns.register(registry, Items.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE, FLOW);
        TrimPatterns.register(registry, Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE, BOLT);
    }

    public static Optional<Holder.Reference<TrimPattern>> getFromTemplate(HolderLookup.Provider registries, ItemStack stack) {
        return registries.lookupOrThrow(Registries.TRIM_PATTERN).listElements().filter(pattern -> stack.is(((TrimPattern)pattern.value()).templateItem())).findFirst();
    }

    public static void register(BootstrapContext<TrimPattern> registry, Item template, ResourceKey<TrimPattern> key) {
        TrimPattern trimPattern = new TrimPattern(key.location(), BuiltInRegistries.ITEM.wrapAsHolder(template), Component.translatable(Util.makeDescriptionId("trim_pattern", key.location())), false);
        registry.register(key, trimPattern);
    }

    private static ResourceKey<TrimPattern> registryKey(String id) {
        return ResourceKey.create(Registries.TRIM_PATTERN, ResourceLocation.withDefaultNamespace(id));
    }
}

