/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.util.MCUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public abstract class BaseSpawner {
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EVENT_SPAWN = 1;
    public int spawnDelay = 20;
    public SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.empty();
    @Nullable
    public SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    public int minSpawnDelay = 200;
    public int maxSpawnDelay = 800;
    public int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    public int maxNearbyEntities = 6;
    public int requiredPlayerRange = 16;
    public int spawnRange = 4;
    private int tickDelay = 0;

    public void setEntityId(EntityType<?> type, @Nullable Level world, RandomSource random, BlockPos pos) {
        this.getOrCreateNextSpawnData(world, random, pos).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(type).toString());
        this.spawnPotentials = SimpleWeightedRandomList.empty();
    }

    public boolean isNearPlayer(Level world, BlockPos pos) {
        if (world.purpurConfig.spawnerDeactivateByRedstone && world.hasNeighborSignal(pos)) {
            return false;
        }
        return world.hasNearbyAlivePlayerThatAffectsSpawning((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(Level world, BlockPos pos) {
        if (!this.isNearPlayer(world, pos)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource randomsource = world.getRandom();
            double d0 = (double)pos.getX() + randomsource.nextDouble();
            double d1 = (double)pos.getY() + randomsource.nextDouble();
            double d2 = (double)pos.getZ() + randomsource.nextDouble();
            world.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            world.addParticle(ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel world, BlockPos pos) {
        if (this.spawnCount <= 0 || this.maxNearbyEntities <= 0) {
            return;
        }
        if (this.spawnDelay > 0 && --this.tickDelay > 0) {
            return;
        }
        this.tickDelay = world.paperConfig().tickRates.mobSpawner;
        if (this.tickDelay == -1) {
            return;
        }
        if (this.isNearPlayer(world, pos)) {
            if (this.spawnDelay < -this.tickDelay) {
                this.delay(world, pos);
            }
            if (this.spawnDelay > 0) {
                this.spawnDelay -= this.tickDelay;
            } else {
                boolean flag = false;
                RandomSource randomsource = world.getRandom();
                SpawnData mobspawnerdata = this.getOrCreateNextSpawnData(world, randomsource, pos);
                for (int i = 0; i < this.spawnCount; ++i) {
                    SpawnData.CustomSpawnRules mobspawnerdata_a;
                    double d2;
                    CompoundTag nbttagcompound = mobspawnerdata.getEntityToSpawn();
                    Optional<EntityType<?>> optional = EntityType.by(nbttagcompound);
                    if (optional.isEmpty()) {
                        this.delay(world, pos);
                        return;
                    }
                    ListTag nbttaglist = nbttagcompound.getList("Pos", 6);
                    int j = nbttaglist.size();
                    double d0 = j >= 1 ? nbttaglist.getDouble(0) : (double)pos.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5;
                    double d1 = j >= 2 ? nbttaglist.getDouble(1) : (double)(pos.getY() + randomsource.nextInt(3) - 1);
                    double d = d2 = j >= 3 ? nbttaglist.getDouble(2) : (double)pos.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.spawnRange + 0.5;
                    if (!world.noCollision(optional.get().getSpawnAABB(d0, d1, d2))) continue;
                    BlockPos blockposition1 = BlockPos.containing(d0, d1, d2);
                    if (!mobspawnerdata.getCustomSpawnRules().isPresent() ? !SpawnPlacements.checkSpawnRules(optional.get(), world, EntitySpawnReason.SPAWNER, blockposition1, world.getRandom()) : !optional.get().getCategory().isFriendly() && world.getDifficulty() == Difficulty.PEACEFUL || !(mobspawnerdata_a = mobspawnerdata.getCustomSpawnRules().get()).isValidPosition(blockposition1, world)) continue;
                    PreSpawnerSpawnEvent event = new PreSpawnerSpawnEvent(MCUtil.toLocation(world, d0, d1, d2), CraftEntityType.minecraftToBukkit(optional.get()), MCUtil.toLocation(world, pos));
                    if (!event.callEvent()) {
                        flag = true;
                        if (!event.shouldAbortSpawn()) continue;
                        break;
                    }
                    Entity entity = EntityType.loadEntityRecursive(nbttagcompound, world, EntitySpawnReason.SPAWNER, entity1 -> {
                        entity1.moveTo(d0, d1, d2, entity1.getYRot(), entity1.getXRot());
                        return entity1;
                    });
                    if (entity == null) {
                        this.delay(world, pos);
                        return;
                    }
                    int k = world.getEntities(EntityTypeTest.forExactClass(entity.getClass()), new AABB(pos.getX(), pos.getY(), pos.getZ(), pos.getX() + 1, pos.getY() + 1, pos.getZ() + 1).inflate(this.spawnRange), EntitySelector.NO_SPECTATORS).size();
                    if (k >= this.maxNearbyEntities) {
                        this.delay(world, pos);
                        return;
                    }
                    entity.preserveMotion = true;
                    entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), randomsource.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        boolean flag1;
                        Mob entityinsentient = (Mob)entity;
                        if (mobspawnerdata.getCustomSpawnRules().isEmpty() && !entityinsentient.checkSpawnRules(world, EntitySpawnReason.SPAWNER) || !entityinsentient.checkSpawnObstruction(world)) continue;
                        boolean bl = flag1 = mobspawnerdata.getEntityToSpawn().size() == 1 && mobspawnerdata.getEntityToSpawn().contains("id", 8);
                        if (flag1) {
                            ((Mob)entity).finalizeSpawn(world, world.getCurrentDifficultyAt(entity.blockPosition()), EntitySpawnReason.SPAWNER, null);
                        }
                        Optional<EquipmentTable> optional1 = mobspawnerdata.getEquipment();
                        Objects.requireNonNull(entityinsentient);
                        optional1.ifPresent(entityinsentient::equip);
                        if (entityinsentient.level().spigotConfig.nerfSpawnerMobs) {
                            entityinsentient.aware = false;
                        }
                    }
                    entity.spawnedViaMobSpawner = true;
                    entity.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                    flag = true;
                    if (CraftEventFactory.callSpawnerSpawnEvent(entity, pos).isCancelled()) continue;
                    if (!world.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                        this.delay(world, pos);
                        return;
                    }
                    world.levelEvent(2004, pos, 0);
                    world.gameEvent(entity, GameEvent.ENTITY_PLACE, blockposition1);
                    if (!(entity instanceof Mob)) continue;
                    ((Mob)entity).spawnAnim();
                }
                if (flag) {
                    this.delay(world, pos);
                }
            }
        }
    }

    public void delay(Level world, BlockPos pos) {
        RandomSource randomsource = world.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(randomsource).ifPresent(weightedentry_b -> this.setNextSpawnData(world, pos, (SpawnData)weightedentry_b.data()));
        this.broadcastEvent(world, pos, 1);
    }

    public void load(@Nullable Level world, BlockPos pos, CompoundTag nbt) {
        boolean flag1;
        this.spawnDelay = nbt.contains("Paper.Delay") ? nbt.getInt("Paper.Delay") : (int)nbt.getShort("Delay");
        boolean flag = nbt.contains(SPAWN_DATA_TAG, 10);
        if (flag) {
            SpawnData mobspawnerdata = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getCompound(SPAWN_DATA_TAG)).resultOrPartial(s -> LOGGER.warn("Invalid SpawnData: {}", s)).orElseGet(SpawnData::new);
            this.setNextSpawnData(world, pos, mobspawnerdata);
        }
        if (flag1 = nbt.contains("SpawnPotentials", 9)) {
            ListTag nbttaglist = nbt.getList("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbttaglist).resultOrPartial(s -> LOGGER.warn("Invalid SpawnPotentials list: {}", s)).orElseGet(SimpleWeightedRandomList::empty);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.single(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData());
        }
        if (nbt.contains("Paper.MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.getInt("Paper.MinSpawnDelay");
            this.maxSpawnDelay = nbt.getInt("Paper.MaxSpawnDelay");
            this.spawnCount = nbt.getShort("SpawnCount");
        } else if (nbt.contains("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.getInt("MinSpawnDelay");
            this.maxSpawnDelay = nbt.getInt("MaxSpawnDelay");
            this.spawnCount = nbt.getShort("SpawnCount");
        }
        if (nbt.contains("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = nbt.getShort("RequiredPlayerRange");
        }
        if (nbt.contains("SpawnRange", 99)) {
            this.spawnRange = nbt.getShort("SpawnRange");
        }
        this.displayEntity = null;
    }

    public CompoundTag save(CompoundTag nbt) {
        if (this.spawnDelay > Short.MAX_VALUE) {
            nbt.putInt("Paper.Delay", this.spawnDelay);
        }
        nbt.putShort("Delay", (short)Math.min(Short.MAX_VALUE, this.spawnDelay));
        if (this.minSpawnDelay > Short.MAX_VALUE || this.maxSpawnDelay > Short.MAX_VALUE) {
            nbt.putInt("Paper.MinSpawnDelay", this.minSpawnDelay);
            nbt.putInt("Paper.MaxSpawnDelay", this.maxSpawnDelay);
        }
        nbt.putShort("MinSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.minSpawnDelay));
        nbt.putShort("MaxSpawnDelay", (short)Math.min(Short.MAX_VALUE, this.maxSpawnDelay));
        nbt.putShort("SpawnCount", (short)this.spawnCount);
        nbt.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        nbt.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        nbt.putShort("SpawnRange", (short)this.spawnRange);
        if (this.nextSpawnData != null) {
            nbt.put(SPAWN_DATA_TAG, (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.nextSpawnData).getOrThrow(s -> new IllegalStateException("Invalid SpawnData: " + s)));
        }
        nbt.put("SpawnPotentials", (Tag)SpawnData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.spawnPotentials).getOrThrow());
        return nbt;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level world, BlockPos pos) {
        if (this.displayEntity == null) {
            CompoundTag nbttagcompound = this.getOrCreateNextSpawnData(world, world.getRandom(), pos).getEntityToSpawn();
            if (!nbttagcompound.contains("id", 8)) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive(nbttagcompound, world, EntitySpawnReason.SPAWNER, Function.identity());
            if (nbttagcompound.size() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level world, int status) {
        if (status == 1) {
            if (world.isClientSide) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    public void setNextSpawnData(@Nullable Level world, BlockPos pos, SpawnData spawnEntry) {
        this.nextSpawnData = spawnEntry;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level world, RandomSource random, BlockPos pos) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(world, pos, this.spawnPotentials.getRandom(random).map(WeightedEntry.Wrapper::data).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

