/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.ThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.dfl.DefaultEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.antixray.ChunkPacketBlockController;
import com.destroystokyo.paper.antixray.ChunkPacketBlockControllerAntiXray;
import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.papermc.paper.configuration.WorldConfiguration;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CapturedBlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.util.CraftSpawnCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.purpurmc.purpur.PurpurWorldConfig;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class Level
implements LevelAccessor,
AutoCloseable,
ChunkSystemLevel,
ChunkSystemEntityGetter {
    public static final Codec<ResourceKey<Level>> RESOURCE_KEY_CODEC = ResourceKey.codec(Registries.DIMENSION);
    public static final ResourceKey<Level> OVERWORLD = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("overworld"));
    public static final ResourceKey<Level> NETHER = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("the_nether"));
    public static final ResourceKey<Level> END = ResourceKey.create(Registries.DIMENSION, ResourceLocation.withDefaultNamespace("the_end"));
    public static final int MAX_LEVEL_SIZE = 30000000;
    public static final int LONG_PARTICLE_CLIP_RANGE = 512;
    public static final int SHORT_PARTICLE_CLIP_RANGE = 32;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int TICKS_PER_DAY = 24000;
    public static final int MAX_ENTITY_SPAWN_Y = 20000000;
    public static final int MIN_ENTITY_SPAWN_Y = -20000000;
    public final List<TickingBlockEntity> blockEntityTickers = Lists.newArrayList();
    protected final NeighborUpdater neighborUpdater;
    private final List<TickingBlockEntity> pendingBlockEntityTickers = Lists.newArrayList();
    private boolean tickingBlockEntities;
    public final Thread thread;
    private final boolean isDebug;
    private int skyDarken;
    protected int randValue = RandomSource.create().nextInt();
    protected final int addend = 1013904223;
    protected float oRainLevel;
    public float rainLevel;
    protected float oThunderLevel;
    public float thunderLevel;
    public final RandomSource random = new ThreadUnsafeRandom(RandomSupport.generateUniqueSeed());
    @Deprecated
    private final RandomSource threadSafeRandom = RandomSource.createThreadSafe();
    private final Holder<DimensionType> dimensionTypeRegistration;
    public final WritableLevelData levelData;
    public final boolean isClientSide;
    private final WorldBorder worldBorder;
    private final BiomeManager biomeManager;
    private final ResourceKey<Level> dimension;
    private final RegistryAccess registryAccess;
    private final DamageSources damageSources;
    private long subTickCount;
    private final CraftWorld world;
    public boolean pvpMode;
    public ChunkGenerator generator;
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public boolean isBlockPlaceCancelled = false;
    public Map<BlockPos, CraftBlockState> capturedBlockStates = new LinkedHashMap<BlockPos, CraftBlockState>();
    public Map<BlockPos, BlockEntity> capturedTileEntities = new LinkedHashMap<BlockPos, BlockEntity>();
    public List<ItemEntity> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public int wakeupInactiveRemainingAnimals;
    public int wakeupInactiveRemainingFlying;
    public int wakeupInactiveRemainingMonsters;
    public int wakeupInactiveRemainingVillagers;
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    private final WorldConfiguration paperConfig;
    public final ChunkPacketBlockController chunkPacketBlockController;
    public final PurpurWorldConfig purpurConfig;
    public static BlockPos lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;
    public final Map<ServerExplosion.CacheKey, Float> explosionDensityCache = new HashMap<ServerExplosion.CacheKey, Float>();
    public ArrayDeque<RedstoneTorchBlock.Toggle> redstoneUpdateInfos;
    private Cache<BreedingCooldownPair, Object> playerBreedingCooldowns;
    private EntityLookup entityLookup;
    private final ConcurrentLong2ReferenceChainedHashTable<ChunkData> chunkData = new ConcurrentLong2ReferenceChainedHashTable();
    private static final FluidState AIR_FLUIDSTATE;
    private final int minY;
    private final int height;
    private final int maxY;
    private final int minSectionY;
    private final int maxSectionY;
    private final int sectionsCount;

    public WorldConfiguration paperConfig() {
        return this.paperConfig;
    }

    private Cache<BreedingCooldownPair, Object> getNewBreedingCooldownCache() {
        return CacheBuilder.newBuilder().expireAfterWrite((long)this.purpurConfig.animalBreedingCooldownSeconds, TimeUnit.SECONDS).build();
    }

    public void resetBreedingCooldowns() {
        this.playerBreedingCooldowns = this.getNewBreedingCooldownCache();
    }

    public boolean hasBreedingCooldown(UUID player, Class<? extends Animal> animalType) {
        return this.playerBreedingCooldowns.getIfPresent((Object)new BreedingCooldownPair(player, animalType)) != null;
    }

    public void addBreedingCooldown(UUID player, Class<? extends Animal> animalType) {
        this.playerBreedingCooldowns.put((Object)new BreedingCooldownPair(player, animalType), new Object());
    }

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public boolean hasChunk(int chunkX, int chunkZ) {
        return this.getChunkIfLoaded(chunkX, chunkZ) != null;
    }

    private int getTicksPerSpawn(SpawnCategory spawnCategory) {
        int perWorld = this.paperConfig().entities.spawning.ticksPerSpawn.getInt((Object)CraftSpawnCategory.toNMS(spawnCategory));
        if (perWorld >= 0) {
            return perWorld;
        }
        return this.getCraftServer().getTicksPerSpawns(spawnCategory);
    }

    public abstract ResourceKey<LevelStem> getTypeKey();

    @Override
    public final EntityLookup moonrise$getEntityLookup() {
        return this.entityLookup;
    }

    @Override
    public final void moonrise$setEntityLookup(EntityLookup entityLookup) {
        if (this.entityLookup != null && !(this.entityLookup instanceof DefaultEntityLookup)) {
            throw new IllegalStateException("Entity lookup already initialised");
        }
        this.entityLookup = entityLookup;
    }

    @Override
    public final <T extends net.minecraft.world.entity.Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB boundingBox, Predicate<? super T> predicate) {
        Profiler.get().incrementCounter("getEntities");
        ArrayList ret = new ArrayList();
        this.moonrise$getEntityLookup().getEntities(entityClass, null, boundingBox, ret, predicate);
        return ret;
    }

    @Override
    public final List<net.minecraft.world.entity.Entity> moonrise$getHardCollidingEntities(net.minecraft.world.entity.Entity entity, AABB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        Profiler.get().incrementCounter("getEntities");
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        this.moonrise$getEntityLookup().getHardCollidingEntities(entity, box, ret, predicate);
        return ret;
    }

    @Override
    public LevelChunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return (LevelChunk)this.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
    }

    @Override
    public ChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        return this.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.EMPTY, false);
    }

    @Override
    public ChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        return this.getChunkSource().getChunk(chunkX, chunkZ, leastStatus, false);
    }

    @Override
    public void moonrise$midTickTasks() {
    }

    @Override
    public final ChunkData moonrise$getChunkData(long chunkKey) {
        return this.chunkData.get(chunkKey);
    }

    @Override
    public final ChunkData moonrise$getChunkData(int chunkX, int chunkZ) {
        return this.chunkData.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    @Override
    public final ChunkData moonrise$requestChunkData(long chunkKey) {
        return this.chunkData.compute(chunkKey, (keyInMap, valueInMap) -> {
            if (valueInMap == null) {
                ChunkData ret = new ChunkData();
                ret.increaseRef();
                return ret;
            }
            valueInMap.increaseRef();
            return valueInMap;
        });
    }

    @Override
    public final ChunkData moonrise$releaseChunkData(long chunkKey) {
        return this.chunkData.compute(chunkKey, (keyInMap, chunkData) -> chunkData.decreaseRef() == 0 ? null : chunkData);
    }

    @Override
    public boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ChunkSource chunkSource = this.getChunkSource();
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.hasChunk(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasChunksAt(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return this.moonrise$areChunksLoaded(minBlockX >> 4, minBlockZ >> 4, maxBlockX >> 4, maxBlockZ >> 4);
    }

    @Override
    public ChunkAccess getChunk(int x, int z, ChunkStatus status) {
        return this.getChunk(x, z, status, true);
    }

    @Override
    public BlockPos getHeightmapPos(Heightmap.Types types, BlockPos blockPos) {
        return new BlockPos(blockPos.getX(), this.getHeight(types, blockPos.getX(), blockPos.getZ()), blockPos.getZ());
    }

    @Override
    public boolean isUnobstructed(net.minecraft.world.entity.Entity entity) {
        AABB boundingBox = entity.getBoundingBox();
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        List<net.minecraft.world.entity.Entity> entities = this.getEntities(entity, boundingBox.inflate(-1.0E-7, -1.0E-7, -1.0E-7), null);
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            net.minecraft.world.entity.Entity otherEntity = entities.get(i);
            if (otherEntity.isSpectator() || otherEntity.isRemoved() || !otherEntity.blocksBuilding || otherEntity.isPassengerOfSameVehicle(entity)) continue;
            return false;
        }
        return true;
    }

    private static BlockHitResult miss(ClipContext clipContext) {
        Vec3 to = clipContext.getTo();
        Vec3 from = clipContext.getFrom();
        return BlockHitResult.miss(to, Direction.getApproximateNearest(from.x - to.x, from.y - to.y, from.z - to.z), BlockPos.containing(to.x, to.y, to.z));
    }

    private static BlockHitResult fastClip(Vec3 from, Vec3 to, Level level, ClipContext clipContext) {
        double adjX = 1.0E-7 * (from.x - to.x);
        double adjY = 1.0E-7 * (from.y - to.y);
        double adjZ = 1.0E-7 * (from.z - to.z);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return Level.miss(clipContext);
        }
        double toXAdj = to.x - adjX;
        double toYAdj = to.y - adjY;
        double toZAdj = to.z - adjZ;
        double fromXAdj = from.x + adjX;
        double fromYAdj = from.y + adjY;
        double fromZAdj = from.z + adjZ;
        int currX = Mth.floor(fromXAdj);
        int currY = Mth.floor(fromYAdj);
        int currZ = Mth.floor(fromZAdj);
        BlockPos.MutableBlockPos currPos = new BlockPos.MutableBlockPos();
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - Mth.frac(fromXAdj) : Mth.frac(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - Mth.frac(fromYAdj) : Mth.frac(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - Mth.frac(fromZAdj) : Mth.frac(fromZAdj));
        LevelChunkSection[] lastChunk = null;
        PalettedContainer<BlockState> lastSection = null;
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkY = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        int minSection = WorldUtil.getMinSection(level);
        while (true) {
            BlockState blockState;
            currPos.set(currX, currY, currZ);
            int newChunkX = currX >> 4;
            int newChunkY = currY >> 4;
            int newChunkZ = currZ >> 4;
            int chunkDiff = newChunkX ^ lastChunkX | newChunkZ ^ lastChunkZ;
            int chunkYDiff = newChunkY ^ lastChunkY;
            if ((chunkDiff | chunkYDiff) != 0) {
                int sectionY;
                if (chunkDiff != 0) {
                    lastChunk = level.getChunk(newChunkX, newChunkZ).getSections();
                }
                lastSection = (sectionY = newChunkY - minSection) >= 0 && sectionY < lastChunk.length ? lastChunk[sectionY].states : null;
                lastChunkX = newChunkX;
                lastChunkY = newChunkY;
                lastChunkZ = newChunkZ;
            }
            if (lastSection != null && !(blockState = lastSection.get(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8)).isAir()) {
                VoxelShape fluidCollision;
                BlockHitResult fluidHit;
                FluidState fluidState;
                BlockHitResult blockHit;
                VoxelShape blockCollision = clipContext.getBlockShape(blockState, level, currPos);
                BlockHitResult blockHitResult = blockHit = blockCollision.isEmpty() ? null : level.clipWithInteractionOverride(from, to, currPos, blockCollision, blockState);
                if (clipContext.fluid != ClipContext.Fluid.NONE && (fluidState = blockState.getFluidState()) != AIR_FLUIDSTATE && (fluidHit = (fluidCollision = clipContext.getFluidShape(fluidState, level, currPos)).clip(from, to, currPos)) != null) {
                    if (blockHit == null) {
                        return fluidHit;
                    }
                    return from.distanceToSqr(blockHit.getLocation()) <= from.distanceToSqr(fluidHit.getLocation()) ? blockHit : fluidHit;
                }
                if (blockHit != null) {
                    return blockHit;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return Level.miss(clipContext);
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    @Override
    public BlockHitResult clip(ClipContext clipContext) {
        return Level.fastClip(clipContext.getFrom(), clipContext.getTo(), this, clipContext);
    }

    @Override
    public boolean collidesWithSuffocatingBlock(net.minecraft.world.entity.Entity entity, AABB box) {
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, 8, (state, pos) -> state.isSuffocating(this, (BlockPos)pos));
    }

    private static VoxelShape inflateAABBToVoxel(AABB aabb, double x, double y, double z) {
        return Shapes.create(aabb.minX - x, aabb.minY - y, aabb.minZ - z, aabb.maxX + x, aabb.maxY + y, aabb.maxZ + z);
    }

    @Override
    public Optional<Vec3> findFreePosition(net.minecraft.world.entity.Entity entity, VoxelShape boundsShape, Vec3 fromPosition, double rangeX, double rangeY, double rangeZ) {
        if (boundsShape.isEmpty()) {
            return Optional.empty();
        }
        double expandByX = rangeX * 0.5;
        double expandByY = rangeY * 0.5;
        double expandByZ = rangeZ * 0.5;
        AABB collectionVolume = boundsShape.bounds().inflate(expandByX, expandByY, expandByZ);
        ArrayList<AABB> aabbs = new ArrayList<AABB>();
        ArrayList<VoxelShape> voxels = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, collectionVolume, voxels, aabbs, 4, null);
        WorldBorder worldBorder = this.getWorldBorder();
        if (worldBorder != null) {
            aabbs.removeIf(aabb -> !worldBorder.isWithinBounds((AABB)aabb));
            voxels.removeIf(shape -> !worldBorder.isWithinBounds(shape.bounds()));
        }
        int len = voxels.size();
        for (int i = 0; i < len; ++i) {
            aabbs.addAll(((VoxelShape)voxels.get(i)).toAabbs());
        }
        VoxelShape first = aabbs.isEmpty() ? Shapes.empty() : Level.inflateAABBToVoxel((AABB)aabbs.get(0), expandByX, expandByY, expandByZ);
        VoxelShape[] rest = new VoxelShape[Math.max(0, aabbs.size() - 1)];
        int len2 = aabbs.size();
        for (int i = 1; i < len2; ++i) {
            rest[i - 1] = Level.inflateAABBToVoxel((AABB)aabbs.get(i), expandByX, expandByY, expandByZ);
        }
        VoxelShape joined = Shapes.or(first, rest);
        VoxelShape freeSpace = Shapes.joinUnoptimized(boundsShape, joined, BooleanOp.ONLY_FIRST);
        return freeSpace.closestPointTo(fromPosition);
    }

    @Override
    public Optional<BlockPos> findSupportingBlock(net.minecraft.world.entity.Entity entity, AABB aabb) {
        int minSection = WorldUtil.getMinSection(this);
        int minBlockX = Mth.floor(aabb.minX - 1.0E-7) - 1;
        int maxBlockX = Mth.floor(aabb.maxX + 1.0E-7) + 1;
        int minBlockY = Math.max((minSection << 4) - 1, Mth.floor(aabb.minY - 1.0E-7) - 1);
        int maxBlockY = Math.min((WorldUtil.getMaxSection(this) << 4) + 16, Mth.floor(aabb.maxY + 1.0E-7) + 1);
        int minBlockZ = Mth.floor(aabb.minZ - 1.0E-7) - 1;
        int maxBlockZ = Mth.floor(aabb.maxZ + 1.0E-7) + 1;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        CollisionUtil.LazyEntityCollisionContext collisionShape = new CollisionUtil.LazyEntityCollisionContext(entity);
        Vec3i selected = null;
        double selectedDistance = Double.MAX_VALUE;
        Vec3 entityPos = entity.position();
        if (minBlockY > maxBlockY) {
            return Optional.empty();
        }
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkSource chunkSource = this.getChunkSource();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkAccess chunk = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, false);
                if (chunk == null) continue;
                LevelChunkSection[] sections = chunk.getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    boolean hasSpecial = section.moonrise$hasSpecialCollidingBlocks();
                    int sectionAdjust = !hasSpecial ? 1 : 0;
                    PalettedContainer<BlockState> blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? (minBlockX & 0xF) + sectionAdjust : 0;
                    int maxXIterate = currChunkX == maxChunkX ? (maxBlockX & 0xF) - sectionAdjust : 15;
                    int minZIterate = currChunkZ == minChunkZ ? (minBlockZ & 0xF) + sectionAdjust : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? (maxBlockZ & 0xF) - sectionAdjust : 15;
                    int minYIterate = currChunkY == minChunkY ? (minBlockY & 0xF) + sectionAdjust : 0;
                    int maxYIterate = currChunkY == maxChunkY ? (maxBlockY & 0xF) - sectionAdjust : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.setY(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.setZ(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                BlockState blockData;
                                double distance;
                                int edgeCount;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.setX(blockX);
                                int n = hasSpecial ? (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0) : (edgeCount = 0);
                                if (edgeCount == 3 || (distance = mutablePos.distToCenterSqr(entityPos)) > selectedDistance || distance == selectedDistance && selected.compareTo(mutablePos) >= 0 || (blockData = blocks.get(localBlockIndex)).moonrise$emptyContextCollisionShape()) continue;
                                VoxelShape blockCollision = blockData.moonrise$getConstantContextCollisionShape();
                                if (edgeCount != 0 && (edgeCount == 1 && !blockData.hasLargeCollisionShape() || edgeCount == 2 && blockData.getBlock() != Blocks.MOVING_PISTON) || blockCollision == null && (blockCollision = blockData.getCollisionShape(this, mutablePos, collisionShape)).isEmpty()) continue;
                                AABB shiftedAABB = aabb.move(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AABB singleAABB = blockCollision.moonrise$getSingleAABBRepresentation();
                                if (singleAABB != null) {
                                    if (!CollisionUtil.voxelShapeIntersect(singleAABB, shiftedAABB)) continue;
                                    selected = mutablePos.immutable();
                                    selectedDistance = distance;
                                    continue;
                                }
                                if (!CollisionUtil.voxelShapeIntersectNoEmpty(blockCollision, shiftedAABB)) continue;
                                selected = mutablePos.immutable();
                                selectedDistance = distance;
                            }
                        }
                    }
                }
            }
        }
        return Optional.ofNullable(selected);
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getSectionsCount() {
        return this.sectionsCount;
    }

    @Override
    public int getMinSectionY() {
        return this.minSectionY;
    }

    @Override
    public int getMaxSectionY() {
        return this.maxSectionY;
    }

    @Override
    public boolean isInsideBuildHeight(int blockY) {
        return blockY >= this.minY && blockY <= this.maxY;
    }

    @Override
    public boolean isOutsideBuildHeight(BlockPos pos) {
        return this.isOutsideBuildHeight(pos.getY());
    }

    @Override
    public boolean isOutsideBuildHeight(int blockY) {
        return blockY < this.minY || blockY > this.maxY;
    }

    @Override
    public int getSectionIndex(int blockY) {
        return (blockY >> 4) - this.minSectionY;
    }

    @Override
    public int getSectionIndexFromSectionY(int sectionY) {
        return sectionY - this.minSectionY;
    }

    @Override
    public int getSectionYFromSectionIndex(int sectionIdx) {
        return sectionIdx + this.minSectionY;
    }

    @Override
    public abstract Holder<Biome> getUncachedNoiseBiome(int var1, int var2, int var3);

    @Override
    public Holder<Biome> getNoiseBiome(int x, int y, int z) {
        ChunkAccess chunk = this.getChunk(x >> 2, z >> 2, ChunkStatus.BIOMES, false);
        return chunk != null ? chunk.getNoiseBiome(x, y, z) : this.getUncachedNoiseBiome(x, y, z);
    }

    protected Level(WritableLevelData worlddatamutable, ResourceKey<Level> resourcekey, RegistryAccess iregistrycustom, Holder<DimensionType> holder, boolean flag, boolean flag1, long i, int j, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env, Function<SpigotWorldConfig, WorldConfiguration> paperWorldConfigCreator, Executor executor) {
        DimensionType dimType = holder.value();
        this.minY = dimType.minY();
        this.height = dimType.height();
        this.maxY = this.minY + this.height - 1;
        this.minSectionY = this.minY >> 4;
        this.maxSectionY = this.maxY >> 4;
        this.sectionsCount = this.maxSectionY - this.minSectionY + 1;
        this.spigotConfig = new SpigotWorldConfig(((PrimaryLevelData)worlddatamutable).getLevelName());
        this.paperConfig = paperWorldConfigCreator.apply(this.spigotConfig);
        this.purpurConfig = new PurpurWorldConfig(((PrimaryLevelData)worlddatamutable).getLevelName(), env);
        this.playerBreedingCooldowns = this.getNewBreedingCooldownCache();
        this.generator = gen;
        this.world = new CraftWorld((ServerLevel)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getTicksPerSpawn(spawnCategory));
        }
        this.levelData = worlddatamutable;
        this.dimensionTypeRegistration = holder;
        DimensionType dimensionmanager = holder.value();
        this.dimension = resourcekey;
        this.isClientSide = flag;
        this.worldBorder = dimensionmanager.coordinateScale() != 1.0 ? new WorldBorder(this){

            @Override
            public double getCenterX() {
                return super.getCenterX();
            }

            @Override
            public double getCenterZ() {
                return super.getCenterZ();
            }
        } : new WorldBorder();
        this.thread = Thread.currentThread();
        this.biomeManager = new BiomeManager(this, i);
        this.isDebug = flag1;
        this.neighborUpdater = new CollectingNeighborUpdater(this, j);
        this.registryAccess = iregistrycustom;
        this.damageSources = new DamageSources(iregistrycustom);
        this.getWorldBorder().world = (ServerLevel)this;
        this.getWorldBorder().addListener(new BorderChangeListener(){

            @Override
            public void onBorderSizeSet(WorldBorder border, double size) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderSizePacket(border), border.world);
            }

            @Override
            public void onBorderSizeLerping(WorldBorder border, double fromSize, double toSize, long time) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(border), border.world);
            }

            @Override
            public void onBorderCenterSet(WorldBorder border, double centerX, double centerZ) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderCenterPacket(border), border.world);
            }

            @Override
            public void onBorderSetWarningTime(WorldBorder border, int warningTime) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(border), border.world);
            }

            @Override
            public void onBorderSetWarningBlocks(WorldBorder border, int warningBlockDistance) {
                Level.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(border), border.world);
            }

            @Override
            public void onBorderSetDamagePerBlock(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void onBorderSetDamageSafeZOne(WorldBorder border, double safeZoneRadius) {
            }
        });
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
        this.chunkPacketBlockController = this.paperConfig().anticheat.antiXray.enabled ? new ChunkPacketBlockControllerAntiXray(this, executor) : ChunkPacketBlockController.NO_OPERATION_INSTANCE;
        this.entityLookup = new DefaultEntityLookup(this);
    }

    public final boolean checkEntityCollision(BlockState data, net.minecraft.world.entity.Entity source, CollisionContext voxelshapedcollision, BlockPos position, boolean checkCanSee) {
        VoxelShape voxelshape = data.getCollisionShape(this, position, voxelshapedcollision);
        if (voxelshape.isEmpty()) {
            return true;
        }
        if ((voxelshape = voxelshape.move(position.getX(), position.getY(), position.getZ())).isEmpty()) {
            return true;
        }
        List<net.minecraft.world.entity.Entity> entities = this.getEntities(null, voxelshape.bounds());
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            net.minecraft.world.entity.Entity entity = entities.get(i);
            if (checkCanSee && source instanceof ServerPlayer && entity instanceof ServerPlayer && !((ServerPlayer)source).getBukkitEntity().canSee(((ServerPlayer)entity).getBukkitEntity()) || entity.isRemoved() || !entity.blocksBuilding || !Shapes.joinIsNotEmpty(voxelshape, Shapes.create(entity.getBoundingBox()), BooleanOp.AND)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return null;
    }

    public HitResult.Type clipDirect(Vec3 start, Vec3 end, CollisionContext context) {
        return this.clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, context)).getType();
    }

    public boolean isInWorldBounds(BlockPos pos) {
        return pos.isInsideBuildHeightAndWorldBoundsHorizontal(this);
    }

    public static boolean isInSpawnableBounds(BlockPos pos) {
        return !Level.isOutsideSpawnableHeight(pos.getY()) && Level.isInWorldBoundsHorizontal(pos);
    }

    private static boolean isInWorldBoundsHorizontal(BlockPos pos) {
        return pos.getX() >= -30000000 && pos.getZ() >= -30000000 && pos.getX() < 30000000 && pos.getZ() < 30000000;
    }

    private static boolean isOutsideSpawnableHeight(int y) {
        return y < -20000000 || y >= 20000000;
    }

    public final LevelChunk getChunkAt(BlockPos pos) {
        return this.getChunk(SectionPos.blockToSectionCoord(pos.getX()), SectionPos.blockToSectionCoord(pos.getZ()));
    }

    @Override
    public final LevelChunk getChunk(int chunkX, int chunkZ) {
        ServerChunkCache cps = ((ServerLevel)this).getChunkSource();
        LevelChunk ifLoaded = cps.getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        return (LevelChunk)cps.getChunk(chunkX, chunkZ, ChunkStatus.FULL, true);
    }

    @Override
    @Nullable
    public final ChunkAccess getChunkIfLoadedImmediately(int x, int z) {
        return ((ServerLevel)this).chunkSource.getChunkAtIfLoadedImmediately(x, z);
    }

    @Override
    @Nullable
    public final BlockState getBlockStateIfLoaded(BlockPos pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (this.isOutsideBuildHeight(pos)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        ChunkAccess chunk = this.getChunkIfLoadedImmediately(pos.getX() >> 4, pos.getZ() >> 4);
        return chunk == null ? null : chunk.getBlockState(pos);
    }

    @Override
    public final FluidState getFluidIfLoaded(BlockPos blockposition) {
        ChunkAccess chunk = this.getChunkIfLoadedImmediately(blockposition.getX() >> 4, blockposition.getZ() >> 4);
        return chunk == null ? null : chunk.getFluidState(blockposition);
    }

    @Override
    public final boolean hasChunkAt(BlockPos pos) {
        return this.getChunkIfLoaded(pos.getX() >> 4, pos.getZ() >> 4) != null;
    }

    public final boolean isLoadedAndInBounds(BlockPos blockposition) {
        return this.getWorldBorder().isWithinBounds(blockposition) && this.getChunkIfLoadedImmediately(blockposition.getX() >> 4, blockposition.getZ() >> 4) != null;
    }

    @Nullable
    public LevelChunk getChunkIfLoaded(int x, int z) {
        return ((ServerLevel)this).getChunkSource().getChunkAtIfLoadedImmediately(x, z);
    }

    @Nullable
    public final LevelChunk getChunkIfLoaded(BlockPos blockposition) {
        return ((ServerLevel)this).getChunkSource().getChunkAtIfLoadedImmediately(blockposition.getX() >> 4, blockposition.getZ() >> 4);
    }

    @Nullable
    public final BlockState getBlockStateIfLoadedAndInBounds(BlockPos blockposition) {
        return this.getWorldBorder().isWithinBounds(blockposition) ? this.getBlockStateIfLoaded(blockposition) : null;
    }

    @Override
    public ChunkAccess getChunk(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        ChunkAccess ichunkaccess = this.getChunkSource().getChunk(chunkX, chunkZ, leastStatus, create);
        if (ichunkaccess == null && create) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public boolean setBlock(BlockPos pos, BlockState state, int flags) {
        return this.setBlock(pos, state, flags, 512);
    }

    @Override
    public boolean setBlock(BlockPos pos, BlockState state, int flags, int maxUpdateDepth) {
        if (this.captureTreeGeneration) {
            BlockState type = this.getBlockState(pos);
            if (!type.isDestroyable()) {
                return false;
            }
            CraftBlockState blockstate = this.capturedBlockStates.get(pos);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, pos, flags);
                this.capturedBlockStates.put(pos.immutable(), blockstate);
            }
            blockstate.setData(state);
            blockstate.setFlag(flags);
            return true;
        }
        if (this.isOutsideBuildHeight(pos)) {
            return false;
        }
        if (!this.isClientSide && this.isDebug()) {
            return false;
        }
        LevelChunk chunk = this.getChunkAt(pos);
        Block block = state.getBlock();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(pos)) {
            CraftBlockState blockstate = (CraftBlockState)this.world.getBlockAt(pos.getX(), pos.getY(), pos.getZ()).getState();
            blockstate.setFlag(flags);
            this.capturedBlockStates.put(pos.immutable(), blockstate);
            captured = true;
        }
        BlockState iblockdata1 = chunk.setBlockState(pos, state, (flags & 0x40) != 0, (flags & 0x400) == 0);
        this.chunkPacketBlockController.onBlockChange(this, pos, state, iblockdata1, flags, maxUpdateDepth);
        if (iblockdata1 == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(pos);
            }
            return false;
        }
        BlockState iblockdata2 = this.getBlockState(pos);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(pos, chunk, iblockdata1, state, iblockdata2, flags, maxUpdateDepth);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPos(pos);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPos blockposition, LevelChunk chunk, BlockState oldBlock, BlockState newBlock, BlockState actualBlock, int i, int j) {
        BlockState iblockdata = newBlock;
        BlockState iblockdata1 = oldBlock;
        BlockState iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.setBlocksDirty(blockposition, iblockdata1, iblockdata2);
            }
            if ((i & 2) != 0 && (!this.isClientSide || (i & 4) == 0) && (this.isClientSide || chunk == null || chunk.getFullStatus() != null && chunk.getFullStatus().isOrAfter(FullChunkStatus.FULL))) {
                this.sendBlockUpdated(blockposition, iblockdata1, iblockdata, i);
            }
            if ((i & 1) != 0) {
                this.blockUpdated(blockposition, iblockdata1.getBlock());
                if (!this.isClientSide && iblockdata.hasAnalogOutputSignal()) {
                    this.updateNeighbourForOutputSignal(blockposition, newBlock.getBlock());
                }
            }
            if ((i & 0x10) == 0 && j > 0) {
                int k = i & 0xFFFFFFDE;
                iblockdata1.updateIndirectNeighbourShapes(this, blockposition, k, j - 1);
                CraftWorld world = ((ServerLevel)this).getWorld();
                boolean cancelledUpdates = false;
                if (world != null && ((ServerLevel)this).hasPhysicsEvent) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    cancelledUpdates = event.isCancelled();
                }
                if (!cancelledUpdates) {
                    iblockdata.updateNeighbourShapes(this, blockposition, k, j - 1);
                    iblockdata.updateIndirectNeighbourShapes(this, blockposition, k, j - 1);
                }
            }
            if (!this.preventPoiUpdated) {
                this.onBlockStateChange(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void onBlockStateChange(BlockPos pos, BlockState oldBlock, BlockState newBlock) {
    }

    @Override
    public boolean removeBlock(BlockPos pos, boolean move) {
        FluidState fluid = this.getFluidState(pos);
        return this.setBlock(pos, fluid.createLegacyBlock(), 3 | (move ? 64 : 0));
    }

    @Override
    public boolean destroyBlock(BlockPos pos, boolean drop, @Nullable net.minecraft.world.entity.Entity breakingEntity, int maxUpdateDepth) {
        boolean flag1;
        BlockState iblockdata = this.getBlockState(pos);
        if (iblockdata.isAir()) {
            return false;
        }
        FluidState fluid = this.getFluidState(pos);
        boolean playEffect = true;
        BlockState effectType = iblockdata;
        int xp = iblockdata.getBlock().getExpDrop(iblockdata, (ServerLevel)this, pos, ItemStack.EMPTY, true);
        if (BlockDestroyEvent.getHandlerList().getRegisteredListeners().length > 0) {
            BlockDestroyEvent event = new BlockDestroyEvent((org.bukkit.block.Block)CraftBlock.at(this, pos), (BlockData)fluid.createLegacyBlock().createCraftBlockData(), (BlockData)effectType.createCraftBlockData(), xp, drop);
            if (!event.callEvent()) {
                return false;
            }
            effectType = ((CraftBlockData)event.getEffectBlock()).getState();
            playEffect = event.playEffect();
            drop = event.willDrop();
            xp = event.getExpToDrop();
        }
        if (playEffect && !(effectType.getBlock() instanceof BaseFireBlock)) {
            this.levelEvent(2001, pos, Block.getId(effectType));
        }
        if (drop) {
            BlockEntity tileentity = iblockdata.hasBlockEntity() ? this.getBlockEntity(pos) : null;
            Block.dropResources(iblockdata, this, pos, tileentity, breakingEntity, ItemStack.EMPTY, false);
            iblockdata.getBlock().popExperience((ServerLevel)this, pos, xp, breakingEntity);
        }
        if (flag1 = this.setBlock(pos, fluid.createLegacyBlock(), 3, maxUpdateDepth)) {
            this.gameEvent(GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(breakingEntity, iblockdata));
        }
        return flag1;
    }

    public void addDestroyBlockEffect(BlockPos pos, BlockState state) {
    }

    public boolean setBlockAndUpdate(BlockPos pos, BlockState state) {
        return this.setBlock(pos, state, 3);
    }

    public abstract void sendBlockUpdated(BlockPos var1, BlockState var2, BlockState var3, int var4);

    public void setBlocksDirty(BlockPos pos, BlockState old, BlockState updated) {
    }

    public void updateNeighborsAt(BlockPos pos, Block block) {
    }

    public void updateNeighborsAt(BlockPos pos, Block sourceBlock, @Nullable Orientation orientation) {
    }

    public void updateNeighborsAtExceptFromFacing(BlockPos pos, Block sourceBlock, Direction direction, @Nullable Orientation orientation) {
    }

    public void neighborChanged(BlockPos pos, Block sourceBlock, @Nullable Orientation orientation) {
    }

    public void neighborChanged(BlockState state, BlockPos pos, Block sourceBlock, @Nullable Orientation orientation, boolean notify) {
    }

    @Override
    public void neighborShapeChanged(Direction direction, BlockPos pos, BlockPos neighborPos, BlockState neighborState, int flags, int maxUpdateDepth) {
        this.neighborUpdater.shapeUpdate(direction, neighborState, pos, neighborPos, flags, maxUpdateDepth);
    }

    @Override
    public int getHeight(Heightmap.Types heightmap, int x, int z) {
        int k = x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000 ? (this.hasChunk(SectionPos.blockToSectionCoord(x), SectionPos.blockToSectionCoord(z)) ? this.getChunk(SectionPos.blockToSectionCoord(x), SectionPos.blockToSectionCoord(z)).getHeight(heightmap, x & 0xF, z & 0xF) + 1 : this.getMinY()) : this.getSeaLevel() + 1;
        return k;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.getChunkSource().getLightEngine();
    }

    @Override
    public BlockState getBlockState(BlockPos pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (this.isOutsideBuildHeight(pos)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        ChunkAccess chunk = this.getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.FULL, true);
        return chunk.getBlockState(pos);
    }

    @Override
    public FluidState getFluidState(BlockPos pos) {
        if (this.isOutsideBuildHeight(pos)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        LevelChunk chunk = this.getChunkAt(pos);
        return chunk.getFluidState(pos);
    }

    public boolean isDay() {
        return !this.dimensionType().hasFixedTime() && this.skyDarken < 4;
    }

    public boolean isNight() {
        return !this.dimensionType().hasFixedTime() && !this.isDay();
    }

    public void playSound(@Nullable net.minecraft.world.entity.Entity source, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        Player entityhuman1;
        Player entityhuman = source instanceof Player ? (entityhuman1 = (Player)source) : null;
        this.playSound(entityhuman, pos, sound, category, volume, pitch);
    }

    @Override
    public void playSound(@Nullable Player source, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        this.playSound(source, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, sound, category, volume, pitch);
    }

    public abstract void playSeededSound(@Nullable Player var1, double var2, double var4, double var6, Holder<SoundEvent> var8, SoundSource var9, float var10, float var11, long var12);

    public void playSeededSound(@Nullable Player source, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, long seed) {
        this.playSeededSound(source, x, y, z, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(sound), category, volume, pitch, seed);
    }

    public abstract void playSeededSound(@Nullable Player var1, net.minecraft.world.entity.Entity var2, Holder<SoundEvent> var3, SoundSource var4, float var5, float var6, long var7);

    public void playSound(@Nullable Player source, double x, double y, double z, SoundEvent sound, SoundSource category) {
        this.playSound(source, x, y, z, sound, category, 1.0f, 1.0f);
    }

    public void playSound(@Nullable Player source, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch) {
        this.playSeededSound(source, x, y, z, sound, category, volume, pitch, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Player source, double x, double y, double z, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch) {
        this.playSeededSound(source, x, y, z, sound, category, volume, pitch, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable Player source, net.minecraft.world.entity.Entity entity, SoundEvent sound, SoundSource category, float volume, float pitch) {
        this.playSeededSound(source, entity, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(sound), category, volume, pitch, this.threadSafeRandom.nextLong());
    }

    public void playLocalSound(BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch, boolean useDistance) {
        this.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, sound, category, volume, pitch, useDistance);
    }

    public void playLocalSound(net.minecraft.world.entity.Entity entity, SoundEvent sound, SoundSource category, float volume, float pitch) {
    }

    public void playLocalSound(double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, boolean useDistance) {
    }

    @Override
    public void addParticle(ParticleOptions parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
    }

    public void addParticle(ParticleOptions parameters, boolean alwaysSpawn, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions parameters, boolean alwaysSpawn, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
    }

    public float getSunAngle(float tickDelta) {
        float f1 = this.getTimeOfDay(tickDelta);
        return f1 * ((float)Math.PI * 2);
    }

    public void addBlockEntityTicker(TickingBlockEntity ticker) {
        (this.tickingBlockEntities ? this.pendingBlockEntityTickers : this.blockEntityTickers).add(ticker);
    }

    protected void tickBlockEntities() {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("blockEntities");
        this.tickingBlockEntities = true;
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
            this.pendingBlockEntityTickers.clear();
        }
        boolean flag = this.tickRateManager().runsNormally();
        int tickedEntities = 0;
        int tilesThisCycle = 0;
        ReferenceOpenHashSet toRemove = new ReferenceOpenHashSet();
        toRemove.add(null);
        this.tileTickPosition = 0;
        while (this.tileTickPosition < this.blockEntityTickers.size()) {
            this.tileTickPosition = this.tileTickPosition < this.blockEntityTickers.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.blockEntityTickers.get(this.tileTickPosition);
            if (tickingblockentity.isRemoved()) {
                --tilesThisCycle;
                toRemove.add((Object)tickingblockentity);
            } else if (flag && this.shouldTickBlocksAt(tickingblockentity.getPos())) {
                tickingblockentity.tick();
                if ((++tickedEntities & 7) == 0) {
                    this.moonrise$midTickTasks();
                }
            }
            ++this.tileTickPosition;
        }
        this.blockEntityTickers.removeAll((Collection<?>)toRemove);
        this.tickingBlockEntities = false;
        gameprofilerfiller.pop();
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends net.minecraft.world.entity.Entity> void guardEntityTick(Consumer<T> tickConsumer, T entity) {
        try {
            tickConsumer.accept(entity);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw throwable;
            }
            String msg = String.format("Entity threw exception at %s:%s,%s,%s", entity.level().getWorld().getName(), entity.getX(), entity.getY(), entity.getZ());
            MinecraftServer.LOGGER.error(msg, throwable);
            this.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, throwable)));
            entity.discard(EntityRemoveEvent.Cause.DISCARD);
        }
        this.moonrise$midTickTasks();
    }

    @Override
    public boolean noCollision(@Nullable net.minecraft.world.entity.Entity entity, AABB box) {
        int flags;
        if (entity instanceof ArmorStand && !entity.level().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return false;
        }
        int n = flags = entity == null ? 12 : 8;
        if (CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, flags, null)) {
            return false;
        }
        return !CollisionUtil.getEntityHardCollisions(this, entity, box, null, flags, null);
    }

    public boolean shouldTickDeath(net.minecraft.world.entity.Entity entity) {
        return true;
    }

    public boolean shouldTickBlocksAt(long chunkPos) {
        return true;
    }

    public boolean shouldTickBlocksAt(BlockPos pos) {
        return this.shouldTickBlocksAt(ChunkPos.asLong(pos));
    }

    public void explode(@Nullable net.minecraft.world.entity.Entity entity, double x, double y, double z, float power, ExplosionInteraction explosionSourceType) {
        this.explode(entity, Explosion.getDefaultDamageSource(this, entity), null, x, y, z, power, false, explosionSourceType, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable net.minecraft.world.entity.Entity entity, double x, double y, double z, float power, boolean createFire, ExplosionInteraction explosionSourceType) {
        this.explode(entity, Explosion.getDefaultDamageSource(this, entity), null, x, y, z, power, createFire, explosionSourceType, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, Vec3 pos, float power, boolean createFire, ExplosionInteraction explosionSourceType) {
        this.explode(entity, damageSource, behavior, pos.x(), pos.y(), pos.z(), power, createFire, explosionSourceType, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x, double y, double z, float power, boolean createFire, ExplosionInteraction explosionSourceType) {
        this.explode(entity, damageSource, behavior, x, y, z, power, createFire, explosionSourceType, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public abstract void explode(@Nullable net.minecraft.world.entity.Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, ExplosionInteraction var12, ParticleOptions var13, ParticleOptions var14, Holder<SoundEvent> var15);

    public abstract String gatherChunkSourceStats();

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.getBlockEntity(pos, true);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos blockposition, boolean validate) {
        BlockEntity blockEntity;
        if (!this.capturedTileEntities.isEmpty() && (blockEntity = this.capturedTileEntities.get(blockposition)) != null) {
            return blockEntity;
        }
        return this.isOutsideBuildHeight(blockposition) ? null : (!this.isClientSide && !TickThread.isTickThread() ? null : this.getChunkAt(blockposition).getBlockEntity(blockposition, LevelChunk.EntityCreationType.IMMEDIATE));
    }

    public void setBlockEntity(BlockEntity blockEntity) {
        BlockPos blockposition = blockEntity.getBlockPos();
        if (!this.isOutsideBuildHeight(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.immutable(), blockEntity);
                return;
            }
            this.getChunkAt(blockposition).addAndRegisterBlockEntity(blockEntity);
        }
    }

    public void removeBlockEntity(BlockPos pos) {
        if (!this.isOutsideBuildHeight(pos)) {
            this.getChunkAt(pos).removeBlockEntity(pos);
        }
    }

    public boolean isLoaded(BlockPos pos) {
        return this.isOutsideBuildHeight(pos) ? false : this.getChunkSource().hasChunk(SectionPos.blockToSectionCoord(pos.getX()), SectionPos.blockToSectionCoord(pos.getZ()));
    }

    public boolean loadedAndEntityCanStandOnFace(BlockPos pos, net.minecraft.world.entity.Entity entity, Direction direction) {
        if (this.isOutsideBuildHeight(pos)) {
            return false;
        }
        ChunkAccess ichunkaccess = this.getChunk(SectionPos.blockToSectionCoord(pos.getX()), SectionPos.blockToSectionCoord(pos.getZ()), ChunkStatus.FULL, false);
        return ichunkaccess == null ? false : ichunkaccess.getBlockState(pos).entityCanStandOnFace(this, pos, entity, direction);
    }

    public boolean loadedAndEntityCanStandOn(BlockPos pos, net.minecraft.world.entity.Entity entity) {
        return this.loadedAndEntityCanStandOnFace(pos, entity, Direction.UP);
    }

    public void updateSkyBrightness() {
        double d0 = 1.0 - (double)(this.getRainLevel(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.getThunderLevel(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * Mth.clamp((double)Mth.cos(this.getTimeOfDay(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.skyDarken = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void setSpawnSettings(boolean spawnMonsters) {
        this.getChunkSource().setSpawnSettings(spawnMonsters);
    }

    public BlockPos getSharedSpawnPos() {
        BlockPos blockposition = this.levelData.getSpawnPos();
        if (!this.getWorldBorder().isWithinBounds(blockposition)) {
            blockposition = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, BlockPos.containing(this.getWorldBorder().getCenterX(), 0.0, this.getWorldBorder().getCenterZ()));
        }
        return blockposition;
    }

    public float getSharedSpawnAngle() {
        return this.levelData.getSpawnAngle();
    }

    protected void prepareWeather() {
        if (this.levelData.isRaining()) {
            this.rainLevel = 1.0f;
            if (this.levelData.isThundering()) {
                this.thunderLevel = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getChunkSource().close();
    }

    @Override
    @Nullable
    public BlockGetter getChunkForCollisions(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
    }

    @Override
    public List<net.minecraft.world.entity.Entity> getEntities(@Nullable net.minecraft.world.entity.Entity except, AABB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        Profiler.get().incrementCounter("getEntities");
        ArrayList list = Lists.newArrayList();
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        this.moonrise$getEntityLookup().getEntities(except, box, ret, predicate);
        PlatformHooks.get().addToGetEntities(this, except, box, predicate, ret);
        return ret;
    }

    @Override
    public <T extends net.minecraft.world.entity.Entity> List<T> getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, AABB box, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(filter, box, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, AABB box, Predicate<? super T> predicate, List<? super T> result) {
        this.getEntities(filter, box, predicate, result, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AABB boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        Profiler.get().incrementCounter("getEntities");
        if (entityTypeTest instanceof EntityType) {
            EntityType byType = (EntityType)entityTypeTest;
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (entityTypeTest == null) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        Class<net.minecraft.world.entity.Entity> base = entityTypeTest.getBaseClass();
        Predicate<net.minecraft.world.entity.Entity> modifiedPredicate = predicate == null ? obj -> entityTypeTest.tryCast((net.minecraft.world.entity.Entity)obj) != null : obj -> {
            net.minecraft.world.entity.Entity casted = (net.minecraft.world.entity.Entity)entityTypeTest.tryCast((net.minecraft.world.entity.Entity)obj);
            if (casted == null) {
                return false;
            }
            return predicate.test(casted);
        };
        if (base == null || base == net.minecraft.world.entity.Entity.class) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, modifiedPredicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, modifiedPredicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (maxCount != Integer.MAX_VALUE) {
            this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate, maxCount);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate);
        PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
    }

    public Entity[] getChunkEntities(int chunkX, int chunkZ) {
        ChunkEntitySlices slices = ((ServerLevel)this).moonrise$getEntityLookup().getChunk(chunkX, chunkZ);
        if (slices == null) {
            return new Entity[0];
        }
        ArrayList<CraftEntity> ret = new ArrayList<CraftEntity>();
        for (net.minecraft.world.entity.Entity entity : slices.getAllEntities()) {
            CraftEntity bukkit = entity.getBukkitEntity();
            if (bukkit == null || !bukkit.isValid()) continue;
            ret.add(bukkit);
        }
        return ret.toArray(new Entity[0]);
    }

    @Nullable
    public abstract net.minecraft.world.entity.Entity getEntity(int var1);

    public void blockEntityChanged(BlockPos pos) {
        if (this.hasChunkAt(pos)) {
            this.getChunkAt(pos).markUnsaved();
        }
    }

    public void disconnect() {
    }

    public long getGameTime() {
        return this.levelData.getGameTime();
    }

    public long getDayTime() {
        return this.levelData.getDayTime();
    }

    public boolean mayInteract(Player player, BlockPos pos) {
        return true;
    }

    public void broadcastEntityEvent(net.minecraft.world.entity.Entity entity, byte status) {
    }

    public void broadcastDamageEvent(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
    }

    public void blockEvent(BlockPos pos, Block block, int type, int data) {
        this.getBlockState(pos).triggerEvent(this, pos, type, data);
    }

    @Override
    public LevelData getLevelData() {
        return this.levelData;
    }

    public abstract TickRateManager tickRateManager();

    public float getThunderLevel(float delta) {
        return Mth.lerp(delta, this.oThunderLevel, this.thunderLevel) * this.getRainLevel(delta);
    }

    public void setThunderLevel(float thunderGradient) {
        float f1;
        this.oThunderLevel = f1 = Mth.clamp(thunderGradient, 0.0f, 1.0f);
        this.thunderLevel = f1;
    }

    public float getRainLevel(float delta) {
        return Mth.lerp(delta, this.oRainLevel, this.rainLevel);
    }

    public void setRainLevel(float rainGradient) {
        float f1;
        this.oRainLevel = f1 = Mth.clamp(rainGradient, 0.0f, 1.0f);
        this.rainLevel = f1;
    }

    private boolean canHaveWeather() {
        return this.dimensionType().hasSkyLight() && !this.dimensionType().hasCeiling();
    }

    public boolean isThundering() {
        return this.canHaveWeather() && (double)this.getThunderLevel(1.0f) > 0.9;
    }

    public boolean isRaining() {
        return this.canHaveWeather() && (double)this.getRainLevel(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPos pos) {
        if (!this.isRaining()) {
            return false;
        }
        if (!this.canSeeSky(pos)) {
            return false;
        }
        if (this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() > pos.getY()) {
            return false;
        }
        Biome biomebase = this.getBiome(pos).value();
        return biomebase.getPrecipitationAt(pos, this.getSeaLevel()) == Biome.Precipitation.RAIN;
    }

    @Nullable
    public abstract MapItemSavedData getMapData(MapId var1);

    public abstract void setMapData(MapId var1, MapItemSavedData var2);

    public abstract MapId getFreeMapId();

    public void globalLevelEvent(int eventId, BlockPos pos, int data) {
    }

    public CrashReportCategory fillReportDetails(CrashReport report) {
        CrashReportCategory crashreportsystemdetails = report.addCategory("Affected level", 1);
        crashreportsystemdetails.setDetail("All players", () -> {
            int i = this.players().size();
            return i + " total; " + String.valueOf(this.players());
        });
        ChunkSource ichunkprovider = this.getChunkSource();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.setDetail("Chunk stats", ichunkprovider::gatherStats);
        crashreportsystemdetails.setDetail("Level dimension", () -> this.dimension().location().toString());
        try {
            this.levelData.fillCrashReportCategory(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.setDetailError("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void destroyBlockProgress(int var1, BlockPos var2, int var3);

    public void createFireworks(double x, double y, double z, double velocityX, double velocityY, double velocityZ, List<FireworkExplosion> explosions) {
    }

    public abstract Scoreboard getScoreboard();

    public void updateNeighbourForOutputSignal(BlockPos pos, Block block) {
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BlockPos blockposition1 = pos.relative(enumdirection);
            if (!this.hasChunkAt(blockposition1)) continue;
            BlockState iblockdata = this.getBlockState(blockposition1);
            if (iblockdata.is(Blocks.COMPARATOR)) {
                this.neighborChanged(iblockdata, blockposition1, block, null, false);
                continue;
            }
            if (!iblockdata.isRedstoneConductor(this, blockposition1) || !(iblockdata = this.getBlockState(blockposition1 = blockposition1.relative(enumdirection))).is(Blocks.COMPARATOR)) continue;
            this.neighborChanged(iblockdata, blockposition1, block, null, false);
        }
    }

    @Override
    public DifficultyInstance getCurrentDifficultyAt(BlockPos pos) {
        long i = 0L;
        float f = 0.0f;
        if (this.hasChunkAt(pos)) {
            f = this.getMoonBrightness();
            i = this.getChunkAt(pos).getInhabitedTime();
        }
        return new DifficultyInstance(this.getDifficulty(), this.getDayTime(), i, f);
    }

    @Override
    public int getSkyDarken() {
        return this.skyDarken;
    }

    public void setSkyFlashTime(int lightningTicksLeft) {
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public void sendPacketToServer(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionType dimensionType() {
        return this.dimensionTypeRegistration.value();
    }

    public Holder<DimensionType> dimensionTypeRegistration() {
        return this.dimensionTypeRegistration;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public boolean isStateAtPosition(BlockPos pos, Predicate<BlockState> state) {
        return state.test(this.getBlockState(pos));
    }

    @Override
    public boolean isFluidAtPosition(BlockPos pos, Predicate<FluidState> state) {
        return state.test(this.getFluidState(pos));
    }

    public abstract RecipeAccess recipeAccess();

    public BlockPos getBlockRandomPos(int x, int y, int z, int l) {
        this.randValue = this.randValue * 3 + 1013904223;
        int i1 = this.randValue >> 2;
        return new BlockPos(x + (i1 & 0xF), y + (i1 >> 16 & l), z + (i1 >> 8 & 0xF));
    }

    public boolean noSave() {
        return false;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public abstract LevelEntityGetter<net.minecraft.world.entity.Entity> getEntities();

    @Override
    public long nextSubTickCount() {
        return this.subTickCount++;
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }

    public DamageSources damageSources() {
        return this.damageSources;
    }

    public abstract PotionBrewing potionBrewing();

    public abstract FuelValues fuelValues();

    public WireHandler getWireHandler() {
        return null;
    }

    public boolean isNether() {
        return this.getWorld().getEnvironment() == World.Environment.NETHER;
    }

    public boolean isTheEnd() {
        return this.getWorld().getEnvironment() == World.Environment.THE_END;
    }

    static {
        AIR_FLUIDSTATE = Fluids.EMPTY.defaultFluidState();
    }

    private static final class BreedingCooldownPair {
        private final UUID playerUUID;
        private final Class<? extends Animal> animalType;

        public BreedingCooldownPair(UUID playerUUID, Class<? extends Animal> animalType) {
            this.playerUUID = playerUUID;
            this.animalType = animalType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BreedingCooldownPair that = (BreedingCooldownPair)o;
            return this.playerUUID.equals(that.playerUUID) && this.animalType.equals(that.animalType);
        }

        public int hashCode() {
            return Objects.hash(this.playerUUID, this.animalType);
        }
    }

    public static enum ExplosionInteraction implements StringRepresentable
    {
        NONE("none"),
        BLOCK("block"),
        MOB("mob"),
        TNT("tnt"),
        TRIGGER("trigger"),
        STANDARD("standard");

        public static final Codec<ExplosionInteraction> CODEC;
        private final String id;

        private ExplosionInteraction(String s) {
            this.id = s;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ExplosionInteraction::values);
        }
    }
}

