/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.PlayerBedFailEnterEvent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.block.CraftBlock;

public class BedBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<BedBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(BedBlock::getColor), BedBlock.propertiesCodec()).apply((Applicative)instance, BedBlock::new));
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    protected static final int HEIGHT = 9;
    protected static final VoxelShape BASE = Block.box(0.0, 3.0, 0.0, 16.0, 9.0, 16.0);
    private static final int LEG_WIDTH = 3;
    protected static final VoxelShape LEG_NORTH_WEST = Block.box(0.0, 0.0, 0.0, 3.0, 3.0, 3.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.box(0.0, 0.0, 13.0, 3.0, 3.0, 16.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.box(13.0, 0.0, 0.0, 16.0, 3.0, 3.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.box(13.0, 0.0, 13.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape NORTH_SHAPE = Shapes.or(BASE, LEG_NORTH_WEST, LEG_NORTH_EAST);
    protected static final VoxelShape SOUTH_SHAPE = Shapes.or(BASE, LEG_SOUTH_WEST, LEG_SOUTH_EAST);
    protected static final VoxelShape WEST_SHAPE = Shapes.or(BASE, LEG_NORTH_WEST, LEG_SOUTH_WEST);
    protected static final VoxelShape EAST_SHAPE = Shapes.or(BASE, LEG_NORTH_EAST, LEG_SOUTH_EAST);
    private final DyeColor color;

    public MapCodec<BedBlock> codec() {
        return CODEC;
    }

    public BedBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any().setValue(PART, BedPart.FOOT)).setValue(OCCUPIED, false));
    }

    @Nullable
    public static Direction getBedOrientation(BlockGetter world, BlockPos pos) {
        BlockState iblockdata = world.getBlockState(pos);
        return iblockdata.getBlock() instanceof BedBlock ? iblockdata.getValue(HorizontalDirectionalBlock.FACING) : null;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS_SERVER;
        }
        if (state.getValue(PART) != BedPart.HEAD && !(state = world.getBlockState(pos = pos.relative(state.getValue(HorizontalDirectionalBlock.FACING)))).is(this)) {
            return InteractionResult.CONSUME;
        }
        if (state.getValue(OCCUPIED).booleanValue()) {
            if (!BedBlock.canSetSpawn(world)) {
                return this.explodeBed(state, world, pos);
            }
            if (!this.kickVillagerOutOfBed(world, pos)) {
                player.displayClientMessage(net.minecraft.network.chat.Component.translatable("block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        BlockState finaliblockdata = state;
        BlockPos finalblockposition = pos;
        player.startSleepInBed(pos).ifLeft(entityhuman_enumbedresult -> {
            if (entityhuman_enumbedresult != null) {
                Component message;
                PlayerBedFailEnterEvent event = new PlayerBedFailEnterEvent((org.bukkit.entity.Player)player.getBukkitEntity(), PlayerBedFailEnterEvent.FailReason.values()[entityhuman_enumbedresult.ordinal()], (org.bukkit.block.Block)CraftBlock.at(world, finalblockposition), !world.dimensionType().bedWorks(), PaperAdventure.asAdventure(entityhuman_enumbedresult.getMessage()));
                if (!event.callEvent()) {
                    return;
                }
                if (event.getWillExplode()) {
                    this.explodeBed(finaliblockdata, world, finalblockposition);
                } else if (entityhuman_enumbedresult.getMessage() != null && (message = event.getMessage()) != null) {
                    player.displayClientMessage(PaperAdventure.asVanilla(message), true);
                }
            }
        });
        return InteractionResult.SUCCESS_SERVER;
    }

    private InteractionResult explodeBed(BlockState iblockdata, Level world, BlockPos blockposition) {
        org.bukkit.block.BlockState blockState = CraftBlock.at(world, blockposition).getState();
        world.removeBlock(blockposition, false);
        BlockPos blockposition1 = blockposition.relative(iblockdata.getValue(HorizontalDirectionalBlock.FACING).getOpposite());
        if (world.getBlockState(blockposition1).getBlock() == this) {
            world.removeBlock(blockposition1, false);
        }
        Vec3 vec3d = blockposition.getCenter();
        if (world.purpurConfig.bedExplode) {
            world.explode((Entity)null, world.damageSources().badRespawnPointExplosion(vec3d, blockState), null, vec3d, (float)world.purpurConfig.bedExplosionPower, world.purpurConfig.bedExplosionFire, world.purpurConfig.bedExplosionEffect);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean canSetSpawn(Level world) {
        return world.dimensionType().bedWorks();
    }

    private boolean kickVillagerOutOfBed(Level world, BlockPos pos) {
        List<Villager> list = world.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (list.isEmpty()) {
            return false;
        }
        list.get(0).stopSleeping();
        return true;
    }

    @Override
    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(world, state, pos, entity, fallDistance);
    }

    @Override
    public void updateEntityMovementAfterFallOn(BlockGetter world, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(world, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3d = entity.getDeltaMovement();
        if (vec3d.y < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vec3d.x, -vec3d.y * (double)0.66f * d0, vec3d.z);
        }
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return direction == BedBlock.getNeighbourDirection(state.getValue(PART), state.getValue(HorizontalDirectionalBlock.FACING)) ? (neighborState.is(this) && neighborState.getValue(PART) != state.getValue(PART) ? (BlockState)state.setValue(OCCUPIED, neighborState.getValue(OCCUPIED)) : Blocks.AIR.defaultBlockState()) : super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockposition1;
        BlockState iblockdata1;
        BedPart blockpropertybedpart;
        if (!world.isClientSide && player.isCreative() && (blockpropertybedpart = state.getValue(PART)) == BedPart.FOOT && (iblockdata1 = world.getBlockState(blockposition1 = pos.relative(BedBlock.getNeighbourDirection(blockpropertybedpart, state.getValue(HorizontalDirectionalBlock.FACING))))).is(this) && iblockdata1.getValue(PART) == BedPart.HEAD) {
            world.setBlock(blockposition1, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, blockposition1, Block.getId(iblockdata1));
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction enumdirection = ctx.getHorizontalDirection();
        BlockPos blockposition = ctx.getClickedPos();
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        Level world = ctx.getLevel();
        return world.getBlockState(blockposition1).canBeReplaced(ctx) && world.getWorldBorder().isWithinBounds(blockposition1) ? (BlockState)this.defaultBlockState().setValue(HorizontalDirectionalBlock.FACING, enumdirection) : null;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction enumdirection = BedBlock.getConnectedDirection(state).getOpposite();
        switch (enumdirection) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction enumdirection = state.getValue(HorizontalDirectionalBlock.FACING);
        return state.getValue(PART) == BedPart.HEAD ? enumdirection.getOpposite() : enumdirection;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        BedPart blockpropertybedpart = state.getValue(PART);
        return blockpropertybedpart == BedPart.HEAD ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    private static boolean isBunkBed(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos.below()).getBlock() instanceof BedBlock;
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> type, CollisionGetter world, BlockPos pos, Direction bedDirection, float spawnAngle) {
        Direction enumdirection2;
        Direction enumdirection1 = bedDirection.getClockWise();
        Direction direction = enumdirection2 = enumdirection1.isFacingAngle(spawnAngle) ? enumdirection1.getOpposite() : enumdirection1;
        if (BedBlock.isBunkBed(world, pos)) {
            return BedBlock.findBunkBedStandUpPosition(type, world, pos, bedDirection, enumdirection2);
        }
        int[][] aint = BedBlock.bedStandUpOffsets(bedDirection, enumdirection2);
        Optional<Vec3> optional = BedBlock.findStandUpPositionAtOffset(type, world, pos, aint, true);
        return optional.isPresent() ? optional : BedBlock.findStandUpPositionAtOffset(type, world, pos, aint, false);
    }

    private static Optional<Vec3> findBunkBedStandUpPosition(EntityType<?> type, CollisionGetter world, BlockPos pos, Direction bedDirection, Direction respawnDirection) {
        int[][] aint = BedBlock.bedSurroundStandUpOffsets(bedDirection, respawnDirection);
        Optional<Vec3> optional = BedBlock.findStandUpPositionAtOffset(type, world, pos, aint, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPos blockposition1 = pos.below();
        Optional<Vec3> optional1 = BedBlock.findStandUpPositionAtOffset(type, world, blockposition1, aint, true);
        if (optional1.isPresent()) {
            return optional1;
        }
        int[][] aint1 = BedBlock.bedAboveStandUpOffsets(bedDirection);
        Optional<Vec3> optional2 = BedBlock.findStandUpPositionAtOffset(type, world, pos, aint1, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        Optional<Vec3> optional3 = BedBlock.findStandUpPositionAtOffset(type, world, pos, aint, false);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vec3> optional4 = BedBlock.findStandUpPositionAtOffset(type, world, blockposition1, aint, false);
        return optional4.isPresent() ? optional4 : BedBlock.findStandUpPositionAtOffset(type, world, pos, aint1, false);
    }

    private static Optional<Vec3> findStandUpPositionAtOffset(EntityType<?> type, CollisionGetter world, BlockPos pos, int[][] possibleOffsets, boolean ignoreInvalidPos) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        int[][] aint1 = possibleOffsets;
        int i = possibleOffsets.length;
        for (int j = 0; j < i; ++j) {
            int[] aint2 = aint1[j];
            blockposition_mutableblockposition.set(pos.getX() + aint2[0], pos.getY(), pos.getZ() + aint2[1]);
            Vec3 vec3d = DismountHelper.findSafeDismountLocation(type, world, blockposition_mutableblockposition, ignoreInvalidPos);
            if (vec3d == null) continue;
            return Optional.of(vec3d);
        }
        return Optional.empty();
    }

    @Override
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(HorizontalDirectionalBlock.FACING, PART, OCCUPIED);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BedBlockEntity(pos, state, this.color);
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide) {
            BlockPos blockposition1 = pos.relative(state.getValue(HorizontalDirectionalBlock.FACING));
            world.setBlock(blockposition1, (BlockState)state.setValue(PART, BedPart.HEAD), 3);
            if (world.captureBlockStates) {
                return;
            }
            world.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes(world, pos, 3);
        }
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    protected long getSeed(BlockState state, BlockPos pos) {
        BlockPos blockposition1 = pos.relative(state.getValue(HorizontalDirectionalBlock.FACING), state.getValue(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.getSeed(blockposition1.getX(), pos.getY(), blockposition1.getZ());
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private static int[][] bedStandUpOffsets(Direction bedDirection, Direction respawnDirection) {
        return (int[][])ArrayUtils.addAll((Object[])BedBlock.bedSurroundStandUpOffsets(bedDirection, respawnDirection), (Object[])BedBlock.bedAboveStandUpOffsets(bedDirection));
    }

    private static int[][] bedSurroundStandUpOffsets(Direction bedDirection, Direction respawnDirection) {
        return new int[][]{{respawnDirection.getStepX(), respawnDirection.getStepZ()}, {respawnDirection.getStepX() - bedDirection.getStepX(), respawnDirection.getStepZ() - bedDirection.getStepZ()}, {respawnDirection.getStepX() - bedDirection.getStepX() * 2, respawnDirection.getStepZ() - bedDirection.getStepZ() * 2}, {-bedDirection.getStepX() * 2, -bedDirection.getStepZ() * 2}, {-respawnDirection.getStepX() - bedDirection.getStepX() * 2, -respawnDirection.getStepZ() - bedDirection.getStepZ() * 2}, {-respawnDirection.getStepX() - bedDirection.getStepX(), -respawnDirection.getStepZ() - bedDirection.getStepZ()}, {-respawnDirection.getStepX(), -respawnDirection.getStepZ()}, {-respawnDirection.getStepX() + bedDirection.getStepX(), -respawnDirection.getStepZ() + bedDirection.getStepZ()}, {bedDirection.getStepX(), bedDirection.getStepZ()}, {respawnDirection.getStepX() + bedDirection.getStepX(), respawnDirection.getStepZ() + bedDirection.getStepZ()}};
    }

    private static int[][] bedAboveStandUpOffsets(Direction bedDirection) {
        return new int[][]{{0, 0}, {-bedDirection.getStepX(), -bedDirection.getStepZ()}};
    }
}

