/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class CactusBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<CactusBlock> CODEC = CactusBlock.simpleCodec(CactusBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;
    public static final int MAX_AGE = 15;
    protected static final int AABB_OFFSET = 1;
    protected static final VoxelShape COLLISION_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    protected static final VoxelShape OUTLINE_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public MapCodec<CactusBlock> codec() {
        return CODEC;
    }

    protected CactusBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.stateDefinition.any().setValue(AGE, 0));
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive(world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos blockposition1 = pos.above();
        if (world.isEmptyBlock(blockposition1)) {
            int i = 1;
            while (world.getBlockState(pos.below(i)).is(this)) {
                ++i;
            }
            if (i < world.paperConfig().maxGrowthHeight.cactus) {
                int j = state.getValue(AGE);
                int modifier = world.spigotConfig.cactusModifier;
                if (j >= 15 || modifier != 100 && random.nextFloat() < (float)modifier / 1600.0f) {
                    CraftEventFactory.handleBlockGrowEvent(world, blockposition1, this.defaultBlockState());
                    BlockState iblockdata1 = (BlockState)state.setValue(AGE, 0);
                    world.setBlock(pos, iblockdata1, 4);
                    world.neighborChanged(iblockdata1, blockposition1, this, null, false);
                } else if (modifier == 100 || random.nextFloat() < (float)modifier / 1600.0f) {
                    world.setBlock(pos, (BlockState)state.setValue(AGE, j + 1), 4);
                }
            }
        }
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return OUTLINE_SHAPE;
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (!state.canSurvive(world, pos)) {
            tickView.scheduleTick(pos, this, 1);
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction enumdirection;
        BlockState iblockdata1;
        Iterator<Direction> iterator = Direction.Plane.HORIZONTAL.iterator();
        do {
            if (!iterator.hasNext()) {
                BlockState iblockdata2 = world.getBlockState(pos.below());
                return (iblockdata2.is(Blocks.CACTUS) || iblockdata2.is(BlockTags.SAND)) && !world.getBlockState(pos.above()).liquid();
            }
            enumdirection = iterator.next();
            iblockdata1 = world.getBlockState(pos.relative(enumdirection));
        } while ((!world.getWorldBorder().world.purpurConfig.cactusBreaksFromSolidNeighbors || !iblockdata1.isSolid()) && !world.getFluidState(pos.relative(enumdirection)).is(FluidTags.LAVA));
        return false;
    }

    @Override
    protected void entityInside(BlockState state, Level world, BlockPos pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        entity.hurt(world.damageSources().cactus().directBlock(world, pos), 1.0f);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(AGE);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        if (!((Level)world).purpurConfig.cactusAffectedByBonemeal || !world.isEmptyBlock(pos.above())) {
            return false;
        }
        int cactusHeight = 0;
        while (world.getBlockState(pos.below(cactusHeight)).is(this)) {
            ++cactusHeight;
        }
        return cactusHeight < ((Level)world).paperConfig().maxGrowthHeight.cactus;
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int cactusHeight = 0;
        while (world.getBlockState(pos.below(cactusHeight)).is(this)) {
            ++cactusHeight;
        }
        for (int i = 0; i <= world.paperConfig().maxGrowthHeight.cactus - cactusHeight; ++i) {
            world.setBlockAndUpdate(pos.above(i), (BlockState)state.setValue(AGE, 0));
        }
    }
}

