/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class ChorusFlowerBlock
extends Block {
    public static final MapCodec<ChorusFlowerBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("plant").forGetter(blockchorusflower -> blockchorusflower.plant), ChorusFlowerBlock.propertiesCodec()).apply((Applicative)instance, ChorusFlowerBlock::new));
    public static final int DEAD_AGE = 5;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;
    protected static final VoxelShape BLOCK_SUPPORT_SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    private final Block plant;

    public MapCodec<ChorusFlowerBlock> codec() {
        return CODEC;
    }

    protected ChorusFlowerBlock(Block plantBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.plant = plantBlock;
        this.registerDefaultState((BlockState)this.stateDefinition.any().setValue(AGE, 0));
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive(world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @Override
    protected boolean isRandomlyTicking(BlockState state) {
        return state.getValue(AGE) < 5;
    }

    @Override
    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter world, BlockPos pos) {
        return BLOCK_SUPPORT_SHAPE;
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i;
        BlockPos blockposition1 = pos.above();
        if (world.isEmptyBlock(blockposition1) && blockposition1.getY() <= world.getMaxY() && (i = state.getValue(AGE).intValue()) < 5) {
            int j;
            boolean flag = false;
            boolean flag1 = false;
            BlockState iblockdata1 = world.getBlockState(pos.below());
            if (iblockdata1.is(Blocks.END_STONE)) {
                flag = true;
            } else if (iblockdata1.is(this.plant)) {
                j = 1;
                for (int k = 0; k < 4; ++k) {
                    BlockState iblockdata2 = world.getBlockState(pos.below(j + 1));
                    if (!iblockdata2.is(this.plant)) {
                        if (!iblockdata2.is(Blocks.END_STONE)) break;
                        flag1 = true;
                        break;
                    }
                    ++j;
                }
                if (j < 2 || j <= random.nextInt(flag1 ? 5 : 4)) {
                    flag = true;
                }
            } else if (iblockdata1.isAir()) {
                flag = true;
            }
            if (flag && ChorusFlowerBlock.allNeighborsEmpty(world, blockposition1, null) && world.isEmptyBlock(pos.above(2))) {
                if (CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition1, (BlockState)this.defaultBlockState().setValue(AGE, i), 2)) {
                    world.setBlock(pos, ChorusPlantBlock.getStateWithConnections(world, pos, this.plant.defaultBlockState()), 2);
                    this.placeGrownFlower(world, blockposition1, i);
                }
            } else if (i < 4) {
                j = random.nextInt(4);
                if (flag1) {
                    ++j;
                }
                boolean flag2 = false;
                for (int l = 0; l < j; ++l) {
                    Direction enumdirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                    BlockPos blockposition2 = pos.relative(enumdirection);
                    if (!world.isEmptyBlock(blockposition2) || !world.isEmptyBlock(blockposition2.below()) || !ChorusFlowerBlock.allNeighborsEmpty(world, blockposition2, enumdirection.getOpposite()) || !CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition2, (BlockState)this.defaultBlockState().setValue(AGE, i + 1), 2)) continue;
                    this.placeGrownFlower(world, blockposition2, i + 1);
                    flag2 = true;
                }
                if (flag2) {
                    world.setBlock(pos, ChorusPlantBlock.getStateWithConnections(world, pos, this.plant.defaultBlockState()), 2);
                } else if (CraftEventFactory.handleBlockGrowEvent(world, pos, (BlockState)this.defaultBlockState().setValue(AGE, 5), 2)) {
                    this.placeDeadFlower(world, pos);
                }
            } else if (CraftEventFactory.handleBlockGrowEvent(world, pos, (BlockState)this.defaultBlockState().setValue(AGE, 5), 2)) {
                this.placeDeadFlower(world, pos);
            }
        }
    }

    private void placeGrownFlower(Level world, BlockPos pos, int age) {
        world.setBlock(pos, (BlockState)this.defaultBlockState().setValue(AGE, age), 2);
        world.levelEvent(1033, pos, 0);
    }

    private void placeDeadFlower(Level world, BlockPos pos) {
        world.setBlock(pos, (BlockState)this.defaultBlockState().setValue(AGE, 5), 2);
        world.levelEvent(1034, pos, 0);
    }

    private static boolean allNeighborsEmpty(LevelReader world, BlockPos pos, @Nullable Direction exceptDirection) {
        Direction enumdirection1;
        Iterator<Direction> iterator = Direction.Plane.HORIZONTAL.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((enumdirection1 = iterator.next()) == exceptDirection || world.isEmptyBlock(pos.relative(enumdirection1)));
        return false;
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction != Direction.UP && !state.canSurvive(world, pos)) {
            tickView.scheduleTick(pos, this, 1);
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState iblockdata1 = world.getBlockState(pos.below());
        if (!iblockdata1.is(this.plant) && !iblockdata1.is(Blocks.END_STONE)) {
            if (!iblockdata1.isAir()) {
                return false;
            }
            boolean flag = false;
            for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
                BlockState iblockdata2 = world.getBlockState(pos.relative(enumdirection));
                if (iblockdata2.is(this.plant)) {
                    if (flag) {
                        return false;
                    }
                    flag = true;
                    continue;
                }
                if (iblockdata2.isAir()) continue;
                return false;
            }
            return flag;
        }
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(AGE);
    }

    public static void generatePlant(LevelAccessor world, BlockPos pos, RandomSource random, int size) {
        world.setBlock(pos, ChorusPlantBlock.getStateWithConnections(world, pos, Blocks.CHORUS_PLANT.defaultBlockState()), 2);
        ChorusFlowerBlock.growTreeRecursive(world, pos, random, pos, size, 0);
    }

    private static void growTreeRecursive(LevelAccessor world, BlockPos pos, RandomSource random, BlockPos rootPos, int size, int layer) {
        Block block = Blocks.CHORUS_PLANT;
        int k = random.nextInt(4) + 1;
        if (layer == 0) {
            ++k;
        }
        for (int l = 0; l < k; ++l) {
            BlockPos blockposition2 = pos.above(l + 1);
            if (!ChorusFlowerBlock.allNeighborsEmpty(world, blockposition2, null)) {
                return;
            }
            world.setBlock(blockposition2, ChorusPlantBlock.getStateWithConnections(world, blockposition2, block.defaultBlockState()), 2);
            world.setBlock(blockposition2.below(), ChorusPlantBlock.getStateWithConnections(world, blockposition2.below(), block.defaultBlockState()), 2);
        }
        boolean flag = false;
        if (layer < 4) {
            int i1 = random.nextInt(4);
            if (layer == 0) {
                ++i1;
            }
            for (int j1 = 0; j1 < i1; ++j1) {
                Direction enumdirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
                BlockPos blockposition3 = pos.above(k).relative(enumdirection);
                if (Math.abs(blockposition3.getX() - rootPos.getX()) >= size || Math.abs(blockposition3.getZ() - rootPos.getZ()) >= size || !world.isEmptyBlock(blockposition3) || !world.isEmptyBlock(blockposition3.below()) || !ChorusFlowerBlock.allNeighborsEmpty(world, blockposition3, enumdirection.getOpposite())) continue;
                flag = true;
                world.setBlock(blockposition3, ChorusPlantBlock.getStateWithConnections(world, blockposition3, block.defaultBlockState()), 2);
                world.setBlock(blockposition3.relative(enumdirection.getOpposite()), ChorusPlantBlock.getStateWithConnections(world, blockposition3.relative(enumdirection.getOpposite()), block.defaultBlockState()), 2);
                ChorusFlowerBlock.growTreeRecursive(world, blockposition3, random, rootPos, size, layer + 1);
            }
        }
        if (!flag) {
            world.setBlock(pos.above(k), (BlockState)Blocks.CHORUS_FLOWER.defaultBlockState().setValue(AGE, 5), 2);
        }
    }

    @Override
    protected void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        ServerLevel worldserver;
        BlockPos blockposition = hit.getBlockPos();
        if (world instanceof ServerLevel && projectile.mayInteract(worldserver = (ServerLevel)world, blockposition) && projectile.mayBreak(worldserver)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockposition, state.getFluidState().createLegacyBlock())) {
                return;
            }
            world.destroyBlock(blockposition, true, projectile);
        }
    }
}

