/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFormEvent;

public class ConcretePowderBlock
extends FallingBlock {
    public static final MapCodec<ConcretePowderBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("concrete").forGetter(blockconcretepowder -> blockconcretepowder.concrete), ConcretePowderBlock.propertiesCodec()).apply((Applicative)instance, ConcretePowderBlock::new));
    private final Block concrete;

    public MapCodec<ConcretePowderBlock> codec() {
        return CODEC;
    }

    public ConcretePowderBlock(Block hardened, BlockBehaviour.Properties settings) {
        super(settings);
        this.concrete = hardened;
    }

    @Override
    public void onLand(Level world, BlockPos pos, BlockState fallingBlockState, BlockState currentStateInPos, FallingBlockEntity fallingBlockEntity) {
        if (ConcretePowderBlock.shouldSolidify(world, pos, currentStateInPos)) {
            CraftEventFactory.handleBlockFormEvent(world, pos, this.concrete.defaultBlockState(), 3);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState iblockdata;
        BlockPos blockposition;
        Level world = ctx.getLevel();
        if (!ConcretePowderBlock.shouldSolidify(world, blockposition = ctx.getClickedPos(), iblockdata = world.getBlockState(blockposition))) {
            return super.getStateForPlacement(ctx);
        }
        CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockposition);
        blockState.setData(this.concrete.defaultBlockState());
        BlockFormEvent event = new BlockFormEvent((org.bukkit.block.Block)blockState.getBlock(), (org.bukkit.block.BlockState)blockState);
        world.getServer().server.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            return blockState.getHandle();
        }
        return super.getStateForPlacement(ctx);
    }

    private static boolean shouldSolidify(BlockGetter world, BlockPos pos, BlockState state) {
        return ConcretePowderBlock.canSolidify(state) || ConcretePowderBlock.touchesLiquid(world, pos);
    }

    private static boolean touchesLiquid(BlockGetter world, BlockPos pos) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = pos.mutable();
        for (Direction enumdirection : Direction.values()) {
            BlockState iblockdata = world.getBlockState(blockposition_mutableblockposition);
            if (enumdirection == Direction.DOWN && !ConcretePowderBlock.canSolidify(iblockdata)) continue;
            blockposition_mutableblockposition.setWithOffset((Vec3i)pos, enumdirection);
            iblockdata = world.getBlockState(blockposition_mutableblockposition);
            if (!ConcretePowderBlock.canSolidify(iblockdata) || iblockdata.isFaceSturdy(world, pos, enumdirection.getOpposite())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean canSolidify(BlockState state) {
        return state.getFluidState().is(FluidTags.WATER);
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (ConcretePowderBlock.touchesLiquid(world, pos)) {
            if (!(world instanceof Level)) {
                return this.concrete.defaultBlockState();
            }
            Level world1 = (Level)world;
            CraftBlockState blockState = CraftBlockStates.getBlockState(world1, pos);
            blockState.setData(this.concrete.defaultBlockState());
            BlockFormEvent event = new BlockFormEvent((org.bukkit.block.Block)blockState.getBlock(), (org.bukkit.block.BlockState)blockState);
            world1.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public int getDustColor(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getMapColor((BlockGetter)world, (BlockPos)pos).col;
    }
}

