/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class CreakingHeartBlock
extends BaseEntityBlock {
    public static final MapCodec<CreakingHeartBlock> CODEC = CreakingHeartBlock.simpleCodec(CreakingHeartBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<CreakingHeartState> CREAKING = BlockStateProperties.CREAKING;

    @Override
    public MapCodec<CreakingHeartBlock> codec() {
        return CODEC;
    }

    protected CreakingHeartBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, Direction.Axis.Y)).setValue(CREAKING, CreakingHeartState.DISABLED));
    }

    @Override
    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CreakingHeartBlockEntity(pos, state);
    }

    @Override
    @Nullable
    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.isClientSide) {
            return null;
        }
        if (state.getValue(CREAKING) != CreakingHeartState.DISABLED) {
            return CreakingHeartBlock.createTickerHelper(type, BlockEntityType.CREAKING_HEART, CreakingHeartBlockEntity::serverTick);
        }
        return null;
    }

    public static boolean canSummonCreaking(Level world) {
        return world.dimensionType().natural() && world.isNight();
    }

    @Override
    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!CreakingHeartBlock.canSummonCreaking(world)) {
            return;
        }
        if (state.getValue(CREAKING) == CreakingHeartState.DISABLED) {
            return;
        }
        if (random.nextInt(16) == 0 && CreakingHeartBlock.isSurroundedByLogs(world, pos)) {
            world.playLocalSound(pos.getX(), pos.getY(), pos.getZ(), SoundEvents.CREAKING_HEART_IDLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    @Override
    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        BlockState blockState = super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
        return CreakingHeartBlock.updateState(blockState, world, pos);
    }

    private static BlockState updateState(BlockState state, LevelReader world, BlockPos pos) {
        boolean bl = CreakingHeartBlock.hasRequiredLogs(state, world, pos);
        CreakingHeartState creakingHeartState = state.getValue(CREAKING);
        if (bl && creakingHeartState == CreakingHeartState.DISABLED) {
            return (BlockState)state.setValue(CREAKING, CreakingHeartState.DORMANT);
        }
        return state;
    }

    public static boolean hasRequiredLogs(BlockState state, LevelReader world, BlockPos pos) {
        Direction.Axis axis = state.getValue(AXIS);
        for (Direction direction : axis.getDirections()) {
            BlockState blockState = world.getBlockState(pos.relative(direction));
            if (blockState.is(BlockTags.PALE_OAK_LOGS) && blockState.getValue(AXIS) == axis) continue;
            return false;
        }
        return true;
    }

    private static boolean isSurroundedByLogs(LevelAccessor world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = world.getBlockState(blockPos);
            if (blockState.is(BlockTags.PALE_OAK_LOGS)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return CreakingHeartBlock.updateState((BlockState)this.defaultBlockState().setValue(AXIS, ctx.getClickedFace().getAxis()), ctx.getLevel(), ctx.getClickedPos());
    }

    @Override
    @Override
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return RotatedPillarBlock.rotatePillar(state, rotation);
    }

    @Override
    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(AXIS, CREAKING);
    }

    @Override
    @Override
    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)blockEntity;
            creakingHeartBlockEntity.removeProtector(null);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    @Override
    @Override
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)blockEntity;
            creakingHeartBlockEntity.removeProtector(player.damageSources().playerAttack(player));
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Override
    @Override
    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Override
    protected int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        void creakingHeartBlockEntity2;
        if (state.getValue(CREAKING) != CreakingHeartState.ACTIVE) {
            return 0;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof CreakingHeartBlockEntity)) {
            return 0;
        }
        CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)blockEntity;
        return creakingHeartBlockEntity2.getAnalogOutputSignal();
    }

    public static enum CreakingHeartState implements StringRepresentable
    {
        DISABLED("disabled"),
        DORMANT("dormant"),
        ACTIVE("active");

        private final String name;

        private CreakingHeartState(String name) {
            this.name = name;
        }

        @Override
        @Override
        public String getSerializedName() {
            return this.name;
        }
    }
}

