/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.player.PlayerFlowerPotManipulateEvent;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class FlowerPotBlock
extends Block {
    public static final MapCodec<FlowerPotBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("potted").forGetter(block -> block.potted), FlowerPotBlock.propertiesCodec()).apply((Applicative)instance, FlowerPotBlock::new));
    private static final Map<Block, Block> POTTED_BY_CONTENT = Maps.newHashMap();
    public static final float AABB_SIZE = 3.0f;
    protected static final VoxelShape SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final Block potted;

    public MapCodec<FlowerPotBlock> codec() {
        return CODEC;
    }

    public FlowerPotBlock(Block content, BlockBehaviour.Properties settings) {
        super(settings);
        this.potted = content;
        POTTED_BY_CONTENT.put(content, this);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected InteractionResult useItemOn(net.minecraft.world.item.ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Block block;
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = POTTED_BY_CONTENT.getOrDefault(blockItem.getBlock(), Blocks.AIR);
        } else {
            block = Blocks.AIR;
        }
        BlockState blockState = block.defaultBlockState();
        if (blockState.isAir()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!this.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        CraftBlock block2 = CraftBlock.at(world, pos);
        ItemStack placedStack = CraftItemStack.asBukkitCopy(stack);
        PlayerFlowerPotManipulateEvent event = new PlayerFlowerPotManipulateEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.block.Block)block2, placedStack, true);
        if (!event.callEvent()) {
            player.containerMenu.sendAllDataToRemote();
            return InteractionResult.CONSUME;
        }
        world.setBlock(pos, blockState, 3);
        world.gameEvent((Entity)player, GameEvent.BLOCK_CHANGE, pos);
        player.awardStat(Stats.POT_FLOWER);
        stack.consume(1, player);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (this.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        net.minecraft.world.item.ItemStack itemStack = new net.minecraft.world.item.ItemStack(this.potted);
        CraftBlock block = CraftBlock.at(world, pos);
        ItemStack pottedStack = new ItemStack(CraftBlockType.minecraftToBukkit(this.potted));
        PlayerFlowerPotManipulateEvent event = new PlayerFlowerPotManipulateEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.block.Block)block, pottedStack, false);
        if (!event.callEvent()) {
            player.containerMenu.sendAllDataToRemote();
            return InteractionResult.PASS;
        }
        if (!player.addItem(itemStack)) {
            player.drop(itemStack, false);
        }
        world.setBlock(pos, Blocks.FLOWER_POT.defaultBlockState(), 3);
        world.gameEvent((Entity)player, GameEvent.BLOCK_CHANGE, pos);
        return InteractionResult.SUCCESS;
    }

    @Override
    public net.minecraft.world.item.ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return this.isEmpty() ? super.getCloneItemStack(world, pos, state) : new net.minecraft.world.item.ItemStack(this.potted);
    }

    private boolean isEmpty() {
        return this.potted == Blocks.AIR;
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return direction == Direction.DOWN && !state.canSurvive(world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public Block getPotted() {
        return this.potted;
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

