/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class SculkVeinBlock
extends MultifaceBlock
implements SculkBehaviour,
SimpleWaterloggedBlock {
    public static final MapCodec<SculkVeinBlock> CODEC = SculkVeinBlock.simpleCodec(SculkVeinBlock::new);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final MultifaceSpreader veinSpreader = new MultifaceSpreader(new SculkVeinSpreaderConfig(this, this, MultifaceSpreader.DEFAULT_SPREAD_ORDER));
    private final MultifaceSpreader sameSpaceSpreader = new MultifaceSpreader(new SculkVeinSpreaderConfig(this, this, MultifaceSpreader.SpreadType.SAME_POSITION));

    public MapCodec<SculkVeinBlock> codec() {
        return CODEC;
    }

    public SculkVeinBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(WATERLOGGED, false));
    }

    @Override
    public MultifaceSpreader getSpreader() {
        return this.veinSpreader;
    }

    public MultifaceSpreader getSameSpaceSpreader() {
        return this.sameSpaceSpreader;
    }

    public static boolean regrow(LevelAccessor world, BlockPos pos, BlockState state, Collection<Direction> directions) {
        boolean flag = false;
        BlockState iblockdata1 = Blocks.SCULK_VEIN.defaultBlockState();
        for (Direction enumdirection : directions) {
            BlockPos blockposition1;
            if (!SculkVeinBlock.canAttachTo(world, enumdirection, blockposition1 = pos.relative(enumdirection), world.getBlockState(blockposition1))) continue;
            iblockdata1 = (BlockState)iblockdata1.setValue(SculkVeinBlock.getFaceProperty(enumdirection), true);
            flag = true;
        }
        if (!flag) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            iblockdata1 = (BlockState)iblockdata1.setValue(WATERLOGGED, true);
        }
        world.setBlock(pos, iblockdata1, 3);
        return true;
    }

    @Override
    public void onDischarged(LevelAccessor world, BlockState state, BlockPos pos, RandomSource random) {
        if (state.is(this)) {
            for (Direction enumdirection : MultifaceBlock.DIRECTIONS) {
                BooleanProperty blockstateboolean = SculkVeinBlock.getFaceProperty(enumdirection);
                if (!state.getValue(blockstateboolean).booleanValue() || !world.getBlockState(pos.relative(enumdirection)).is(Blocks.SCULK)) continue;
                state = (BlockState)state.setValue(blockstateboolean, false);
            }
            if (!SculkVeinBlock.hasAnyFace(state)) {
                FluidState fluid = world.getFluidState(pos);
                state = (fluid.isEmpty() ? Blocks.AIR : Blocks.WATER).defaultBlockState();
            }
            world.setBlock(pos, state, 3);
            SculkBehaviour.super.onDischarged(world, state, pos, random);
        }
    }

    @Override
    public int attemptUseCharge(SculkSpreader.ChargeCursor cursor, LevelAccessor world, BlockPos catalystPos, RandomSource random, SculkSpreader spreadManager, boolean shouldConvertToBlock) {
        return shouldConvertToBlock && this.attemptPlaceSculk(spreadManager, world, cursor.getPos(), random, catalystPos) ? cursor.getCharge() - 1 : (random.nextInt(spreadManager.chargeDecayRate()) == 0 ? Mth.floor((float)cursor.getCharge() * 0.5f) : cursor.getCharge());
    }

    private boolean attemptPlaceSculk(SculkSpreader sculkspreader, LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource, BlockPos sourceBlock) {
        BlockState iblockdata = generatoraccess.getBlockState(blockposition);
        TagKey<Block> tagkey = sculkspreader.replaceableBlocks();
        for (Direction enumdirection : Direction.allShuffled(randomsource)) {
            BlockPos blockposition1;
            BlockState iblockdata1;
            if (!SculkVeinBlock.hasFace(iblockdata, enumdirection) || !(iblockdata1 = generatoraccess.getBlockState(blockposition1 = blockposition.relative(enumdirection))).is(tagkey)) continue;
            BlockState iblockdata2 = Blocks.SCULK.defaultBlockState();
            if (!CraftEventFactory.handleBlockSpreadEvent(generatoraccess, sourceBlock, blockposition1, iblockdata2, 3)) {
                return false;
            }
            Block.pushEntitiesUp(iblockdata1, iblockdata2, generatoraccess, blockposition1);
            generatoraccess.playSound(null, blockposition1, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.veinSpreader.spreadAll(iblockdata2, generatoraccess, blockposition1, sculkspreader.isWorldGeneration());
            Direction enumdirection1 = enumdirection.getOpposite();
            for (Direction enumdirection2 : MultifaceBlock.DIRECTIONS) {
                BlockPos blockposition2;
                BlockState iblockdata3;
                if (enumdirection2 == enumdirection1 || !(iblockdata3 = generatoraccess.getBlockState(blockposition2 = blockposition1.relative(enumdirection2))).is(this)) continue;
                this.onDischarged(generatoraccess, iblockdata3, blockposition2, randomsource);
            }
            return true;
        }
        return false;
    }

    public static boolean hasSubstrateAccess(LevelAccessor world, BlockState state, BlockPos pos) {
        if (!state.is(Blocks.SCULK_VEIN)) {
            return false;
        }
        for (Direction enumdirection : MultifaceBlock.DIRECTIONS) {
            if (!SculkVeinBlock.hasFace(state, enumdirection) || !world.getBlockState(pos.relative(enumdirection)).is(BlockTags.SCULK_REPLACEABLE)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (state.getValue(WATERLOGGED).booleanValue()) {
            tickView.scheduleTick(pos, Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(WATERLOGGED);
    }

    @Override
    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.getItemInHand().is(Items.SCULK_VEIN) || super.canBeReplaced(state, context);
    }

    @Override
    protected FluidState getFluidState(BlockState state) {
        return state.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    private class SculkVeinSpreaderConfig
    extends MultifaceSpreader.DefaultSpreaderConfig {
        private final MultifaceSpreader.SpreadType[] spreadTypes;

        public SculkVeinSpreaderConfig(SculkVeinBlock sculkVeinBlock, SculkVeinBlock growTypes, MultifaceSpreader.SpreadType ... amultifacespreader_e) {
            super(growTypes);
            this.spreadTypes = amultifacespreader_e;
        }

        @Override
        public boolean stateCanBeReplaced(BlockGetter world, BlockPos pos, BlockPos growPos, Direction direction, BlockState state) {
            BlockState iblockdata1 = world.getBlockState(growPos.relative(direction));
            if (!(iblockdata1.is(Blocks.SCULK) || iblockdata1.is(Blocks.SCULK_CATALYST) || iblockdata1.is(Blocks.MOVING_PISTON))) {
                BlockPos blockposition2;
                if (pos.distManhattan(growPos) == 2 && world.getBlockState(blockposition2 = pos.relative(direction.getOpposite())).isFaceSturdy(world, blockposition2, direction)) {
                    return false;
                }
                FluidState fluid = state.getFluidState();
                return !fluid.isEmpty() && !fluid.is(Fluids.WATER) ? false : (state.is(BlockTags.FIRE) ? false : state.canBeReplaced() || super.stateCanBeReplaced(world, pos, growPos, direction, state));
            }
            return false;
        }

        @Override
        public MultifaceSpreader.SpreadType[] getSpreadTypes() {
            return this.spreadTypes;
        }

        @Override
        public boolean isOtherBlockValidAsSource(BlockState state) {
            return !state.is(Blocks.SCULK_VEIN);
        }
    }
}

