/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.player.PlayerSignOpenEvent;

public abstract class SignBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final float AABB_OFFSET = 4.0f;
    protected static final VoxelShape SHAPE = Block.box(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private final WoodType type;

    protected SignBlock(WoodType type, BlockBehaviour.Properties settings) {
        super(settings);
        this.type = type;
    }

    protected abstract MapCodec<? extends SignBlock> codec();

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (state.getValue(WATERLOGGED).booleanValue()) {
            tickView.scheduleTick(pos, Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SignBlockEntity(pos, state);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof SignBlockEntity) {
            boolean flag;
            SignApplicator signapplicator1;
            SignBlockEntity tileentitysign = (SignBlockEntity)tileentity;
            Item item = stack.getItem();
            SignApplicator signapplicator = item instanceof SignApplicator ? (signapplicator1 = (SignApplicator)((Object)item)) : null;
            SignApplicator signapplicator2 = signapplicator;
            boolean bl = flag = signapplicator2 != null && player.mayBuild();
            if (!world.isClientSide) {
                if (flag && !tileentitysign.isWaxed() && !this.otherPlayerIsEditingSign(player, tileentitysign)) {
                    boolean flag1 = tileentitysign.isFacingFrontText(player);
                    if (signapplicator2.canApplyToSign(tileentitysign.getText(flag1), player) && signapplicator2.tryApplyToSign(world, tileentitysign, flag1, player)) {
                        tileentitysign.executeClickCommandsIfPresent(player, world, pos, flag1);
                        player.awardStat(Stats.ITEM_USED.get(stack.getItem()));
                        world.gameEvent(GameEvent.BLOCK_CHANGE, tileentitysign.getBlockPos(), GameEvent.Context.of(player, tileentitysign.getBlockState()));
                        stack.consume(1, player);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            return !flag && !tileentitysign.isWaxed() ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof SignBlockEntity) {
            SignBlockEntity tileentitysign = (SignBlockEntity)tileentity;
            if (world.isClientSide) {
                Util.pauseInIde(new IllegalStateException("Expected to only call this on server"));
            }
            boolean flag = tileentitysign.isFacingFrontText(player);
            boolean flag1 = tileentitysign.executeClickCommandsIfPresent(player, world, pos, flag);
            if (tileentitysign.isWaxed()) {
                world.playSound(null, tileentitysign.getBlockPos(), tileentitysign.getSignInteractionFailedSoundEvent(), SoundSource.BLOCKS);
                return InteractionResult.SUCCESS_SERVER;
            }
            if (flag1) {
                return InteractionResult.SUCCESS_SERVER;
            }
            if (!this.otherPlayerIsEditingSign(player, tileentitysign) && player.mayBuild() && this.hasEditableText(player, tileentitysign, flag)) {
                this.openTextEdit(player, tileentitysign, flag, PlayerOpenSignEvent.Cause.INTERACT);
                return InteractionResult.SUCCESS_SERVER;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private boolean hasEditableText(Player player, SignBlockEntity blockEntity, boolean front) {
        SignText signtext = blockEntity.getText(front);
        return Arrays.stream(signtext.getMessages(player.isTextFilteringEnabled())).allMatch(ichatbasecomponent -> ichatbasecomponent.equals(CommonComponents.EMPTY) || ichatbasecomponent.getContents() instanceof PlainTextContents);
    }

    public abstract float getYRotationDegrees(BlockState var1);

    public Vec3 getSignHitboxCenterPosition(BlockState state) {
        return new Vec3(0.5, 0.5, 0.5);
    }

    @Override
    protected FluidState getFluidState(BlockState state) {
        return state.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public WoodType type() {
        return this.type;
    }

    public static WoodType getWoodType(Block block) {
        WoodType blockpropertywood = block instanceof SignBlock ? ((SignBlock)block).type() : WoodType.OAK;
        return blockpropertywood;
    }

    @DoNotUse
    @Deprecated
    public void openTextEdit(Player player, SignBlockEntity blockEntity, boolean front) {
        this.openTextEdit(player, blockEntity, front, PlayerOpenSignEvent.Cause.UNKNOWN);
    }

    public void openTextEdit(Player entityhuman, SignBlockEntity tileentitysign, boolean flag, PlayerOpenSignEvent.Cause cause) {
        CraftBlock bukkitBlock;
        CraftSign bukkitSign;
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)entityhuman.getBukkitEntity();
        PlayerOpenSignEvent event = new PlayerOpenSignEvent(bukkitPlayer, (Sign)(bukkitSign = (CraftSign)CraftBlockStates.getBlockState(bukkitBlock = CraftBlock.at(tileentitysign.getLevel(), tileentitysign.getBlockPos()))), flag ? Side.FRONT : Side.BACK, cause);
        if (!event.callEvent()) {
            return;
        }
        if (PlayerSignOpenEvent.getHandlerList().getRegisteredListeners().length > 0) {
            PlayerSignOpenEvent.Cause legacyCause;
            switch (cause) {
                default: {
                    throw new MatchException(null, null);
                }
                case PLACE: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.PLACE;
                    break;
                }
                case PLUGIN: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.PLUGIN;
                    break;
                }
                case INTERACT: {
                    PlayerSignOpenEvent.Cause cause2 = PlayerSignOpenEvent.Cause.INTERACT;
                    break;
                }
                case UNKNOWN: {
                    PlayerSignOpenEvent.Cause cause2 = legacyCause = PlayerSignOpenEvent.Cause.UNKNOWN;
                }
            }
            if (!CraftEventFactory.callPlayerSignOpenEvent(entityhuman, tileentitysign, flag, legacyCause)) {
                return;
            }
        }
        tileentitysign.setAllowedPlayerEditor(entityhuman.getUUID());
        entityhuman.openTextEdit(tileentitysign, flag);
    }

    private boolean otherPlayerIsEditingSign(Player player, SignBlockEntity blockEntity) {
        UUID uuid = blockEntity.getPlayerWhoMayEdit();
        return uuid != null && !uuid.equals(player.getUUID());
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return null;
    }
}

