/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class TurtleEggBlock
extends Block {
    public static final MapCodec<TurtleEggBlock> CODEC = TurtleEggBlock.simpleCodec(TurtleEggBlock::new);
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 4;
    private static final VoxelShape ONE_EGG_AABB = Block.box(3.0, 0.0, 3.0, 12.0, 7.0, 12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.box(1.0, 0.0, 1.0, 15.0, 7.0, 15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final IntegerProperty EGGS = BlockStateProperties.EGGS;

    public MapCodec<TurtleEggBlock> codec() {
        return CODEC;
    }

    public TurtleEggBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any().setValue(HATCH, 0)).setValue(EGGS, 1));
    }

    @Override
    public void stepOn(Level world, BlockPos pos, BlockState state, net.minecraft.world.entity.Entity entity) {
        if (!entity.isSteppingCarefully()) {
            this.destroyEgg(world, state, pos, entity, 100);
        }
        super.stepOn(world, pos, state, entity);
    }

    @Override
    public void fallOn(Level world, BlockState state, BlockPos pos, net.minecraft.world.entity.Entity entity, float fallDistance) {
        if (!(entity instanceof Zombie)) {
            this.destroyEgg(world, state, pos, entity, 3);
        }
        super.fallOn(world, state, pos, entity, fallDistance);
    }

    private void destroyEgg(Level world, BlockState state, BlockPos pos, net.minecraft.world.entity.Entity entity, int inverseChance) {
        ServerLevel worldserver;
        if (state.is(Blocks.TURTLE_EGG) && world instanceof ServerLevel && this.canDestroyEgg(worldserver = (ServerLevel)world, entity) && world.random.nextInt(inverseChance) == 0) {
            PlayerInteractEvent cancellable;
            if (entity instanceof Player) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(worldserver, pos));
                worldserver.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.decreaseEggs(worldserver, pos, state);
        }
    }

    public void decreaseEggs(Level world, BlockPos pos, BlockState state) {
        world.playSound((Player)null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + world.random.nextFloat() * 0.2f);
        int i = state.getValue(EGGS);
        if (i <= 1) {
            world.destroyBlock(pos, false);
        } else {
            world.setBlock(pos, (BlockState)state.setValue(EGGS, i - 1), 2);
            world.gameEvent(GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(state));
            world.levelEvent(2001, pos, Block.getId(state));
        }
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.shouldUpdateHatchLevel(world) && TurtleEggBlock.onSand(world, pos)) {
            int i = state.getValue(HATCH);
            if (i < 2) {
                if (!CraftEventFactory.handleBlockGrowEvent(world, pos, (BlockState)state.setValue(HATCH, i + 1), 2)) {
                    return;
                }
                world.playSound((Player)null, pos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                world.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(state));
            } else {
                if (CraftEventFactory.callBlockFadeEvent(world, pos, Blocks.AIR.defaultBlockState()).isCancelled()) {
                    return;
                }
                world.playSound((Player)null, pos, SoundEvents.TURTLE_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                world.removeBlock(pos, false);
                world.gameEvent(GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(state));
                for (int j = 0; j < state.getValue(EGGS); ++j) {
                    world.levelEvent(2001, pos, Block.getId(state));
                    Turtle entityturtle = EntityType.TURTLE.create(world, EntitySpawnReason.BREEDING);
                    if (entityturtle == null) continue;
                    entityturtle.setAge(-24000);
                    entityturtle.setHomePos(pos);
                    entityturtle.moveTo((double)pos.getX() + 0.3 + (double)j * 0.2, pos.getY(), (double)pos.getZ() + 0.3, 0.0f, 0.0f);
                    world.addFreshEntity(entityturtle, CreatureSpawnEvent.SpawnReason.EGG);
                }
            }
        }
    }

    public static boolean onSand(BlockGetter world, BlockPos pos) {
        return TurtleEggBlock.isSand(world, pos.below());
    }

    public static boolean isSand(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos).is(BlockTags.SAND);
    }

    @Override
    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (TurtleEggBlock.onSand(world, pos) && !world.isClientSide) {
            world.levelEvent(2012, pos, 15);
        }
    }

    private boolean shouldUpdateHatchLevel(Level world) {
        float f = world.getTimeOfDay(1.0f);
        return (double)f < 0.69 && (double)f > 0.65 ? true : world.random.nextInt(world.purpurConfig.turtleEggsRandomTickCrackChance) == 0;
    }

    @Override
    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool, boolean includeDrops, boolean dropExp) {
        super.playerDestroy(world, player, pos, state, blockEntity, tool, includeDrops, dropExp);
        this.decreaseEggs(world, pos, state);
    }

    @Override
    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.isSecondaryUseActive() && context.getItemInHand().is(this.asItem()) && state.getValue(EGGS) < 4 ? true : super.canBeReplaced(state, context);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState iblockdata = ctx.getLevel().getBlockState(ctx.getClickedPos());
        return iblockdata.is(this) ? (BlockState)iblockdata.setValue(EGGS, Math.min(4, iblockdata.getValue(EGGS) + 1)) : super.getStateForPlacement(ctx);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue(EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(HATCH, EGGS);
    }

    private boolean canDestroyEgg(ServerLevel world, net.minecraft.world.entity.Entity entity) {
        if (entity instanceof Turtle || entity instanceof Bat) {
            return false;
        }
        if (world.purpurConfig.turtleEggsBreakFromExpOrbs && entity instanceof ExperienceOrb) {
            return true;
        }
        if (world.purpurConfig.turtleEggsBreakFromItems && entity instanceof ItemEntity) {
            return true;
        }
        if (world.purpurConfig.turtleEggsBreakFromMinecarts && entity instanceof AbstractMinecart) {
            return true;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (world.purpurConfig.turtleEggsTramplingFeatherFalling) {
            Iterator<ItemStack> armor = ((LivingEntity)entity).getArmorSlots().iterator();
            return !armor.hasNext() || EnchantmentHelper.getItemEnchantmentLevel(Enchantments.FEATHER_FALLING, armor.next()) < (int)entity.fallDistance;
        }
        if (entity instanceof Player) {
            return true;
        }
        return world.purpurConfig.turtleEggsBypassMobGriefing ^ world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }
}

