/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;

public class BeehiveBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_FLOWER_POS = "flower_pos";
    private static final String BEES = "bees";
    static final List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "hive_pos", "Passengers", "leash", "UUID");
    public static final int MAX_OCCUPANTS = 3;
    private static final int MIN_TICKS_BEFORE_REENTERING_HIVE = 400;
    private static final int MIN_OCCUPATION_TICKS_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_NECTARLESS = 600;
    private List<BeeData> stored = Lists.newArrayList();
    @Nullable
    public BlockPos savedFlowerPos;
    public int maxBees = PurpurConfig.beeInsideBeeHive;

    public BeehiveBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.BEEHIVE, pos, state);
    }

    @Override
    public void setChanged() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromHive(null, this.level.getBlockState(this.getBlockPos()), BeeReleaseStatus.EMERGENCY);
        }
        super.setChanged();
    }

    public boolean isFireNearby() {
        BlockPos blockposition;
        if (this.level == null) {
            return false;
        }
        Iterator<BlockPos> iterator = BlockPos.betweenClosed(this.worldPosition.offset(-1, -1, -1), this.worldPosition.offset(1, 1, 1)).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(this.level.getBlockState(blockposition = iterator.next()).getBlock() instanceof FireBlock));
        return true;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == this.maxBees;
    }

    public void emptyAllLivingFromHive(@Nullable Player player, BlockState state, BeeReleaseStatus beeState) {
        List<net.minecraft.world.entity.Entity> list = this.releaseAllOccupants(state, beeState);
        if (player != null) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (!(entity instanceof Bee)) continue;
                Bee entitybee = (Bee)entity;
                if (!(player.position().distanceToSqr(entity.position()) <= 16.0)) continue;
                if (!this.isSedated()) {
                    entitybee.setTarget(player, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    continue;
                }
                entitybee.setStayOutOfHiveCountdown(400);
            }
        }
    }

    private List<net.minecraft.world.entity.Entity> releaseAllOccupants(BlockState state, BeeReleaseStatus beeState) {
        return this.releaseBees(state, beeState, false);
    }

    public List<net.minecraft.world.entity.Entity> releaseBees(BlockState iblockdata, BeeReleaseStatus tileentitybeehive_releasestatus, boolean force) {
        ArrayList list = Lists.newArrayList();
        this.stored.removeIf(tileentitybeehive_hivebee -> BeehiveBlockEntity.releaseOccupant(this.level, this.worldPosition, iblockdata, tileentitybeehive_hivebee.toOccupant(), list, tileentitybeehive_releasestatus, this.savedFlowerPos, force));
        if (!list.isEmpty()) {
            super.setChanged();
        }
        return list;
    }

    public List<net.minecraft.world.entity.Entity> releaseBee(BlockState iblockdata, BeeData data, BeeReleaseStatus tileentitybeehive_releasestatus, boolean force) {
        ArrayList list = Lists.newArrayList();
        BeehiveBlockEntity.releaseOccupant(this.level, this.worldPosition, iblockdata, data.occupant, list, tileentitybeehive_releasestatus, this.savedFlowerPos, force);
        if (!list.isEmpty()) {
            this.stored.remove(data);
            super.setChanged();
        }
        return list;
    }

    @VisibleForDebug
    public int getOccupantCount() {
        return this.stored.size();
    }

    public List<BeeData> getStored() {
        return this.stored;
    }

    public void clearBees() {
        this.stored.clear();
    }

    public static int getHoneyLevel(BlockState state) {
        return state.getValue(BeehiveBlock.HONEY_LEVEL);
    }

    @VisibleForDebug
    public boolean isSedated() {
        return CampfireBlock.isSmokeyPos(this.level, this.getBlockPos());
    }

    public void addOccupant(net.minecraft.world.entity.Entity entity) {
        if (this.stored.size() < this.maxBees) {
            if (this.level != null) {
                EntityEnterBlockEvent event = new EntityEnterBlockEvent((Entity)entity.getBukkitEntity(), (Block)CraftBlock.at(this.level, this.getBlockPos()));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    if (entity instanceof Bee) {
                        ((Bee)entity).setStayOutOfHiveCountdown(400);
                    }
                    return;
                }
            }
            entity.stopRiding();
            entity.ejectPassengers();
            this.storeBee(Occupant.of(entity));
            if (this.level != null) {
                Bee entitybee;
                if (entity instanceof Bee && (entitybee = (Bee)entity).hasSavedFlowerPos() && (!this.hasSavedFlowerPos() || this.level.random.nextBoolean())) {
                    this.savedFlowerPos = entitybee.getSavedFlowerPos();
                }
                BlockPos blockposition = this.getBlockPos();
                this.level.playSound((Player)null, (double)blockposition.getX(), (double)blockposition.getY(), (double)blockposition.getZ(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.level.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(entity, this.getBlockState()));
            }
            entity.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
            super.setChanged();
        }
    }

    public void storeBee(Occupant bee) {
        this.stored.add(new BeeData(bee));
    }

    private static boolean releaseOccupant(Level world, BlockPos pos, BlockState state, Occupant bee, @Nullable List<net.minecraft.world.entity.Entity> entities, BeeReleaseStatus beeState, @Nullable BlockPos flowerPos) {
        return BeehiveBlockEntity.releaseOccupant(world, pos, state, bee, entities, beeState, flowerPos, false);
    }

    private static boolean releaseOccupant(Level world, BlockPos blockposition, BlockState iblockdata, Occupant tileentitybeehive_c, @Nullable List<net.minecraft.world.entity.Entity> list, BeeReleaseStatus tileentitybeehive_releasestatus, @Nullable BlockPos blockposition1, boolean force) {
        boolean flag;
        if (!force && Bee.isNightOrRaining(world) && tileentitybeehive_releasestatus != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        Direction enumdirection = iblockdata.getValue(BeehiveBlock.FACING);
        BlockPos blockposition2 = blockposition.relative(enumdirection);
        boolean bl = flag = !world.getBlockState(blockposition2).getCollisionShape(world, blockposition2).isEmpty();
        if (flag && tileentitybeehive_releasestatus != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = tileentitybeehive_c.createEntity(world, blockposition);
        if (entity != null) {
            if (entity instanceof Bee) {
                float f = entity.getBbWidth();
                double d0 = flag ? 0.0 : 0.55 + (double)(f / 2.0f);
                double d1 = (double)blockposition.getX() + 0.5 + d0 * (double)enumdirection.getStepX();
                double d2 = (double)blockposition.getY() + 0.5 - (double)(entity.getBbHeight() / 2.0f);
                double d3 = (double)blockposition.getZ() + 0.5 + d0 * (double)enumdirection.getStepZ();
                entity.moveTo(d1, d2, d3, entity.getYRot(), entity.getXRot());
            }
            if (!world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.BEEHIVE)) {
                return false;
            }
            if (entity instanceof Bee) {
                Bee entitybee = (Bee)entity;
                if (blockposition1 != null && !entitybee.hasSavedFlowerPos() && world.random.nextFloat() < 0.9f) {
                    entitybee.setSavedFlowerPos(blockposition1);
                }
                if (tileentitybeehive_releasestatus == BeeReleaseStatus.HONEY_DELIVERED) {
                    int i;
                    entitybee.dropOffNectar();
                    if (iblockdata.is(BlockTags.BEEHIVES, blockbase_blockdata -> blockbase_blockdata.hasProperty(BeehiveBlock.HONEY_LEVEL)) && (i = BeehiveBlockEntity.getHoneyLevel(iblockdata)) < 5) {
                        BlockState newBlockState;
                        int j;
                        int n = j = world.random.nextInt(100) == 0 ? 2 : 1;
                        if (i + j > 5) {
                            --j;
                        }
                        if (CraftEventFactory.callEntityChangeBlockEvent(entitybee, blockposition, newBlockState = (BlockState)iblockdata.setValue(BeehiveBlock.HONEY_LEVEL, i + j))) {
                            world.setBlockAndUpdate(blockposition, newBlockState);
                        }
                    }
                }
                if (list != null) {
                    list.add(entitybee);
                }
            }
            world.playSound((Player)null, blockposition, SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(entity, world.getBlockState(blockposition)));
            return true;
        }
        return false;
    }

    private boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    private static void tickOccupants(Level world, BlockPos pos, BlockState state, List<BeeData> bees, @Nullable BlockPos flowerPos) {
        boolean flag = false;
        Iterator<BeeData> iterator = bees.iterator();
        while (iterator.hasNext()) {
            BeeReleaseStatus tileentitybeehive_releasestatus;
            BeeData tileentitybeehive_hivebee = iterator.next();
            if (!tileentitybeehive_hivebee.tick()) continue;
            BeeReleaseStatus beeReleaseStatus = tileentitybeehive_releasestatus = tileentitybeehive_hivebee.hasNectar() ? BeeReleaseStatus.HONEY_DELIVERED : BeeReleaseStatus.BEE_RELEASED;
            if (BeehiveBlockEntity.releaseOccupant(world, pos, state, tileentitybeehive_hivebee.toOccupant(), null, tileentitybeehive_releasestatus, flowerPos)) {
                flag = true;
                iterator.remove();
                continue;
            }
            tileentitybeehive_hivebee.exitTickCounter = tileentitybeehive_hivebee.occupant.minTicksInHive / 2;
        }
        if (flag) {
            BeehiveBlockEntity.setChanged(world, pos, state);
        }
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, BeehiveBlockEntity blockEntity) {
        BeehiveBlockEntity.tickOccupants(world, pos, state, blockEntity.stored, blockEntity.savedFlowerPos);
        if (!blockEntity.stored.isEmpty() && world.getRandom().nextDouble() < 0.005) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            world.playSound((Player)null, d0, d1, d2, SoundEvents.BEEHIVE_WORK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        DebugPackets.sendHiveInfo(world, pos, state, blockEntity);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.stored = Lists.newArrayList();
        if (nbt.contains(BEES)) {
            Occupant.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(BEES)).resultOrPartial(s -> LOGGER.error("Failed to parse bees: '{}'", s)).ifPresent(list -> list.forEach(this::storeBee));
        }
        this.savedFlowerPos = NbtUtils.readBlockPos(nbt, TAG_FLOWER_POS).orElse(null);
        if (nbt.contains("Bukkit.MaxEntities")) {
            this.maxBees = nbt.getInt("Bukkit.MaxEntities");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put(BEES, (Tag)Occupant.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.getBees()).getOrThrow());
        if (this.hasSavedFlowerPos()) {
            nbt.put(TAG_FLOWER_POS, NbtUtils.writeBlockPos(this.savedFlowerPos));
        }
        nbt.putInt("Bukkit.MaxEntities", this.maxBees);
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.stored = Lists.newArrayList();
        List list = components.getOrDefault(DataComponents.BEES, List.of());
        list.forEach(this::storeBee);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.BEES, this.getBees());
    }

    @Override
    public void removeComponentsFromTag(CompoundTag nbt) {
        super.removeComponentsFromTag(nbt);
        nbt.remove(BEES);
    }

    private List<Occupant> getBees() {
        return this.stored.stream().map(BeeData::toOccupant).toList();
    }

    public static enum BeeReleaseStatus {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }

    public static class BeeData {
        public final Occupant occupant;
        private int exitTickCounter;
        private int ticksInHive;

        BeeData(Occupant data) {
            this.occupant = data;
            this.exitTickCounter = this.ticksInHive = data.ticksInHive();
        }

        public boolean tick() {
            ++this.ticksInHive;
            return this.exitTickCounter++ > this.occupant.minTicksInHive;
        }

        public Occupant toOccupant() {
            return new Occupant(this.occupant.entityData, this.ticksInHive, this.occupant.minTicksInHive);
        }

        public boolean hasNectar() {
            return this.occupant.entityData.getUnsafe().getBoolean("HasNectar");
        }
    }

    public record Occupant(CustomData entityData, int ticksInHive, int minTicksInHive) {
        public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomData.CODEC.optionalFieldOf("entity_data", (Object)CustomData.EMPTY).forGetter(Occupant::entityData), (App)Codec.INT.fieldOf("ticks_in_hive").forGetter(Occupant::ticksInHive), (App)Codec.INT.fieldOf("min_ticks_in_hive").forGetter(Occupant::minTicksInHive)).apply((Applicative)instance, Occupant::new));
        public static final Codec<List<Occupant>> LIST_CODEC = CODEC.listOf();
        public static final StreamCodec<ByteBuf, Occupant> STREAM_CODEC = StreamCodec.composite(CustomData.STREAM_CODEC, Occupant::entityData, ByteBufCodecs.VAR_INT, Occupant::ticksInHive, ByteBufCodecs.VAR_INT, Occupant::minTicksInHive, Occupant::new);

        public static Occupant of(net.minecraft.world.entity.Entity entity) {
            CompoundTag nbttagcompound = new CompoundTag();
            entity.save(nbttagcompound);
            List<String> list = IGNORED_BEE_TAGS;
            Objects.requireNonNull(nbttagcompound);
            list.forEach(nbttagcompound::remove);
            boolean flag = nbttagcompound.getBoolean("HasNectar");
            return new Occupant(CustomData.of(nbttagcompound), 0, flag ? 2400 : 600);
        }

        public static Occupant create(int ticksInHive) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(EntityType.BEE).toString());
            return new Occupant(CustomData.of(nbttagcompound), ticksInHive, 600);
        }

        @Nullable
        public net.minecraft.world.entity.Entity createEntity(Level world, BlockPos pos) {
            CompoundTag nbttagcompound = this.entityData.copyTag();
            List<String> list = IGNORED_BEE_TAGS;
            Objects.requireNonNull(nbttagcompound);
            list.forEach(nbttagcompound::remove);
            net.minecraft.world.entity.Entity entity = EntityType.loadEntityRecursive(nbttagcompound, world, EntitySpawnReason.LOAD, entity1 -> entity1);
            if (entity != null && entity.getType().is(EntityTypeTags.BEEHIVE_INHABITORS)) {
                entity.setNoGravity(true);
                if (entity instanceof Bee) {
                    Bee entitybee = (Bee)entity;
                    entitybee.setHivePos(pos);
                    Occupant.setBeeReleaseData(this.ticksInHive, entitybee);
                }
                return entity;
            }
            return null;
        }

        private static void setBeeReleaseData(int ticksInHive, Bee beeEntity) {
            if (!beeEntity.ageLocked) {
                int j = beeEntity.getAge();
                if (j < 0) {
                    beeEntity.setAge(Math.min(0, j + ticksInHive));
                } else if (j > 0) {
                    beeEntity.setAge(Math.max(0, j - ticksInHive));
                }
                beeEntity.setInLoveTime(Math.max(0, beeEntity.getInLoveTime() - ticksInHive));
            }
        }
    }
}

