/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.profile.PaperMinecraftSessionService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Services;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SkullBlockEntity
extends BlockEntity {
    private static final String TAG_PROFILE = "profile";
    private static final String TAG_NOTE_BLOCK_SOUND = "note_block_sound";
    private static final String TAG_CUSTOM_NAME = "custom_name";
    private static final Logger LOGGER = LogUtils.getLogger();
    @javax.annotation.Nullable
    private static Executor mainThreadExecutor;
    @javax.annotation.Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> profileCacheByName;
    @javax.annotation.Nullable
    private static LoadingCache<Pair<UUID, @Nullable GameProfile>, CompletableFuture<Optional<GameProfile>>> profileCacheById;
    public static final Executor CHECKED_MAIN_THREAD_EXECUTOR;
    @javax.annotation.Nullable
    public ResolvableProfile owner;
    @javax.annotation.Nullable
    public ResourceLocation noteBlockSound;
    private int animationTickCount;
    private boolean isAnimating;
    @javax.annotation.Nullable
    private Component customName;

    public SkullBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.SKULL, pos, state);
    }

    public static void setup(final Services apiServices, Executor executor) {
        mainThreadExecutor = executor;
        final BooleanSupplier booleanSupplier = () -> profileCacheById == null;
        profileCacheByName = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(String string) {
                return SkullBlockEntity.fetchProfileByName(string, apiServices);
            }
        });
        profileCacheById = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<Pair<UUID, GameProfile>, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(Pair<UUID, @Nullable GameProfile> uUID) {
                return SkullBlockEntity.fetchProfileById(uUID, apiServices, booleanSupplier);
            }
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileByName(String name, Services apiServices) {
        return apiServices.profileCache().getAsync(name).thenCompose(optional -> {
            LoadingCache<Pair<UUID, @Nullable GameProfile>, CompletableFuture<Optional<GameProfile>>> loadingCache = profileCacheById;
            return loadingCache != null && !optional.isEmpty() ? ((CompletableFuture)loadingCache.getUnchecked((Object)new Pair((Object)((GameProfile)optional.get()).getId(), (Object)((GameProfile)optional.get())))).thenApply(optional2 -> optional2.or(() -> optional)) : CompletableFuture.completedFuture(Optional.empty());
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileById(Pair<UUID, @Nullable GameProfile> pair, Services apiServices, BooleanSupplier booleanSupplier) {
        return CompletableFuture.supplyAsync(() -> {
            if (booleanSupplier.getAsBoolean()) {
                return Optional.empty();
            }
            MinecraftSessionService patt0$temp = apiServices.sessionService();
            if (patt0$temp instanceof PaperMinecraftSessionService) {
                PaperMinecraftSessionService paperService = (PaperMinecraftSessionService)patt0$temp;
                GameProfile profile = pair.getSecond() != null ? (GameProfile)pair.getSecond() : new GameProfile((UUID)pair.getFirst(), "");
                return Optional.ofNullable(paperService.fetchProfile(profile, true)).map(ProfileResult::profile);
            }
            ProfileResult profileResult = apiServices.sessionService().fetchProfile((UUID)pair.getFirst(), true);
            return Optional.ofNullable(profileResult).map(ProfileResult::profile);
        }, Util.PROFILE_EXECUTOR);
    }

    public static void clear() {
        mainThreadExecutor = null;
        profileCacheByName = null;
        profileCacheById = null;
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.owner != null) {
            nbt.put(TAG_PROFILE, (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.owner).getOrThrow());
        }
        if (this.noteBlockSound != null) {
            nbt.putString(TAG_NOTE_BLOCK_SOUND, this.noteBlockSound.toString());
        }
        if (this.customName != null) {
            nbt.putString(TAG_CUSTOM_NAME, Component.Serializer.toJson(this.customName, registries));
        }
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains(TAG_PROFILE)) {
            ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(TAG_PROFILE)).resultOrPartial(string -> LOGGER.error("Failed to load profile from player head: {}", string)).ifPresent(this::setOwner);
        }
        if (nbt.contains(TAG_NOTE_BLOCK_SOUND, 8)) {
            this.noteBlockSound = ResourceLocation.tryParse(nbt.getString(TAG_NOTE_BLOCK_SOUND));
        }
        this.customName = nbt.contains(TAG_CUSTOM_NAME, 8) ? SkullBlockEntity.parseCustomNameSafe(nbt.getString(TAG_CUSTOM_NAME), registries) : null;
    }

    public static void animation(Level world, BlockPos pos, BlockState state, SkullBlockEntity blockEntity) {
        if (state.hasProperty(AbstractSkullBlock.POWERED) && state.getValue(AbstractSkullBlock.POWERED).booleanValue()) {
            blockEntity.isAnimating = true;
            ++blockEntity.animationTickCount;
        } else {
            blockEntity.isAnimating = false;
        }
    }

    public float getAnimation(float tickDelta) {
        return this.isAnimating ? (float)this.animationTickCount + tickDelta : (float)this.animationTickCount;
    }

    @javax.annotation.Nullable
    public ResolvableProfile getOwnerProfile() {
        return this.owner;
    }

    @javax.annotation.Nullable
    public ResourceLocation getNoteBlockSound() {
        return this.noteBlockSound;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@javax.annotation.Nullable ResolvableProfile profile) {
        SkullBlockEntity skullBlockEntity = this;
        synchronized (skullBlockEntity) {
            this.owner = profile;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        if (this.owner != null && !this.owner.isResolved()) {
            this.owner.resolve().thenAcceptAsync(owner -> {
                this.owner = owner;
                this.setChanged();
            }, CHECKED_MAIN_THREAD_EXECUTOR);
        } else {
            this.setChanged();
        }
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(String name) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> loadingCache = profileCacheByName;
        return loadingCache != null && StringUtil.isValidPlayerName(name) ? (CompletableFuture)loadingCache.getUnchecked((Object)name) : CompletableFuture.completedFuture(Optional.empty());
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(UUID uuid, @javax.annotation.Nullable String name) {
        LoadingCache<Pair<UUID, @Nullable GameProfile>, CompletableFuture<Optional<GameProfile>>> loadingCache = profileCacheById;
        return loadingCache != null ? (CompletableFuture)loadingCache.getUnchecked((Object)new Pair((Object)uuid, (Object)(name != null ? new GameProfile(uuid, name) : null))) : CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.setOwner(components.get(DataComponents.PROFILE));
        this.noteBlockSound = components.get(DataComponents.NOTE_BLOCK_SOUND);
        this.customName = components.get(DataComponents.CUSTOM_NAME);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.PROFILE, this.owner);
        builder.set(DataComponents.NOTE_BLOCK_SOUND, this.noteBlockSound);
        builder.set(DataComponents.CUSTOM_NAME, this.customName);
    }

    @Override
    public void removeComponentsFromTag(CompoundTag nbt) {
        super.removeComponentsFromTag(nbt);
        nbt.remove(TAG_PROFILE);
        nbt.remove(TAG_NOTE_BLOCK_SOUND);
        nbt.remove(TAG_CUSTOM_NAME);
    }

    static {
        CHECKED_MAIN_THREAD_EXECUTOR = runnable -> {
            Executor executor = mainThreadExecutor;
            if (executor != null) {
                executor.execute(runnable);
            }
        };
    }
}

