/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;

public class TrappedChestBlockEntity
extends ChestBlockEntity {
    public TrappedChestBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.TRAPPED_CHEST, pos, state);
    }

    @Override
    @Override
    protected void signalOpenCount(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        super.signalOpenCount(world, pos, state, oldViewerCount, newViewerCount);
        if (oldViewerCount != newViewerCount) {
            Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, state.getValue(ChestBlock.FACING).getOpposite(), Direction.UP);
            Block block = state.getBlock();
            world.updateNeighborsAt(pos, block, orientation);
            world.updateNeighborsAt(pos.below(), block, orientation);
        }
    }
}

