/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccess;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.Property;

public final class EnumProperty<T extends Enum<T>>
extends Property<T>
implements PropertyAccess<T> {
    private final List<T> values;
    private final Map<String, T> names;
    private final int[] ordinalToIndex;
    private int[] idLookupTable;

    @Override
    public final int moonrise$getIdFor(T value) {
        Class target = this.getValueClass();
        return value.getClass() != target && ((Enum)value).getDeclaringClass() != target ? -1 : this.idLookupTable[((Enum)value).ordinal()];
    }

    private void init() {
        List<T> values = this.getPossibleValues();
        Class clazz = this.getValueClass();
        int id = 0;
        this.idLookupTable = new int[((Enum[])clazz.getEnumConstants()).length];
        Arrays.fill(this.idLookupTable, -1);
        Enum[] byId = (Enum[])Array.newInstance(clazz, values.size());
        for (Enum value : values) {
            int valueId;
            this.idLookupTable[value.ordinal()] = valueId = id++;
            byId[valueId] = value;
        }
        this.moonrise$setById((Comparable[])byId);
    }

    private EnumProperty(String name, Class<T> type, List<T> values) {
        super(name, type);
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Trying to make empty EnumProperty '" + name + "'");
        }
        this.values = List.copyOf(values);
        Enum[] enums = (Enum[])type.getEnumConstants();
        this.ordinalToIndex = new int[enums.length];
        for (Enum enum_ : enums) {
            this.ordinalToIndex[enum_.ordinal()] = values.indexOf(enum_);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Enum enum2 : values) {
            String string = ((StringRepresentable)((Object)enum2)).getSerializedName();
            builder.put((Object)string, (Object)enum2);
        }
        this.names = builder.buildOrThrow();
        this.init();
    }

    @Override
    public List<T> getPossibleValues() {
        return this.values;
    }

    @Override
    public Optional<T> getValue(String name) {
        return Optional.ofNullable((Enum)this.names.get(name));
    }

    @Override
    public String getName(T enum_) {
        return ((StringRepresentable)enum_).getSerializedName();
    }

    @Override
    public int getInternalIndex(T enum_) {
        return this.ordinalToIndex[((Enum)enum_).ordinal()];
    }

    public boolean equals_unused(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EnumProperty) {
            EnumProperty enumProperty = (EnumProperty)object;
            if (super.equals(object)) {
                return this.values.equals(enumProperty.values);
            }
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        int i = super.generateHashCode();
        return 31 * i + this.values.hashCode();
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> type) {
        return EnumProperty.create(name, type, (T enum_) -> true);
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> type, Predicate<T> filter) {
        return EnumProperty.create(name, type, Arrays.stream((Enum[])type.getEnumConstants()).filter(filter).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> type, T ... values) {
        return EnumProperty.create(name, type, List.of(values));
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> type, List<T> values) {
        return new EnumProperty<T>(name, type, values);
    }
}

