/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.world.StructuresLocateEvent;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.util.RandomSourceWrapper;
import org.bukkit.event.Event;
import org.bukkit.event.world.AsyncStructureSpawnEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.generator.structure.Structure;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> CODEC = BuiltInRegistries.CHUNK_GENERATOR.byNameCodec().dispatchStable(ChunkGenerator::codec, Function.identity());
    protected final BiomeSource biomeSource;
    private final Supplier<List<FeatureSorter.StepFeatureData>> featuresPerStep;
    public final Function<Holder<Biome>, BiomeGenerationSettings> generationSettingsGetter;

    public ChunkGenerator(BiomeSource biomeSource) {
        this(biomeSource, holder -> ((Biome)holder.value()).getGenerationSettings());
    }

    public ChunkGenerator(BiomeSource biomeSource, Function<Holder<Biome>, BiomeGenerationSettings> generationSettingsGetter) {
        this.biomeSource = biomeSource;
        this.generationSettingsGetter = generationSettingsGetter;
        this.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(biomeSource.possibleBiomes()), holder -> ((BiomeGenerationSettings)generationSettingsGetter.apply((Holder<Biome>)holder)).features(), true));
    }

    public void validate() {
        this.featuresPerStep.get();
    }

    protected abstract MapCodec<? extends ChunkGenerator> codec();

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderlookup, RandomState randomstate, long i, SpigotWorldConfig conf) {
        return ChunkGeneratorStructureState.createForNormal(randomstate, i, this.biomeSource, holderlookup, conf);
    }

    public Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> getTypeNameForDataFixer() {
        return BuiltInRegistries.CHUNK_GENERATOR.getResourceKey(this.codec());
    }

    public CompletableFuture<ChunkAccess> createBiomes(RandomState noiseConfig, Blender blender, StructureManager structureAccessor, ChunkAccess chunk) {
        return CompletableFuture.supplyAsync(() -> {
            chunk.fillBiomesFromNoise(this.biomeSource, noiseConfig.sampler());
            return chunk;
        }, Runnable::run);
    }

    public abstract void applyCarvers(WorldGenRegion var1, long var2, RandomState var4, BiomeManager var5, StructureManager var6, ChunkAccess var7);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> findNearestMapStructure(ServerLevel world, HolderSet<net.minecraft.world.level.levelgen.structure.Structure> structures, BlockPos center, int radius, boolean skipReferencedStructures) {
        void var12_16;
        CraftWorld bukkitWorld = world.getWorld();
        Location origin = MCUtil.toLocation(world, center);
        List<Structure> apiStructures = structures.stream().map(Holder::value).map(nms -> CraftStructure.minecraftToBukkit(nms)).toList();
        if (!apiStructures.isEmpty()) {
            StructuresLocateEvent event = new StructuresLocateEvent((World)bukkitWorld, origin, apiStructures, radius, skipReferencedStructures);
            if (!event.callEvent()) {
                return null;
            }
            if (event.getResult() != null) {
                return Pair.of((Object)MCUtil.toBlockPos(event.getResult().pos()), world.registryAccess().lookupOrThrow(Registries.STRUCTURE).wrapAsHolder(CraftStructure.bukkitToMinecraft(event.getResult().structure())));
            }
            center = MCUtil.toBlockPosition(event.getOrigin());
            radius = event.getRadius();
            skipReferencedStructures = event.shouldFindUnexplored();
            structures = HolderSet.direct(api -> world.registryAccess().lookupOrThrow(Registries.STRUCTURE).wrapAsHolder(CraftStructure.bukkitToMinecraft(api)), event.getStructures());
        }
        ChunkGeneratorStructureState chunkgeneratorstructurestate = world.getChunkSource().getGeneratorState();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Holder holder : structures) {
            for (StructurePlacement structureplacement : chunkgeneratorstructurestate.getPlacementsForStructure(holder)) {
                map.computeIfAbsent(structureplacement, structureplacement1 -> new ObjectArraySet()).add(holder);
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        Object var12_13 = null;
        double d0 = Double.MAX_VALUE;
        StructureManager structuremanager = world.structureManager();
        ArrayList list = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structureplacement12 = (StructurePlacement)entry.getKey();
            if (structureplacement12 instanceof ConcentricRingsStructurePlacement) {
                BlockPos blockposition1;
                double d;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement12;
                Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair1 = this.getNearestGeneratedStructure((Set)entry.getValue(), world, structuremanager, center, skipReferencedStructures, concentricringsstructureplacement);
                if (pair1 == null || !((d = center.distSqr(blockposition1 = (BlockPos)pair1.getFirst())) < d0)) continue;
                d0 = d;
                Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair = pair1;
                continue;
            }
            if (!(structureplacement12 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int j = SectionPos.blockToSectionCoord(center.getX());
            int k = SectionPos.blockToSectionCoord(center.getZ());
            for (int l = 0; l <= radius; ++l) {
                boolean flag1 = false;
                for (Map.Entry entry : list) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair2 = ChunkGenerator.getNearestGeneratedStructure((Set)entry.getValue(), world, structuremanager, j, k, l, skipReferencedStructures, chunkgeneratorstructurestate.getLevelSeed(), randomspreadstructureplacement);
                    if (pair2 == null) continue;
                    flag1 = true;
                    double d2 = center.distSqr((Vec3i)pair2.getFirst());
                    if (!(d2 < d0)) continue;
                    d0 = d2;
                    Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair = pair2;
                }
                if (!flag1) continue;
                return var12_16;
            }
        }
        return var12_16;
    }

    @Nullable
    private Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> getNearestGeneratedStructure(Set<Holder<net.minecraft.world.level.levelgen.structure.Structure>> structures, ServerLevel world, StructureManager structureAccessor, BlockPos center, boolean skipReferencedStructures, ConcentricRingsStructurePlacement placement) {
        List<ChunkPos> list = world.getChunkSource().getGeneratorState().getRingPositionsFor(placement);
        if (list == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair = null;
        double d0 = Double.MAX_VALUE;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (ChunkPos chunkcoordintpair : list) {
            Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair1;
            if (!world.paperConfig().environment.locateStructuresOutsideWorldBorder && !world.getWorldBorder().isChunkInBounds(chunkcoordintpair.x, chunkcoordintpair.z)) continue;
            blockposition_mutableblockposition.set(SectionPos.sectionToBlockCoord(chunkcoordintpair.x, 8), 32, SectionPos.sectionToBlockCoord(chunkcoordintpair.z, 8));
            double d1 = blockposition_mutableblockposition.distSqr(center);
            boolean flag1 = pair == null || d1 < d0;
            if (!flag1 || (pair1 = ChunkGenerator.getStructureGeneratingAt(structures, world, structureAccessor, skipReferencedStructures, placement, chunkcoordintpair)) == null) continue;
            pair = pair1;
            d0 = d1;
        }
        return pair;
    }

    @Nullable
    private static Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> getNearestGeneratedStructure(Set<Holder<net.minecraft.world.level.levelgen.structure.Structure>> structures, LevelReader world, StructureManager structureAccessor, int centerChunkX, int centerChunkZ, int radius, boolean skipReferencedStructures, long seed, RandomSpreadStructurePlacement placement) {
        int i1 = placement.spacing();
        for (int j1 = -radius; j1 <= radius; ++j1) {
            boolean flag1;
            boolean onBorderAlongZAxis = flag1 = j1 == -radius || j1 == radius;
            for (int k1 = -radius; k1 <= radius; k1 += onBorderAlongZAxis ? 1 : radius * 2) {
                int l1 = centerChunkX + i1 * j1;
                int i2 = centerChunkZ + i1 * k1;
                ChunkPos chunkcoordintpair = placement.getPotentialStructureChunk(seed, l1, i2);
                Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair = ChunkGenerator.getStructureGeneratingAt(structures, world, structureAccessor, skipReferencedStructures, placement, chunkcoordintpair);
                if (pair == null) continue;
                return pair;
            }
        }
        return null;
    }

    @Nullable
    private static Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> getStructureGeneratingAt(Set<Holder<net.minecraft.world.level.levelgen.structure.Structure>> structures, LevelReader world, StructureManager structureAccessor, boolean skipReferencedStructures, StructurePlacement placement, ChunkPos pos) {
        StructureStart structurestart;
        Holder<net.minecraft.world.level.levelgen.structure.Structure> holder;
        Iterator<Holder<net.minecraft.world.level.levelgen.structure.Structure>> iterator = structures.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return null;
            }
            holder = iterator.next();
            StructureCheckResult structurecheckresult = structureAccessor.checkStructurePresence(pos, holder.value(), placement, skipReferencedStructures);
            if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!skipReferencedStructures && structurecheckresult == StructureCheckResult.START_PRESENT) {
                return Pair.of((Object)placement.getLocatePos(pos), holder);
            }
            ChunkAccess ichunkaccess = world.moonrise$syncLoadNonFull(pos.x, pos.z, ChunkStatus.STRUCTURE_STARTS);
            structurestart = structureAccessor.getStartForStructure(SectionPos.bottomOf(ichunkaccess), holder.value(), ichunkaccess);
            if (structurestart != null && structurestart.isValid() && (!skipReferencedStructures || ChunkGenerator.tryAddReference(structureAccessor, structurestart))) break;
        }
        return Pair.of((Object)placement.getLocatePos(structurestart.getChunkPos()), holder);
    }

    private static boolean tryAddReference(StructureManager structureAccessor, StructureStart start) {
        if (start.canBeReferenced()) {
            structureAccessor.addReference(start);
            return true;
        }
        return false;
    }

    public void addVanillaDecorations(WorldGenLevel generatoraccessseed, ChunkAccess ichunkaccess, StructureManager structuremanager) {
        ChunkPos chunkcoordintpair = ichunkaccess.getPos();
        if (!SharedConstants.debugVoidTerrain(chunkcoordintpair)) {
            SectionPos sectionposition = SectionPos.of(chunkcoordintpair, generatoraccessseed.getMinSectionY());
            BlockPos blockposition = sectionposition.origin();
            HolderLookup.RegistryLookup iregistry = generatoraccessseed.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            Map<Integer, List<net.minecraft.world.level.levelgen.structure.Structure>> map = iregistry.stream().collect(Collectors.groupingBy(structure -> structure.step().ordinal()));
            List<FeatureSorter.StepFeatureData> list = this.featuresPerStep.get();
            WorldgenRandom seededrandom = new WorldgenRandom(new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
            long i = seededrandom.setDecorationSeed(generatoraccessseed.getSeed(), blockposition.getX(), blockposition.getZ());
            ObjectArraySet set = new ObjectArraySet();
            ChunkPos.rangeClosed(sectionposition.chunk(), 1).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$8(generatoraccessseed, (Set)set, arg_0));
            set.retainAll(this.biomeSource.possibleBiomes());
            int j = list.size();
            try {
                HolderLookup.RegistryLookup iregistry1 = generatoraccessseed.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE);
                int k = Math.max(GenerationStep.Decoration.values().length, j);
                for (int l = 0; l < k; ++l) {
                    int i1 = 0;
                    if (structuremanager.shouldGenerateStructures()) {
                        List list1 = map.getOrDefault(l, Collections.emptyList());
                        for (net.minecraft.world.level.levelgen.structure.Structure structure2 : list1) {
                            seededrandom.setFeatureSeed(i, i1, l);
                            Supplier<String> supplier = () -> ChunkGenerator.lambda$addVanillaDecorations$9((Registry)iregistry, structure2);
                            try {
                                generatoraccessseed.setCurrentlyGenerating(supplier);
                                structuremanager.startsForStructure(sectionposition, structure2).forEach(structurestart -> structurestart.placeInChunk(generatoraccessseed, structuremanager, this, seededrandom, ChunkGenerator.getWritableArea(ichunkaccess), chunkcoordintpair));
                            }
                            catch (Exception exception) {
                                CrashReport crashreport = CrashReport.forThrowable(exception, "Feature placement");
                                CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Feature");
                                Objects.requireNonNull(supplier);
                                crashreportsystemdetails.setDetail("Description", supplier::get);
                                throw new ReportedException(crashreport);
                            }
                            ++i1;
                        }
                    }
                    if (l >= j) continue;
                    IntArraySet intarrayset = new IntArraySet();
                    for (Holder holder : set) {
                        List<HolderSet<PlacedFeature>> list2 = this.generationSettingsGetter.apply(holder).features();
                        if (l >= list2.size()) continue;
                        HolderSet<PlacedFeature> holderset = list2.get(l);
                        FeatureSorter.StepFeatureData featuresorter_b = list.get(l);
                        holderset.stream().map(Holder::value).forEach(placedfeature -> intarrayset.add(featuresorter_b.indexMapping().applyAsInt((PlacedFeature)placedfeature)));
                    }
                    int j1 = intarrayset.size();
                    int[] aint = intarrayset.toIntArray();
                    Arrays.sort(aint);
                    FeatureSorter.StepFeatureData featuresorter_b1 = list.get(l);
                    for (int k1 = 0; k1 < j1; ++k1) {
                        int l1 = aint[k1];
                        PlacedFeature placedfeature2 = featuresorter_b1.features().get(l1);
                        Supplier<String> supplier1 = () -> ChunkGenerator.lambda$addVanillaDecorations$12((Registry)iregistry1, placedfeature2);
                        long featurePopulationSeed = i;
                        long configFeatureSeed = generatoraccessseed.getMinecraftWorld().paperConfig().featureSeeds.features.getLong(placedfeature2.feature());
                        if (configFeatureSeed != -1L) {
                            featurePopulationSeed = seededrandom.setDecorationSeed(configFeatureSeed, blockposition.getX(), blockposition.getZ());
                        }
                        seededrandom.setFeatureSeed(featurePopulationSeed, l1, l);
                        try {
                            generatoraccessseed.setCurrentlyGenerating(supplier1);
                            placedfeature2.placeWithBiomeCheck(generatoraccessseed, this, seededrandom, blockposition);
                            continue;
                        }
                        catch (Exception exception1) {
                            CrashReport crashreport1 = CrashReport.forThrowable(exception1, "Feature placement");
                            CrashReportCategory crashreportsystemdetails = crashreport1.addCategory("Feature");
                            Objects.requireNonNull(supplier1);
                            crashreportsystemdetails.setDetail("Description", supplier1::get);
                            throw new ReportedException(crashreport1);
                        }
                    }
                }
                generatoraccessseed.setCurrentlyGenerating(null);
            }
            catch (Exception exception2) {
                CrashReport crashreport2 = CrashReport.forThrowable(exception2, "Biome decoration");
                crashreport2.addCategory("Generation").setDetail("CenterX", chunkcoordintpair.x).setDetail("CenterZ", chunkcoordintpair.z).setDetail("Decoration Seed", i);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void applyBiomeDecoration(WorldGenLevel world, ChunkAccess chunk, StructureManager structureAccessor) {
        this.applyBiomeDecoration(world, chunk, structureAccessor, true);
    }

    public void applyBiomeDecoration(WorldGenLevel generatoraccessseed, ChunkAccess ichunkaccess, StructureManager structuremanager, boolean vanilla) {
        CraftWorld world;
        if (vanilla) {
            this.addVanillaDecorations(generatoraccessseed, ichunkaccess, structuremanager);
        }
        if (!(world = generatoraccessseed.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.getPos());
            int x = ichunkaccess.getPos().x;
            int z = ichunkaccess.getPos().z;
            for (BlockPopulator populator : world.getPopulators()) {
                WorldgenRandom seededrandom = new WorldgenRandom(new LegacyRandomSource(generatoraccessseed.getSeed()));
                seededrandom.setDecorationSeed(generatoraccessseed.getSeed(), x, z);
                populator.populate((WorldInfo)world, (Random)new RandomSourceWrapper.RandomWrapper(seededrandom), x, z, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    private static BoundingBox getWritableArea(ChunkAccess chunk) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        int i = chunkcoordintpair.getMinBlockX();
        int j = chunkcoordintpair.getMinBlockZ();
        LevelHeightAccessor levelheightaccessor = chunk.getHeightAccessorForGeneration();
        int k = levelheightaccessor.getMinY() + 1;
        int l = levelheightaccessor.getMaxY();
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    public abstract void buildSurface(WorldGenRegion var1, StructureManager var2, RandomState var3, ChunkAccess var4);

    public abstract void spawnOriginalMobs(WorldGenRegion var1);

    public int getSpawnHeight(LevelHeightAccessor world) {
        return 64;
    }

    public BiomeSource getBiomeSource() {
        return this.biomeSource;
    }

    public abstract int getGenDepth();

    public WeightedRandomList<MobSpawnSettings.SpawnerData> getMobsAt(Holder<Biome> biome, StructureManager accessor, MobCategory group, BlockPos pos) {
        Map<net.minecraft.world.level.levelgen.structure.Structure, LongSet> map = accessor.getAllStructuresAt(pos);
        for (Map.Entry<net.minecraft.world.level.levelgen.structure.Structure, LongSet> entry : map.entrySet()) {
            net.minecraft.world.level.levelgen.structure.Structure structure = entry.getKey();
            StructureSpawnOverride structurespawnoverride = structure.spawnOverrides().get(group);
            if (structurespawnoverride == null) continue;
            MutableBoolean mutableboolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structurespawnoverride.boundingBox() == StructureSpawnOverride.BoundingBoxType.PIECE ? structurestart -> accessor.structureHasPieceAt(pos, (StructureStart)structurestart) : structurestart -> structurestart.getBoundingBox().isInside(pos);
            accessor.fillStartsForStructure(structure, entry.getValue(), structurestart -> {
                if (mutableboolean.isFalse() && predicate.test((StructureStart)structurestart)) {
                    mutableboolean.setTrue();
                }
            });
            if (!mutableboolean.isTrue()) continue;
            return structurespawnoverride.spawns();
        }
        return biome.value().getMobSettings().getMobs(group);
    }

    public void createStructures(RegistryAccess registryManager, ChunkGeneratorStructureState placementCalculator, StructureManager structureAccessor, ChunkAccess chunk, StructureTemplateManager structureTemplateManager) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        SectionPos sectionposition = SectionPos.bottomOf(chunk);
        RandomState randomstate = placementCalculator.randomState();
        placementCalculator.possibleStructureSets().forEach(holder -> {
            ResourceKey<StructureSet> resourceKey;
            StructurePlacement structureplacement = ((StructureSet)holder.value()).placement();
            List<StructureSet.StructureSelectionEntry> list = ((StructureSet)holder.value()).structures();
            for (StructureSet.StructureSelectionEntry structureset_a : list) {
                StructureStart structurestart = structureAccessor.getStartForStructure(sectionposition, structureset_a.structure().value(), chunk);
                if (structurestart == null || !structurestart.isValid()) continue;
                return;
            }
            int n = chunkcoordintpair.x;
            int n2 = chunkcoordintpair.z;
            if (structureplacement instanceof ChunkGeneratorStructureState.KeyedRandomSpreadStructurePlacement) {
                ChunkGeneratorStructureState.KeyedRandomSpreadStructurePlacement keyed = (ChunkGeneratorStructureState.KeyedRandomSpreadStructurePlacement)structureplacement;
                resourceKey = keyed.key;
            } else {
                resourceKey = null;
            }
            if (structureplacement.isStructureChunk(placementCalculator, n, n2, resourceKey)) {
                if (list.size() == 1) {
                    this.tryGenerateStructure(list.get(0), structureAccessor, registryManager, randomstate, structureTemplateManager, placementCalculator.getLevelSeed(), chunk, chunkcoordintpair, sectionposition);
                } else {
                    ArrayList<StructureSet.StructureSelectionEntry> arraylist = new ArrayList<StructureSet.StructureSelectionEntry>(list.size());
                    arraylist.addAll(list);
                    WorldgenRandom seededrandom = new WorldgenRandom(new LegacyRandomSource(0L));
                    seededrandom.setLargeFeatureSeed(placementCalculator.getLevelSeed(), chunkcoordintpair.x, chunkcoordintpair.z);
                    int i = 0;
                    for (StructureSet.StructureSelectionEntry structureset_a1 : arraylist) {
                        i += structureset_a1.weight();
                    }
                    while (!arraylist.isEmpty()) {
                        StructureSet.StructureSelectionEntry structureset_a2;
                        int j = seededrandom.nextInt(i);
                        int k = 0;
                        Iterator iterator2 = arraylist.iterator();
                        while (iterator2.hasNext() && (j -= (structureset_a2 = (StructureSet.StructureSelectionEntry)iterator2.next()).weight()) >= 0) {
                            ++k;
                        }
                        StructureSet.StructureSelectionEntry structureset_a3 = (StructureSet.StructureSelectionEntry)arraylist.get(k);
                        if (this.tryGenerateStructure(structureset_a3, structureAccessor, registryManager, randomstate, structureTemplateManager, placementCalculator.getLevelSeed(), chunk, chunkcoordintpair, sectionposition)) {
                            return;
                        }
                        arraylist.remove(k);
                        i -= structureset_a3.weight();
                    }
                }
            }
        });
    }

    private boolean tryGenerateStructure(StructureSet.StructureSelectionEntry weightedEntry, StructureManager structureAccessor, RegistryAccess dynamicRegistryManager, RandomState noiseConfig, StructureTemplateManager structureManager, long seed, ChunkAccess chunk, ChunkPos pos, SectionPos sectionPos) {
        net.minecraft.world.level.levelgen.structure.Structure structure = weightedEntry.structure().value();
        int j = ChunkGenerator.fetchReferences(structureAccessor, chunk, sectionPos, structure);
        HolderSet<Biome> holderset = structure.biomes();
        Objects.requireNonNull(holderset);
        Predicate<Holder<Biome>> predicate = holderset::contains;
        StructureStart structurestart = structure.generate(dynamicRegistryManager, this, this.biomeSource, noiseConfig, structureManager, seed, pos, j, chunk, predicate);
        if (structurestart.isValid()) {
            BoundingBox box = structurestart.getBoundingBox();
            AsyncStructureSpawnEvent event = new AsyncStructureSpawnEvent((World)structureAccessor.level.getMinecraftWorld().getWorld(), CraftStructure.minecraftToBukkit(structure), new org.bukkit.util.BoundingBox((double)box.minX(), (double)box.minY(), (double)box.minZ(), (double)box.maxX(), (double)box.maxY(), (double)box.maxZ()), pos.x, pos.z);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return true;
            }
            structureAccessor.setStartForStructure(sectionPos, structure, structurestart, chunk);
            return true;
        }
        return false;
    }

    private static int fetchReferences(StructureManager structureAccessor, ChunkAccess chunk, SectionPos sectionPos, net.minecraft.world.level.levelgen.structure.Structure structure) {
        StructureStart structurestart = structureAccessor.getStartForStructure(sectionPos, structure, chunk);
        return structurestart != null ? structurestart.getReferences() : 0;
    }

    public void createReferences(WorldGenLevel world, StructureManager structureAccessor, ChunkAccess chunk) {
        boolean flag = true;
        ChunkPos chunkcoordintpair = chunk.getPos();
        int i = chunkcoordintpair.x;
        int j = chunkcoordintpair.z;
        int k = chunkcoordintpair.getMinBlockX();
        int l = chunkcoordintpair.getMinBlockZ();
        SectionPos sectionposition = SectionPos.bottomOf(chunk);
        for (int i1 = i - 8; i1 <= i + 8; ++i1) {
            for (int j1 = j - 8; j1 <= j + 8; ++j1) {
                long k1 = ChunkPos.asLong(i1, j1);
                for (StructureStart structurestart : world.getChunk(i1, j1).getAllStarts().values()) {
                    try {
                        if (!structurestart.isValid() || !structurestart.getBoundingBox().intersects(k, l, k + 15, l + 15)) continue;
                        structureAccessor.addReferenceForStructure(sectionposition, structurestart.getStructure(), k1, chunk);
                        DebugPackets.sendStructurePacket(world, structurestart);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.forThrowable(exception, "Generating structure reference");
                        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Structure");
                        Optional<Registry<net.minecraft.world.level.levelgen.structure.Structure>> optional = world.registryAccess().lookup(Registries.STRUCTURE);
                        crashreportsystemdetails.setDetail("Id", () -> optional.map(iregistry -> iregistry.getKey(structurestart.getStructure()).toString()).orElse("UNKNOWN"));
                        crashreportsystemdetails.setDetail("Name", () -> BuiltInRegistries.STRUCTURE_TYPE.getKey(structurestart.getStructure().type()).toString());
                        crashreportsystemdetails.setDetail("Class", () -> structurestart.getStructure().getClass().getCanonicalName());
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<ChunkAccess> fillFromNoise(Blender var1, RandomState var2, StructureManager var3, ChunkAccess var4);

    public abstract int getSeaLevel();

    public abstract int getMinY();

    public abstract int getBaseHeight(int var1, int var2, Heightmap.Types var3, LevelHeightAccessor var4, RandomState var5);

    public abstract NoiseColumn getBaseColumn(int var1, int var2, LevelHeightAccessor var3, RandomState var4);

    public int getFirstFreeHeight(int x, int z, Heightmap.Types heightmap, LevelHeightAccessor world, RandomState noiseConfig) {
        return this.getBaseHeight(x, z, heightmap, world, noiseConfig);
    }

    public int getFirstOccupiedHeight(int x, int z, Heightmap.Types heightmap, LevelHeightAccessor world, RandomState noiseConfig) {
        return this.getBaseHeight(x, z, heightmap, world, noiseConfig) - 1;
    }

    public abstract void addDebugScreenInfo(List<String> var1, RandomState var2, BlockPos var3);

    @Deprecated
    public BiomeGenerationSettings getBiomeGenerationSettings(Holder<Biome> biomeEntry) {
        return this.generationSettingsGetter.apply(biomeEntry);
    }

    private static /* synthetic */ String lambda$addVanillaDecorations$12(Registry iregistry1, PlacedFeature placedfeature) {
        Optional<String> optional = iregistry1.getResourceKey(placedfeature).map(Object::toString);
        Objects.requireNonNull(placedfeature);
        return (String)optional.orElseGet(placedfeature::toString);
    }

    private static /* synthetic */ String lambda$addVanillaDecorations$9(Registry iregistry, net.minecraft.world.level.levelgen.structure.Structure structure) {
        Optional<String> optional = iregistry.getResourceKey(structure).map(Object::toString);
        Objects.requireNonNull(structure);
        return (String)optional.orElseGet(structure::toString);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$8(WorldGenLevel generatoraccessseed, Set set, ChunkPos chunkcoordintpair1) {
        ChunkAccess ichunkaccess1 = generatoraccessseed.getChunk(chunkcoordintpair1.x, chunkcoordintpair1.z);
        for (LevelChunkSection chunksection : ichunkaccess1.getSections()) {
            PalettedContainerRO<Holder<Biome>> palettedcontainerro = chunksection.getBiomes();
            Objects.requireNonNull(set);
            palettedcontainerro.getAll(set::add);
        }
    }
}

