/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.patches.fast_palette.FastPalette;
import ca.spottedleaf.moonrise.patches.fast_palette.FastPaletteData;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import org.apache.commons.lang3.Validate;

public class SingleValuePalette<T>
implements Palette<T>,
FastPalette<T> {
    private final IdMap<T> registry;
    @Nullable
    private T value;
    private final PaletteResize<T> resizeHandler;
    private T[] rawPalette;

    @Override
    public final T[] moonrise$getRawPalette(FastPaletteData<T> container) {
        if (this.rawPalette != null) {
            return this.rawPalette;
        }
        this.rawPalette = new Object[]{this.value};
        return this.rawPalette;
    }

    public SingleValuePalette(IdMap<T> idList, PaletteResize<T> listener, List<T> entries) {
        this.registry = idList;
        this.resizeHandler = listener;
        if (entries.size() > 0) {
            Validate.isTrue((entries.size() <= 1 ? 1 : 0) != 0, (String)"Can't initialize SingleValuePalette with %d values.", (long)entries.size());
            this.value = entries.get(0);
        }
    }

    public static <A> Palette<A> create(int bitSize, IdMap<A> idList, PaletteResize<A> listener, List<A> entries) {
        return new SingleValuePalette<A>(idList, listener, entries);
    }

    @Override
    public int idFor(T object) {
        if (this.value != null && this.value != object) {
            return this.resizeHandler.onResize(1, object);
        }
        this.value = object;
        if (this.rawPalette != null) {
            this.rawPalette[0] = object;
        }
        return 0;
    }

    @Override
    public boolean maybeHas(Predicate<T> predicate) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return predicate.test(this.value);
    }

    @Override
    public T valueFor(int id) {
        if (this.value != null && id == 0) {
            return this.value;
        }
        throw new IllegalStateException("Missing Palette entry for id " + id + ".");
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value = this.registry.byIdOrThrow(buf.readVarInt());
        if (this.rawPalette != null) {
            this.rawPalette[0] = this.value;
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        buf.writeVarInt(this.registry.getId(this.value));
    }

    @Override
    public int getSerializedSize() {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return VarInt.getByteSize(this.registry.getId(this.value));
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public Palette<T> copy(PaletteResize<T> resizeListener) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return this;
    }
}

