/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import io.papermc.paper.configuration.WorldConfiguration;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.bukkit.event.entity.EntityRemoveEvent;

public class ChunkStatusTasks {
    private static boolean isLighted(ChunkAccess chunk) {
        return chunk.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT) && chunk.isLightCorrect();
    }

    static CompletableFuture<ChunkAccess> passThrough(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<ChunkAccess> generateStructureStarts(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        ServerLevel worldserver = context.level();
        if (worldserver.serverLevelData.worldGenOptions().generateStructures()) {
            context.generator().createStructures(worldserver.registryAccess(), worldserver.getChunkSource().getGeneratorState(), worldserver.structureManager(), chunk, context.structureManager());
        }
        worldserver.onStructureStartsAvailable(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<ChunkAccess> loadStructureStarts(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        context.level().onStructureStartsAvailable(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<ChunkAccess> generateStructureReferences(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        ServerLevel worldserver = context.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, chunks, step, chunk);
        context.generator().createReferences(regionlimitedworldaccess, worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<ChunkAccess> generateBiomes(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        ServerLevel worldserver = context.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, chunks, step, chunk);
        return context.generator().createBiomes(worldserver.getChunkSource().randomState(), Blender.of(regionlimitedworldaccess), worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), chunk);
    }

    static CompletableFuture<ChunkAccess> generateNoise(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        ServerLevel worldserver = context.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, chunks, step, chunk);
        return context.generator().fillFromNoise(Blender.of(regionlimitedworldaccess), worldserver.getChunkSource().randomState(), worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), chunk).thenApply(ichunkaccess1 -> {
            ProtoChunk protochunk;
            BelowZeroRetrogen belowzeroretrogen;
            if (ichunkaccess1 instanceof ProtoChunk && (belowzeroretrogen = (protochunk = (ProtoChunk)ichunkaccess1).getBelowZeroRetrogen()) != null) {
                BelowZeroRetrogen.replaceOldBedrock(protochunk);
                if (belowzeroretrogen.hasBedrockHoles()) {
                    belowzeroretrogen.applyBedrockMask(protochunk);
                }
            }
            return ichunkaccess1;
        });
    }

    static CompletableFuture<ChunkAccess> generateSurface(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        ServerLevel worldserver = context.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, chunks, step, chunk);
        context.generator().buildSurface(regionlimitedworldaccess, worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), worldserver.getChunkSource().randomState(), chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<ChunkAccess> generateCarvers(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        ServerLevel worldserver = context.level();
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, chunks, step, chunk);
        if (chunk instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)chunk;
            Blender.addAroundOldChunksCarvingMaskFilter(regionlimitedworldaccess, protochunk);
        }
        context.generator().applyCarvers(regionlimitedworldaccess, worldserver.getSeed(), worldserver.getChunkSource().randomState(), worldserver.getBiomeManager(), worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess), chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<ChunkAccess> generateFeatures(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        ServerLevel worldserver = context.level();
        Heightmap.primeHeightmaps(chunk, EnumSet.of(Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE));
        WorldGenRegion regionlimitedworldaccess = new WorldGenRegion(worldserver, chunks, step, chunk);
        context.generator().applyBiomeDecoration(regionlimitedworldaccess, chunk, worldserver.structureManager().forWorldGenRegion(regionlimitedworldaccess));
        Blender.generateBorderTicks(regionlimitedworldaccess, chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<ChunkAccess> initializeLight(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        ThreadedLevelLightEngine lightenginethreaded = context.lightEngine();
        chunk.initializeLightSources();
        ((ProtoChunk)chunk).setLightEngine(lightenginethreaded);
        boolean flag = ChunkStatusTasks.isLighted(chunk);
        return lightenginethreaded.initializeLight(chunk, flag);
    }

    static CompletableFuture<ChunkAccess> light(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        boolean flag = ChunkStatusTasks.isLighted(chunk);
        return context.lightEngine().lightChunk(chunk, flag);
    }

    static CompletableFuture<ChunkAccess> generateSpawn(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        if (!chunk.isUpgrading()) {
            context.generator().spawnOriginalMobs(new WorldGenRegion(context.level(), chunks, step, chunk));
        }
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<ChunkAccess> full(WorldGenContext context, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks, ChunkAccess chunk) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        GenerationChunkHolder generationchunkholder = chunks.get(chunkcoordintpair.x, chunkcoordintpair.z);
        return CompletableFuture.supplyAsync(() -> {
            LevelChunk chunk1;
            ProtoChunk protochunk = (ProtoChunk)chunk;
            ServerLevel worldserver = context.level();
            if (protochunk instanceof ImposterProtoChunk) {
                ImposterProtoChunk protochunkextension = (ImposterProtoChunk)protochunk;
                chunk1 = protochunkextension.getWrapped();
            } else {
                chunk1 = new LevelChunk(worldserver, protochunk, $ -> ChunkStatusTasks.postLoadProtoChunk(worldserver, protochunk.getEntities(), protochunk.getPos()));
                generationchunkholder.replaceProtoChunk(new ImposterProtoChunk(chunk1, false));
            }
            Objects.requireNonNull(generationchunkholder);
            chunk1.setFullStatus(generationchunkholder::getFullStatus);
            chunk1.runPostLoad();
            chunk1.setLoaded(true);
            chunk1.registerAllBlockEntitiesAfterLevelLoad();
            chunk1.registerTickContainerInLevel(worldserver);
            chunk1.setUnsavedListener(context.unsavedListener());
            return chunk1;
        }, context.mainThreadExecutor());
    }

    public static void postLoadProtoChunk(ServerLevel world, List<CompoundTag> entities, ChunkPos pos) {
        if (!entities.isEmpty()) {
            world.addWorldGenChunkEntities(EntityType.loadEntitiesRecursive(entities, world, EntitySpawnReason.LOAD).filter(entity -> {
                boolean needsRemoval = false;
                DedicatedServer server = world.getCraftServer().getServer();
                if (!world.getChunkSource().spawnFriendlies && (entity instanceof Animal || entity instanceof WaterAnimal)) {
                    entity.discard(null);
                    needsRemoval = true;
                }
                ChunkStatusTasks.checkDupeUUID(world, entity);
                return !needsRemoval;
            }), pos);
        }
    }

    public static boolean checkDupeUUID(ServerLevel level, Entity entity) {
        WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode mode = level.paperConfig().entities.spawning.duplicateUuid.mode;
        if (mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.WARN && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.DELETE && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN) {
            return false;
        }
        Entity other = level.getEntity(entity.getUUID());
        if (other == null || other == entity) {
            return false;
        }
        if (mode == WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN && other != null && !other.isRemoved() && Objects.equals(other.getEncodeId(), entity.getEncodeId()) && entity.getBukkitEntity().getLocation().distance(other.getBukkitEntity().getLocation()) < (double)level.paperConfig().entities.spawning.duplicateUuid.safeRegenDeleteRange) {
            entity.discard(null);
            return true;
        }
        if (!other.isRemoved()) {
            switch (mode) {
                case SAFE_REGEN: {
                    entity.setUUID(UUID.randomUUID());
                    break;
                }
                case DELETE: {
                    entity.discard(EntityRemoveEvent.Cause.DISCARD);
                    return true;
                }
            }
        }
        return false;
    }
}

