/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkStorage;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.LegacyStructureDataHandler;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ChunkStorage
implements AutoCloseable,
ChunkSystemChunkStorage {
    public static final int LAST_MONOLYTH_STRUCTURE_DATA_VERSION = 1493;
    protected final DataFixer fixerUpper;
    @Nullable
    private volatile LegacyStructureDataHandler legacyStructureHandler;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RegionFileStorage storage;

    @Override
    public final RegionFileStorage moonrise$getRegionStorage() {
        return this.storage;
    }

    public ChunkStorage(RegionStorageInfo storageKey, Path directory, DataFixer dataFixer, boolean dsync) {
        this.fixerUpper = dataFixer;
        this.storage = new IOWorker((RegionStorageInfo)storageKey, (Path)directory, (boolean)dsync).storage;
    }

    public boolean isOldChunkAround(ChunkPos chunkPos, int checkRadius) {
        return true;
    }

    private boolean check(ServerChunkCache cps, int x, int z) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag upgradeChunkTag(ResourceKey<LevelStem> resourcekey, Supplier<DimensionDataStorage> supplier, CompoundTag nbttagcompound, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional, ChunkPos pos, @Nullable LevelAccessor generatoraccess) {
        int i = ChunkStorage.getVersion(nbttagcompound);
        if (i == SharedConstants.getCurrentVersion().getDataVersion().getVersion()) {
            return nbttagcompound;
        }
        try {
            boolean belowZeroGenerationInExistingChunks;
            if (i < 1493 && (nbttagcompound = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, i, 1493)).getCompound("Level").getBoolean("hasLegacyStructureData")) {
                LegacyStructureDataHandler persistentstructurelegacy;
                LegacyStructureDataHandler legacyStructureDataHandler = persistentstructurelegacy = this.getLegacyStructureHandler(resourcekey, supplier);
                synchronized (legacyStructureDataHandler) {
                    nbttagcompound = persistentstructurelegacy.updateFromLegacy(nbttagcompound);
                }
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((ServerLevel)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (i <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(nbttagcompound.getCompound("Level").getString("Status"));
            }
            ChunkStorage.injectDatafixingContext(nbttagcompound, resourcekey, optional);
            nbttagcompound = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, Math.max(1493, i), SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            if (stopBelowZero) {
                nbttagcompound.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(ChunkStatus.SPAWN).toString());
            }
            ChunkStorage.removeDatafixingContext(nbttagcompound);
            NbtUtils.addCurrentDataVersion(nbttagcompound);
            return nbttagcompound;
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable(exception, "Updated chunk");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Updated chunk details");
            crashreportsystemdetails.setDetail("Data version", i);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LegacyStructureDataHandler getLegacyStructureHandler(ResourceKey<LevelStem> worldKey, Supplier<DimensionDataStorage> stateManagerGetter) {
        LegacyStructureDataHandler persistentstructurelegacy = this.legacyStructureHandler;
        if (persistentstructurelegacy == null) {
            ChunkStorage chunkStorage = this;
            synchronized (chunkStorage) {
                persistentstructurelegacy = this.legacyStructureHandler;
                if (persistentstructurelegacy == null) {
                    this.legacyStructureHandler = persistentstructurelegacy = LegacyStructureDataHandler.getLegacyStructureHandler(worldKey, stateManagerGetter.get());
                }
            }
        }
        return persistentstructurelegacy;
    }

    public static void injectDatafixingContext(CompoundTag nbt, ResourceKey<LevelStem> worldKey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> generatorCodecKey) {
        CompoundTag nbttagcompound1 = new CompoundTag();
        nbttagcompound1.putString("dimension", worldKey.location().toString());
        generatorCodecKey.ifPresent(resourcekey1 -> nbttagcompound1.putString("generator", resourcekey1.location().toString()));
        nbt.put("__context", nbttagcompound1);
    }

    private static void removeDatafixingContext(CompoundTag nbt) {
        nbt.remove("__context");
    }

    public static int getVersion(CompoundTag nbt) {
        return NbtUtils.getDataVersion(nbt, -1);
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.storage.read(chunkPos)));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    public CompletableFuture<Void> write(ChunkPos chunkPos, Supplier<CompoundTag> nbtSupplier) {
        Supplier<CompoundTag> guardedPosCheck = () -> {
            CompoundTag nbt = (CompoundTag)nbtSupplier.get();
            if (nbt != null && !chunkPos.equals(SerializableChunkData.getChunkCoordinate(nbt))) {
                String world = this instanceof ChunkMap ? ((ChunkMap)this).level.getWorld().getName() : null;
                throw new IllegalArgumentException("Chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + String.valueOf(chunkPos) + " but compound says coordinate is " + String.valueOf(SerializableChunkData.getChunkCoordinate(nbt)) + (String)(world == null ? " for an unknown world" : " for world: " + world));
            }
            return nbt;
        };
        this.handleLegacyStructureIndex(chunkPos);
        try {
            this.storage.write(chunkPos, guardedPosCheck.get());
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLegacyStructureIndex(ChunkPos chunkPos) {
        if (this.legacyStructureHandler != null) {
            LegacyStructureDataHandler legacyStructureDataHandler = this.legacyStructureHandler;
            synchronized (legacyStructureDataHandler) {
                this.legacyStructureHandler.removeIndex(chunkPos.toLong());
            }
        }
    }

    public void flushWorker() {
        try {
            this.storage.flush();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to flush chunk storage", (Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    public ChunkScanAccess chunkScanner() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.storage.scanChunk(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public RegionStorageInfo storageInfo() {
        return this.storage.info();
    }
}

