/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.io.ChunkSystemRegionFileStorage;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.util.stream.ExternalChunkStreamMarker;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExceptionCollector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;

public class RegionFileStorage
implements AutoCloseable,
ChunkSystemRegionFileStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String ANVIL_EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    public final Long2ObjectLinkedOpenHashMap<RegionFile> regionCache = new Long2ObjectLinkedOpenHashMap();
    private final RegionStorageInfo info;
    private final Path folder;
    private final boolean sync;
    private static final int REGION_SHIFT = 5;
    private static final int MAX_NON_EXISTING_CACHE = 4096;
    private final LongLinkedOpenHashSet nonExistingRegionFiles = new LongLinkedOpenHashSet();
    private final boolean isChunkData;

    private static String getRegionFileName(int chunkX, int chunkZ) {
        return "r." + (chunkX >> 5) + "." + (chunkZ >> 5) + ANVIL_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesRegionFilePossiblyExist(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.contains(position)) {
                this.nonExistingRegionFiles.addAndMoveToFirst(position);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRegionFile(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            this.nonExistingRegionFiles.remove(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markNonExisting(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.addAndMoveToFirst(position)) {
                while (this.nonExistingRegionFiles.size() >= 4096) {
                    this.nonExistingRegionFiles.removeLastLong();
                }
            }
        }
    }

    @Override
    public final boolean moonrise$doesRegionFileNotExistNoIO(int chunkX, int chunkZ) {
        return !this.doesRegionFilePossiblyExist(ChunkPos.asLong(chunkX >> 5, chunkZ >> 5));
    }

    @Override
    public final synchronized RegionFile moonrise$getRegionFileIfLoaded(int chunkX, int chunkZ) {
        return (RegionFile)this.regionCache.getAndMoveToFirst(ChunkPos.asLong(chunkX >> 5, chunkZ >> 5));
    }

    @Override
    public final synchronized RegionFile moonrise$getRegionFileIfExists(int chunkX, int chunkZ) throws IOException {
        Path regionPath;
        long key = ChunkPos.asLong(chunkX >> 5, chunkZ >> 5);
        RegionFile ret = (RegionFile)this.regionCache.getAndMoveToFirst(key);
        if (ret != null) {
            return ret;
        }
        if (!this.doesRegionFilePossiblyExist(key)) {
            return null;
        }
        if (this.regionCache.size() >= GlobalConfiguration.get().misc.regionFileCacheSize) {
            ((RegionFile)this.regionCache.removeLast()).close();
        }
        if (!Files.exists(regionPath = this.folder.resolve(RegionFileStorage.getRegionFileName(chunkX, chunkZ)), new LinkOption[0])) {
            this.markNonExisting(key);
            return null;
        }
        this.createRegionFile(key);
        FileUtil.createDirectoriesSafe(this.folder);
        ret = new RegionFile(this.info, regionPath, this.folder, this.sync);
        this.regionCache.putAndMoveToFirst(key, (Object)ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MoonriseRegionFileIO.RegionDataController.WriteData moonrise$startWrite(int chunkX, int chunkZ, CompoundTag compound) throws IOException {
        if (compound == null) {
            return new MoonriseRegionFileIO.RegionDataController.WriteData(compound, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE, null, null);
        }
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        RegionFile regionFile = this.getRegionFile(pos);
        MoonriseRegionFileIO.RegionDataController.WriteData writeData = regionFile.moonrise$startWrite(compound, pos);
        try {
            try {
                NbtIo.write(compound, writeData.output());
            }
            finally {
                writeData.output().close();
            }
        }
        catch (RegionFileSizeException ex) {
            int maxSize = 500;
            LOGGER.error("Chunk at (" + chunkX + "," + chunkZ + ") in regionfile '" + regionFile.getPath().toString() + "' exceeds max size of 500MiB, it has been deleted from disk.");
            return new MoonriseRegionFileIO.RegionDataController.WriteData(compound, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE, null, null);
        }
        return writeData;
    }

    @Override
    public final void moonrise$finishWrite(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.WriteData writeData) throws IOException {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        if (writeData.result() == MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE) {
            RegionFile regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
            if (regionFile != null) {
                regionFile.clear(pos);
            }
            return;
        }
        writeData.write().run(this.getRegionFile(pos));
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController.ReadData moonrise$readData(int chunkX, int chunkZ) throws IOException {
        DataInputStream input;
        RegionFile regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
        DataInputStream dataInputStream = input = regionFile == null ? null : regionFile.getChunkDataInputStream(new ChunkPos(chunkX, chunkZ));
        if (input == null) {
            return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.NO_DATA, null, null);
        }
        MoonriseRegionFileIO.RegionDataController.ReadData ret = new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.HAS_DATA, input, null);
        if (!(input instanceof ExternalChunkStreamMarker)) {
            return ret;
        }
        CompoundTag syncRead = this.moonrise$finishRead(chunkX, chunkZ, ret);
        if (syncRead == null) {
            return this.moonrise$readData(chunkX, chunkZ);
        }
        return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.SYNC_READ, null, syncRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompoundTag moonrise$finishRead(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.ReadData readData) throws IOException {
        try {
            CompoundTag compoundTag = NbtIo.read(readData.input());
            return compoundTag;
        }
        finally {
            readData.input().close();
        }
    }

    public static boolean isChunkDataFolder(Path path) {
        return path.toFile().getName().equalsIgnoreCase("region");
    }

    @Nullable
    public static ChunkPos getRegionFileCoordinates(Path file) {
        String fileName = file.getFileName().toString();
        if (!fileName.startsWith("r.") || !fileName.endsWith(ANVIL_EXTENSION)) {
            return null;
        }
        String[] split = fileName.split("\\.");
        if (split.length != 4) {
            return null;
        }
        try {
            int x = Integer.parseInt(split[1]);
            int z = Integer.parseInt(split[2]);
            return new ChunkPos(x << 5, z << 5);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    protected RegionFileStorage(RegionStorageInfo storageKey, Path directory, boolean dsync) {
        this.folder = directory;
        this.sync = dsync;
        this.info = storageKey;
        this.isChunkData = RegionFileStorage.isChunkDataFolder(this.folder);
    }

    public RegionFile getRegionFile(ChunkPos chunkcoordintpair) throws IOException {
        return this.getRegionFile(chunkcoordintpair, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionFile getRegionFile(ChunkPos chunkcoordintpair, boolean existingOnly) throws IOException {
        if (existingOnly) {
            return this.moonrise$getRegionFileIfExists(chunkcoordintpair.x, chunkcoordintpair.z);
        }
        RegionFileStorage regionFileStorage = this;
        synchronized (regionFileStorage) {
            long key = ChunkPos.asLong(chunkcoordintpair.x >> 5, chunkcoordintpair.z >> 5);
            RegionFile ret = (RegionFile)this.regionCache.getAndMoveToFirst(key);
            if (ret != null) {
                return ret;
            }
            if (this.regionCache.size() >= GlobalConfiguration.get().misc.regionFileCacheSize) {
                ((RegionFile)this.regionCache.removeLast()).close();
            }
            Path regionPath = this.folder.resolve(RegionFileStorage.getRegionFileName(chunkcoordintpair.x, chunkcoordintpair.z));
            this.createRegionFile(key);
            FileUtil.createDirectoriesSafe(this.folder);
            ret = new RegionFile(this.info, regionPath, this.folder, this.sync);
            this.regionCache.putAndMoveToFirst(key, (Object)ret);
            return ret;
        }
    }

    private static void printOversizedLog(String msg, Path file, int x, int z) {
        LogManager.getLogger().fatal(msg + " (" + file.toString().replaceAll(".+[\\\\/]", "") + " - " + x + "," + z + ") Go clean it up to remove this message. /minecraft:tp " + (x << 4) + " 128 " + (z << 4) + " - DO NOT REPORT THIS TO PURPUR - You may ask for help on Discord, but do not file an issue. These error messages can not be removed.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CompoundTag readOversizedChunk(RegionFile regionfile, ChunkPos chunkCoordinate) throws IOException {
        RegionFile regionFile = regionfile;
        synchronized (regionFile) {
            try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(chunkCoordinate);){
                CompoundTag oversizedData = regionfile.getOversizedData(chunkCoordinate.x, chunkCoordinate.z);
                CompoundTag chunk = NbtIo.read(datainputstream);
                if (oversizedData == null) {
                    CompoundTag compoundTag2 = chunk;
                    return compoundTag2;
                }
                CompoundTag oversizedLevel = oversizedData.getCompound("Level");
                RegionFileStorage.mergeChunkList(chunk.getCompound("Level"), oversizedLevel, "Entities", "Entities");
                RegionFileStorage.mergeChunkList(chunk.getCompound("Level"), oversizedLevel, "TileEntities", "TileEntities");
                CompoundTag compoundTag = chunk;
                return compoundTag;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                throw throwable3;
            }
        }
    }

    private static void mergeChunkList(CompoundTag level, CompoundTag oversizedLevel, String key, String oversizedKey) {
        ListTag levelList = level.getList(key, 10);
        ListTag oversizedList = oversizedLevel.getList(oversizedKey, 10);
        if (!oversizedList.isEmpty()) {
            levelList.addAll(oversizedList);
            level.put(key, levelList);
        }
    }

    @Nullable
    public CompoundTag read(ChunkPos pos) throws IOException {
        CompoundTag nbttagcompound;
        block11: {
            CompoundTag nbttagcompound2;
            RegionFile regionfile = this.getRegionFile(pos, true);
            if (regionfile == null) {
                return null;
            }
            DataInputStream datainputstream = regionfile.getChunkDataInputStream(pos);
            if (regionfile.isOversized(pos.x, pos.z)) {
                RegionFileStorage.printOversizedLog("Loading Oversized Chunk!", regionfile.getPath(), pos.x, pos.z);
                return RegionFileStorage.readOversizedChunk(regionfile, pos);
            }
            try {
                if (datainputstream != null) {
                    ChunkPos chunkPos;
                    nbttagcompound = NbtIo.read(datainputstream);
                    if (this.isChunkData && !(chunkPos = SerializableChunkData.getChunkCoordinate(nbttagcompound)).equals(pos)) {
                        MinecraftServer.LOGGER.error("Attempting to read chunk data at " + String.valueOf(pos) + " but got chunk data for " + String.valueOf(chunkPos) + " instead! Attempting regionfile recalculation for regionfile " + String.valueOf(regionfile.getPath().toAbsolutePath()));
                        if (regionfile.recalculateHeader()) {
                            return this.read(pos);
                        }
                        MinecraftServer.LOGGER.error("Can't recalculate regionfile header, regenerating chunk " + String.valueOf(pos) + " for " + String.valueOf(regionfile.getPath().toAbsolutePath()));
                        return null;
                    }
                    break block11;
                }
                nbttagcompound2 = null;
            }
            finally {
                if (datainputstream != null) {
                    datainputstream.close();
                }
            }
            return nbttagcompound2;
        }
        return nbttagcompound;
    }

    public void scanChunk(ChunkPos chunkPos, StreamTagVisitor scanner) throws IOException {
        RegionFile regionfile = this.getRegionFile(chunkPos, true);
        if (regionfile == null) {
            return;
        }
        try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(chunkPos);){
            if (datainputstream != null) {
                NbtIo.parse(datainputstream, scanner, NbtAccounter.unlimitedHeap());
            }
        }
    }

    public void write(ChunkPos pos, @Nullable CompoundTag nbt) throws IOException {
        RegionFile regionfile = this.getRegionFile(pos, nbt == null);
        if (regionfile == null) {
            return;
        }
        if (nbt == null) {
            regionfile.clear(pos);
        } else {
            DataOutputStream dataoutputstream = regionfile.getChunkDataOutputStream(pos);
            try {
                NbtIo.write(nbt, dataoutputstream);
                regionfile.setOversized(pos.x, pos.z, false);
                dataoutputstream.close();
            }
            catch (RegionFileSizeException ex) {
                regionfile.clear(pos);
                int maxSize = 500;
                LOGGER.error("Chunk at (" + pos.x + "," + pos.z + ") in regionfile '" + regionfile.getPath().toString() + "' exceeds max size of 500MiB, it has been deleted from disk.");
                return;
            }
            catch (Throwable throwable) {
                if (dataoutputstream != null) {
                    // empty if block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RegionFileStorage regionFileStorage = this;
        synchronized (regionFileStorage) {
            ExceptionCollector<IOException> exceptionCollector = new ExceptionCollector<IOException>();
            for (RegionFile regionFile : this.regionCache.values()) {
                try {
                    regionFile.close();
                }
                catch (IOException ex) {
                    exceptionCollector.add(ex);
                }
            }
            exceptionCollector.throwIfPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        RegionFileStorage regionFileStorage = this;
        synchronized (regionFileStorage) {
            ExceptionCollector<IOException> exceptionCollector = new ExceptionCollector<IOException>();
            for (RegionFile regionFile : this.regionCache.values()) {
                try {
                    regionFile.flush();
                }
                catch (IOException ex) {
                    exceptionCollector.add(ex);
                }
            }
            exceptionCollector.throwIfPresent();
        }
    }

    public RegionStorageInfo info() {
        return this.info;
    }

    public static final class RegionFileSizeException
    extends RuntimeException {
        public RegionFileSizeException(String message) {
            super(message);
        }
    }
}

