/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import org.apache.commons.lang3.mutable.MutableDouble;

public interface Aquifer {
    public static Aquifer create(NoiseChunk chunkNoiseSampler, ChunkPos chunkPos, NoiseRouter noiseRouter, PositionalRandomFactory randomSplitter, int minimumY, int height, FluidPicker fluidLevelSampler) {
        return new NoiseBasedAquifer(chunkNoiseSampler, chunkPos, noiseRouter, randomSplitter, minimumY, height, fluidLevelSampler);
    }

    public static Aquifer createDisabled(final FluidPicker fluidLevelSampler) {
        return new Aquifer(){

            @Override
            @Nullable
            @Override
            public BlockState computeSubstance(DensityFunction.FunctionContext pos, double density) {
                if (density > 0.0) {
                    return null;
                }
                return fluidLevelSampler.computeFluid(pos.blockX(), pos.blockY(), pos.blockZ()).at(pos.blockY());
            }

            @Override
            @Override
            public boolean shouldScheduleFluidUpdate() {
                return false;
            }
        };
    }

    @Nullable
    public BlockState computeSubstance(DensityFunction.FunctionContext var1, double var2);

    public boolean shouldScheduleFluidUpdate();

    public static class NoiseBasedAquifer
    implements Aquifer {
        private static final int X_RANGE = 10;
        private static final int Y_RANGE = 9;
        private static final int Z_RANGE = 10;
        private static final int X_SEPARATION = 6;
        private static final int Y_SEPARATION = 3;
        private static final int Z_SEPARATION = 6;
        private static final int X_SPACING = 16;
        private static final int Y_SPACING = 12;
        private static final int Z_SPACING = 16;
        private static final int MAX_REASONABLE_DISTANCE_TO_AQUIFER_CENTER = 11;
        private static final double FLOWING_UPDATE_SIMULARITY = NoiseBasedAquifer.similarity(Mth.square(10), Mth.square(12));
        private final NoiseChunk noiseChunk;
        private final DensityFunction barrierNoise;
        private final DensityFunction fluidLevelFloodednessNoise;
        private final DensityFunction fluidLevelSpreadNoise;
        private final DensityFunction lavaNoise;
        private final PositionalRandomFactory positionalRandomFactory;
        private final FluidStatus[] aquiferCache;
        private final long[] aquiferLocationCache;
        private final FluidPicker globalFluidPicker;
        private final DensityFunction erosion;
        private final DensityFunction depth;
        private boolean shouldScheduleFluidUpdate;
        private final int minGridX;
        private final int minGridY;
        private final int minGridZ;
        private final int gridSizeX;
        private final int gridSizeZ;
        private static final int[][] SURFACE_SAMPLING_OFFSETS_IN_CHUNKS = new int[][]{{0, 0}, {-2, -1}, {-1, -1}, {0, -1}, {1, -1}, {-3, 0}, {-2, 0}, {-1, 0}, {1, 0}, {-2, 1}, {-1, 1}, {0, 1}, {1, 1}};

        NoiseBasedAquifer(NoiseChunk chunkNoiseSampler, ChunkPos chunkPos, NoiseRouter noiseRouter, PositionalRandomFactory randomSplitter, int minimumY, int height, FluidPicker fluidLevelSampler) {
            this.noiseChunk = chunkNoiseSampler;
            this.barrierNoise = noiseRouter.barrierNoise();
            this.fluidLevelFloodednessNoise = noiseRouter.fluidLevelFloodednessNoise();
            this.fluidLevelSpreadNoise = noiseRouter.fluidLevelSpreadNoise();
            this.lavaNoise = noiseRouter.lavaNoise();
            this.erosion = noiseRouter.erosion();
            this.depth = noiseRouter.depth();
            this.positionalRandomFactory = randomSplitter;
            this.minGridX = this.gridX(chunkPos.getMinBlockX()) - 1;
            this.globalFluidPicker = fluidLevelSampler;
            int i = this.gridX(chunkPos.getMaxBlockX()) + 1;
            this.gridSizeX = i - this.minGridX + 1;
            this.minGridY = this.gridY(minimumY) - 1;
            int j = this.gridY(minimumY + height) + 1;
            int k = j - this.minGridY + 1;
            this.minGridZ = this.gridZ(chunkPos.getMinBlockZ()) - 1;
            int l = this.gridZ(chunkPos.getMaxBlockZ()) + 1;
            this.gridSizeZ = l - this.minGridZ + 1;
            int m = this.gridSizeX * k * this.gridSizeZ;
            this.aquiferCache = new FluidStatus[m];
            this.aquiferLocationCache = new long[m];
            Arrays.fill(this.aquiferLocationCache, Long.MAX_VALUE);
        }

        private int getIndex(int x, int y, int z) {
            int i = x - this.minGridX;
            int j = y - this.minGridY;
            int k = z - this.minGridZ;
            return (j * this.gridSizeZ + k) * this.gridSizeX + i;
        }

        @Override
        @Nullable
        @Override
        public BlockState computeSubstance(DensityFunction.FunctionContext pos, double density) {
            boolean bl3;
            double ak;
            double g;
            BlockState blockState;
            int i = pos.blockX();
            int j = pos.blockY();
            int k = pos.blockZ();
            if (density > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            FluidStatus fluidStatus = this.globalFluidPicker.computeFluid(i, j, k);
            if (fluidStatus.at(j).is(Blocks.LAVA)) {
                this.shouldScheduleFluidUpdate = false;
                return Blocks.LAVA.defaultBlockState();
            }
            int l = Math.floorDiv(i - 5, 16);
            int m = Math.floorDiv(j + 1, 12);
            int n = Math.floorDiv(k - 5, 16);
            int o = Integer.MAX_VALUE;
            int p = Integer.MAX_VALUE;
            int q = Integer.MAX_VALUE;
            int r = Integer.MAX_VALUE;
            long s = 0L;
            long t = 0L;
            long u = 0L;
            long v = 0L;
            for (int w = 0; w <= 1; ++w) {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 0; y <= 1; ++y) {
                        long af;
                        int z = l + w;
                        int aa = m + x;
                        int ab = n + y;
                        int ac = this.getIndex(z, aa, ab);
                        long ad = this.aquiferLocationCache[ac];
                        if (ad != Long.MAX_VALUE) {
                            long ae = ad;
                        } else {
                            RandomSource randomSource = this.positionalRandomFactory.at(z, aa, ab);
                            this.aquiferLocationCache[ac] = af = BlockPos.asLong(z * 16 + randomSource.nextInt(10), aa * 12 + randomSource.nextInt(9), ab * 16 + randomSource.nextInt(10));
                        }
                        int ag = BlockPos.getX(af) - i;
                        int ah = BlockPos.getY(af) - j;
                        int ai = BlockPos.getZ(af) - k;
                        int aj = ag * ag + ah * ah + ai * ai;
                        if (o >= aj) {
                            v = u;
                            u = t;
                            t = s;
                            s = af;
                            r = q;
                            q = p;
                            p = o;
                            o = aj;
                            continue;
                        }
                        if (p >= aj) {
                            v = u;
                            u = t;
                            t = af;
                            r = q;
                            q = p;
                            p = aj;
                            continue;
                        }
                        if (q >= aj) {
                            v = u;
                            u = af;
                            r = q;
                            q = aj;
                            continue;
                        }
                        if (r < aj) continue;
                        v = af;
                        r = aj;
                    }
                }
            }
            FluidStatus fluidStatus2 = this.getAquiferStatus(s);
            double d = NoiseBasedAquifer.similarity(o, p);
            BlockState blockState2 = blockState = fluidStatus2.at(j);
            if (d <= 0.0) {
                FluidStatus fluidStatus3;
                this.shouldScheduleFluidUpdate = d >= FLOWING_UPDATE_SIMULARITY ? !fluidStatus2.equals(fluidStatus3 = this.getAquiferStatus(t)) : false;
                return blockState2;
            }
            if (blockState.is(Blocks.WATER) && this.globalFluidPicker.computeFluid(i, j - 1, k).at(j - 1).is(Blocks.LAVA)) {
                this.shouldScheduleFluidUpdate = true;
                return blockState2;
            }
            MutableDouble mutableDouble = new MutableDouble(Double.NaN);
            FluidStatus fluidStatus4 = this.getAquiferStatus(t);
            double e = d * this.calculatePressure(pos, mutableDouble, fluidStatus2, fluidStatus4);
            if (density + e > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            FluidStatus fluidStatus5 = this.getAquiferStatus(u);
            double f = NoiseBasedAquifer.similarity(o, q);
            if (f > 0.0 && density + (g = d * f * this.calculatePressure(pos, mutableDouble, fluidStatus2, fluidStatus5)) > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            double h = NoiseBasedAquifer.similarity(p, q);
            if (h > 0.0 && density + (ak = d * h * this.calculatePressure(pos, mutableDouble, fluidStatus4, fluidStatus5)) > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            boolean bl = !fluidStatus2.equals(fluidStatus4);
            boolean bl2 = h >= FLOWING_UPDATE_SIMULARITY && !fluidStatus4.equals(fluidStatus5);
            boolean bl4 = bl3 = f >= FLOWING_UPDATE_SIMULARITY && !fluidStatus2.equals(fluidStatus5);
            this.shouldScheduleFluidUpdate = bl || bl2 || bl3 ? true : f >= FLOWING_UPDATE_SIMULARITY && NoiseBasedAquifer.similarity(o, r) >= FLOWING_UPDATE_SIMULARITY && !fluidStatus2.equals(this.getAquiferStatus(v));
            return blockState2;
        }

        @Override
        @Override
        public boolean shouldScheduleFluidUpdate() {
            return this.shouldScheduleFluidUpdate;
        }

        private static double similarity(int i, int a) {
            double d = 25.0;
            return 1.0 - (double)Math.abs(a - i) / 25.0;
        }

        private double calculatePressure(DensityFunction.FunctionContext pos, MutableDouble mutableDouble, FluidStatus fluidStatus, FluidStatus fluidStatus2) {
            double aa;
            double u;
            int i = pos.blockY();
            BlockState blockState = fluidStatus.at(i);
            BlockState blockState2 = fluidStatus2.at(i);
            if (blockState.is(Blocks.LAVA) && blockState2.is(Blocks.WATER) || blockState.is(Blocks.WATER) && blockState2.is(Blocks.LAVA)) {
                return 2.0;
            }
            int j = Math.abs(fluidStatus.fluidLevel - fluidStatus2.fluidLevel);
            if (j == 0) {
                return 0.0;
            }
            double d = 0.5 * (double)(fluidStatus.fluidLevel + fluidStatus2.fluidLevel);
            double e = (double)i + 0.5 - d;
            double f = (double)j / 2.0;
            double g = 0.0;
            double h = 2.5;
            double k = 1.5;
            double l = 3.0;
            double m = 10.0;
            double n = 3.0;
            double o = f - Math.abs(e);
            if (e > 0.0) {
                double p = 0.0 + o;
                if (p > 0.0) {
                    double q = p / 1.5;
                } else {
                    double r = p / 2.5;
                }
            } else {
                double s = 3.0 + o;
                if (s > 0.0) {
                    double t = s / 3.0;
                } else {
                    u = s / 10.0;
                }
            }
            double v = 2.0;
            if (u < -2.0 || u > 2.0) {
                double w = 0.0;
            } else {
                double x = mutableDouble.getValue();
                if (Double.isNaN(x)) {
                    double y = this.barrierNoise.compute(pos);
                    mutableDouble.setValue(y);
                    double z = y;
                } else {
                    aa = x;
                }
            }
            return 2.0 * (aa + u);
        }

        private int gridX(int x) {
            return Math.floorDiv(x, 16);
        }

        private int gridY(int y) {
            return Math.floorDiv(y, 12);
        }

        private int gridZ(int z) {
            return Math.floorDiv(z, 16);
        }

        private FluidStatus getAquiferStatus(long pos) {
            FluidStatus fluidStatus2;
            int n;
            int m;
            int i = BlockPos.getX(pos);
            int j = BlockPos.getY(pos);
            int k = BlockPos.getZ(pos);
            int l = this.gridX(i);
            int o = this.getIndex(l, m = this.gridY(j), n = this.gridZ(k));
            FluidStatus fluidStatus = this.aquiferCache[o];
            if (fluidStatus != null) {
                return fluidStatus;
            }
            this.aquiferCache[o] = fluidStatus2 = this.computeFluid(i, j, k);
            return fluidStatus2;
        }

        private FluidStatus computeFluid(int blockX, int blockY, int blockZ) {
            FluidStatus fluidStatus = this.globalFluidPicker.computeFluid(blockX, blockY, blockZ);
            int i = Integer.MAX_VALUE;
            int j = blockY + 12;
            int k = blockY - 12;
            boolean bl = false;
            for (int[] is : SURFACE_SAMPLING_OFFSETS_IN_CHUNKS) {
                FluidStatus fluidStatus2;
                boolean bl3;
                boolean bl2;
                int l = blockX + SectionPos.sectionToBlockCoord(is[0]);
                int m = blockZ + SectionPos.sectionToBlockCoord(is[1]);
                int n = this.noiseChunk.preliminarySurfaceLevel(l, m);
                int o = n + 8;
                boolean bl4 = bl2 = is[0] == 0 && is[1] == 0;
                if (bl2 && k > o) {
                    return fluidStatus;
                }
                boolean bl5 = bl3 = j > o;
                if ((bl3 || bl2) && !(fluidStatus2 = this.globalFluidPicker.computeFluid(l, o, m)).at(o).isAir()) {
                    if (bl2) {
                        bl = true;
                    }
                    if (bl3) {
                        return fluidStatus2;
                    }
                }
                i = Math.min(i, n);
            }
            int p = this.computeSurfaceLevel(blockX, blockY, blockZ, fluidStatus, i, bl);
            return new FluidStatus(p, this.computeFluidType(blockX, blockY, blockZ, fluidStatus, p));
        }

        private int computeSurfaceLevel(int blockX, int blockY, int blockZ, FluidStatus defaultFluidLevel, int surfaceHeightEstimate, boolean bl) {
            int p;
            double m;
            double l;
            DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(blockX, blockY, blockZ);
            if (OverworldBiomeBuilder.isDeepDarkRegion(this.erosion, this.depth, singlePointContext)) {
                double d = -1.0;
                double e = -1.0;
            } else {
                int i = surfaceHeightEstimate + 8 - blockY;
                int j = 64;
                double f = bl ? Mth.clampedMap((double)i, 0.0, 64.0, 1.0, 0.0) : 0.0;
                double g = Mth.clamp(this.fluidLevelFloodednessNoise.compute(singlePointContext), -1.0, 1.0);
                double h = Mth.map(f, 1.0, 0.0, -0.3, 0.8);
                double k = Mth.map(f, 1.0, 0.0, -0.8, 0.4);
                l = g - k;
                m = g - h;
            }
            if (m > 0.0) {
                int n = defaultFluidLevel.fluidLevel;
            } else if (l > 0.0) {
                int o = this.computeRandomizedFluidSurfaceLevel(blockX, blockY, blockZ, surfaceHeightEstimate);
            } else {
                p = DimensionType.WAY_BELOW_MIN_Y;
            }
            return p;
        }

        private int computeRandomizedFluidSurfaceLevel(int blockX, int blockY, int blockZ, int surfaceHeightEstimate) {
            int i = 16;
            int j = 40;
            int k = Math.floorDiv(blockX, 16);
            int l = Math.floorDiv(blockY, 40);
            int m = Math.floorDiv(blockZ, 16);
            int n = l * 40 + 20;
            int o = 10;
            double d = this.fluidLevelSpreadNoise.compute(new DensityFunction.SinglePointContext(k, l, m)) * 10.0;
            int p = Mth.quantize(d, 3);
            int q = n + p;
            return Math.min(surfaceHeightEstimate, q);
        }

        private BlockState computeFluidType(int blockX, int blockY, int blockZ, FluidStatus defaultFluidLevel, int fluidLevel) {
            BlockState blockState = defaultFluidLevel.fluidType;
            if (fluidLevel <= -10 && fluidLevel != DimensionType.WAY_BELOW_MIN_Y && defaultFluidLevel.fluidType != Blocks.LAVA.defaultBlockState()) {
                int m;
                int l;
                int i = 64;
                int j = 40;
                int k = Math.floorDiv(blockX, 64);
                double d = this.lavaNoise.compute(new DensityFunction.SinglePointContext(k, l = Math.floorDiv(blockY, 40), m = Math.floorDiv(blockZ, 64)));
                if (Math.abs(d) > 0.3) {
                    blockState = Blocks.LAVA.defaultBlockState();
                }
            }
            return blockState;
        }
    }

    public static interface FluidPicker {
        public FluidStatus computeFluid(int var1, int var2, int var3);
    }

    public record FluidStatus(int fluidLevel, BlockState fluidType) {
        public BlockState at(int y) {
            return y < this.fluidLevel ? this.fluidType : Blocks.AIR.defaultBlockState();
        }
    }
}

