/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.jetbrains.annotations.Nullable;

public class WorldGenerationContext {
    private final int minY;
    private final int height;
    @javax.annotation.Nullable
    private final Level level;

    public WorldGenerationContext(ChunkGenerator generator, LevelHeightAccessor world) {
        this(generator, world, null);
    }

    public WorldGenerationContext(ChunkGenerator generator, LevelHeightAccessor world, @Nullable Level level) {
        this.minY = Math.max(world.getMinY(), generator.getMinY());
        this.height = Math.min(world.getHeight(), generator.getGenDepth());
        this.level = level;
    }

    public int getMinGenY() {
        return this.minY;
    }

    public int getGenDepth() {
        return this.height;
    }

    public Level getWorld() {
        if (this.level == null) {
            throw new NullPointerException("WorldGenerationContext was initialized without a Level, but WorldGenerationContext#getWorld was called");
        }
        return this.level;
    }
}

