/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;

public class BasaltColumnsFeature
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.LAVA, (Object)Blocks.BEDROCK, (Object)Blocks.MAGMA_BLOCK, (Object)Blocks.SOUL_SAND, (Object)Blocks.NETHER_BRICKS, (Object)Blocks.NETHER_BRICK_FENCE, (Object)Blocks.NETHER_BRICK_STAIRS, (Object)Blocks.NETHER_WART, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER);
    private static final int CLUSTERED_REACH = 5;
    private static final int CLUSTERED_SIZE = 50;
    private static final int UNCLUSTERED_REACH = 8;
    private static final int UNCLUSTERED_SIZE = 15;

    public BasaltColumnsFeature(Codec<ColumnFeatureConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean place(FeaturePlaceContext<ColumnFeatureConfiguration> context) {
        int i = context.chunkGenerator().getSeaLevel();
        BlockPos blockPos = context.origin();
        WorldGenLevel worldGenLevel = context.level();
        RandomSource randomSource = context.random();
        ColumnFeatureConfiguration columnFeatureConfiguration = context.config();
        if (!BasaltColumnsFeature.canPlaceAt(worldGenLevel, i, blockPos.mutable())) {
            return false;
        }
        int j = columnFeatureConfiguration.height().sample(randomSource);
        boolean bl = randomSource.nextFloat() < 0.9f;
        int k = Math.min(j, bl ? 5 : 8);
        int l = bl ? 50 : 15;
        boolean bl2 = false;
        for (BlockPos blockPos2 : BlockPos.randomBetweenClosed(randomSource, l, blockPos.getX() - k, blockPos.getY(), blockPos.getZ() - k, blockPos.getX() + k, blockPos.getY(), blockPos.getZ() + k)) {
            int m = j - blockPos2.distManhattan(blockPos);
            if (m < 0) continue;
            bl2 |= this.placeColumn(worldGenLevel, i, blockPos2, m, columnFeatureConfiguration.reach().sample(randomSource));
        }
        return bl2;
    }

    private boolean placeColumn(LevelAccessor world, int seaLevel, BlockPos pos, int height, int reach) {
        boolean bl = false;
        block0: for (BlockPos blockPos : BlockPos.betweenClosed(pos.getX() - reach, pos.getY(), pos.getZ() - reach, pos.getX() + reach, pos.getY(), pos.getZ() + reach)) {
            BlockPos blockPos2;
            int i = blockPos.distManhattan(pos);
            BlockPos blockPos3 = blockPos2 = BasaltColumnsFeature.isAirOrLavaOcean(world, seaLevel, blockPos) ? BasaltColumnsFeature.findSurface(world, seaLevel, blockPos.mutable(), i) : BasaltColumnsFeature.findAir(world, blockPos.mutable(), i);
            if (blockPos2 == null) continue;
            BlockPos.MutableBlockPos mutableBlockPos = blockPos2.mutable();
            for (int j = height - i / 2; j >= 0; --j) {
                if (BasaltColumnsFeature.isAirOrLavaOcean(world, seaLevel, mutableBlockPos)) {
                    this.setBlock(world, mutableBlockPos, Blocks.BASALT.defaultBlockState());
                    mutableBlockPos.move(Direction.UP);
                    bl = true;
                    continue;
                }
                if (!world.getBlockState(mutableBlockPos).is(Blocks.BASALT)) continue block0;
                mutableBlockPos.move(Direction.UP);
            }
        }
        return bl;
    }

    @Nullable
    private static BlockPos findSurface(LevelAccessor world, int seaLevel, BlockPos.MutableBlockPos mutablePos, int distance) {
        while (mutablePos.getY() > world.getMinY() + 1 && distance > 0) {
            --distance;
            if (BasaltColumnsFeature.canPlaceAt(world, seaLevel, mutablePos)) {
                return mutablePos;
            }
            mutablePos.move(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor world, int seaLevel, BlockPos.MutableBlockPos mutablePos) {
        if (BasaltColumnsFeature.isAirOrLavaOcean(world, seaLevel, mutablePos)) {
            BlockState blockState = world.getBlockState(mutablePos.move(Direction.DOWN));
            mutablePos.move(Direction.UP);
            return !blockState.isAir() && !CANNOT_PLACE_ON.contains((Object)blockState.getBlock());
        }
        return false;
    }

    @Nullable
    private static BlockPos findAir(LevelAccessor world, BlockPos.MutableBlockPos mutablePos, int distance) {
        while (mutablePos.getY() <= world.getMaxY() && distance > 0) {
            --distance;
            BlockState blockState = world.getBlockState(mutablePos);
            if (CANNOT_PLACE_ON.contains((Object)blockState.getBlock())) {
                return null;
            }
            if (blockState.isAir()) {
                return mutablePos;
            }
            mutablePos.move(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(LevelAccessor world, int seaLevel, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.isAir() || blockState.is(Blocks.LAVA) && pos.getY() <= seaLevel;
    }
}

