/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class TrunkVineDecorator
extends TreeDecorator {
    public static final MapCodec<TrunkVineDecorator> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final TrunkVineDecorator INSTANCE = new TrunkVineDecorator();

    @Override
    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.TRUNK_VINE;
    }

    @Override
    @Override
    public void place(TreeDecorator.Context generator) {
        RandomSource randomSource = generator.random();
        generator.logs().forEach(pos -> {
            BlockPos blockPos4;
            BlockPos blockPos3;
            BlockPos blockPos2;
            BlockPos blockPos;
            if (randomSource.nextInt(3) > 0 && generator.isAir(blockPos = pos.west())) {
                generator.placeVine(blockPos, VineBlock.EAST);
            }
            if (randomSource.nextInt(3) > 0 && generator.isAir(blockPos2 = pos.east())) {
                generator.placeVine(blockPos2, VineBlock.WEST);
            }
            if (randomSource.nextInt(3) > 0 && generator.isAir(blockPos3 = pos.north())) {
                generator.placeVine(blockPos3, VineBlock.SOUTH);
            }
            if (randomSource.nextInt(3) > 0 && generator.isAir(blockPos4 = pos.south())) {
                generator.placeVine(blockPos4, VineBlock.NORTH);
            }
        });
    }
}

