/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.common.map.SynchronisedLong2BooleanMap;
import ca.spottedleaf.moonrise.common.map.SynchronisedLong2ObjectMap;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class StructureCheck {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_STRUCTURE = -1;
    private final ChunkScanAccess storageAccess;
    private final RegistryAccess registryAccess;
    private final StructureTemplateManager structureTemplateManager;
    private final ResourceKey<LevelStem> dimension;
    private final ChunkGenerator chunkGenerator;
    private final RandomState randomState;
    private final LevelHeightAccessor heightAccessor;
    private final BiomeSource biomeSource;
    private final long seed;
    private final DataFixer fixerUpper;
    private static final int CHUNK_TOTAL_LIMIT = 2020050;
    private static final int PER_FEATURE_CHECK_LIMIT = 2020050;
    private final SynchronisedLong2ObjectMap<Object2IntMap<Structure>> loadedChunksSafe = new SynchronisedLong2ObjectMap(2020050);
    private final ConcurrentHashMap<Structure, SynchronisedLong2BooleanMap> featureChecksSafe = new ConcurrentHashMap();

    public StructureCheck(ChunkScanAccess chunkIoWorker, RegistryAccess registryManager, StructureTemplateManager structureTemplateManager, ResourceKey<LevelStem> worldKey, ChunkGenerator chunkGenerator, RandomState noiseConfig, LevelHeightAccessor world, BiomeSource biomeSource, long seed, DataFixer dataFixer) {
        this.storageAccess = chunkIoWorker;
        this.registryAccess = registryManager;
        this.structureTemplateManager = structureTemplateManager;
        this.dimension = worldKey;
        this.chunkGenerator = chunkGenerator;
        this.randomState = noiseConfig;
        this.heightAccessor = world;
        this.biomeSource = biomeSource;
        this.seed = seed;
        this.fixerUpper = dataFixer;
    }

    @Nullable
    private Integer getSaltOverride(Structure type) {
        LevelHeightAccessor levelHeightAccessor = this.heightAccessor;
        if (levelHeightAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelHeightAccessor;
            if (type instanceof MineshaftStructure) {
                return serverLevel.spigotConfig.mineshaftSeed;
            }
            if (type instanceof BuriedTreasureStructure) {
                return serverLevel.spigotConfig.buriedTreasureSeed;
            }
        }
        return null;
    }

    public StructureCheckResult checkStart(ChunkPos pos, Structure type, StructurePlacement placement, boolean skipReferencedStructures) {
        long l = pos.toLong();
        Object2IntMap<Structure> object2IntMap = this.loadedChunksSafe.get(l);
        if (object2IntMap != null) {
            return this.checkStructureInfo(object2IntMap, type, skipReferencedStructures);
        }
        StructureCheckResult structureCheckResult = this.tryLoadFromStorage(pos, type, skipReferencedStructures, l);
        if (structureCheckResult != null) {
            return structureCheckResult;
        }
        if (!placement.applyAdditionalChunkRestrictions(pos.x, pos.z, this.seed, this.getSaltOverride(type))) {
            return StructureCheckResult.START_NOT_PRESENT;
        }
        boolean bl = this.featureChecksSafe.computeIfAbsent(type, structure2 -> new SynchronisedLong2BooleanMap(2020050)).getOrCompute(l, chunkPos -> this.canCreateStructure(pos, type));
        return !bl ? StructureCheckResult.START_NOT_PRESENT : StructureCheckResult.CHUNK_LOAD_NEEDED;
    }

    private boolean canCreateStructure(ChunkPos pos, Structure structure) {
        return structure.findValidGenerationPoint(new Structure.GenerationContext(this.registryAccess, this.chunkGenerator, this.biomeSource, this.randomState, this.structureTemplateManager, this.seed, pos, this.heightAccessor, structure.biomes()::contains)).isPresent();
    }

    @Nullable
    private StructureCheckResult tryLoadFromStorage(ChunkPos pos, Structure structure, boolean skipReferencedStructures, long posLong) {
        CompoundTag compoundTag2;
        CollectFields collectFields = new CollectFields(new FieldSelector(IntTag.TYPE, "DataVersion"), new FieldSelector("Level", "Structures", CompoundTag.TYPE, "Starts"), new FieldSelector("structures", CompoundTag.TYPE, "starts"));
        try {
            this.storageAccess.scanChunk(pos, collectFields).join();
        }
        catch (Exception var13) {
            LOGGER.warn("Failed to read chunk {}", (Object)pos, (Object)var13);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        Tag tag = collectFields.getResult();
        if (!(tag instanceof CompoundTag)) {
            return null;
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        int i = ChunkStorage.getVersion(compoundTag);
        if (i <= 1493) {
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        ChunkStorage.injectDatafixingContext(compoundTag, this.dimension, this.chunkGenerator.getTypeNameForDataFixer());
        try {
            compoundTag2 = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, compoundTag, i, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        }
        catch (Exception var12) {
            LOGGER.warn("Failed to partially datafix chunk {}", (Object)pos, (Object)var12);
            return StructureCheckResult.CHUNK_LOAD_NEEDED;
        }
        Object2IntMap<Structure> object2IntMap = this.loadStructures(compoundTag2);
        if (object2IntMap == null) {
            return null;
        }
        this.storeFullResults(posLong, object2IntMap);
        return this.checkStructureInfo(object2IntMap, structure, skipReferencedStructures);
    }

    @Nullable
    private Object2IntMap<Structure> loadStructures(CompoundTag nbt) {
        if (!nbt.contains("structures", 10)) {
            return null;
        }
        CompoundTag compoundTag = nbt.getCompound("structures");
        if (!compoundTag.contains("starts", 10)) {
            return null;
        }
        CompoundTag compoundTag2 = compoundTag.getCompound("starts");
        if (compoundTag2.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        HolderLookup.RegistryLookup registry = this.registryAccess.lookupOrThrow(Registries.STRUCTURE);
        for (String string : compoundTag2.getAllKeys()) {
            String string2;
            CompoundTag compoundTag3;
            Structure structure;
            ResourceLocation resourceLocation = ResourceLocation.tryParse(string);
            if (resourceLocation == null || (structure = (Structure)registry.getValue(resourceLocation)) == null || (compoundTag3 = compoundTag2.getCompound(string)).isEmpty() || "INVALID".equals(string2 = compoundTag3.getString("id"))) continue;
            int i = compoundTag3.getInt("references");
            object2IntMap.put((Object)structure, i);
        }
        return object2IntMap;
    }

    private static Object2IntMap<Structure> deduplicateEmptyMap(Object2IntMap<Structure> map) {
        return map.isEmpty() ? Object2IntMaps.emptyMap() : map;
    }

    private StructureCheckResult checkStructureInfo(Object2IntMap<Structure> referencesByStructure, Structure structure, boolean skipReferencedStructures) {
        int i = referencesByStructure.getOrDefault((Object)structure, -1);
        return i == -1 || skipReferencedStructures && i != 0 ? StructureCheckResult.START_NOT_PRESENT : StructureCheckResult.START_PRESENT;
    }

    public void onStructureLoad(ChunkPos pos, Map<Structure, StructureStart> structureStarts) {
        long l = pos.toLong();
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        structureStarts.forEach((arg_0, arg_1) -> StructureCheck.lambda$onStructureLoad$2((Object2IntMap)object2IntMap, arg_0, arg_1));
        this.storeFullResults(l, (Object2IntMap<Structure>)object2IntMap);
    }

    private void storeFullResults(long pos, Object2IntMap<Structure> referencesByStructure) {
        this.loadedChunksSafe.put(pos, StructureCheck.deduplicateEmptyMap(referencesByStructure));
        for (SynchronisedLong2BooleanMap value : this.featureChecksSafe.values()) {
            value.remove(pos);
        }
    }

    public void incrementReference(ChunkPos pos, Structure structure) {
        this.loadedChunksSafe.compute(pos.toLong(), (posx, referencesByStructure) -> {
            if (referencesByStructure == null) {
                referencesByStructure = new Object2IntOpenHashMap();
            } else {
                Object2IntOpenHashMap object2IntOpenHashMap;
                if (referencesByStructure instanceof Object2IntOpenHashMap) {
                    Object2IntOpenHashMap fastClone = (Object2IntOpenHashMap)referencesByStructure;
                    object2IntOpenHashMap = fastClone.clone();
                } else {
                    object2IntOpenHashMap = new Object2IntOpenHashMap(referencesByStructure);
                }
                referencesByStructure = object2IntOpenHashMap;
            }
            referencesByStructure.computeInt((Object)structure, (feature, references) -> references == null ? 1 : references + 1);
            return referencesByStructure;
        });
    }

    private static /* synthetic */ void lambda$onStructureLoad$2(Object2IntMap object2IntMap, Structure start, StructureStart structureStart) {
        if (structureStart.isValid()) {
            object2IntMap.put((Object)start, structureStart.getReferences());
        }
    }
}

