/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class StructureFeatureIndexSavedData
extends SavedData {
    private static final String TAG_REMAINING_INDEXES = "Remaining";
    private static final String TAG_All_INDEXES = "All";
    private final LongSet all;
    private final LongSet remaining;

    public static SavedData.Factory<StructureFeatureIndexSavedData> factory() {
        return new SavedData.Factory<StructureFeatureIndexSavedData>(StructureFeatureIndexSavedData::new, StructureFeatureIndexSavedData::load, DataFixTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES);
    }

    private StructureFeatureIndexSavedData(LongSet all, LongSet remaining) {
        this.all = all;
        this.remaining = remaining;
    }

    public StructureFeatureIndexSavedData() {
        this((LongSet)new LongOpenHashSet(), (LongSet)new LongOpenHashSet());
    }

    public static StructureFeatureIndexSavedData load(CompoundTag nbt, HolderLookup.Provider registries) {
        return new StructureFeatureIndexSavedData((LongSet)new LongOpenHashSet(nbt.getLongArray(TAG_All_INDEXES)), (LongSet)new LongOpenHashSet(nbt.getLongArray(TAG_REMAINING_INDEXES)));
    }

    @Override
    @Override
    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putLongArray(TAG_All_INDEXES, this.all.toLongArray());
        nbt.putLongArray(TAG_REMAINING_INDEXES, this.remaining.toLongArray());
        return nbt;
    }

    public void addIndex(long pos) {
        this.all.add(pos);
        this.remaining.add(pos);
        this.setDirty();
    }

    public boolean hasStartIndex(long pos) {
        return this.all.contains(pos);
    }

    public boolean hasUnhandledIndex(long pos) {
        return this.remaining.contains(pos);
    }

    public void removeIndex(long pos) {
        if (this.remaining.remove(pos)) {
            this.setDirty();
        }
    }

    public LongSet getAll() {
        return this.all;
    }
}

