/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class WoodlandMansionPieces {
    public static void generateMansion(StructureTemplateManager manager, BlockPos pos, Rotation rotation, List<WoodlandMansionPiece> pieces, RandomSource random) {
        MansionGrid mansionGrid = new MansionGrid(random);
        MansionPiecePlacer mansionPiecePlacer = new MansionPiecePlacer(manager, random);
        mansionPiecePlacer.createMansion(pos, rotation, pieces, mansionGrid);
    }

    static class MansionGrid {
        private static final int DEFAULT_SIZE = 11;
        private static final int CLEAR = 0;
        private static final int CORRIDOR = 1;
        private static final int ROOM = 2;
        private static final int START_ROOM = 3;
        private static final int TEST_ROOM = 4;
        private static final int BLOCKED = 5;
        private static final int ROOM_1x1 = 65536;
        private static final int ROOM_1x2 = 131072;
        private static final int ROOM_2x2 = 262144;
        private static final int ROOM_ORIGIN_FLAG = 0x100000;
        private static final int ROOM_DOOR_FLAG = 0x200000;
        private static final int ROOM_STAIRS_FLAG = 0x400000;
        private static final int ROOM_CORRIDOR_FLAG = 0x800000;
        private static final int ROOM_TYPE_MASK = 983040;
        private static final int ROOM_ID_MASK = 65535;
        private final RandomSource random;
        final SimpleGrid baseGrid;
        final SimpleGrid thirdFloorGrid;
        final SimpleGrid[] floorRooms;
        final int entranceX;
        final int entranceY;

        public MansionGrid(RandomSource random) {
            this.random = random;
            int i = 11;
            this.entranceX = 7;
            this.entranceY = 4;
            this.baseGrid = new SimpleGrid(11, 11, 5);
            this.baseGrid.set(this.entranceX, this.entranceY, this.entranceX + 1, this.entranceY + 1, 3);
            this.baseGrid.set(this.entranceX - 1, this.entranceY, this.entranceX - 1, this.entranceY + 1, 2);
            this.baseGrid.set(this.entranceX + 2, this.entranceY - 2, this.entranceX + 3, this.entranceY + 3, 5);
            this.baseGrid.set(this.entranceX + 1, this.entranceY - 2, this.entranceX + 1, this.entranceY - 1, 1);
            this.baseGrid.set(this.entranceX + 1, this.entranceY + 2, this.entranceX + 1, this.entranceY + 3, 1);
            this.baseGrid.set(this.entranceX - 1, this.entranceY - 1, 1);
            this.baseGrid.set(this.entranceX - 1, this.entranceY + 2, 1);
            this.baseGrid.set(0, 0, 11, 1, 5);
            this.baseGrid.set(0, 9, 11, 11, 5);
            this.recursiveCorridor(this.baseGrid, this.entranceX, this.entranceY - 2, Direction.WEST, 6);
            this.recursiveCorridor(this.baseGrid, this.entranceX, this.entranceY + 3, Direction.WEST, 6);
            this.recursiveCorridor(this.baseGrid, this.entranceX - 2, this.entranceY - 1, Direction.WEST, 3);
            this.recursiveCorridor(this.baseGrid, this.entranceX - 2, this.entranceY + 2, Direction.WEST, 3);
            while (this.cleanEdges(this.baseGrid)) {
            }
            this.floorRooms = new SimpleGrid[3];
            this.floorRooms[0] = new SimpleGrid(11, 11, 5);
            this.floorRooms[1] = new SimpleGrid(11, 11, 5);
            this.floorRooms[2] = new SimpleGrid(11, 11, 5);
            this.identifyRooms(this.baseGrid, this.floorRooms[0]);
            this.identifyRooms(this.baseGrid, this.floorRooms[1]);
            this.floorRooms[0].set(this.entranceX + 1, this.entranceY, this.entranceX + 1, this.entranceY + 1, 0x800000);
            this.floorRooms[1].set(this.entranceX + 1, this.entranceY, this.entranceX + 1, this.entranceY + 1, 0x800000);
            this.thirdFloorGrid = new SimpleGrid(this.baseGrid.width, this.baseGrid.height, 5);
            this.setupThirdFloor();
            this.identifyRooms(this.thirdFloorGrid, this.floorRooms[2]);
        }

        public static boolean isHouse(SimpleGrid layout, int i, int j) {
            int k = layout.get(i, j);
            return k == 1 || k == 2 || k == 3 || k == 4;
        }

        public boolean isRoomId(SimpleGrid layout, int i, int j, int floor, int roomId) {
            return (this.floorRooms[floor].get(i, j) & 0xFFFF) == roomId;
        }

        @Nullable
        public Direction get1x2RoomDirection(SimpleGrid layout, int i, int j, int floor, int roomId) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!this.isRoomId(layout, i + direction.getStepX(), j + direction.getStepZ(), floor, roomId)) continue;
                return direction;
            }
            return null;
        }

        private void recursiveCorridor(SimpleGrid layout, int i, int j, Direction direction, int length) {
            if (length <= 0) {
                return;
            }
            layout.set(i, j, 1);
            layout.setif(i + direction.getStepX(), j + direction.getStepZ(), 0, 1);
            for (int k = 0; k < 8; ++k) {
                Direction direction2 = Direction.from2DDataValue(this.random.nextInt(4));
                if (direction2 == direction.getOpposite() || direction2 == Direction.EAST && this.random.nextBoolean()) continue;
                int l = i + direction.getStepX();
                int m = j + direction.getStepZ();
                if (layout.get(l + direction2.getStepX(), m + direction2.getStepZ()) != 0 || layout.get(l + direction2.getStepX() * 2, m + direction2.getStepZ() * 2) != 0) continue;
                this.recursiveCorridor(layout, i + direction.getStepX() + direction2.getStepX(), j + direction.getStepZ() + direction2.getStepZ(), direction2, length - 1);
                break;
            }
            Direction direction3 = direction.getClockWise();
            Direction direction4 = direction.getCounterClockWise();
            layout.setif(i + direction3.getStepX(), j + direction3.getStepZ(), 0, 2);
            layout.setif(i + direction4.getStepX(), j + direction4.getStepZ(), 0, 2);
            layout.setif(i + direction.getStepX() + direction3.getStepX(), j + direction.getStepZ() + direction3.getStepZ(), 0, 2);
            layout.setif(i + direction.getStepX() + direction4.getStepX(), j + direction.getStepZ() + direction4.getStepZ(), 0, 2);
            layout.setif(i + direction.getStepX() * 2, j + direction.getStepZ() * 2, 0, 2);
            layout.setif(i + direction3.getStepX() * 2, j + direction3.getStepZ() * 2, 0, 2);
            layout.setif(i + direction4.getStepX() * 2, j + direction4.getStepZ() * 2, 0, 2);
        }

        private boolean cleanEdges(SimpleGrid layout) {
            boolean bl = false;
            for (int i = 0; i < layout.height; ++i) {
                for (int j = 0; j < layout.width; ++j) {
                    if (layout.get(j, i) != 0) continue;
                    int k = 0;
                    k += MansionGrid.isHouse(layout, j + 1, i) ? 1 : 0;
                    k += MansionGrid.isHouse(layout, j - 1, i) ? 1 : 0;
                    k += MansionGrid.isHouse(layout, j, i + 1) ? 1 : 0;
                    if ((k += MansionGrid.isHouse(layout, j, i - 1) ? 1 : 0) >= 3) {
                        layout.set(j, i, 2);
                        bl = true;
                        continue;
                    }
                    if (k != 2) continue;
                    int l = 0;
                    l += MansionGrid.isHouse(layout, j + 1, i + 1) ? 1 : 0;
                    l += MansionGrid.isHouse(layout, j - 1, i + 1) ? 1 : 0;
                    l += MansionGrid.isHouse(layout, j + 1, i - 1) ? 1 : 0;
                    if ((l += MansionGrid.isHouse(layout, j - 1, i - 1) ? 1 : 0) > 1) continue;
                    layout.set(j, i, 2);
                    bl = true;
                }
            }
            return bl;
        }

        private void setupThirdFloor() {
            ArrayList list = Lists.newArrayList();
            SimpleGrid simpleGrid = this.floorRooms[1];
            for (int i = 0; i < this.thirdFloorGrid.height; ++i) {
                for (int j = 0; j < this.thirdFloorGrid.width; ++j) {
                    int k = simpleGrid.get(j, i);
                    int l = k & 0xF0000;
                    if (l != 131072 || (k & 0x200000) != 0x200000) continue;
                    list.add(new Tuple<Integer, Integer>(j, i));
                }
            }
            if (list.isEmpty()) {
                this.thirdFloorGrid.set(0, 0, this.thirdFloorGrid.width, this.thirdFloorGrid.height, 5);
                return;
            }
            Tuple tuple = (Tuple)list.get(this.random.nextInt(list.size()));
            int m = simpleGrid.get((Integer)tuple.getA(), (Integer)tuple.getB());
            simpleGrid.set((Integer)tuple.getA(), (Integer)tuple.getB(), m | 0x400000);
            Direction direction = this.get1x2RoomDirection(this.baseGrid, (Integer)tuple.getA(), (Integer)tuple.getB(), 1, m & 0xFFFF);
            int n = (Integer)tuple.getA() + direction.getStepX();
            int o = (Integer)tuple.getB() + direction.getStepZ();
            for (int p = 0; p < this.thirdFloorGrid.height; ++p) {
                for (int q = 0; q < this.thirdFloorGrid.width; ++q) {
                    if (!MansionGrid.isHouse(this.baseGrid, q, p)) {
                        this.thirdFloorGrid.set(q, p, 5);
                        continue;
                    }
                    if (q == (Integer)tuple.getA() && p == (Integer)tuple.getB()) {
                        this.thirdFloorGrid.set(q, p, 3);
                        continue;
                    }
                    if (q != n || p != o) continue;
                    this.thirdFloorGrid.set(q, p, 3);
                    this.floorRooms[2].set(q, p, 0x800000);
                }
            }
            ArrayList list2 = Lists.newArrayList();
            for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                if (this.thirdFloorGrid.get(n + direction2.getStepX(), o + direction2.getStepZ()) != 0) continue;
                list2.add(direction2);
            }
            if (list2.isEmpty()) {
                this.thirdFloorGrid.set(0, 0, this.thirdFloorGrid.width, this.thirdFloorGrid.height, 5);
                simpleGrid.set((Integer)tuple.getA(), (Integer)tuple.getB(), m);
                return;
            }
            Direction direction3 = (Direction)list2.get(this.random.nextInt(list2.size()));
            this.recursiveCorridor(this.thirdFloorGrid, n + direction3.getStepX(), o + direction3.getStepZ(), direction3, 4);
            while (this.cleanEdges(this.thirdFloorGrid)) {
            }
        }

        private void identifyRooms(SimpleGrid layout, SimpleGrid roomFlags) {
            ObjectArrayList objectArrayList = new ObjectArrayList();
            for (int i = 0; i < layout.height; ++i) {
                for (int j = 0; j < layout.width; ++j) {
                    if (layout.get(j, i) != 2) continue;
                    objectArrayList.add(new Tuple<Integer, Integer>(j, i));
                }
            }
            Util.shuffle(objectArrayList, this.random);
            int k = 10;
            for (Tuple tuple : objectArrayList) {
                int m;
                int l = (Integer)tuple.getA();
                if (roomFlags.get(l, m = ((Integer)tuple.getB()).intValue()) != 0) continue;
                int n = l;
                int o = l;
                int p = m;
                int q = m;
                int r = 65536;
                if (roomFlags.get(l + 1, m) == 0 && roomFlags.get(l, m + 1) == 0 && roomFlags.get(l + 1, m + 1) == 0 && layout.get(l + 1, m) == 2 && layout.get(l, m + 1) == 2 && layout.get(l + 1, m + 1) == 2) {
                    ++o;
                    ++q;
                    r = 262144;
                } else if (roomFlags.get(l - 1, m) == 0 && roomFlags.get(l, m + 1) == 0 && roomFlags.get(l - 1, m + 1) == 0 && layout.get(l - 1, m) == 2 && layout.get(l, m + 1) == 2 && layout.get(l - 1, m + 1) == 2) {
                    --n;
                    ++q;
                    r = 262144;
                } else if (roomFlags.get(l - 1, m) == 0 && roomFlags.get(l, m - 1) == 0 && roomFlags.get(l - 1, m - 1) == 0 && layout.get(l - 1, m) == 2 && layout.get(l, m - 1) == 2 && layout.get(l - 1, m - 1) == 2) {
                    --n;
                    --p;
                    r = 262144;
                } else if (roomFlags.get(l + 1, m) == 0 && layout.get(l + 1, m) == 2) {
                    ++o;
                    r = 131072;
                } else if (roomFlags.get(l, m + 1) == 0 && layout.get(l, m + 1) == 2) {
                    ++q;
                    r = 131072;
                } else if (roomFlags.get(l - 1, m) == 0 && layout.get(l - 1, m) == 2) {
                    --n;
                    r = 131072;
                } else if (roomFlags.get(l, m - 1) == 0 && layout.get(l, m - 1) == 2) {
                    --p;
                    r = 131072;
                }
                int s = this.random.nextBoolean() ? n : o;
                int t = this.random.nextBoolean() ? p : q;
                int u = 0x200000;
                if (!layout.edgesTo(s, t, 1)) {
                    s = s == n ? o : n;
                    int n2 = t = t == p ? q : p;
                    if (!layout.edgesTo(s, t, 1)) {
                        int n3 = t = t == p ? q : p;
                        if (!layout.edgesTo(s, t, 1)) {
                            s = s == n ? o : n;
                            int n4 = t = t == p ? q : p;
                            if (!layout.edgesTo(s, t, 1)) {
                                u = 0;
                                s = n;
                                t = p;
                            }
                        }
                    }
                }
                for (int v = p; v <= q; ++v) {
                    for (int w = n; w <= o; ++w) {
                        if (w == s && v == t) {
                            roomFlags.set(w, v, 0x100000 | u | r | k);
                            continue;
                        }
                        roomFlags.set(w, v, r | k);
                    }
                }
                ++k;
            }
        }
    }

    static class MansionPiecePlacer {
        private final StructureTemplateManager structureTemplateManager;
        private final RandomSource random;
        private int startX;
        private int startY;

        public MansionPiecePlacer(StructureTemplateManager manager, RandomSource random) {
            this.structureTemplateManager = manager;
            this.random = random;
        }

        public void createMansion(BlockPos pos, Rotation rotation, List<WoodlandMansionPiece> pieces, MansionGrid parameters) {
            PlacementData placementData = new PlacementData();
            placementData.position = pos;
            placementData.rotation = rotation;
            placementData.wallType = "wall_flat";
            PlacementData placementData2 = new PlacementData();
            this.entrance(pieces, placementData);
            placementData2.position = placementData.position.above(8);
            placementData2.rotation = placementData.rotation;
            placementData2.wallType = "wall_window";
            if (!pieces.isEmpty()) {
                // empty if block
            }
            SimpleGrid simpleGrid = parameters.baseGrid;
            SimpleGrid simpleGrid2 = parameters.thirdFloorGrid;
            this.startX = parameters.entranceX + 1;
            this.startY = parameters.entranceY + 1;
            int i = parameters.entranceX + 1;
            int j = parameters.entranceY;
            this.traverseOuterWalls(pieces, placementData, simpleGrid, Direction.SOUTH, this.startX, this.startY, i, j);
            this.traverseOuterWalls(pieces, placementData2, simpleGrid, Direction.SOUTH, this.startX, this.startY, i, j);
            PlacementData placementData3 = new PlacementData();
            placementData3.position = placementData.position.above(19);
            placementData3.rotation = placementData.rotation;
            placementData3.wallType = "wall_window";
            boolean bl = false;
            for (int k = 0; k < simpleGrid2.height && !bl; ++k) {
                for (int l = simpleGrid2.width - 1; l >= 0 && !bl; --l) {
                    if (!MansionGrid.isHouse(simpleGrid2, l, k)) continue;
                    placementData3.position = placementData3.position.relative(rotation.rotate(Direction.SOUTH), 8 + (k - this.startY) * 8);
                    placementData3.position = placementData3.position.relative(rotation.rotate(Direction.EAST), (l - this.startX) * 8);
                    this.traverseWallPiece(pieces, placementData3);
                    this.traverseOuterWalls(pieces, placementData3, simpleGrid2, Direction.SOUTH, l, k, l, k);
                    bl = true;
                }
            }
            this.createRoof(pieces, pos.above(16), rotation, simpleGrid, simpleGrid2);
            this.createRoof(pieces, pos.above(27), rotation, simpleGrid2, null);
            if (!pieces.isEmpty()) {
                // empty if block
            }
            FloorRoomCollection[] floorRoomCollections = new FloorRoomCollection[]{new FirstFloorRoomCollection(), new SecondFloorRoomCollection(), new ThirdFloorRoomCollection()};
            for (int m = 0; m < 3; ++m) {
                BlockPos blockPos = pos.above(8 * m + (m == 2 ? 3 : 0));
                SimpleGrid simpleGrid3 = parameters.floorRooms[m];
                SimpleGrid simpleGrid4 = m == 2 ? simpleGrid2 : simpleGrid;
                String string = m == 0 ? "carpet_south_1" : "carpet_south_2";
                String string2 = m == 0 ? "carpet_west_1" : "carpet_west_2";
                for (int n = 0; n < simpleGrid4.height; ++n) {
                    for (int o = 0; o < simpleGrid4.width; ++o) {
                        if (simpleGrid4.get(o, n) != 1) continue;
                        BlockPos blockPos2 = blockPos.relative(rotation.rotate(Direction.SOUTH), 8 + (n - this.startY) * 8);
                        blockPos2 = blockPos2.relative(rotation.rotate(Direction.EAST), (o - this.startX) * 8);
                        pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "corridor_floor", blockPos2, rotation));
                        if (simpleGrid4.get(o, n - 1) == 1 || (simpleGrid3.get(o, n - 1) & 0x800000) == 0x800000) {
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "carpet_north", blockPos2.relative(rotation.rotate(Direction.EAST), 1).above(), rotation));
                        }
                        if (simpleGrid4.get(o + 1, n) == 1 || (simpleGrid3.get(o + 1, n) & 0x800000) == 0x800000) {
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "carpet_east", blockPos2.relative(rotation.rotate(Direction.SOUTH), 1).relative(rotation.rotate(Direction.EAST), 5).above(), rotation));
                        }
                        if (simpleGrid4.get(o, n + 1) == 1 || (simpleGrid3.get(o, n + 1) & 0x800000) == 0x800000) {
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, string, blockPos2.relative(rotation.rotate(Direction.SOUTH), 5).relative(rotation.rotate(Direction.WEST), 1), rotation));
                        }
                        if (simpleGrid4.get(o - 1, n) != 1 && (simpleGrid3.get(o - 1, n) & 0x800000) != 0x800000) continue;
                        pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, string2, blockPos2.relative(rotation.rotate(Direction.WEST), 1).relative(rotation.rotate(Direction.NORTH), 1), rotation));
                    }
                }
                String string3 = m == 0 ? "indoors_wall_1" : "indoors_wall_2";
                String string4 = m == 0 ? "indoors_door_1" : "indoors_door_2";
                ArrayList list = Lists.newArrayList();
                for (int p = 0; p < simpleGrid4.height; ++p) {
                    for (int q = 0; q < simpleGrid4.width; ++q) {
                        boolean bl2;
                        boolean bl3 = bl2 = m == 2 && simpleGrid4.get(q, p) == 3;
                        if (simpleGrid4.get(q, p) != 2 && !bl2) continue;
                        int r = simpleGrid3.get(q, p);
                        int s = r & 0xF0000;
                        int t = r & 0xFFFF;
                        bl2 = bl2 && (r & 0x800000) == 0x800000;
                        list.clear();
                        if ((r & 0x200000) == 0x200000) {
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                if (simpleGrid4.get(q + direction.getStepX(), p + direction.getStepZ()) != 1) continue;
                                list.add(direction);
                            }
                        }
                        Direction direction2 = null;
                        if (!list.isEmpty()) {
                            direction2 = (Direction)list.get(this.random.nextInt(list.size()));
                        } else if ((r & 0x100000) == 0x100000) {
                            direction2 = Direction.UP;
                        }
                        BlockPos blockPos3 = blockPos.relative(rotation.rotate(Direction.SOUTH), 8 + (p - this.startY) * 8);
                        blockPos3 = blockPos3.relative(rotation.rotate(Direction.EAST), -1 + (q - this.startX) * 8);
                        if (MansionGrid.isHouse(simpleGrid4, q - 1, p) && !parameters.isRoomId(simpleGrid4, q - 1, p, m, t)) {
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, direction2 == Direction.WEST ? string4 : string3, blockPos3, rotation));
                        }
                        if (simpleGrid4.get(q + 1, p) == 1 && !bl2) {
                            BlockPos blockPos4 = blockPos3.relative(rotation.rotate(Direction.EAST), 8);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, direction2 == Direction.EAST ? string4 : string3, blockPos4, rotation));
                        }
                        if (MansionGrid.isHouse(simpleGrid4, q, p + 1) && !parameters.isRoomId(simpleGrid4, q, p + 1, m, t)) {
                            BlockPos blockPos5 = blockPos3.relative(rotation.rotate(Direction.SOUTH), 7);
                            blockPos5 = blockPos5.relative(rotation.rotate(Direction.EAST), 7);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, direction2 == Direction.SOUTH ? string4 : string3, blockPos5, rotation.getRotated(Rotation.CLOCKWISE_90)));
                        }
                        if (simpleGrid4.get(q, p - 1) == 1 && !bl2) {
                            BlockPos blockPos6 = blockPos3.relative(rotation.rotate(Direction.NORTH), 1);
                            blockPos6 = blockPos6.relative(rotation.rotate(Direction.EAST), 7);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, direction2 == Direction.NORTH ? string4 : string3, blockPos6, rotation.getRotated(Rotation.CLOCKWISE_90)));
                        }
                        if (s == 65536) {
                            this.addRoom1x1(pieces, blockPos3, rotation, direction2, floorRoomCollections[m]);
                            continue;
                        }
                        if (s == 131072 && direction2 != null) {
                            Direction direction3 = parameters.get1x2RoomDirection(simpleGrid4, q, p, m, t);
                            boolean bl32 = (r & 0x400000) == 0x400000;
                            this.addRoom1x2(pieces, blockPos3, rotation, direction3, direction2, floorRoomCollections[m], bl32);
                            continue;
                        }
                        if (s == 262144 && direction2 != null && direction2 != Direction.UP) {
                            Direction direction4 = direction2.getClockWise();
                            if (!parameters.isRoomId(simpleGrid4, q + direction4.getStepX(), p + direction4.getStepZ(), m, t)) {
                                direction4 = direction4.getOpposite();
                            }
                            this.addRoom2x2(pieces, blockPos3, rotation, direction4, direction2, floorRoomCollections[m]);
                            continue;
                        }
                        if (s != 262144 || direction2 != Direction.UP) continue;
                        this.addRoom2x2Secret(pieces, blockPos3, rotation, floorRoomCollections[m]);
                    }
                }
            }
        }

        private void traverseOuterWalls(List<WoodlandMansionPiece> pieces, PlacementData wallPiece, SimpleGrid layout, Direction direction, int startI, int startJ, int endI, int endJ) {
            int i = startI;
            int j = startJ;
            Direction direction2 = direction;
            do {
                if (!MansionGrid.isHouse(layout, i + direction.getStepX(), j + direction.getStepZ())) {
                    this.traverseTurn(pieces, wallPiece);
                    direction = direction.getClockWise();
                    if (i == endI && j == endJ && direction2 == direction) continue;
                    this.traverseWallPiece(pieces, wallPiece);
                    continue;
                }
                if (MansionGrid.isHouse(layout, i + direction.getStepX(), j + direction.getStepZ()) && MansionGrid.isHouse(layout, i + direction.getStepX() + direction.getCounterClockWise().getStepX(), j + direction.getStepZ() + direction.getCounterClockWise().getStepZ())) {
                    this.traverseInnerTurn(pieces, wallPiece);
                    i += direction.getStepX();
                    j += direction.getStepZ();
                    direction = direction.getCounterClockWise();
                    continue;
                }
                if ((i += direction.getStepX()) == endI && (j += direction.getStepZ()) == endJ && direction2 == direction) continue;
                this.traverseWallPiece(pieces, wallPiece);
            } while (i != endI || j != endJ || direction2 != direction);
        }

        private void createRoof(List<WoodlandMansionPiece> pieces, BlockPos pos, Rotation rotation, SimpleGrid layout, @Nullable SimpleGrid nextFloorLayout) {
            for (int i = 0; i < layout.height; ++i) {
                for (int j = 0; j < layout.width; ++j) {
                    boolean bl;
                    BlockPos blockPos = pos;
                    blockPos = blockPos.relative(rotation.rotate(Direction.SOUTH), 8 + (i - this.startY) * 8);
                    blockPos = blockPos.relative(rotation.rotate(Direction.EAST), (j - this.startX) * 8);
                    boolean bl2 = bl = nextFloorLayout != null && MansionGrid.isHouse(nextFloorLayout, j, i);
                    if (!MansionGrid.isHouse(layout, j, i) || bl) continue;
                    pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof", blockPos.above(3), rotation));
                    if (!MansionGrid.isHouse(layout, j + 1, i)) {
                        BlockPos blockPos2 = blockPos.relative(rotation.rotate(Direction.EAST), 6);
                        pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_front", blockPos2, rotation));
                    }
                    if (!MansionGrid.isHouse(layout, j - 1, i)) {
                        BlockPos blockPos3 = blockPos.relative(rotation.rotate(Direction.EAST), 0);
                        blockPos3 = blockPos3.relative(rotation.rotate(Direction.SOUTH), 7);
                        pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_front", blockPos3, rotation.getRotated(Rotation.CLOCKWISE_180)));
                    }
                    if (!MansionGrid.isHouse(layout, j, i - 1)) {
                        BlockPos blockPos4 = blockPos.relative(rotation.rotate(Direction.WEST), 1);
                        pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_front", blockPos4, rotation.getRotated(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (MansionGrid.isHouse(layout, j, i + 1)) continue;
                    BlockPos blockPos5 = blockPos.relative(rotation.rotate(Direction.EAST), 6);
                    blockPos5 = blockPos5.relative(rotation.rotate(Direction.SOUTH), 6);
                    pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_front", blockPos5, rotation.getRotated(Rotation.CLOCKWISE_90)));
                }
            }
            if (nextFloorLayout != null) {
                for (int k = 0; k < layout.height; ++k) {
                    for (int l = 0; l < layout.width; ++l) {
                        BlockPos blockPos6 = pos;
                        blockPos6 = blockPos6.relative(rotation.rotate(Direction.SOUTH), 8 + (k - this.startY) * 8);
                        blockPos6 = blockPos6.relative(rotation.rotate(Direction.EAST), (l - this.startX) * 8);
                        boolean bl2 = MansionGrid.isHouse(nextFloorLayout, l, k);
                        if (!MansionGrid.isHouse(layout, l, k) || !bl2) continue;
                        if (!MansionGrid.isHouse(layout, l + 1, k)) {
                            BlockPos blockPos7 = blockPos6.relative(rotation.rotate(Direction.EAST), 7);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "small_wall", blockPos7, rotation));
                        }
                        if (!MansionGrid.isHouse(layout, l - 1, k)) {
                            BlockPos blockPos8 = blockPos6.relative(rotation.rotate(Direction.WEST), 1);
                            blockPos8 = blockPos8.relative(rotation.rotate(Direction.SOUTH), 6);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "small_wall", blockPos8, rotation.getRotated(Rotation.CLOCKWISE_180)));
                        }
                        if (!MansionGrid.isHouse(layout, l, k - 1)) {
                            BlockPos blockPos9 = blockPos6.relative(rotation.rotate(Direction.WEST), 0);
                            blockPos9 = blockPos9.relative(rotation.rotate(Direction.NORTH), 1);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "small_wall", blockPos9, rotation.getRotated(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (!MansionGrid.isHouse(layout, l, k + 1)) {
                            BlockPos blockPos10 = blockPos6.relative(rotation.rotate(Direction.EAST), 6);
                            blockPos10 = blockPos10.relative(rotation.rotate(Direction.SOUTH), 7);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "small_wall", blockPos10, rotation.getRotated(Rotation.CLOCKWISE_90)));
                        }
                        if (!MansionGrid.isHouse(layout, l + 1, k)) {
                            if (!MansionGrid.isHouse(layout, l, k - 1)) {
                                BlockPos blockPos11 = blockPos6.relative(rotation.rotate(Direction.EAST), 7);
                                blockPos11 = blockPos11.relative(rotation.rotate(Direction.NORTH), 2);
                                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "small_wall_corner", blockPos11, rotation));
                            }
                            if (!MansionGrid.isHouse(layout, l, k + 1)) {
                                BlockPos blockPos12 = blockPos6.relative(rotation.rotate(Direction.EAST), 8);
                                blockPos12 = blockPos12.relative(rotation.rotate(Direction.SOUTH), 7);
                                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "small_wall_corner", blockPos12, rotation.getRotated(Rotation.CLOCKWISE_90)));
                            }
                        }
                        if (MansionGrid.isHouse(layout, l - 1, k)) continue;
                        if (!MansionGrid.isHouse(layout, l, k - 1)) {
                            BlockPos blockPos13 = blockPos6.relative(rotation.rotate(Direction.WEST), 2);
                            blockPos13 = blockPos13.relative(rotation.rotate(Direction.NORTH), 1);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "small_wall_corner", blockPos13, rotation.getRotated(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (MansionGrid.isHouse(layout, l, k + 1)) continue;
                        BlockPos blockPos14 = blockPos6.relative(rotation.rotate(Direction.WEST), 1);
                        blockPos14 = blockPos14.relative(rotation.rotate(Direction.SOUTH), 8);
                        pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "small_wall_corner", blockPos14, rotation.getRotated(Rotation.CLOCKWISE_180)));
                    }
                }
            }
            for (int m = 0; m < layout.height; ++m) {
                for (int n = 0; n < layout.width; ++n) {
                    boolean bl3;
                    BlockPos blockPos15 = pos;
                    blockPos15 = blockPos15.relative(rotation.rotate(Direction.SOUTH), 8 + (m - this.startY) * 8);
                    blockPos15 = blockPos15.relative(rotation.rotate(Direction.EAST), (n - this.startX) * 8);
                    boolean bl = bl3 = nextFloorLayout != null && MansionGrid.isHouse(nextFloorLayout, n, m);
                    if (!MansionGrid.isHouse(layout, n, m) || bl3) continue;
                    if (!MansionGrid.isHouse(layout, n + 1, m)) {
                        BlockPos blockPos16 = blockPos15.relative(rotation.rotate(Direction.EAST), 6);
                        if (!MansionGrid.isHouse(layout, n, m + 1)) {
                            BlockPos blockPos17 = blockPos16.relative(rotation.rotate(Direction.SOUTH), 6);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_corner", blockPos17, rotation));
                        } else if (MansionGrid.isHouse(layout, n + 1, m + 1)) {
                            BlockPos blockPos18 = blockPos16.relative(rotation.rotate(Direction.SOUTH), 5);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_inner_corner", blockPos18, rotation));
                        }
                        if (!MansionGrid.isHouse(layout, n, m - 1)) {
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_corner", blockPos16, rotation.getRotated(Rotation.COUNTERCLOCKWISE_90)));
                        } else if (MansionGrid.isHouse(layout, n + 1, m - 1)) {
                            BlockPos blockPos19 = blockPos15.relative(rotation.rotate(Direction.EAST), 9);
                            blockPos19 = blockPos19.relative(rotation.rotate(Direction.NORTH), 2);
                            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_inner_corner", blockPos19, rotation.getRotated(Rotation.CLOCKWISE_90)));
                        }
                    }
                    if (MansionGrid.isHouse(layout, n - 1, m)) continue;
                    BlockPos blockPos20 = blockPos15.relative(rotation.rotate(Direction.EAST), 0);
                    blockPos20 = blockPos20.relative(rotation.rotate(Direction.SOUTH), 0);
                    if (!MansionGrid.isHouse(layout, n, m + 1)) {
                        BlockPos blockPos21 = blockPos20.relative(rotation.rotate(Direction.SOUTH), 6);
                        pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_corner", blockPos21, rotation.getRotated(Rotation.CLOCKWISE_90)));
                    } else if (MansionGrid.isHouse(layout, n - 1, m + 1)) {
                        BlockPos blockPos22 = blockPos20.relative(rotation.rotate(Direction.SOUTH), 8);
                        blockPos22 = blockPos22.relative(rotation.rotate(Direction.WEST), 3);
                        pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_inner_corner", blockPos22, rotation.getRotated(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (!MansionGrid.isHouse(layout, n, m - 1)) {
                        pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_corner", blockPos20, rotation.getRotated(Rotation.CLOCKWISE_180)));
                        continue;
                    }
                    if (!MansionGrid.isHouse(layout, n - 1, m - 1)) continue;
                    BlockPos blockPos23 = blockPos20.relative(rotation.rotate(Direction.SOUTH), 1);
                    pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "roof_inner_corner", blockPos23, rotation.getRotated(Rotation.CLOCKWISE_180)));
                }
            }
        }

        private void entrance(List<WoodlandMansionPiece> pieces, PlacementData wallPiece) {
            Direction direction = wallPiece.rotation.rotate(Direction.WEST);
            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "entrance", wallPiece.position.relative(direction, 9), wallPiece.rotation));
            wallPiece.position = wallPiece.position.relative(wallPiece.rotation.rotate(Direction.SOUTH), 16);
        }

        private void traverseWallPiece(List<WoodlandMansionPiece> pieces, PlacementData wallPiece) {
            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, wallPiece.wallType, wallPiece.position.relative(wallPiece.rotation.rotate(Direction.EAST), 7), wallPiece.rotation));
            wallPiece.position = wallPiece.position.relative(wallPiece.rotation.rotate(Direction.SOUTH), 8);
        }

        private void traverseTurn(List<WoodlandMansionPiece> pieces, PlacementData wallPiece) {
            wallPiece.position = wallPiece.position.relative(wallPiece.rotation.rotate(Direction.SOUTH), -1);
            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, "wall_corner", wallPiece.position, wallPiece.rotation));
            wallPiece.position = wallPiece.position.relative(wallPiece.rotation.rotate(Direction.SOUTH), -7);
            wallPiece.position = wallPiece.position.relative(wallPiece.rotation.rotate(Direction.WEST), -6);
            wallPiece.rotation = wallPiece.rotation.getRotated(Rotation.CLOCKWISE_90);
        }

        private void traverseInnerTurn(List<WoodlandMansionPiece> pieces, PlacementData wallPiece) {
            wallPiece.position = wallPiece.position.relative(wallPiece.rotation.rotate(Direction.SOUTH), 6);
            wallPiece.position = wallPiece.position.relative(wallPiece.rotation.rotate(Direction.EAST), 8);
            wallPiece.rotation = wallPiece.rotation.getRotated(Rotation.COUNTERCLOCKWISE_90);
        }

        private void addRoom1x1(List<WoodlandMansionPiece> pieces, BlockPos pos, Rotation rotation, Direction direction, FloorRoomCollection pool) {
            Rotation rotation2 = Rotation.NONE;
            String string = pool.get1x1(this.random);
            if (direction != Direction.EAST) {
                if (direction == Direction.NORTH) {
                    rotation2 = rotation2.getRotated(Rotation.COUNTERCLOCKWISE_90);
                } else if (direction == Direction.WEST) {
                    rotation2 = rotation2.getRotated(Rotation.CLOCKWISE_180);
                } else if (direction == Direction.SOUTH) {
                    rotation2 = rotation2.getRotated(Rotation.CLOCKWISE_90);
                } else {
                    string = pool.get1x1Secret(this.random);
                }
            }
            BlockPos blockPos = StructureTemplate.getZeroPositionWithTransform(new BlockPos(1, 0, 0), Mirror.NONE, rotation2, 7, 7);
            rotation2 = rotation2.getRotated(rotation);
            blockPos = blockPos.rotate(rotation);
            BlockPos blockPos2 = pos.offset(blockPos.getX(), 0, blockPos.getZ());
            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, string, blockPos2, rotation2));
        }

        private void addRoom1x2(List<WoodlandMansionPiece> pieces, BlockPos pos, Rotation rotation, Direction connectedRoomDirection, Direction entranceDirection, FloorRoomCollection pool, boolean staircase) {
            if (entranceDirection == Direction.EAST && connectedRoomDirection == Direction.SOUTH) {
                BlockPos blockPos = pos.relative(rotation.rotate(Direction.EAST), 1);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2SideEntrance(this.random, staircase), blockPos, rotation));
            } else if (entranceDirection == Direction.EAST && connectedRoomDirection == Direction.NORTH) {
                BlockPos blockPos2 = pos.relative(rotation.rotate(Direction.EAST), 1);
                blockPos2 = blockPos2.relative(rotation.rotate(Direction.SOUTH), 6);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2SideEntrance(this.random, staircase), blockPos2, rotation, Mirror.LEFT_RIGHT));
            } else if (entranceDirection == Direction.WEST && connectedRoomDirection == Direction.NORTH) {
                BlockPos blockPos3 = pos.relative(rotation.rotate(Direction.EAST), 7);
                blockPos3 = blockPos3.relative(rotation.rotate(Direction.SOUTH), 6);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2SideEntrance(this.random, staircase), blockPos3, rotation.getRotated(Rotation.CLOCKWISE_180)));
            } else if (entranceDirection == Direction.WEST && connectedRoomDirection == Direction.SOUTH) {
                BlockPos blockPos4 = pos.relative(rotation.rotate(Direction.EAST), 7);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2SideEntrance(this.random, staircase), blockPos4, rotation, Mirror.FRONT_BACK));
            } else if (entranceDirection == Direction.SOUTH && connectedRoomDirection == Direction.EAST) {
                BlockPos blockPos5 = pos.relative(rotation.rotate(Direction.EAST), 1);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2SideEntrance(this.random, staircase), blockPos5, rotation.getRotated(Rotation.CLOCKWISE_90), Mirror.LEFT_RIGHT));
            } else if (entranceDirection == Direction.SOUTH && connectedRoomDirection == Direction.WEST) {
                BlockPos blockPos6 = pos.relative(rotation.rotate(Direction.EAST), 7);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2SideEntrance(this.random, staircase), blockPos6, rotation.getRotated(Rotation.CLOCKWISE_90)));
            } else if (entranceDirection == Direction.NORTH && connectedRoomDirection == Direction.WEST) {
                BlockPos blockPos7 = pos.relative(rotation.rotate(Direction.EAST), 7);
                blockPos7 = blockPos7.relative(rotation.rotate(Direction.SOUTH), 6);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2SideEntrance(this.random, staircase), blockPos7, rotation.getRotated(Rotation.CLOCKWISE_90), Mirror.FRONT_BACK));
            } else if (entranceDirection == Direction.NORTH && connectedRoomDirection == Direction.EAST) {
                BlockPos blockPos8 = pos.relative(rotation.rotate(Direction.EAST), 1);
                blockPos8 = blockPos8.relative(rotation.rotate(Direction.SOUTH), 6);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2SideEntrance(this.random, staircase), blockPos8, rotation.getRotated(Rotation.COUNTERCLOCKWISE_90)));
            } else if (entranceDirection == Direction.SOUTH && connectedRoomDirection == Direction.NORTH) {
                BlockPos blockPos9 = pos.relative(rotation.rotate(Direction.EAST), 1);
                blockPos9 = blockPos9.relative(rotation.rotate(Direction.NORTH), 8);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2FrontEntrance(this.random, staircase), blockPos9, rotation));
            } else if (entranceDirection == Direction.NORTH && connectedRoomDirection == Direction.SOUTH) {
                BlockPos blockPos10 = pos.relative(rotation.rotate(Direction.EAST), 7);
                blockPos10 = blockPos10.relative(rotation.rotate(Direction.SOUTH), 14);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2FrontEntrance(this.random, staircase), blockPos10, rotation.getRotated(Rotation.CLOCKWISE_180)));
            } else if (entranceDirection == Direction.WEST && connectedRoomDirection == Direction.EAST) {
                BlockPos blockPos11 = pos.relative(rotation.rotate(Direction.EAST), 15);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2FrontEntrance(this.random, staircase), blockPos11, rotation.getRotated(Rotation.CLOCKWISE_90)));
            } else if (entranceDirection == Direction.EAST && connectedRoomDirection == Direction.WEST) {
                BlockPos blockPos12 = pos.relative(rotation.rotate(Direction.WEST), 7);
                blockPos12 = blockPos12.relative(rotation.rotate(Direction.SOUTH), 6);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2FrontEntrance(this.random, staircase), blockPos12, rotation.getRotated(Rotation.COUNTERCLOCKWISE_90)));
            } else if (entranceDirection == Direction.UP && connectedRoomDirection == Direction.EAST) {
                BlockPos blockPos13 = pos.relative(rotation.rotate(Direction.EAST), 15);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2Secret(this.random), blockPos13, rotation.getRotated(Rotation.CLOCKWISE_90)));
            } else if (entranceDirection == Direction.UP && connectedRoomDirection == Direction.SOUTH) {
                BlockPos blockPos14 = pos.relative(rotation.rotate(Direction.EAST), 1);
                blockPos14 = blockPos14.relative(rotation.rotate(Direction.NORTH), 0);
                pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get1x2Secret(this.random), blockPos14, rotation));
            }
        }

        private void addRoom2x2(List<WoodlandMansionPiece> pieces, BlockPos pos, Rotation rotation, Direction connectedRoomDirection, Direction entranceDirection, FloorRoomCollection pool) {
            int i = 0;
            int j = 0;
            Rotation rotation2 = rotation;
            Mirror mirror = Mirror.NONE;
            if (entranceDirection == Direction.EAST && connectedRoomDirection == Direction.SOUTH) {
                i = -7;
            } else if (entranceDirection == Direction.EAST && connectedRoomDirection == Direction.NORTH) {
                i = -7;
                j = 6;
                mirror = Mirror.LEFT_RIGHT;
            } else if (entranceDirection == Direction.NORTH && connectedRoomDirection == Direction.EAST) {
                i = 1;
                j = 14;
                rotation2 = rotation.getRotated(Rotation.COUNTERCLOCKWISE_90);
            } else if (entranceDirection == Direction.NORTH && connectedRoomDirection == Direction.WEST) {
                i = 7;
                j = 14;
                rotation2 = rotation.getRotated(Rotation.COUNTERCLOCKWISE_90);
                mirror = Mirror.LEFT_RIGHT;
            } else if (entranceDirection == Direction.SOUTH && connectedRoomDirection == Direction.WEST) {
                i = 7;
                j = -8;
                rotation2 = rotation.getRotated(Rotation.CLOCKWISE_90);
            } else if (entranceDirection == Direction.SOUTH && connectedRoomDirection == Direction.EAST) {
                i = 1;
                j = -8;
                rotation2 = rotation.getRotated(Rotation.CLOCKWISE_90);
                mirror = Mirror.LEFT_RIGHT;
            } else if (entranceDirection == Direction.WEST && connectedRoomDirection == Direction.NORTH) {
                i = 15;
                j = 6;
                rotation2 = rotation.getRotated(Rotation.CLOCKWISE_180);
            } else if (entranceDirection == Direction.WEST && connectedRoomDirection == Direction.SOUTH) {
                i = 15;
                mirror = Mirror.FRONT_BACK;
            }
            BlockPos blockPos = pos.relative(rotation.rotate(Direction.EAST), i);
            blockPos = blockPos.relative(rotation.rotate(Direction.SOUTH), j);
            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get2x2(this.random), blockPos, rotation2, mirror));
        }

        private void addRoom2x2Secret(List<WoodlandMansionPiece> pieces, BlockPos pos, Rotation rotation, FloorRoomCollection pool) {
            BlockPos blockPos = pos.relative(rotation.rotate(Direction.EAST), 1);
            pieces.add(new WoodlandMansionPiece(this.structureTemplateManager, pool.get2x2Secret(this.random), blockPos, rotation, Mirror.NONE));
        }
    }

    static class ThirdFloorRoomCollection
    extends SecondFloorRoomCollection {
        ThirdFloorRoomCollection() {
        }
    }

    static class SecondFloorRoomCollection
    extends FloorRoomCollection {
        SecondFloorRoomCollection() {
        }

        @Override
        @Override
        public String get1x1(RandomSource random) {
            return "1x1_b" + (random.nextInt(4) + 1);
        }

        @Override
        @Override
        public String get1x1Secret(RandomSource random) {
            return "1x1_as" + (random.nextInt(4) + 1);
        }

        @Override
        @Override
        public String get1x2SideEntrance(RandomSource random, boolean staircase) {
            if (staircase) {
                return "1x2_c_stairs";
            }
            return "1x2_c" + (random.nextInt(4) + 1);
        }

        @Override
        @Override
        public String get1x2FrontEntrance(RandomSource random, boolean staircase) {
            if (staircase) {
                return "1x2_d_stairs";
            }
            return "1x2_d" + (random.nextInt(5) + 1);
        }

        @Override
        @Override
        public String get1x2Secret(RandomSource random) {
            return "1x2_se" + (random.nextInt(1) + 1);
        }

        @Override
        @Override
        public String get2x2(RandomSource random) {
            return "2x2_b" + (random.nextInt(5) + 1);
        }

        @Override
        @Override
        public String get2x2Secret(RandomSource random) {
            return "2x2_s1";
        }
    }

    static class FirstFloorRoomCollection
    extends FloorRoomCollection {
        FirstFloorRoomCollection() {
        }

        @Override
        @Override
        public String get1x1(RandomSource random) {
            return "1x1_a" + (random.nextInt(5) + 1);
        }

        @Override
        @Override
        public String get1x1Secret(RandomSource random) {
            return "1x1_as" + (random.nextInt(4) + 1);
        }

        @Override
        @Override
        public String get1x2SideEntrance(RandomSource random, boolean staircase) {
            return "1x2_a" + (random.nextInt(9) + 1);
        }

        @Override
        @Override
        public String get1x2FrontEntrance(RandomSource random, boolean staircase) {
            return "1x2_b" + (random.nextInt(5) + 1);
        }

        @Override
        @Override
        public String get1x2Secret(RandomSource random) {
            return "1x2_s" + (random.nextInt(2) + 1);
        }

        @Override
        @Override
        public String get2x2(RandomSource random) {
            return "2x2_a" + (random.nextInt(4) + 1);
        }

        @Override
        @Override
        public String get2x2Secret(RandomSource random) {
            return "2x2_s1";
        }
    }

    static abstract class FloorRoomCollection {
        FloorRoomCollection() {
        }

        public abstract String get1x1(RandomSource var1);

        public abstract String get1x1Secret(RandomSource var1);

        public abstract String get1x2SideEntrance(RandomSource var1, boolean var2);

        public abstract String get1x2FrontEntrance(RandomSource var1, boolean var2);

        public abstract String get1x2Secret(RandomSource var1);

        public abstract String get2x2(RandomSource var1);

        public abstract String get2x2Secret(RandomSource var1);
    }

    static class SimpleGrid {
        private final int[][] grid;
        final int width;
        final int height;
        private final int valueIfOutside;

        public SimpleGrid(int n, int m, int fallback) {
            this.width = n;
            this.height = m;
            this.valueIfOutside = fallback;
            this.grid = new int[n][m];
        }

        public void set(int i, int j, int value) {
            if (i >= 0 && i < this.width && j >= 0 && j < this.height) {
                this.grid[i][j] = value;
            }
        }

        public void set(int i0, int j0, int i1, int j1, int value) {
            for (int i = j0; i <= j1; ++i) {
                for (int j = i0; j <= i1; ++j) {
                    this.set(j, i, value);
                }
            }
        }

        public int get(int i, int j) {
            if (i >= 0 && i < this.width && j >= 0 && j < this.height) {
                return this.grid[i][j];
            }
            return this.valueIfOutside;
        }

        public void setif(int i, int j, int expected, int newValue) {
            if (this.get(i, j) == expected) {
                this.set(i, j, newValue);
            }
        }

        public boolean edgesTo(int i, int j, int value) {
            return this.get(i - 1, j) == value || this.get(i + 1, j) == value || this.get(i, j + 1) == value || this.get(i, j - 1) == value;
        }
    }

    static class PlacementData {
        public Rotation rotation;
        public BlockPos position;
        public String wallType;

        PlacementData() {
        }
    }

    public static class WoodlandMansionPiece
    extends TemplateStructurePiece {
        public WoodlandMansionPiece(StructureTemplateManager manager, String template, BlockPos pos, Rotation rotation) {
            this(manager, template, pos, rotation, Mirror.NONE);
        }

        public WoodlandMansionPiece(StructureTemplateManager manager, String template, BlockPos pos, Rotation rotation, Mirror mirror) {
            super(StructurePieceType.WOODLAND_MANSION_PIECE, 0, manager, WoodlandMansionPiece.makeLocation(template), template, WoodlandMansionPiece.makeSettings(mirror, rotation), pos);
        }

        public WoodlandMansionPiece(StructureTemplateManager manager, CompoundTag nbt) {
            super(StructurePieceType.WOODLAND_MANSION_PIECE, nbt, manager, (ResourceLocation id) -> WoodlandMansionPiece.makeSettings(Mirror.valueOf(nbt.getString("Mi")), Rotation.valueOf(nbt.getString("Rot"))));
        }

        @Override
        @Override
        protected ResourceLocation makeTemplateLocation() {
            return WoodlandMansionPiece.makeLocation(this.templateName);
        }

        private static ResourceLocation makeLocation(String identifier) {
            return ResourceLocation.withDefaultNamespace("woodland_mansion/" + identifier);
        }

        private static StructurePlaceSettings makeSettings(Mirror mirror, Rotation rotation) {
            return new StructurePlaceSettings().setIgnoreEntities(true).setRotation(rotation).setMirror(mirror).addProcessor(BlockIgnoreProcessor.STRUCTURE_BLOCK);
        }

        @Override
        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
            super.addAdditionalSaveData(context, nbt);
            nbt.putString("Rot", this.placeSettings.getRotation().name());
            nbt.putString("Mi", this.placeSettings.getMirror().name());
        }

        @Override
        @Override
        protected void handleDataMarker(String metadata, BlockPos pos, ServerLevelAccessor world, RandomSource random, BoundingBox boundingBox) {
            if (metadata.startsWith("Chest")) {
                Rotation rotation = this.placeSettings.getRotation();
                BlockState blockState = Blocks.CHEST.defaultBlockState();
                if ("ChestWest".equals(metadata)) {
                    blockState = (BlockState)blockState.setValue(ChestBlock.FACING, rotation.rotate(Direction.WEST));
                } else if ("ChestEast".equals(metadata)) {
                    blockState = (BlockState)blockState.setValue(ChestBlock.FACING, rotation.rotate(Direction.EAST));
                } else if ("ChestSouth".equals(metadata)) {
                    blockState = (BlockState)blockState.setValue(ChestBlock.FACING, rotation.rotate(Direction.SOUTH));
                } else if ("ChestNorth".equals(metadata)) {
                    blockState = (BlockState)blockState.setValue(ChestBlock.FACING, rotation.rotate(Direction.NORTH));
                }
                this.createChest(world, boundingBox, random, pos, BuiltInLootTables.WOODLAND_MANSION, blockState);
            } else {
                ArrayList<Mob> list = new ArrayList<Mob>();
                switch (metadata) {
                    case "Mage": {
                        list.add(EntityType.EVOKER.create(world.getLevel(), EntitySpawnReason.STRUCTURE));
                        break;
                    }
                    case "Warrior": {
                        list.add(EntityType.VINDICATOR.create(world.getLevel(), EntitySpawnReason.STRUCTURE));
                        break;
                    }
                    case "Group of Allays": {
                        int i = world.getRandom().nextInt(3) + 1;
                        for (int j = 0; j < i; ++j) {
                            list.add(EntityType.ALLAY.create(world.getLevel(), EntitySpawnReason.STRUCTURE));
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
                for (Mob mob : list) {
                    if (mob == null) continue;
                    mob.setPersistenceRequired();
                    mob.moveTo(pos, 0.0f, 0.0f);
                    mob.finalizeSpawn(world, world.getCurrentDifficultyAt(mob.blockPosition()), EntitySpawnReason.STRUCTURE, null);
                    world.addFreshEntityWithPassengers(mob);
                    world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                }
            }
        }
    }
}

