/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.CraftLootable;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.util.TransformerGeneratorAccess;

public class StructureTemplate {
    public static final String PALETTE_TAG = "palette";
    public static final String PALETTE_LIST_TAG = "palettes";
    public static final String ENTITIES_TAG = "entities";
    public static final String BLOCKS_TAG = "blocks";
    public static final String BLOCK_TAG_POS = "pos";
    public static final String BLOCK_TAG_STATE = "state";
    public static final String BLOCK_TAG_NBT = "nbt";
    public static final String ENTITY_TAG_POS = "pos";
    public static final String ENTITY_TAG_BLOCKPOS = "blockPos";
    public static final String ENTITY_TAG_NBT = "nbt";
    public static final String SIZE_TAG = "size";
    public final List<Palette> palettes = Lists.newArrayList();
    public final List<StructureEntityInfo> entityInfoList = Lists.newArrayList();
    private Vec3i size;
    private String author = "?";
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);

    public StructureTemplate() {
        this.size = Vec3i.ZERO;
    }

    public Vec3i getSize() {
        return this.size;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void fillFromWorld(Level world, BlockPos start, Vec3i dimensions, boolean includeEntities, @Nullable Block ignoredBlock) {
        if (dimensions.getX() >= 1 && dimensions.getY() >= 1 && dimensions.getZ() >= 1) {
            BlockPos blockposition1 = start.offset(dimensions).offset(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockposition2 = new BlockPos(Math.min(start.getX(), blockposition1.getX()), Math.min(start.getY(), blockposition1.getY()), Math.min(start.getZ(), blockposition1.getZ()));
            BlockPos blockposition3 = new BlockPos(Math.max(start.getX(), blockposition1.getX()), Math.max(start.getY(), blockposition1.getY()), Math.max(start.getZ(), blockposition1.getZ()));
            this.size = dimensions;
            for (BlockPos blockposition4 : BlockPos.betweenClosed(blockposition2, blockposition3)) {
                BlockPos blockposition5 = blockposition4.subtract(blockposition2);
                BlockState iblockdata = world.getBlockState(blockposition4);
                if (ignoredBlock != null && iblockdata.is(ignoredBlock)) continue;
                BlockEntity tileentity = world.getBlockEntity(blockposition4);
                StructureBlockInfo definedstructure_blockinfo = tileentity != null ? new StructureBlockInfo(blockposition5, iblockdata, tileentity.saveWithId(world.registryAccess())) : new StructureBlockInfo(blockposition5, iblockdata, null);
                StructureTemplate.addToLists(definedstructure_blockinfo, list, list1, list2);
            }
            List<StructureBlockInfo> list3 = StructureTemplate.buildInfoList(list, list1, list2);
            this.palettes.clear();
            this.palettes.add(new Palette(list3));
            if (includeEntities) {
                this.fillEntityList(world, blockposition2, blockposition3);
            } else {
                this.entityInfoList.clear();
            }
        }
    }

    private static void addToLists(StructureBlockInfo blockInfo, List<StructureBlockInfo> fullBlocks, List<StructureBlockInfo> blocksWithNbt, List<StructureBlockInfo> otherBlocks) {
        if (blockInfo.nbt != null) {
            blocksWithNbt.add(blockInfo);
        } else if (!blockInfo.state.getBlock().hasDynamicShape() && blockInfo.state.isCollisionShapeFullBlock(EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
            fullBlocks.add(blockInfo);
        } else {
            otherBlocks.add(blockInfo);
        }
    }

    private static List<StructureBlockInfo> buildInfoList(List<StructureBlockInfo> fullBlocks, List<StructureBlockInfo> blocksWithNbt, List<StructureBlockInfo> otherBlocks) {
        Comparator<StructureBlockInfo> comparator = Comparator.comparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.pos.getY()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.pos.getX()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.pos.getZ());
        fullBlocks.sort(comparator);
        otherBlocks.sort(comparator);
        blocksWithNbt.sort(comparator);
        ArrayList list3 = Lists.newArrayList();
        list3.addAll(fullBlocks);
        list3.addAll(otherBlocks);
        list3.addAll(blocksWithNbt);
        return list3;
    }

    private void fillEntityList(Level world, BlockPos firstCorner, BlockPos secondCorner) {
        List<Entity> list = world.getEntitiesOfClass(Entity.class, AABB.encapsulatingFullBlocks(firstCorner, secondCorner), entity -> !(entity instanceof Player));
        this.entityInfoList.clear();
        for (Entity entity2 : list) {
            Vec3 vec3d = new Vec3(entity2.getX() - (double)firstCorner.getX(), entity2.getY() - (double)firstCorner.getY(), entity2.getZ() - (double)firstCorner.getZ());
            CompoundTag nbttagcompound = new CompoundTag();
            entity2.save(nbttagcompound);
            BlockPos blockposition2 = entity2 instanceof Painting ? ((Painting)entity2).getPos().subtract(firstCorner) : BlockPos.containing(vec3d);
            this.entityInfoList.add(new StructureEntityInfo(vec3d, blockposition2, nbttagcompound.copy()));
        }
    }

    public List<StructureBlockInfo> filterBlocks(BlockPos pos, StructurePlaceSettings placementData, Block block) {
        return this.filterBlocks(pos, placementData, block, true);
    }

    public List<JigsawBlockInfo> getJigsaws(BlockPos pos, Rotation rotation) {
        if (this.palettes.isEmpty()) {
            return new ArrayList<JigsawBlockInfo>();
        }
        StructurePlaceSettings definedstructureinfo = new StructurePlaceSettings().setRotation(rotation);
        List<JigsawBlockInfo> list = definedstructureinfo.getRandomPalette(this.palettes, pos).jigsaws();
        ArrayList<JigsawBlockInfo> list1 = new ArrayList<JigsawBlockInfo>(list.size());
        for (JigsawBlockInfo definedstructure_a : list) {
            StructureBlockInfo definedstructure_blockinfo = definedstructure_a.info;
            list1.add(definedstructure_a.withInfo(new StructureBlockInfo(StructureTemplate.calculateRelativePosition(definedstructureinfo, definedstructure_blockinfo.pos()).offset(pos), definedstructure_blockinfo.state.rotate(definedstructureinfo.getRotation()), definedstructure_blockinfo.nbt)));
        }
        return list1;
    }

    public ObjectArrayList<StructureBlockInfo> filterBlocks(BlockPos pos, StructurePlaceSettings placementData, Block block, boolean transformed) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        BoundingBox structureboundingbox = placementData.getBoundingBox();
        if (this.palettes.isEmpty()) {
            return objectarraylist;
        }
        for (StructureBlockInfo definedstructure_blockinfo : placementData.getRandomPalette(this.palettes, pos).blocks(block)) {
            BlockPos blockposition1;
            BlockPos blockPos = blockposition1 = transformed ? StructureTemplate.calculateRelativePosition(placementData, definedstructure_blockinfo.pos).offset(pos) : definedstructure_blockinfo.pos;
            if (structureboundingbox != null && !structureboundingbox.isInside(blockposition1)) continue;
            objectarraylist.add((Object)new StructureBlockInfo(blockposition1, definedstructure_blockinfo.state.rotate(placementData.getRotation()), definedstructure_blockinfo.nbt));
        }
        return objectarraylist;
    }

    public BlockPos calculateConnectedPosition(StructurePlaceSettings placementData1, BlockPos pos1, StructurePlaceSettings placementData2, BlockPos pos2) {
        BlockPos blockposition2 = StructureTemplate.calculateRelativePosition(placementData1, pos1);
        BlockPos blockposition3 = StructureTemplate.calculateRelativePosition(placementData2, pos2);
        return blockposition2.subtract(blockposition3);
    }

    public static BlockPos calculateRelativePosition(StructurePlaceSettings placementData, BlockPos pos) {
        return StructureTemplate.transform(pos, placementData.getMirror(), placementData.getRotation(), placementData.getRotationPivot());
    }

    public boolean placeInWorld(ServerLevelAccessor world, BlockPos pos, BlockPos pivot, StructurePlaceSettings placementData, RandomSource random, int flags) {
        List<StructureBlockInfo> list;
        if (this.palettes.isEmpty()) {
            return false;
        }
        ServerLevelAccessor wrappedAccess = world;
        CraftStructureTransformer structureTransformer = null;
        if (wrappedAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)wrappedAccess;
            world = transformerAccess.getHandle();
            structureTransformer = transformerAccess.getStructureTransformer();
            if (structureTransformer != null && !structureTransformer.canTransformBlocks()) {
                structureTransformer = null;
            }
        }
        if (!((list = placementData.getRandomPalette(this.palettes, pos).blocks()).isEmpty() && (placementData.isIgnoreEntities() || this.entityInfoList.isEmpty()) || this.size.getX() < 1 || this.size.getY() < 1 || this.size.getZ() < 1)) {
            BlockState iblockdata1;
            BlockEntity tileentity;
            BoundingBox structureboundingbox = placementData.getBoundingBox();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placementData.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)(placementData.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list3 = Lists.newArrayListWithCapacity((int)list.size());
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MAX_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            int k1 = Integer.MIN_VALUE;
            List<StructureBlockInfo> list4 = StructureTemplate.processBlockInfos(world, pos, pivot, placementData, list);
            for (StructureBlockInfo definedstructure_blockinfo : list4) {
                BlockPos blockposition2 = definedstructure_blockinfo.pos;
                if (structureboundingbox != null && !structureboundingbox.isInside(blockposition2)) continue;
                FluidState fluid = placementData.shouldApplyWaterlogging() ? world.getFluidState(blockposition2) : null;
                BlockState iblockdata = definedstructure_blockinfo.state.mirror(placementData.getMirror()).rotate(placementData.getRotation());
                if (definedstructure_blockinfo.nbt != null) {
                    tileentity = world.getBlockEntity(blockposition2);
                    if (!(world instanceof WorldGenLevel)) {
                        Clearable.tryClear(tileentity);
                    }
                    world.setBlock(blockposition2, Blocks.BARRIER.defaultBlockState(), 20);
                }
                if (structureTransformer != null) {
                    CompoundTag compoundTag;
                    CraftBlockState craftBlockState = (CraftBlockState)CraftBlockStates.getBlockState((LevelReader)world, blockposition2, iblockdata, null);
                    if (definedstructure_blockinfo.nbt != null && craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState entityState = (CraftBlockEntityState)craftBlockState;
                        entityState.loadData(definedstructure_blockinfo.nbt);
                        if (craftBlockState instanceof CraftLootable) {
                            CraftLootable craftLootable = (CraftLootable)craftBlockState;
                            craftLootable.setSeed(random.nextLong());
                        }
                    }
                    craftBlockState = structureTransformer.transformCraftState(craftBlockState);
                    iblockdata = craftBlockState.getHandle();
                    if (craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState craftBlockEntityState = (CraftBlockEntityState)craftBlockState;
                        compoundTag = craftBlockEntityState.getSnapshotNBT();
                    } else {
                        compoundTag = null;
                    }
                    definedstructure_blockinfo = new StructureBlockInfo(blockposition2, iblockdata, compoundTag);
                }
                if (!world.setBlock(blockposition2, iblockdata, flags)) continue;
                j = Math.min(j, blockposition2.getX());
                k = Math.min(k, blockposition2.getY());
                l = Math.min(l, blockposition2.getZ());
                i1 = Math.max(i1, blockposition2.getX());
                j1 = Math.max(j1, blockposition2.getY());
                k1 = Math.max(k1, blockposition2.getZ());
                list3.add(Pair.of((Object)blockposition2, (Object)definedstructure_blockinfo.nbt));
                if (definedstructure_blockinfo.nbt != null && (tileentity = world.getBlockEntity(blockposition2)) != null) {
                    if (structureTransformer == null && tileentity instanceof RandomizableContainer) {
                        definedstructure_blockinfo.nbt.putLong("LootTableSeed", random.nextLong());
                    }
                    tileentity.loadWithComponents(definedstructure_blockinfo.nbt, world.registryAccess());
                }
                if (fluid == null) continue;
                if (iblockdata.getFluidState().isSource()) {
                    list2.add(blockposition2);
                    continue;
                }
                if (!(iblockdata.getBlock() instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)((Object)iblockdata.getBlock())).placeLiquid(world, blockposition2, iblockdata, fluid);
                if (fluid.isSource()) continue;
                list1.add(blockposition2);
            }
            boolean flag = true;
            Direction[] aenumdirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator1 = list1.iterator();
                while (iterator1.hasNext()) {
                    Block block;
                    BlockPos blockposition3 = (BlockPos)iterator1.next();
                    FluidState fluid1 = world.getFluidState(blockposition3);
                    for (int l1 = 0; l1 < aenumdirection.length && !fluid1.isSource(); ++l1) {
                        BlockPos blockposition4 = blockposition3.relative(aenumdirection[l1]);
                        FluidState fluid2 = world.getFluidState(blockposition4);
                        if (!fluid2.isSource() || list2.contains(blockposition4)) continue;
                        fluid1 = fluid2;
                    }
                    if (!fluid1.isSource() || !((block = (iblockdata1 = world.getBlockState(blockposition3)).getBlock()) instanceof LiquidBlockContainer)) continue;
                    ((LiquidBlockContainer)((Object)block)).placeLiquid(world, blockposition3, iblockdata1, fluid1);
                    flag = true;
                    iterator1.remove();
                }
            }
            if (j <= i1) {
                if (!placementData.getKnownShape()) {
                    BitSetDiscreteVoxelShape voxelshapebitset = new BitSetDiscreteVoxelShape(i1 - j + 1, j1 - k + 1, k1 - l + 1);
                    int i2 = j;
                    int j2 = k;
                    int l1 = l;
                    for (Pair pair : list3) {
                        BlockPos blockposition5 = (BlockPos)pair.getFirst();
                        voxelshapebitset.fill(blockposition5.getX() - i2, blockposition5.getY() - j2, blockposition5.getZ() - l1);
                    }
                    StructureTemplate.updateShapeAtEdge(world, flags, voxelshapebitset, i2, j2, l1);
                }
                for (Pair pair1 : list3) {
                    BlockPos blockposition6 = (BlockPos)pair1.getFirst();
                    if (!placementData.getKnownShape()) {
                        BlockState iblockdata2;
                        iblockdata1 = world.getBlockState(blockposition6);
                        if (iblockdata1 != (iblockdata2 = Block.updateFromNeighbourShapes(iblockdata1, world, blockposition6))) {
                            world.setBlock(blockposition6, iblockdata2, flags & 0xFFFFFFFE | 0x10);
                        }
                        world.blockUpdated(blockposition6, iblockdata2.getBlock());
                    }
                    if (pair1.getSecond() == null || (tileentity = world.getBlockEntity(blockposition6)) == null || world instanceof WorldGenLevel) continue;
                    tileentity.setChanged();
                }
            }
            if (!placementData.isIgnoreEntities()) {
                this.placeEntities(wrappedAccess, pos, placementData.getMirror(), placementData.getRotation(), placementData.getRotationPivot(), structureboundingbox, placementData.shouldFinalizeEntities());
            }
            return true;
        }
        return false;
    }

    public static void updateShapeAtEdge(LevelAccessor world, int flags, DiscreteVoxelShape set, BlockPos startPos) {
        StructureTemplate.updateShapeAtEdge(world, flags, set, startPos.getX(), startPos.getY(), startPos.getZ());
    }

    public static void updateShapeAtEdge(LevelAccessor world, int flags, DiscreteVoxelShape set, int startX, int startY, int startZ) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos blockposition_mutableblockposition1 = new BlockPos.MutableBlockPos();
        set.forAllFaces((enumdirection, i1, j1, k1) -> {
            BlockState iblockdata3;
            blockposition_mutableblockposition.set(startX + i1, startY + j1, startZ + k1);
            blockposition_mutableblockposition1.setWithOffset((Vec3i)blockposition_mutableblockposition, enumdirection);
            BlockState iblockdata = world.getBlockState(blockposition_mutableblockposition);
            BlockState iblockdata1 = world.getBlockState(blockposition_mutableblockposition1);
            BlockState iblockdata2 = iblockdata.updateShape(world, world, blockposition_mutableblockposition, enumdirection, blockposition_mutableblockposition1, iblockdata1, world.getRandom());
            if (iblockdata != iblockdata2) {
                world.setBlock(blockposition_mutableblockposition, iblockdata2, flags & 0xFFFFFFFE);
            }
            if (iblockdata1 != (iblockdata3 = iblockdata1.updateShape(world, world, blockposition_mutableblockposition1, enumdirection.getOpposite(), blockposition_mutableblockposition, iblockdata2, world.getRandom()))) {
                world.setBlock(blockposition_mutableblockposition1, iblockdata3, flags & 0xFFFFFFFE);
            }
        });
    }

    public static List<StructureBlockInfo> processBlockInfos(ServerLevelAccessor world, BlockPos pos, BlockPos pivot, StructurePlaceSettings placementData, List<StructureBlockInfo> infos) {
        ArrayList<StructureBlockInfo> list1 = new ArrayList<StructureBlockInfo>();
        List<StructureBlockInfo> list2 = new ArrayList<StructureBlockInfo>();
        for (StructureBlockInfo definedstructure_blockinfo : infos) {
            BlockPos blockposition2 = StructureTemplate.calculateRelativePosition(placementData, definedstructure_blockinfo.pos).offset(pos);
            StructureBlockInfo definedstructure_blockinfo1 = new StructureBlockInfo(blockposition2, definedstructure_blockinfo.state, definedstructure_blockinfo.nbt != null ? definedstructure_blockinfo.nbt.copy() : null);
            Iterator<StructureProcessor> iterator1 = placementData.getProcessors().iterator();
            while (definedstructure_blockinfo1 != null && iterator1.hasNext()) {
                definedstructure_blockinfo1 = iterator1.next().processBlock(world, pos, pivot, definedstructure_blockinfo, definedstructure_blockinfo1, placementData);
            }
            if (definedstructure_blockinfo1 == null) continue;
            list2.add(definedstructure_blockinfo1);
            list1.add(definedstructure_blockinfo);
        }
        for (StructureProcessor definedstructureprocessor : placementData.getProcessors()) {
            list2 = definedstructureprocessor.finalizeProcessing(world, pos, pivot, list1, list2, placementData);
        }
        return list2;
    }

    private void placeEntities(ServerLevelAccessor world, BlockPos pos, Mirror mirror, Rotation rotation, BlockPos pivot, @Nullable BoundingBox area, boolean initializeMobs) {
        for (StructureEntityInfo definedstructure_entityinfo : this.entityInfoList) {
            BlockPos blockposition2 = StructureTemplate.transform(definedstructure_entityinfo.blockPos, mirror, rotation, pivot).offset(pos);
            if (area != null && !area.isInside(blockposition2)) continue;
            CompoundTag nbttagcompound = definedstructure_entityinfo.nbt.copy();
            Vec3 vec3d = StructureTemplate.transform(definedstructure_entityinfo.pos, mirror, rotation, pivot);
            Vec3 vec3d1 = vec3d.add(pos.getX(), pos.getY(), pos.getZ());
            ListTag nbttaglist = new ListTag();
            nbttaglist.add(DoubleTag.valueOf(vec3d1.x));
            nbttaglist.add(DoubleTag.valueOf(vec3d1.y));
            nbttaglist.add(DoubleTag.valueOf(vec3d1.z));
            nbttagcompound.put("Pos", nbttaglist);
            nbttagcompound.remove("UUID");
            StructureTemplate.createEntityIgnoreException(world, nbttagcompound).ifPresent(entity -> {
                float f = entity.rotate(rotation);
                entity.moveTo(vec3d1.x, vec3d1.y, vec3d1.z, f += entity.mirror(mirror) - entity.getYRot(), entity.getXRot());
                if (initializeMobs && entity instanceof Mob) {
                    ((Mob)entity).finalizeSpawn(world, world.getCurrentDifficultyAt(BlockPos.containing(vec3d1)), EntitySpawnReason.STRUCTURE, null);
                }
                world.addFreshEntityWithPassengers((Entity)entity);
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(ServerLevelAccessor world, CompoundTag nbt) {
        return EntityType.create(nbt, world.getLevel(), EntitySpawnReason.STRUCTURE, true);
    }

    public Vec3i getSize(Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new Vec3i(this.size.getZ(), this.size.getY(), this.size.getX());
            }
        }
        return this.size;
    }

    public static BlockPos transform(BlockPos pos, Mirror mirror, Rotation rotation, BlockPos pivot) {
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l = pivot.getX();
        int i1 = pivot.getZ();
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(l - i1 + k, j, l + i1 - i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(l + i1 - k, j, i1 - l + i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(l + l - i, j, i1 + i1 - k);
            }
        }
        return flag ? new BlockPos(i, j, k) : pos;
    }

    public static Vec3 transform(Vec3 point, Mirror mirror, Rotation rotation, BlockPos pivot) {
        double d0 = point.x;
        double d1 = point.y;
        double d2 = point.z;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i = pivot.getX();
        int j = pivot.getZ();
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3((double)(i - j) + d2, d1, (double)(i + j + 1) - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3((double)(i + j + 1) - d2, d1, (double)(j - i) + d0);
            }
            case CLOCKWISE_180: {
                return new Vec3((double)(i + i + 1) - d0, d1, (double)(j + j + 1) - d2);
            }
        }
        return flag ? new Vec3(d0, d1, d2) : point;
    }

    public BlockPos getZeroPositionWithTransform(BlockPos pos, Mirror mirror, Rotation rotation) {
        return StructureTemplate.getZeroPositionWithTransform(pos, mirror, rotation, this.getSize().getX(), this.getSize().getZ());
    }

    public static BlockPos getZeroPositionWithTransform(BlockPos pos, Mirror mirror, Rotation rotation, int offsetX, int offsetZ) {
        int k = mirror == Mirror.FRONT_BACK ? --offsetX : 0;
        int l = mirror == Mirror.LEFT_RIGHT ? --offsetZ : 0;
        BlockPos blockposition1 = pos;
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                blockposition1 = pos.offset(l, 0, offsetX - k);
                break;
            }
            case CLOCKWISE_90: {
                blockposition1 = pos.offset(offsetZ - l, 0, k);
                break;
            }
            case CLOCKWISE_180: {
                blockposition1 = pos.offset(offsetX - k, 0, offsetZ - l);
                break;
            }
            case NONE: {
                blockposition1 = pos.offset(k, 0, l);
            }
        }
        return blockposition1;
    }

    public BoundingBox getBoundingBox(StructurePlaceSettings placementData, BlockPos pos) {
        return this.getBoundingBox(pos, placementData.getRotation(), placementData.getRotationPivot(), placementData.getMirror());
    }

    public BoundingBox getBoundingBox(BlockPos pos, Rotation rotation, BlockPos pivot, Mirror mirror) {
        return StructureTemplate.getBoundingBox(pos, rotation, pivot, mirror, this.size);
    }

    @VisibleForTesting
    protected static BoundingBox getBoundingBox(BlockPos pos, Rotation rotation, BlockPos pivot, Mirror mirror, Vec3i dimensions) {
        Vec3i baseblockposition1 = dimensions.offset(-1, -1, -1);
        BlockPos blockposition2 = StructureTemplate.transform(BlockPos.ZERO, mirror, rotation, pivot);
        BlockPos blockposition3 = StructureTemplate.transform(BlockPos.ZERO.offset(baseblockposition1), mirror, rotation, pivot);
        return BoundingBox.fromCorners(blockposition2, blockposition3).move(pos);
    }

    public CompoundTag save(CompoundTag nbt) {
        if (this.palettes.isEmpty()) {
            nbt.put(BLOCKS_TAG, new ListTag());
            nbt.put(PALETTE_TAG, new ListTag());
        } else {
            ArrayList list = Lists.newArrayList();
            SimplePalette definedstructure_c = new SimplePalette();
            list.add(definedstructure_c);
            for (int i = 1; i < this.palettes.size(); ++i) {
                list.add(new SimplePalette());
            }
            ListTag nbttaglist = new ListTag();
            List<StructureBlockInfo> list1 = this.palettes.get(0).blocks();
            for (int j = 0; j < list1.size(); ++j) {
                StructureBlockInfo definedstructure_blockinfo = list1.get(j);
                CompoundTag nbttagcompound1 = new CompoundTag();
                nbttagcompound1.put("pos", this.newIntegerList(definedstructure_blockinfo.pos.getX(), definedstructure_blockinfo.pos.getY(), definedstructure_blockinfo.pos.getZ()));
                int k = definedstructure_c.idFor(definedstructure_blockinfo.state);
                nbttagcompound1.putInt(BLOCK_TAG_STATE, k);
                if (definedstructure_blockinfo.nbt != null) {
                    nbttagcompound1.put("nbt", definedstructure_blockinfo.nbt);
                }
                nbttaglist.add(nbttagcompound1);
                for (int l = 1; l < this.palettes.size(); ++l) {
                    SimplePalette definedstructure_c1 = (SimplePalette)list.get(l);
                    definedstructure_c1.addMapping(this.palettes.get((int)l).blocks().get((int)j).state, k);
                }
            }
            nbt.put(BLOCKS_TAG, nbttaglist);
            if (list.size() == 1) {
                nbttaglist1 = new ListTag();
                for (BlockState iblockdata : definedstructure_c) {
                    nbttaglist1.add(NbtUtils.writeBlockState(iblockdata));
                }
                nbt.put(PALETTE_TAG, nbttaglist1);
            } else {
                nbttaglist1 = new ListTag();
                for (SimplePalette definedstructure_c2 : list) {
                    ListTag nbttaglist2 = new ListTag();
                    for (BlockState iblockdata1 : definedstructure_c2) {
                        nbttaglist2.add(NbtUtils.writeBlockState(iblockdata1));
                    }
                    nbttaglist1.add(nbttaglist2);
                }
                nbt.put(PALETTE_LIST_TAG, nbttaglist1);
            }
        }
        ListTag nbttaglist3 = new ListTag();
        for (StructureEntityInfo definedstructure_entityinfo : this.entityInfoList) {
            CompoundTag nbttagcompound2 = new CompoundTag();
            nbttagcompound2.put("pos", this.newDoubleList(definedstructure_entityinfo.pos.x, definedstructure_entityinfo.pos.y, definedstructure_entityinfo.pos.z));
            nbttagcompound2.put(ENTITY_TAG_BLOCKPOS, this.newIntegerList(definedstructure_entityinfo.blockPos.getX(), definedstructure_entityinfo.blockPos.getY(), definedstructure_entityinfo.blockPos.getZ()));
            if (definedstructure_entityinfo.nbt != null) {
                nbttagcompound2.put("nbt", definedstructure_entityinfo.nbt);
            }
            nbttaglist3.add(nbttagcompound2);
        }
        nbt.put(ENTITIES_TAG, nbttaglist3);
        nbt.put(SIZE_TAG, this.newIntegerList(this.size.getX(), this.size.getY(), this.size.getZ()));
        if (!this.persistentDataContainer.isEmpty()) {
            nbt.put("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return NbtUtils.addCurrentDataVersion(nbt);
    }

    public void load(HolderGetter<Block> blockLookup, CompoundTag nbt) {
        int i;
        ListTag nbttaglist2;
        this.palettes.clear();
        this.entityInfoList.clear();
        ListTag nbttaglist = nbt.getList(SIZE_TAG, 3);
        this.size = new Vec3i(nbttaglist.getInt(0), nbttaglist.getInt(1), nbttaglist.getInt(2));
        ListTag nbttaglist1 = nbt.getList(BLOCKS_TAG, 10);
        if (nbt.contains(PALETTE_LIST_TAG, 9)) {
            nbttaglist2 = nbt.getList(PALETTE_LIST_TAG, 9);
            for (i = 0; i < nbttaglist2.size(); ++i) {
                this.loadPalette(blockLookup, nbttaglist2.getList(i), nbttaglist1);
            }
        } else {
            this.loadPalette(blockLookup, nbt.getList(PALETTE_TAG, 10), nbttaglist1);
        }
        nbttaglist2 = nbt.getList(ENTITIES_TAG, 10);
        for (i = 0; i < nbttaglist2.size(); ++i) {
            CompoundTag nbttagcompound1 = nbttaglist2.getCompound(i);
            ListTag nbttaglist3 = nbttagcompound1.getList("pos", 6);
            Vec3 vec3d = new Vec3(nbttaglist3.getDouble(0), nbttaglist3.getDouble(1), nbttaglist3.getDouble(2));
            ListTag nbttaglist4 = nbttagcompound1.getList(ENTITY_TAG_BLOCKPOS, 3);
            BlockPos blockposition = new BlockPos(nbttaglist4.getInt(0), nbttaglist4.getInt(1), nbttaglist4.getInt(2));
            if (!nbttagcompound1.contains("nbt")) continue;
            CompoundTag nbttagcompound2 = nbttagcompound1.getCompound("nbt");
            this.entityInfoList.add(new StructureEntityInfo(vec3d, blockposition, nbttagcompound2));
        }
        Tag base = nbt.get("BukkitValues");
        if (base instanceof CompoundTag) {
            this.persistentDataContainer.putAll((CompoundTag)base);
        }
    }

    private void loadPalette(HolderGetter<Block> blockLookup, ListTag palette, ListTag blocks) {
        SimplePalette definedstructure_c = new SimplePalette();
        for (int i = 0; i < palette.size(); ++i) {
            definedstructure_c.addMapping(NbtUtils.readBlockState(blockLookup, palette.getCompound(i)), i);
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (int j = 0; j < blocks.size(); ++j) {
            CompoundTag nbttagcompound = blocks.getCompound(j);
            ListTag nbttaglist2 = nbttagcompound.getList("pos", 3);
            BlockPos blockposition = new BlockPos(nbttaglist2.getInt(0), nbttaglist2.getInt(1), nbttaglist2.getInt(2));
            BlockState iblockdata = definedstructure_c.stateFor(nbttagcompound.getInt(BLOCK_TAG_STATE));
            CompoundTag nbttagcompound1 = nbttagcompound.contains("nbt") ? nbttagcompound.getCompound("nbt") : null;
            StructureBlockInfo definedstructure_blockinfo = new StructureBlockInfo(blockposition, iblockdata, nbttagcompound1);
            StructureTemplate.addToLists(definedstructure_blockinfo, list, list1, list2);
        }
        List<StructureBlockInfo> list3 = StructureTemplate.buildInfoList(list, list1, list2);
        this.palettes.add(new Palette(list3));
    }

    private ListTag newIntegerList(int ... ints) {
        ListTag nbttaglist = new ListTag();
        int[] aint1 = ints;
        int i = ints.length;
        for (int j = 0; j < i; ++j) {
            int k = aint1[j];
            nbttaglist.add(IntTag.valueOf(k));
        }
        return nbttaglist;
    }

    private ListTag newDoubleList(double ... doubles) {
        ListTag nbttaglist = new ListTag();
        double[] adouble1 = doubles;
        int i = doubles.length;
        for (int j = 0; j < i; ++j) {
            double d0 = adouble1[j];
            nbttaglist.add(DoubleTag.valueOf(d0));
        }
        return nbttaglist;
    }

    public static JigsawBlockEntity.JointType getJointType(CompoundTag nbt, BlockState state) {
        return JigsawBlockEntity.JointType.CODEC.byName(nbt.getString("joint"), () -> JigsawBlock.getFrontFacing(state).getAxis().isHorizontal() ? JigsawBlockEntity.JointType.ALIGNED : JigsawBlockEntity.JointType.ROLLABLE);
    }

    public record StructureBlockInfo(BlockPos pos, BlockState state, @Nullable CompoundTag nbt) {
        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.pos, this.state, this.nbt);
        }
    }

    public static final class Palette {
        private final List<StructureBlockInfo> blocks;
        private final Map<Block, List<StructureBlockInfo>> cache = Maps.newConcurrentMap();
        @Nullable
        private List<JigsawBlockInfo> cachedJigsaws;

        Palette(List<StructureBlockInfo> infos) {
            this.blocks = infos;
        }

        public List<JigsawBlockInfo> jigsaws() {
            if (this.cachedJigsaws == null) {
                this.cachedJigsaws = this.blocks(Blocks.JIGSAW).stream().map(JigsawBlockInfo::of).toList();
            }
            return this.cachedJigsaws;
        }

        public List<StructureBlockInfo> blocks() {
            return this.blocks;
        }

        public List<StructureBlockInfo> blocks(Block block) {
            return this.cache.computeIfAbsent(block, block1 -> this.blocks.stream().filter(definedstructure_blockinfo -> definedstructure_blockinfo.state.is((Block)block1)).collect(Collectors.toList()));
        }
    }

    public static class StructureEntityInfo {
        public final Vec3 pos;
        public final BlockPos blockPos;
        public final CompoundTag nbt;

        public StructureEntityInfo(Vec3 pos, BlockPos blockPos, CompoundTag nbt) {
            this.pos = pos;
            this.blockPos = blockPos;
            this.nbt = nbt;
        }
    }

    public record JigsawBlockInfo(StructureBlockInfo info, JigsawBlockEntity.JointType jointType, ResourceLocation name, ResourceLocation pool, ResourceLocation target, int placementPriority, int selectionPriority) {
        public static JigsawBlockInfo of(StructureBlockInfo structureBlockInfo) {
            CompoundTag nbttagcompound = Objects.requireNonNull(structureBlockInfo.nbt(), () -> String.valueOf(structureBlockInfo) + " nbt was null");
            return new JigsawBlockInfo(structureBlockInfo, StructureTemplate.getJointType(nbttagcompound, structureBlockInfo.state()), ResourceLocation.parse(nbttagcompound.getString("name")), ResourceLocation.parse(nbttagcompound.getString("pool")), ResourceLocation.parse(nbttagcompound.getString("target")), nbttagcompound.getInt("placement_priority"), nbttagcompound.getInt("selection_priority"));
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<JigsawBlockInfo | %s | %s | name: %s | pool: %s | target: %s | placement: %d | selection: %d | %s>", this.info.pos, this.info.state, this.name, this.pool, this.target, this.placementPriority, this.selectionPriority, this.info.nbt);
        }

        public JigsawBlockInfo withInfo(StructureBlockInfo structureBlockInfo) {
            return new JigsawBlockInfo(structureBlockInfo, this.jointType, this.name, this.pool, this.target, this.placementPriority, this.selectionPriority);
        }
    }

    private static class SimplePalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
        private final IdMapper<BlockState> ids = new IdMapper(16);
        private int lastId;

        SimplePalette() {
        }

        public int idFor(BlockState state) {
            int i = this.ids.getId(state);
            if (i == -1) {
                i = this.lastId++;
                this.ids.addMapping(state, i);
            }
            return i;
        }

        @Nullable
        public BlockState stateFor(int id) {
            BlockState iblockdata = this.ids.byId(id);
            return iblockdata == null ? DEFAULT_BLOCK_STATE : iblockdata;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState state, int id) {
            this.ids.addMapping(state, id);
        }
    }
}

