/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import ca.spottedleaf.moonrise.patches.collisions.util.FluidOcclusionCacheKey;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty FALLING = BlockStateProperties.FALLING;
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_FLOWING;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<BlockStatePairKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<BlockStatePairKey>(200){

            protected void rehash(int i) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    private final Map<FluidState, VoxelShape> shapes = Maps.newIdentityHashMap();
    private FluidState sourceFalling;
    private FluidState sourceNotFalling;
    private static final int TOTAL_FLOWING_STATES = FALLING.getPossibleValues().size() * LEVEL.getPossibleValues().size();
    private static final int MIN_LEVEL = (Integer)LEVEL.getPossibleValues().stream().sorted().findFirst().get();
    private FluidState[] flowingLookUp;
    private volatile boolean init;
    private static final int COLLISION_OCCLUSION_CACHE_SIZE = 2048;
    private static final ThreadLocal<FluidOcclusionCacheKey[]> COLLISION_OCCLUSION_CACHE = ThreadLocal.withInitial(() -> new FluidOcclusionCacheKey[2048]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        FlowingFluid flowingFluid = this;
        synchronized (flowingFluid) {
            if (this.init) {
                return;
            }
            this.flowingLookUp = new FluidState[TOTAL_FLOWING_STATES];
            FluidState defaultFlowState = this.getFlowing().defaultFluidState();
            for (int i = 0; i < TOTAL_FLOWING_STATES; ++i) {
                int falling = i & 1;
                int level = (i >>> 1) + MIN_LEVEL;
                this.flowingLookUp[i] = (FluidState)((FluidState)defaultFlowState.setValue(FALLING, falling == 1 ? Boolean.TRUE : Boolean.FALSE)).setValue(LEVEL, level);
            }
            FluidState defaultFallState = this.getSource().defaultFluidState();
            this.sourceFalling = (FluidState)defaultFallState.setValue(FALLING, Boolean.TRUE);
            this.sourceNotFalling = (FluidState)defaultFallState.setValue(FALLING, Boolean.FALSE);
            this.init = true;
        }
    }

    @Override
    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        builder.add(FALLING);
    }

    @Override
    public Vec3 getFlow(BlockGetter world, BlockPos pos, FluidState state) {
        double d0 = 0.0;
        double d1 = 0.0;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            blockposition_mutableblockposition.setWithOffset((Vec3i)pos, enumdirection);
            FluidState fluid1 = world.getFluidState(blockposition_mutableblockposition);
            if (!this.affectsFlow(fluid1)) continue;
            float f = fluid1.getOwnHeight();
            float f1 = 0.0f;
            if (f == 0.0f) {
                Vec3i blockposition1;
                FluidState fluid2;
                if (!world.getBlockState(blockposition_mutableblockposition).blocksMotion() && this.affectsFlow(fluid2 = world.getFluidState((BlockPos)(blockposition1 = blockposition_mutableblockposition.below()))) && (f = fluid2.getOwnHeight()) > 0.0f) {
                    f1 = state.getOwnHeight() - (f - 0.8888889f);
                }
            } else if (f > 0.0f) {
                f1 = state.getOwnHeight() - f;
            }
            if (f1 == 0.0f) continue;
            d0 += (double)((float)enumdirection.getStepX() * f1);
            d1 += (double)((float)enumdirection.getStepZ() * f1);
        }
        Vec3 vec3d = new Vec3(d0, 0.0, d1);
        if (state.getValue(FALLING).booleanValue()) {
            for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
                blockposition_mutableblockposition.setWithOffset((Vec3i)pos, enumdirection1);
                if (!this.isSolidFace(world, blockposition_mutableblockposition, enumdirection1) && !this.isSolidFace(world, (BlockPos)blockposition_mutableblockposition.above(), enumdirection1)) continue;
                vec3d = vec3d.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3d.normalize();
    }

    private boolean affectsFlow(FluidState state) {
        return state.isEmpty() || state.getType().isSame(this);
    }

    protected boolean isSolidFace(BlockGetter world, BlockPos pos, Direction direction) {
        BlockState iblockdata = world.getBlockState(pos);
        FluidState fluid = world.getFluidState(pos);
        return fluid.getType().isSame(this) ? false : (direction == Direction.UP ? true : (iblockdata.getBlock() instanceof IceBlock ? false : iblockdata.isFaceSturdy(world, pos, direction)));
    }

    protected void spread(ServerLevel world, BlockPos fluidPos, BlockState blockState, FluidState fluidState) {
        if (!fluidState.isEmpty()) {
            FluidState fluid2;
            Fluid fluidtype;
            FluidState fluid1;
            BlockState iblockdata1;
            BlockPos blockposition1 = fluidPos.below();
            if (this.canMaybePassThrough(world, fluidPos, blockState, Direction.DOWN, blockposition1, iblockdata1 = world.getBlockState(blockposition1), fluid1 = iblockdata1.getFluidState()) && fluid1.canBeReplacedWith(world, blockposition1, fluidtype = (fluid2 = this.getNewLiquid(world, blockposition1, iblockdata1)).getType(), Direction.DOWN) && FlowingFluid.canHoldSpecificFluid(world, blockposition1, iblockdata1, fluidtype)) {
                CraftBlock source = CraftBlock.at(world, fluidPos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, BlockFace.DOWN);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.spreadTo(world, blockposition1, iblockdata1, Direction.DOWN, fluid2);
                if (this.sourceNeighborCount(world, fluidPos) >= 3) {
                    this.spreadToSides(world, fluidPos, fluidState, blockState);
                }
                return;
            }
            if (fluidState.isSource() || !this.isWaterHole(world, fluidPos, blockState, blockposition1, iblockdata1)) {
                this.spreadToSides(world, fluidPos, fluidState, blockState);
            }
        }
    }

    private void spreadToSides(ServerLevel world, BlockPos pos, FluidState fluidState, BlockState blockState) {
        int i = fluidState.getAmount() - this.getDropOff(world);
        if (fluidState.getValue(FALLING).booleanValue()) {
            i = 7;
        }
        if (i > 0) {
            Map<Direction, FluidState> map = this.getSpread(world, pos, blockState);
            for (Map.Entry<Direction, FluidState> entry : map.entrySet()) {
                Direction enumdirection = entry.getKey();
                FluidState fluid1 = entry.getValue();
                BlockPos blockposition1 = pos.relative(enumdirection);
                BlockState blockStateIfLoaded = world.getBlockStateIfLoaded(blockposition1);
                if (blockStateIfLoaded == null) continue;
                CraftBlock source = CraftBlock.at(world, pos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, CraftBlock.notchToBlockFace(enumdirection));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.spreadTo(world, blockposition1, blockStateIfLoaded, enumdirection, fluid1);
            }
        }
    }

    protected FluidState getNewLiquid(ServerLevel world, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition2;
        BlockState iblockdata3;
        FluidState fluid2;
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            FluidState fluid;
            BlockPos.MutableBlockPos blockposition_mutableblockposition1 = blockposition_mutableblockposition.setWithOffset((Vec3i)pos, enumdirection);
            BlockState iblockdata1 = world.getBlockStateIfLoaded(blockposition_mutableblockposition1);
            if (iblockdata1 == null || !(fluid = iblockdata1.getFluidState()).getType().isSame(this) || !FlowingFluid.canPassThroughWall(enumdirection, world, pos, state, blockposition_mutableblockposition1, iblockdata1)) continue;
            if (fluid.isSource()) {
                ++j;
            }
            i = Math.max(i, fluid.getAmount());
        }
        if (j >= this.getRequiredSources(world) && this.canConvertToSource(world)) {
            BlockState iblockdata2 = world.getBlockState(blockposition_mutableblockposition.setWithOffset((Vec3i)pos, Direction.DOWN));
            FluidState fluid1 = iblockdata2.getFluidState();
            if (iblockdata2.isSolid() || this.isSourceBlockOfThisType(fluid1)) {
                return this.getSource(false);
            }
        }
        if (!(fluid2 = (iblockdata3 = world.getBlockState(blockposition_mutableblockposition2 = blockposition_mutableblockposition.setWithOffset((Vec3i)pos, Direction.UP))).getFluidState()).isEmpty() && fluid2.getType().isSame(this) && FlowingFluid.canPassThroughWall(Direction.UP, world, pos, state, blockposition_mutableblockposition2, iblockdata3)) {
            return this.getFlowing(8, true);
        }
        int k = i - this.getDropOff(world);
        return k <= 0 ? Fluids.EMPTY.defaultFluidState() : this.getFlowing(k, false);
    }

    private static boolean canPassThroughWall(Direction direction, BlockGetter level, BlockPos fromPos, BlockState fromState, BlockPos toPos, BlockState toState) {
        VoxelShape shape2;
        boolean result;
        FluidOcclusionCacheKey cached;
        if (fromState.moonrise$emptyCollisionShape() & toState.moonrise$emptyCollisionShape()) {
            return true;
        }
        if (fromState.moonrise$occludesFullBlock() | toState.moonrise$occludesFullBlock()) {
            return false;
        }
        FluidOcclusionCacheKey[] cache = fromState.moonrise$hasCache() & toState.moonrise$hasCache() ? COLLISION_OCCLUSION_CACHE.get() : null;
        int keyIndex = (fromState.moonrise$uniqueId1() ^ toState.moonrise$uniqueId2() ^ ((CollisionDirection)direction).moonrise$uniqueId()) & 0x7FF;
        if (cache != null && (cached = cache[keyIndex]) != null && cached.first() == fromState && cached.second() == toState && cached.direction() == direction) {
            return cached.result();
        }
        VoxelShape shape1 = fromState.getCollisionShape(level, fromPos);
        boolean bl = result = !Shapes.mergedFaceOccludes(shape1, shape2 = toState.getCollisionShape(level, toPos), direction);
        if (cache != null) {
            cache[keyIndex] = new FluidOcclusionCacheKey(fromState, toState, direction, result);
        }
        return result;
    }

    public abstract Fluid getFlowing();

    public FluidState getFlowing(int level, boolean falling) {
        int amount = level;
        if (!this.init) {
            this.init();
        }
        int index = (falling ? 1 : 0) | amount - MIN_LEVEL << 1;
        return this.flowingLookUp[index];
    }

    public abstract Fluid getSource();

    public FluidState getSource(boolean falling) {
        if (!this.init) {
            this.init();
        }
        return falling ? this.sourceFalling : this.sourceNotFalling;
    }

    protected abstract boolean canConvertToSource(ServerLevel var1);

    protected int getRequiredSources(Level level) {
        return 2;
    }

    protected void spreadTo(LevelAccessor world, BlockPos pos, BlockState state, Direction direction, FluidState fluidState) {
        Block block = state.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer ifluidcontainer = (LiquidBlockContainer)((Object)block);
            ifluidcontainer.placeLiquid(world, pos, state, fluidState);
        } else {
            if (!state.isAir()) {
                this.beforeDestroyingBlock(world, pos, state, pos.relative(direction.getOpposite()));
            }
            world.setBlock(pos, fluidState.createLegacyBlock(), 3);
        }
    }

    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState state, BlockPos source) {
        this.beforeDestroyingBlock(world, pos, state);
    }

    protected abstract void beforeDestroyingBlock(LevelAccessor var1, BlockPos var2, BlockState var3);

    protected int getSlopeDistance(LevelReader world, BlockPos pos, int i, Direction direction, BlockState state, SpreadContext spreadCache) {
        int j = 1000;
        for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
            int k;
            BlockPos blockposition1;
            BlockState iblockdata1;
            if (enumdirection1 == direction || (iblockdata1 = spreadCache.getBlockStateIfLoaded(blockposition1 = pos.relative(enumdirection1))) == null) continue;
            FluidState fluid = iblockdata1.getFluidState();
            if (!this.canPassThrough(world, this.getFlowing(), pos, state, enumdirection1, blockposition1, iblockdata1, fluid)) continue;
            if (spreadCache.isHole(blockposition1)) {
                return i;
            }
            if (i >= this.getSlopeFindDistance(world) || (k = this.getSlopeDistance(world, blockposition1, i + 1, enumdirection1.getOpposite(), iblockdata1, spreadCache)) >= j) continue;
            j = k;
        }
        return j;
    }

    boolean isWaterHole(BlockGetter world, BlockPos pos, BlockState state, BlockPos fromPos, BlockState fromState) {
        return !FlowingFluid.canPassThroughWall(Direction.DOWN, world, pos, state, fromPos, fromState) ? false : (fromState.getFluidState().getType().isSame(this) ? true : FlowingFluid.canHoldFluid(world, fromPos, fromState, this.getFlowing()));
    }

    private boolean canPassThrough(BlockGetter world, Fluid fluid, BlockPos pos, BlockState state, Direction face, BlockPos fromPos, BlockState fromState, FluidState fluidState) {
        return this.canMaybePassThrough(world, pos, state, face, fromPos, fromState, fluidState) && FlowingFluid.canHoldSpecificFluid(world, fromPos, fromState, fluid);
    }

    private boolean canMaybePassThrough(BlockGetter world, BlockPos pos, BlockState state, Direction face, BlockPos fromPos, BlockState fromState, FluidState fluidState) {
        return !this.isSourceBlockOfThisType(fluidState) && FlowingFluid.canHoldAnyFluid(fromState) && FlowingFluid.canPassThroughWall(face, world, pos, state, fromPos, fromState);
    }

    private boolean isSourceBlockOfThisType(FluidState state) {
        return state.getType().isSame(this) && state.isSource();
    }

    protected abstract int getSlopeFindDistance(LevelReader var1);

    private int sourceNeighborCount(LevelReader world, BlockPos pos) {
        int i = 0;
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BlockPos blockposition1 = pos.relative(enumdirection);
            FluidState fluid = world.getFluidState(blockposition1);
            if (!this.isSourceBlockOfThisType(fluid)) continue;
            ++i;
        }
        return i;
    }

    protected Map<Direction, FluidState> getSpread(ServerLevel world, BlockPos pos, BlockState state) {
        int i = 1000;
        EnumMap map = Maps.newEnumMap(Direction.class);
        SpreadContext fluidtypeflowing_b = null;
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            int j;
            FluidState fluid1;
            FluidState fluid;
            BlockPos blockposition1 = pos.relative(enumdirection);
            BlockState iblockdata1 = world.getBlockStateIfLoaded(blockposition1);
            if (iblockdata1 == null || !this.canMaybePassThrough(world, pos, state, enumdirection, blockposition1, iblockdata1, fluid = iblockdata1.getFluidState()) || !FlowingFluid.canHoldSpecificFluid(world, blockposition1, iblockdata1, (fluid1 = this.getNewLiquid(world, blockposition1, iblockdata1)).getType())) continue;
            if (fluidtypeflowing_b == null) {
                fluidtypeflowing_b = new SpreadContext(world, pos);
            }
            if ((j = fluidtypeflowing_b.isHole(blockposition1) ? 0 : this.getSlopeDistance(world, blockposition1, 1, enumdirection.getOpposite(), iblockdata1, fluidtypeflowing_b)) < i) {
                map.clear();
            }
            if (j > i) continue;
            if (fluid.canBeReplacedWith(world, blockposition1, fluid1.getType(), enumdirection)) {
                map.put(enumdirection, fluid1);
            }
            i = j;
        }
        return map;
    }

    private static boolean canHoldAnyFluid(BlockState state) {
        Block block = state.getBlock();
        return block instanceof LiquidBlockContainer ? true : (state.blocksMotion() ? false : !(block instanceof DoorBlock) && !state.is(BlockTags.SIGNS) && !state.is(Blocks.LADDER) && !state.is(Blocks.SUGAR_CANE) && !state.is(Blocks.BUBBLE_COLUMN) && !state.is(Blocks.NETHER_PORTAL) && !state.is(Blocks.END_PORTAL) && !state.is(Blocks.END_GATEWAY) && !state.is(Blocks.STRUCTURE_VOID));
    }

    private static boolean canHoldFluid(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return FlowingFluid.canHoldAnyFluid(state) && FlowingFluid.canHoldSpecificFluid(world, pos, state, fluid);
    }

    private static boolean canHoldSpecificFluid(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        Block block = state.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer ifluidcontainer = (LiquidBlockContainer)((Object)block);
            return ifluidcontainer.canPlaceLiquid(null, world, pos, state, fluid);
        }
        return true;
    }

    protected abstract int getDropOff(LevelReader var1);

    protected int getSpreadDelay(Level world, BlockPos pos, FluidState oldState, FluidState newState) {
        return this.getTickDelay(world);
    }

    @Override
    public void tick(ServerLevel world, BlockPos pos, BlockState blockState, FluidState fluidState) {
        if (!fluidState.isSource()) {
            FluidState fluid1 = this.getNewLiquid(world, pos, world.getBlockState(pos));
            int i = this.getSpreadDelay(world, pos, fluidState, fluid1);
            if (fluid1.isEmpty()) {
                fluidState = fluid1;
                blockState = Blocks.AIR.defaultBlockState();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(world, pos, blockState);
                if (event.isCancelled()) {
                    return;
                }
                blockState = ((CraftBlockData)event.getNewData()).getState();
                world.setBlock(pos, blockState, 3);
            } else if (!fluid1.equals(fluidState)) {
                fluidState = fluid1;
                blockState = fluid1.createLegacyBlock();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(world, pos, blockState);
                if (event.isCancelled()) {
                    return;
                }
                blockState = ((CraftBlockData)event.getNewData()).getState();
                world.setBlock(pos, blockState, 3);
                world.scheduleTick(pos, fluid1.getType(), i);
            }
        }
        this.spread(world, pos, blockState, fluidState);
    }

    protected static int getLegacyLevel(FluidState state) {
        return state.isSource() ? 0 : 8 - Math.min(state.getAmount(), 8) + (state.getValue(FALLING) != false ? 8 : 0);
    }

    private static boolean hasSameAbove(FluidState state, BlockGetter world, BlockPos pos) {
        return state.getType().isSame(world.getFluidState(pos.above()).getType());
    }

    @Override
    public float getHeight(FluidState state, BlockGetter world, BlockPos pos) {
        return FlowingFluid.hasSameAbove(state, world, pos) ? 1.0f : state.getOwnHeight();
    }

    @Override
    public float getOwnHeight(FluidState state) {
        return (float)state.getAmount() / 9.0f;
    }

    @Override
    public abstract int getAmount(FluidState var1);

    @Override
    public VoxelShape getShape(FluidState state, BlockGetter world, BlockPos pos) {
        return state.getAmount() == 9 && FlowingFluid.hasSameAbove(state, world, pos) ? Shapes.block() : this.shapes.computeIfAbsent(state, fluid1 -> Shapes.box(0.0, 0.0, 0.0, 1.0, fluid1.getHeight(world, pos), 1.0));
    }

    protected class SpreadContext {
        private final BlockGetter level;
        private final BlockPos origin;
        private final Short2ObjectMap<BlockState> stateCache = new Short2ObjectOpenHashMap();
        private final Short2BooleanMap holeCache = new Short2BooleanOpenHashMap();

        SpreadContext(BlockGetter iblockaccess, BlockPos blockposition) {
            this.level = iblockaccess;
            this.origin = blockposition;
        }

        public BlockState getBlockState(BlockPos pos) {
            return this.getBlockState(pos, this.getCacheKey(pos));
        }

        @Nullable
        public BlockState getBlockStateIfLoaded(BlockPos pos) {
            return this.getBlockState(pos, this.getCacheKey(pos), false);
        }

        private BlockState getBlockState(BlockPos pos, short packed) {
            return this.getBlockState(pos, packed, true);
        }

        @Nullable
        private BlockState getBlockState(BlockPos pos, short packed, boolean load) {
            BlockState blockState = (BlockState)this.stateCache.get(packed);
            if (blockState == null) {
                BlockState blockState2 = blockState = load ? this.level.getBlockState(pos) : this.level.getBlockStateIfLoaded(pos);
                if (blockState != null) {
                    this.stateCache.put(packed, (Object)blockState);
                }
            }
            return blockState;
        }

        public boolean isHole(BlockPos pos) {
            return this.holeCache.computeIfAbsent(this.getCacheKey(pos), short0 -> {
                BlockState iblockdata = this.getBlockState(pos, short0);
                BlockPos blockposition1 = pos.below();
                BlockState iblockdata1 = this.level.getBlockState(blockposition1);
                return FlowingFluid.this.isWaterHole(this.level, pos, iblockdata, blockposition1, iblockdata1);
            });
        }

        private short getCacheKey(BlockPos pos) {
            int i = pos.getX() - this.origin.getX();
            int j = pos.getZ() - this.origin.getZ();
            return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
        }
    }

    private record BlockStatePairKey(BlockState first, BlockState second, Direction direction) {
        @Override
        public boolean equals(Object object) {
            if (object instanceof BlockStatePairKey) {
                BlockStatePairKey fluidtypeflowing_a = (BlockStatePairKey)object;
                if (this.first == fluidtypeflowing_a.first && this.second == fluidtypeflowing_a.second && this.direction == fluidtypeflowing_a.direction) {
                    boolean flag = true;
                    return flag;
                }
            }
            boolean flag = false;
            return flag;
        }

        @Override
        public int hashCode() {
            int i = System.identityHashCode(this.first);
            i = 31 * i + System.identityHashCode(this.second);
            i = 31 * i + this.direction.hashCode();
            return i;
        }
    }
}

