/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;
import org.purpurmc.purpur.PurpurConfig;

public class PortalShape {
    private static final int MIN_WIDTH = 2;
    public static final int MAX_WIDTH = 21;
    private static final int MIN_HEIGHT = 3;
    public static final int MAX_HEIGHT = 21;
    private static final BlockBehaviour.StatePredicate FRAME = (iblockdata, iblockaccess, blockposition) -> iblockdata.is(Blocks.OBSIDIAN) || PurpurConfig.cryingObsidianValidForPortalFrame && iblockdata.is(Blocks.CRYING_OBSIDIAN);
    private static final float SAFE_TRAVEL_MAX_ENTITY_XY = 4.0f;
    private static final double SAFE_TRAVEL_MAX_VERTICAL_DELTA = 1.0;
    private final Direction.Axis axis;
    private final Direction rightDir;
    private final int numPortalBlocks;
    private final BlockPos bottomLeft;
    private final int height;
    private final int width;
    private final BlockStateListPopulator blocks;

    private PortalShape(Direction.Axis enumdirection_enumaxis, int i, Direction enumdirection, BlockPos blockposition, int j, int k, BlockStateListPopulator blocks) {
        this.blocks = blocks;
        this.axis = enumdirection_enumaxis;
        this.numPortalBlocks = i;
        this.rightDir = enumdirection;
        this.bottomLeft = blockposition;
        this.width = j;
        this.height = k;
    }

    public static Optional<PortalShape> findEmptyPortalShape(LevelAccessor world, BlockPos pos, Direction.Axis firstCheckedAxis) {
        return PortalShape.findPortalShape(world, pos, blockportalshape -> blockportalshape.isValid() && blockportalshape.numPortalBlocks == 0, firstCheckedAxis);
    }

    public static Optional<PortalShape> findPortalShape(LevelAccessor world, BlockPos pos, Predicate<PortalShape> validator, Direction.Axis firstCheckedAxis) {
        Optional<PortalShape> optional = Optional.of(PortalShape.findAnyShape(world, pos, firstCheckedAxis)).filter(validator);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis enumdirection_enumaxis1 = firstCheckedAxis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(PortalShape.findAnyShape(world, pos, enumdirection_enumaxis1)).filter(validator);
    }

    public static PortalShape findAnyShape(BlockGetter world, BlockPos pos, Direction.Axis axis) {
        BlockStateListPopulator blocks;
        Direction enumdirection = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        BlockPos blockposition1 = PortalShape.calculateBottomLeft(world, enumdirection, pos, blocks = new BlockStateListPopulator(((LevelAccessor)world).getMinecraftWorld()));
        if (blockposition1 == null) {
            return new PortalShape(axis, 0, enumdirection, pos, 0, 0, blocks);
        }
        int i = PortalShape.calculateWidth(world, blockposition1, enumdirection, blocks);
        if (i == 0) {
            return new PortalShape(axis, 0, enumdirection, blockposition1, 0, 0, blocks);
        }
        MutableInt mutableint = new MutableInt();
        int j = PortalShape.calculateHeight(world, blockposition1, enumdirection, i, mutableint, blocks);
        return new PortalShape(axis, mutableint.getValue(), enumdirection, blockposition1, i, j, blocks);
    }

    @Nullable
    private static BlockPos calculateBottomLeft(BlockGetter iblockaccess, Direction enumdirection, BlockPos blockposition, BlockStateListPopulator blocks) {
        int i = Math.max(iblockaccess.getMinY(), blockposition.getY() - 21);
        while (blockposition.getY() > i && PortalShape.isEmpty(iblockaccess.getBlockState(blockposition.below()))) {
            blockposition = blockposition.below();
        }
        Direction enumdirection1 = enumdirection.getOpposite();
        int j = PortalShape.getDistanceUntilEdgeAboveFrame(iblockaccess, blockposition, enumdirection1, blocks) - 1;
        return j < 0 ? null : blockposition.relative(enumdirection1, j);
    }

    private static int calculateWidth(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection, BlockStateListPopulator blocks) {
        int i = PortalShape.getDistanceUntilEdgeAboveFrame(iblockaccess, blockposition, enumdirection, blocks);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private static int getDistanceUntilEdgeAboveFrame(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection, BlockStateListPopulator blocks) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= 21; ++i) {
            blockposition_mutableblockposition.set(blockposition).move(enumdirection, i);
            BlockState iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
            if (!PortalShape.isEmpty(iblockdata)) {
                if (!FRAME.test(iblockdata, iblockaccess, blockposition_mutableblockposition)) break;
                blocks.setBlock(blockposition_mutableblockposition, iblockdata, 18);
                return i;
            }
            BlockState iblockdata1 = iblockaccess.getBlockState(blockposition_mutableblockposition.move(Direction.DOWN));
            if (!FRAME.test(iblockdata1, iblockaccess, blockposition_mutableblockposition)) break;
            blocks.setBlock(blockposition_mutableblockposition, iblockdata1, 18);
        }
        return 0;
    }

    private static int calculateHeight(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection, int i, MutableInt mutableint, BlockStateListPopulator blocks) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        int j = PortalShape.getDistanceUntilTop(iblockaccess, blockposition, enumdirection, blockposition_mutableblockposition, i, mutableint, blocks);
        return j >= 3 && j <= 21 && PortalShape.hasTopFrame(iblockaccess, blockposition, enumdirection, blockposition_mutableblockposition, i, j, blocks) ? j : 0;
    }

    private static boolean hasTopFrame(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection, BlockPos.MutableBlockPos blockposition_mutableblockposition, int i, int j, BlockStateListPopulator blocks) {
        for (int k = 0; k < i; ++k) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition1 = blockposition_mutableblockposition.set(blockposition).move(Direction.UP, j).move(enumdirection, k);
            if (!FRAME.test(iblockaccess.getBlockState(blockposition_mutableblockposition1), iblockaccess, blockposition_mutableblockposition1)) {
                return false;
            }
            blocks.setBlock(blockposition_mutableblockposition1, iblockaccess.getBlockState(blockposition_mutableblockposition1), 18);
        }
        return true;
    }

    private static int getDistanceUntilTop(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection, BlockPos.MutableBlockPos blockposition_mutableblockposition, int i, MutableInt mutableint, BlockStateListPopulator blocks) {
        for (int j = 0; j < 21; ++j) {
            blockposition_mutableblockposition.set(blockposition).move(Direction.UP, j).move(enumdirection, -1);
            if (!FRAME.test(iblockaccess.getBlockState(blockposition_mutableblockposition), iblockaccess, blockposition_mutableblockposition)) {
                return j;
            }
            blockposition_mutableblockposition.set(blockposition).move(Direction.UP, j).move(enumdirection, i);
            if (!FRAME.test(iblockaccess.getBlockState(blockposition_mutableblockposition), iblockaccess, blockposition_mutableblockposition)) {
                return j;
            }
            for (int k = 0; k < i; ++k) {
                blockposition_mutableblockposition.set(blockposition).move(Direction.UP, j).move(enumdirection, k);
                BlockState iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
                if (!PortalShape.isEmpty(iblockdata)) {
                    return j;
                }
                if (!iblockdata.is(Blocks.NETHER_PORTAL)) continue;
                mutableint.increment();
            }
            blocks.setBlock(blockposition_mutableblockposition.set(blockposition).move(Direction.UP, j).move(enumdirection, -1), iblockaccess.getBlockState(blockposition_mutableblockposition), 18);
            blocks.setBlock(blockposition_mutableblockposition.set(blockposition).move(Direction.UP, j).move(enumdirection, i), iblockaccess.getBlockState(blockposition_mutableblockposition), 18);
        }
        return 21;
    }

    private static boolean isEmpty(BlockState state) {
        return state.isAir() || state.is(BlockTags.FIRE) || state.is(Blocks.NETHER_PORTAL);
    }

    public boolean isValid() {
        return this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public boolean createPortalBlocks(LevelAccessor generatoraccess, net.minecraft.world.entity.Entity entity) {
        CraftWorld bworld = generatoraccess.getMinecraftWorld().getWorld();
        BlockState iblockdata = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue(NetherPortalBlock.AXIS, this.axis);
        BlockPos.betweenClosed(this.bottomLeft, this.bottomLeft.relative(Direction.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(blockposition -> this.blocks.setBlock((BlockPos)blockposition, iblockdata, 18));
        PortalCreateEvent event = new PortalCreateEvent(this.blocks.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.FIRE);
        generatoraccess.getMinecraftWorld().getServer().server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BlockPos.betweenClosed(this.bottomLeft, this.bottomLeft.relative(Direction.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(blockposition -> generatoraccess.setBlock((BlockPos)blockposition, iblockdata, 18));
        return true;
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }

    public static Vec3 getRelativePosition(BlockUtil.FoundRectangle portalRect, Direction.Axis portalAxis, Vec3 entityPos, EntityDimensions entityDimensions) {
        Direction.Axis enumdirection_enumaxis1;
        double d3;
        double d2;
        double d0 = (double)portalRect.axis1Size - (double)entityDimensions.width();
        double d1 = (double)portalRect.axis2Size - (double)entityDimensions.height();
        BlockPos blockposition = portalRect.minCorner;
        if (d0 > 0.0) {
            d2 = (double)blockposition.get(portalAxis) + (double)entityDimensions.width() / 2.0;
            d3 = Mth.clamp(Mth.inverseLerp(entityPos.get(portalAxis) - d2, 0.0, d0), 0.0, 1.0);
        } else {
            d3 = 0.5;
        }
        if (d1 > 0.0) {
            enumdirection_enumaxis1 = Direction.Axis.Y;
            d2 = Mth.clamp(Mth.inverseLerp(entityPos.get(enumdirection_enumaxis1) - (double)blockposition.get(enumdirection_enumaxis1), 0.0, d1), 0.0, 1.0);
        } else {
            d2 = 0.0;
        }
        enumdirection_enumaxis1 = portalAxis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        double d4 = entityPos.get(enumdirection_enumaxis1) - ((double)blockposition.get(enumdirection_enumaxis1) + 0.5);
        return new Vec3(d3, d2, d4);
    }

    public static Vec3 findCollisionFreePosition(Vec3 fallback, ServerLevel world, net.minecraft.world.entity.Entity entity, EntityDimensions dimensions) {
        if (dimensions.width() <= 4.0f && dimensions.height() <= 4.0f) {
            double d0 = (double)dimensions.height() / 2.0;
            Vec3 vec3d1 = fallback.add(0.0, d0, 0.0);
            VoxelShape voxelshape = Shapes.create(AABB.ofSize(vec3d1, dimensions.width(), 0.0, dimensions.width()).expandTowards(0.0, 1.0, 0.0).inflate(1.0E-6));
            Optional<Vec3> optional = world.findFreePosition(entity, voxelshape, vec3d1, dimensions.width(), dimensions.height(), dimensions.width());
            Optional<Vec3> optional1 = optional.map(vec3d2 -> vec3d2.subtract(0.0, d0, 0.0));
            return optional1.orElse(fallback);
        }
        return fallback;
    }
}

