/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class DefaultRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    public DefaultRedstoneWireEvaluator(RedStoneWireBlock wire) {
        super(wire);
    }

    @Override
    public void updatePowerStrength(Level world, BlockPos pos, BlockState state, @Nullable Orientation orientation, boolean blockAdded) {
        int i = this.calculateTargetStrength(world, pos);
        int oldPower = state.getValue(RedStoneWireBlock.POWER);
        if (oldPower != i) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(world, pos), oldPower, i);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            i = event.getNewCurrent();
        }
        if (oldPower != i) {
            if (world.getBlockState(pos) == state) {
                world.setBlock(pos, (BlockState)state.setValue(RedStoneWireBlock.POWER, i), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction enumdirection : Direction.values()) {
                set.add(pos.relative(enumdirection));
            }
            for (BlockPos blockposition1 : set) {
                world.updateNeighborsAt(blockposition1, this.wireBlock);
            }
        }
    }

    public int calculateTargetStrength(Level world, BlockPos pos) {
        int i = this.getBlockSignal(world, pos);
        return i == 15 ? i : Math.max(i, this.getIncomingWireSignal(world, pos));
    }
}

