/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.level.storage.loot.LootContextUser;

public class ValidationContext {
    private final ProblemReporter reporter;
    private final ContextKeySet contextKeySet;
    private final Optional<HolderGetter.Provider> resolver;
    private final Set<ResourceKey<?>> visitedElements;

    public ValidationContext(ProblemReporter errorReporter, ContextKeySet contextType, HolderGetter.Provider dataLookup) {
        this(errorReporter, contextType, Optional.of(dataLookup), Set.of());
    }

    public ValidationContext(ProblemReporter errorReporter, ContextKeySet contextType) {
        this(errorReporter, contextType, Optional.empty(), Set.of());
    }

    private ValidationContext(ProblemReporter errorReporter, ContextKeySet contextType, Optional<HolderGetter.Provider> dataLookup, Set<ResourceKey<?>> referenceStack) {
        this.reporter = errorReporter;
        this.contextKeySet = contextType;
        this.resolver = dataLookup;
        this.visitedElements = referenceStack;
    }

    public ValidationContext forChild(String name) {
        return new ValidationContext(this.reporter.forChild(name), this.contextKeySet, this.resolver, this.visitedElements);
    }

    public ValidationContext enterElement(String name, ResourceKey<?> key) {
        ImmutableSet set = ImmutableSet.builder().addAll(this.visitedElements).add(key).build();
        return new ValidationContext(this.reporter.forChild(name), this.contextKeySet, this.resolver, (Set<ResourceKey<?>>)set);
    }

    public boolean hasVisitedElement(ResourceKey<?> key) {
        return this.visitedElements.contains(key);
    }

    public void reportProblem(String message) {
        this.reporter.report(message);
    }

    public void validateContextUsage(LootContextUser contextAware) {
        Set<ContextKey<?>> set = contextAware.getReferencedContextParams();
        Sets.SetView set2 = Sets.difference(set, this.contextKeySet.allowed());
        if (!set2.isEmpty()) {
            this.reporter.report("Parameters " + String.valueOf(set2) + " are not provided in this context");
        }
    }

    public HolderGetter.Provider resolver() {
        return this.resolver.orElseThrow(() -> new UnsupportedOperationException("References not allowed"));
    }

    public boolean allowsReferences() {
        return this.resolver.isPresent();
    }

    public ValidationContext setContextKeySet(ContextKeySet contextType) {
        return new ValidationContext(this.reporter, contextType, this.resolver, this.visitedElements);
    }

    public ProblemReporter reporter() {
        return this.reporter;
    }
}

