/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class FunctionReference
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<FunctionReference> CODEC = RecordCodecBuilder.mapCodec(instance -> FunctionReference.commonFields(instance).and((App)ResourceKey.codec(Registries.ITEM_MODIFIER).fieldOf("name").forGetter(function -> function.name)).apply((Applicative)instance, FunctionReference::new));
    private final ResourceKey<LootItemFunction> name;

    private FunctionReference(List<LootItemCondition> conditions, ResourceKey<LootItemFunction> name) {
        super(conditions);
        this.name = name;
    }

    @Override
    public LootItemFunctionType<FunctionReference> getType() {
        return LootItemFunctions.REFERENCE;
    }

    @Override
    @Override
    public void validate(ValidationContext reporter) {
        if (!reporter.allowsReferences()) {
            reporter.reportProblem("Uses reference to " + String.valueOf(this.name.location()) + ", but references are not allowed");
            return;
        }
        if (reporter.hasVisitedElement(this.name)) {
            reporter.reportProblem("Function " + String.valueOf(this.name.location()) + " is recursively called");
            return;
        }
        super.validate(reporter);
        reporter.resolver().get(this.name).ifPresentOrElse(reference -> ((LootItemFunction)reference.value()).validate(reporter.enterElement(".{" + String.valueOf(this.name.location()) + "}", this.name)), () -> reporter.reportProblem("Unknown function table called " + String.valueOf(this.name.location())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected ItemStack run(ItemStack stack, LootContext context) {
        LootItemFunction lootItemFunction = context.getResolver().get(this.name).map(Holder::value).orElse(null);
        if (lootItemFunction == null) {
            LOGGER.warn("Unknown function: {}", (Object)this.name.location());
            return stack;
        }
        LootContext.VisitedEntry<LootItemFunction> visitedEntry = LootContext.createVisitedEntry(lootItemFunction);
        if (context.pushVisitedElement(visitedEntry)) {
            try {
                ItemStack itemStack = (ItemStack)lootItemFunction.apply(stack, context);
                return itemStack;
            }
            finally {
                context.popVisitedElement(visitedEntry);
            }
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> functionReference(ResourceKey<LootItemFunction> name) {
        return FunctionReference.simpleBuilder(conditions -> new FunctionReference((List<LootItemCondition>)conditions, name));
    }
}

