/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class SetNameFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SetNameFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetNameFunction.commonFields(instance).and(instance.group((App)ComponentSerialization.CODEC.optionalFieldOf("name").forGetter(function -> function.name), (App)LootContext.EntityTarget.CODEC.optionalFieldOf("entity").forGetter(function -> function.resolutionContext), (App)Target.CODEC.optionalFieldOf("target", (Object)Target.CUSTOM_NAME).forGetter(function -> function.target))).apply((Applicative)instance, SetNameFunction::new));
    private final Optional<Component> name;
    private final Optional<LootContext.EntityTarget> resolutionContext;
    private final Target target;

    private SetNameFunction(List<LootItemCondition> conditions, Optional<Component> name, Optional<LootContext.EntityTarget> entity, Target target) {
        super(conditions);
        this.name = name;
        this.resolutionContext = entity;
        this.target = target;
    }

    @Override
    public LootItemFunctionType<SetNameFunction> getType() {
        return LootItemFunctions.SET_NAME;
    }

    @Override
    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.resolutionContext.map(entity -> Set.of(entity.getParam())).orElse(Set.of());
    }

    public static UnaryOperator<Component> createResolver(LootContext context, @Nullable LootContext.EntityTarget sourceEntity) {
        Entity entity;
        if (sourceEntity != null && (entity = context.getOptionalParameter(sourceEntity.getParam())) != null) {
            CommandSourceStack commandSourceStack = entity.createCommandSourceStackForNameResolution(context.getLevel()).withPermission(2);
            return textComponent -> {
                try {
                    return ComponentUtils.updateForEntity(commandSourceStack, textComponent, entity, 0);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    LOGGER.warn("Failed to resolve text component", (Throwable)commandSyntaxException);
                    return textComponent;
                }
            };
        }
        return textComponent -> textComponent;
    }

    @Override
    @Override
    public ItemStack run(ItemStack stack, LootContext context) {
        this.name.ifPresent(name -> stack.set(this.target.component(), (Component)SetNameFunction.createResolver(context, this.resolutionContext.orElse(null)).apply((Component)name)));
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> setName(Component name, Target target) {
        return SetNameFunction.simpleBuilder(conditions -> new SetNameFunction((List<LootItemCondition>)conditions, Optional.of(name), Optional.empty(), target));
    }

    public static LootItemConditionalFunction.Builder<?> setName(Component name, Target target, LootContext.EntityTarget entity) {
        return SetNameFunction.simpleBuilder(conditions -> new SetNameFunction((List<LootItemCondition>)conditions, Optional.of(name), Optional.of(entity), target));
    }

    public static enum Target implements StringRepresentable
    {
        CUSTOM_NAME("custom_name"),
        ITEM_NAME("item_name");

        public static final Codec<Target> CODEC;
        private final String name;

        private Target(String id) {
            this.name = id;
        }

        @Override
        @Override
        public String getSerializedName() {
            return this.name;
        }

        public DataComponentType<Component> component() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> DataComponents.ITEM_NAME;
                case 0 -> DataComponents.CUSTOM_NAME;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(Target::values);
        }
    }
}

