/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.timers;

import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.world.level.timers.TimerCallback;
import net.minecraft.world.level.timers.TimerQueue;

public class FunctionTagCallback
implements TimerCallback<MinecraftServer> {
    final ResourceLocation tagId;

    public FunctionTagCallback(ResourceLocation name) {
        this.tagId = name;
    }

    @Override
    @Override
    public void handle(MinecraftServer minecraftServer, TimerQueue<MinecraftServer> timerQueue, long l) {
        ServerFunctionManager serverFunctionManager = minecraftServer.getFunctions();
        List<CommandFunction<CommandSourceStack>> list = serverFunctionManager.getTag(this.tagId);
        for (CommandFunction<CommandSourceStack> commandFunction : list) {
            serverFunctionManager.execute(commandFunction, serverFunctionManager.getGameLoopSender());
        }
    }

    @Override
    public /* synthetic */ void handle(Object server, TimerQueue events, long time) {
        this.handle((MinecraftServer)server, (TimerQueue<MinecraftServer>)events, time);
    }

    public static class Serializer
    extends TimerCallback.Serializer<MinecraftServer, FunctionTagCallback> {
        public Serializer() {
            super(ResourceLocation.withDefaultNamespace("function_tag"), FunctionTagCallback.class);
        }

        @Override
        @Override
        public void serialize(CompoundTag nbt, FunctionTagCallback callback) {
            nbt.putString("Name", callback.tagId.toString());
        }

        @Override
        @Override
        public FunctionTagCallback deserialize(CompoundTag compoundTag) {
            ResourceLocation resourceLocation = ResourceLocation.parse(compoundTag.getString("Name"));
            return new FunctionTagCallback(resourceLocation);
        }

        @Override
        public /* synthetic */ TimerCallback deserialize(CompoundTag nbt) {
            return this.deserialize(nbt);
        }
    }
}

