/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockHitResult
extends HitResult {
    private final Direction direction;
    private final BlockPos blockPos;
    private final boolean miss;
    private final boolean inside;
    private final boolean worldBorderHit;

    public static BlockHitResult miss(Vec3 pos, Direction side, BlockPos blockPos) {
        return new BlockHitResult(true, pos, side, blockPos, false, false);
    }

    public BlockHitResult(Vec3 pos, Direction side, BlockPos blockPos, boolean insideBlock) {
        this(false, pos, side, blockPos, insideBlock, false);
    }

    public BlockHitResult(Vec3 pos, Direction side, BlockPos blockPos, boolean insideBlock, boolean againstWorldBorder) {
        this(false, pos, side, blockPos, insideBlock, againstWorldBorder);
    }

    private BlockHitResult(boolean missed, Vec3 pos, Direction side, BlockPos blockPos, boolean insideBlock, boolean againstWorldBorder) {
        super(pos);
        this.miss = missed;
        this.direction = side;
        this.blockPos = blockPos;
        this.inside = insideBlock;
        this.worldBorderHit = againstWorldBorder;
    }

    public BlockHitResult withDirection(Direction side) {
        return new BlockHitResult(this.miss, this.location, side, this.blockPos, this.inside, this.worldBorderHit);
    }

    public BlockHitResult withPosition(BlockPos blockPos) {
        return new BlockHitResult(this.miss, this.location, this.direction, blockPos, this.inside, this.worldBorderHit);
    }

    public BlockHitResult hitBorder() {
        return new BlockHitResult(this.miss, this.location, this.direction, this.blockPos, this.inside, true);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    @Override
    public HitResult.Type getType() {
        return this.miss ? HitResult.Type.MISS : HitResult.Type.BLOCK;
    }

    public boolean isInside() {
        return this.inside;
    }

    public boolean isWorldBorderHit() {
        return this.worldBorderHit;
    }
}

