/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MinecartCollisionContext
extends EntityCollisionContext {
    @Nullable
    private BlockPos ingoreBelow;
    @Nullable
    private BlockPos slopeIgnore;

    protected MinecartCollisionContext(AbstractMinecart minecart, boolean collidesWithFluid) {
        super(minecart, collidesWithFluid);
        this.setupContext(minecart);
    }

    private void setupContext(AbstractMinecart minecart) {
        BlockPos blockPos = minecart.getCurrentBlockPosOrRailBelow();
        BlockState blockState = minecart.level().getBlockState(blockPos);
        boolean bl = BaseRailBlock.isRail(blockState);
        if (bl) {
            this.ingoreBelow = blockPos.below();
            RailShape railShape = blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty());
            if (railShape.isSlope()) {
                this.slopeIgnore = switch (railShape) {
                    case RailShape.ASCENDING_EAST -> blockPos.east();
                    case RailShape.ASCENDING_WEST -> blockPos.west();
                    case RailShape.ASCENDING_NORTH -> blockPos.north();
                    case RailShape.ASCENDING_SOUTH -> blockPos.south();
                    default -> null;
                };
            }
        }
    }

    @Override
    @Override
    public VoxelShape getCollisionShape(BlockState state, CollisionGetter world, BlockPos pos) {
        if (pos.equals(this.ingoreBelow) || pos.equals(this.slopeIgnore)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, world, pos);
    }
}

