/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.DiscreteCubeMerger;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.IdenticalMerger;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.IndirectMerger;
import net.minecraft.world.phys.shapes.NonOverlappingMerger;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class Shapes {
    public static final double EPSILON = 1.0E-7;
    public static final double BIG_EPSILON = 1.0E-6;
    private static final VoxelShape BLOCK = Util.make(() -> {
        BitSetDiscreteVoxelShape shape = new BitSetDiscreteVoxelShape(1, 1, 1);
        ((DiscreteVoxelShape)shape).fill(0, 0, 0);
        return new ArrayVoxelShape((DiscreteVoxelShape)shape, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE);
    });
    public static final VoxelShape INFINITY = Shapes.box(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape EMPTY = new ArrayVoxelShape((DiscreteVoxelShape)new BitSetDiscreteVoxelShape(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));
    private static final DoubleArrayList[] PARTS_BY_BITS = new DoubleArrayList[]{DoubleArrayList.wrap((double[])Shapes.generateCubeParts(1)), DoubleArrayList.wrap((double[])Shapes.generateCubeParts(2)), DoubleArrayList.wrap((double[])Shapes.generateCubeParts(4)), DoubleArrayList.wrap((double[])Shapes.generateCubeParts(8))};

    public static VoxelShape empty() {
        return EMPTY;
    }

    public static VoxelShape block() {
        return BLOCK;
    }

    private static double[] generateCubeParts(int parts) {
        double inc = 1.0 / (double)parts;
        double[] ret = new double[parts + 1];
        double val = 0.0;
        for (int i = 0; i <= parts; ++i) {
            ret[i] = val;
            val += inc;
        }
        return ret;
    }

    public static VoxelShape box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(minX > maxX || minY > maxY || minZ > maxZ)) {
            return Shapes.create(minX, minY, minZ, maxX, maxY, maxZ);
        }
        throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
    }

    public static VoxelShape create(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7)) {
            int bitsX = Shapes.findBits(minX, maxX);
            int bitsY = Shapes.findBits(minY, maxY);
            int bitsZ = Shapes.findBits(minZ, maxZ);
            if (bitsX >= 0 && bitsY >= 0 && bitsZ >= 0) {
                if (bitsX == 0 && bitsY == 0 && bitsZ == 0) {
                    return BLOCK;
                }
                int sizeX = 1 << bitsX;
                int sizeY = 1 << bitsY;
                int sizeZ = 1 << bitsZ;
                BitSetDiscreteVoxelShape shape = BitSetDiscreteVoxelShape.withFilledBounds(sizeX, sizeY, sizeZ, (int)Math.round(minX * (double)sizeX), (int)Math.round(minY * (double)sizeY), (int)Math.round(minZ * (double)sizeZ), (int)Math.round(maxX * (double)sizeX), (int)Math.round(maxY * (double)sizeY), (int)Math.round(maxZ * (double)sizeZ));
                return new ArrayVoxelShape((DiscreteVoxelShape)shape, (DoubleList)PARTS_BY_BITS[bitsX], (DoubleList)PARTS_BY_BITS[bitsY], (DoubleList)PARTS_BY_BITS[bitsZ]);
            }
            return new ArrayVoxelShape(Shapes.BLOCK.shape, (DoubleList)(minX == 0.0 && maxX == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minX, maxX})), (DoubleList)(minY == 0.0 && maxY == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minY, maxY})), (DoubleList)(minZ == 0.0 && maxZ == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minZ, maxZ})));
        }
        return EMPTY;
    }

    public static VoxelShape create(AABB box) {
        return Shapes.create(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    @VisibleForTesting
    protected static int findBits(double min, double max) {
        if (!(min < -1.0E-7) && !(max > 1.0000001)) {
            for (int i = 0; i <= 3; ++i) {
                boolean bl2;
                int j = 1 << i;
                double d = min * (double)j;
                double e = max * (double)j;
                boolean bl = Math.abs(d - (double)Math.round(d)) < 1.0E-7 * (double)j;
                boolean bl3 = bl2 = Math.abs(e - (double)Math.round(e)) < 1.0E-7 * (double)j;
                if (!bl || !bl2) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    protected static long lcm(int a, int b) {
        return (long)a * (long)(b / IntMath.gcd((int)a, (int)b));
    }

    public static VoxelShape or(VoxelShape first, VoxelShape second) {
        return Shapes.join(first, second, BooleanOp.OR);
    }

    public static VoxelShape or(VoxelShape shape, VoxelShape ... others) {
        int size = others.length;
        if (size == 0) {
            return shape;
        }
        VoxelShape[] tmp = Arrays.copyOf(others, ++size);
        tmp[size - 1] = shape;
        while (size > 1) {
            int newSize = 0;
            for (int i = 0; i < size; i += 2) {
                int next = i + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i];
                    break;
                }
                VoxelShape first = tmp[i];
                VoxelShape second = tmp[next];
                tmp[newSize++] = Shapes.joinUnoptimized(first, second, BooleanOp.OR);
            }
            size = newSize;
        }
        return tmp[0].optimize();
    }

    public static VoxelShape join(VoxelShape first, VoxelShape second, BooleanOp function) {
        return CollisionUtil.joinOptimized(first, second, function);
    }

    public static VoxelShape joinUnoptimized(VoxelShape one, VoxelShape two, BooleanOp function) {
        return CollisionUtil.joinUnoptimized(one, two, function);
    }

    public static boolean joinIsNotEmpty(VoxelShape shape1, VoxelShape shape2, BooleanOp predicate) {
        return CollisionUtil.isJoinNonEmpty(shape1, shape2, predicate);
    }

    private static boolean joinIsNotEmpty(IndexMerger mergedX, IndexMerger mergedY, IndexMerger mergedZ, DiscreteVoxelShape shape1, DiscreteVoxelShape shape2, BooleanOp predicate) {
        return !mergedX.forMergedIndexes((x1, x2, index1) -> mergedY.forMergedIndexes((y1, y2, index2) -> mergedZ.forMergedIndexes((z1, z2, index3) -> !predicate.apply(shape1.isFullWide(x1, y1, z1), shape2.isFullWide(x2, y2, z2)))));
    }

    public static double collide(Direction.Axis axis, AABB box, Iterable<VoxelShape> shapes, double maxDist) {
        for (VoxelShape voxelShape : shapes) {
            if (Math.abs(maxDist) < 1.0E-7) {
                return 0.0;
            }
            maxDist = voxelShape.collide(axis, box, maxDist);
        }
        return maxDist;
    }

    public static boolean blockOccudes(VoxelShape first, VoxelShape second, Direction direction) {
        boolean secondBlock;
        boolean firstBlock = first == BLOCK;
        boolean bl = secondBlock = second == BLOCK;
        if (firstBlock & secondBlock) {
            return true;
        }
        if (first.isEmpty() | second.isEmpty()) {
            return false;
        }
        VoxelShape newFirst = first.moonrise$getFaceShapeClamped(direction);
        if (newFirst.isEmpty()) {
            return false;
        }
        VoxelShape newSecond = second.moonrise$getFaceShapeClamped(direction.getOpposite());
        if (newSecond.isEmpty()) {
            return false;
        }
        return !Shapes.joinIsNotEmpty(newFirst, newSecond, BooleanOp.ONLY_FIRST);
    }

    private static boolean mergedMayOccludeBlock(VoxelShape shape1, VoxelShape shape2) {
        AABB bounds1 = shape1.bounds();
        AABB bounds2 = shape2.bounds();
        double minX = Math.min(bounds1.minX, bounds2.minX);
        double minY = Math.min(bounds1.minY, bounds2.minY);
        double minZ = Math.min(bounds1.minZ, bounds2.minZ);
        double maxX = Math.max(bounds1.maxX, bounds2.maxX);
        double maxY = Math.max(bounds1.maxY, bounds2.maxY);
        double maxZ = Math.max(bounds1.maxZ, bounds2.maxZ);
        return minX <= 1.0E-7 && maxX >= 0.9999999 && minY <= 1.0E-7 && maxY >= 0.9999999 && minZ <= 1.0E-7 && maxZ >= 0.9999999;
    }

    public static boolean mergedFaceOccludes(VoxelShape first, VoxelShape second, Direction direction) {
        boolean secondEmpty;
        if (first.moonrise$occludesFullBlockIfCached() || second.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        if (first.isEmpty() & second.isEmpty()) {
            return false;
        }
        VoxelShape newFirst = first.moonrise$getFaceShapeClamped(direction);
        VoxelShape newSecond = second.moonrise$getFaceShapeClamped(direction.getOpposite());
        if (newFirst.moonrise$occludesFullBlockIfCached() || newSecond.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean firstEmpty = newFirst.isEmpty();
        if (firstEmpty & (secondEmpty = newSecond.isEmpty())) {
            return false;
        }
        if (firstEmpty | secondEmpty) {
            return secondEmpty ? newFirst.moonrise$occludesFullBlock() : newSecond.moonrise$occludesFullBlock();
        }
        if (newFirst == newSecond) {
            return newFirst.moonrise$occludesFullBlock();
        }
        return Shapes.mergedMayOccludeBlock(newFirst, newSecond) && newFirst.moonrise$orUnoptimized(newSecond).moonrise$occludesFullBlock();
    }

    public static boolean faceShapeOccludes(VoxelShape shape1, VoxelShape shape2) {
        boolean s2Empty;
        if (shape1.moonrise$occludesFullBlockIfCached() || shape2.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean s1Empty = shape1.isEmpty();
        if (s1Empty & (s2Empty = shape2.isEmpty())) {
            return false;
        }
        if (s1Empty | s2Empty) {
            return s2Empty ? shape1.moonrise$occludesFullBlock() : shape2.moonrise$occludesFullBlock();
        }
        if (shape1 == shape2) {
            return shape1.moonrise$occludesFullBlock();
        }
        return Shapes.mergedMayOccludeBlock(shape1, shape2) && shape1.moonrise$orUnoptimized(shape2).moonrise$occludesFullBlock();
    }

    @VisibleForTesting
    private static IndexMerger createIndexMerger(int size, DoubleList first, DoubleList second, boolean includeFirst, boolean includeSecond) {
        if (first.getDouble(0) == Double.NEGATIVE_INFINITY && first.getDouble(first.size() - 1) == Double.POSITIVE_INFINITY) {
            return new IndirectMerger(first, second, includeFirst, includeSecond);
        }
        return Shapes.lessCommonMerge(size, first, second, includeFirst, includeSecond);
    }

    private static IndexMerger lessCommonMerge(int size, DoubleList first, DoubleList second, boolean includeFirst, boolean includeSecond) {
        long l;
        int i = first.size() - 1;
        int j = second.size() - 1;
        if (first instanceof CubePointRange && second instanceof CubePointRange && (long)size * (l = Shapes.lcm(i, j)) <= 256L) {
            return new DiscreteCubeMerger(i, j);
        }
        if (i == j && Objects.equals(first, second)) {
            if (first instanceof IdenticalMerger) {
                return (IndexMerger)first;
            }
            if (second instanceof IdenticalMerger) {
                return (IndexMerger)second;
            }
            return new IdenticalMerger(first);
        }
        if (first.getDouble(i) < second.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(first, second, false);
        }
        if (second.getDouble(j) < first.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(second, first, true);
        }
        return new IndirectMerger(first, second, includeFirst, includeSecond);
    }

    public static interface DoubleLineConsumer {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

