/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.Hash;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public record SavedTick<T>(T type, BlockPos pos, int delay, TickPriority priority) {
    private static final String TAG_ID = "i";
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_Z = "z";
    private static final String TAG_DELAY = "t";
    private static final String TAG_PRIORITY = "p";
    public static final Hash.Strategy<SavedTick<?>> UNIQUE_TICK_HASH = new Hash.Strategy<SavedTick<?>>(){

        @Override
        public int hashCode(SavedTick<?> savedTick) {
            return 31 * savedTick.pos().hashCode() + savedTick.type().hashCode();
        }

        @Override
        public boolean equals(@Nullable SavedTick<?> savedTick, @Nullable SavedTick<?> savedTick2) {
            if (savedTick == savedTick2) {
                return true;
            }
            if (savedTick == null || savedTick2 == null) {
                return false;
            }
            return savedTick.type() == savedTick2.type() && savedTick.pos().equals(savedTick2.pos());
        }

        public /* synthetic */ boolean equals(@Nullable Object object, @Nullable Object object2) {
            return this.equals((SavedTick)object, (SavedTick)object2);
        }

        public /* synthetic */ int hashCode(Object object) {
            return this.hashCode((SavedTick)object);
        }
    };

    public static <T> List<SavedTick<T>> loadTickList(ListTag tickList, Function<String, Optional<T>> nameToTypeFunction, ChunkPos pos) {
        ArrayList list = new ArrayList(tickList.size());
        long l = pos.toLong();
        for (int i = 0; i < tickList.size(); ++i) {
            CompoundTag compoundTag = tickList.getCompound(i);
            SavedTick.loadTick(compoundTag, nameToTypeFunction).ifPresent(tick -> {
                if (ChunkPos.asLong(tick.pos()) == l) {
                    list.add((SavedTick)tick);
                }
            });
        }
        return list;
    }

    public static <T> Optional<SavedTick<T>> loadTick(CompoundTag nbt, Function<String, Optional<T>> nameToType) {
        return nameToType.apply(nbt.getString(TAG_ID)).map(type -> {
            BlockPos blockPos = new BlockPos(nbt.getInt(TAG_X), nbt.getInt(TAG_Y), nbt.getInt(TAG_Z));
            return new SavedTick<Object>(type, blockPos, nbt.getInt(TAG_DELAY), TickPriority.byValue(nbt.getInt(TAG_PRIORITY)));
        });
    }

    private static CompoundTag saveTick(String type, BlockPos pos, int delay, TickPriority priority) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString(TAG_ID, type);
        compoundTag.putInt(TAG_X, pos.getX());
        compoundTag.putInt(TAG_Y, pos.getY());
        compoundTag.putInt(TAG_Z, pos.getZ());
        compoundTag.putInt(TAG_DELAY, delay);
        compoundTag.putInt(TAG_PRIORITY, priority.getValue());
        return compoundTag;
    }

    public CompoundTag save(Function<T, String> typeToNameFunction) {
        return SavedTick.saveTick(typeToNameFunction.apply(this.type), this.pos, this.delay, this.priority);
    }

    public ScheduledTick<T> unpack(long time, long subTickOrder) {
        return new ScheduledTick<T>(this.type, this.pos, time + (long)this.delay, this.priority, subTickOrder);
    }

    public static <T> SavedTick<T> probe(T type, BlockPos pos) {
        return new SavedTick<T>(type, pos, 0, TickPriority.NORMAL);
    }
}

