/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import java.util.Locale;
import net.minecraft.core.registries.Registries;
import org.bukkit.Fluid;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftFluid
implements Fluid,
Handleable<net.minecraft.world.level.material.Fluid> {
    private static int count = 0;
    private final NamespacedKey key;
    private final net.minecraft.world.level.material.Fluid fluidType;
    private final String name;
    private final int ordinal;

    public static Fluid minecraftToBukkit(net.minecraft.world.level.material.Fluid minecraft) {
        return (Fluid)CraftRegistry.minecraftToBukkit(minecraft, Registries.FLUID, Registry.FLUID);
    }

    public static net.minecraft.world.level.material.Fluid bukkitToMinecraft(Fluid bukkit) {
        return (net.minecraft.world.level.material.Fluid)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftFluid(NamespacedKey key, net.minecraft.world.level.material.Fluid fluidType) {
        this.key = key;
        this.fluidType = fluidType;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
        this.ordinal = count++;
    }

    @Override
    public net.minecraft.world.level.material.Fluid getHandle() {
        return this.fluidType;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public int compareTo(@NotNull Fluid fluid) {
        return this.ordinal - fluid.ordinal();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftFluid)) {
            return false;
        }
        CraftFluid otherFluid = (CraftFluid)other;
        return this.getKey().equals((Object)otherFluid.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

