/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.destroystokyo.paper.block.BlockSoundGroup;
import com.destroystokyo.paper.block.CraftBlockSoundGroup;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.CraftSoundGroup;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.util.CraftVoxelShape;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class CraftBlock
implements org.bukkit.block.Block {
    private final LevelAccessor world;
    private final BlockPos position;

    public CraftBlock(LevelAccessor world, BlockPos position) {
        this.world = world;
        this.position = position.immutable();
    }

    public static CraftBlock at(LevelAccessor world, BlockPos position) {
        return new CraftBlock(world, position);
    }

    public net.minecraft.world.level.block.state.BlockState getNMS() {
        return this.world.getBlockState(this.position);
    }

    public FluidState getNMSFluid() {
        return this.world.getFluidState(this.position);
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public LevelAccessor getHandle() {
        return this.world;
    }

    public World getWorld() {
        return this.world.getMinecraftWorld().getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public Location getLocation() {
        return CraftLocation.toBukkit(this.position, this.getWorld());
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX((double)this.position.getX());
            loc.setY((double)this.position.getY());
            loc.setZ((double)this.position.getZ());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.getX(), this.getY(), this.getZ());
    }

    public int getX() {
        return this.position.getX();
    }

    public int getY() {
        return this.position.getY();
    }

    public int getZ() {
        return this.position.getZ();
    }

    public Chunk getChunk() {
        return this.getWorld().getChunkAt((org.bukkit.block.Block)this);
    }

    public void setData(byte data) {
        this.setData(data, 3);
    }

    public void setData(byte data, boolean applyPhysics) {
        if (applyPhysics) {
            this.setData(data, 3);
        } else {
            this.setData(data, 2);
        }
    }

    private void setData(byte data, int flag) {
        this.world.setBlock(this.position, CraftMagicNumbers.getBlock(this.getType(), data), flag);
    }

    public byte getData() {
        net.minecraft.world.level.block.state.BlockState blockData = this.world.getBlockState(this.position);
        return CraftMagicNumbers.toLegacyData(blockData);
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getNMS());
    }

    public void setType(Material type) {
        this.setType(type, true);
    }

    public void setType(Material type, boolean applyPhysics) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        this.setBlockData(type.createBlockData(), applyPhysics);
    }

    public void setBlockData(BlockData data) {
        this.setBlockData(data, true);
    }

    public void setBlockData(BlockData data, boolean applyPhysics) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        this.setTypeAndData(((CraftBlockData)data).getState(), applyPhysics);
    }

    boolean setTypeAndData(net.minecraft.world.level.block.state.BlockState blockData, boolean applyPhysics) {
        return CraftBlock.setTypeAndData(this.world, this.position, this.getNMS(), blockData, applyPhysics);
    }

    public static boolean setTypeAndData(LevelAccessor world, BlockPos position, net.minecraft.world.level.block.state.BlockState old, net.minecraft.world.level.block.state.BlockState blockData, boolean applyPhysics) {
        if (old.hasBlockEntity() && blockData.getBlock() != old.getBlock()) {
            if (world instanceof Level) {
                ((Level)world).removeBlockEntity(position);
            } else {
                world.setBlock(position, Blocks.AIR.defaultBlockState(), 0);
            }
        }
        if (applyPhysics) {
            return world.setBlock(position, blockData, 3);
        }
        boolean success = world.setBlock(position, blockData, 1042);
        if (success && world instanceof Level) {
            world.getMinecraftWorld().sendBlockUpdated(position, old, blockData, 3);
        }
        return success;
    }

    public Material getType() {
        return this.world.getBlockState(this.position).getBukkitMaterial();
    }

    public byte getLightLevel() {
        return (byte)this.world.getMinecraftWorld().getMaxLocalRawBrightness(this.position);
    }

    public byte getLightFromSky() {
        return (byte)this.world.getBrightness(LightLayer.SKY, this.position);
    }

    public byte getLightFromBlocks() {
        return (byte)this.world.getBrightness(LightLayer.BLOCK, this.position);
    }

    public org.bukkit.block.Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public org.bukkit.block.Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    public org.bukkit.block.Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    public org.bukkit.block.Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public org.bukkit.block.Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    public BlockFace getFace(org.bukkit.block.Block block) {
        BlockFace[] values;
        for (BlockFace face : values = BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{pos=" + String.valueOf(this.position) + ",type=" + String.valueOf(this.getType()) + ",data=" + String.valueOf(this.getNMS()) + ",fluid=" + String.valueOf(this.world.getFluidState(this.position)) + "}";
    }

    public static BlockFace notchToBlockFace(Direction notch) {
        if (notch == null) {
            return BlockFace.SELF;
        }
        switch (notch) {
            case DOWN: {
                return BlockFace.DOWN;
            }
            case UP: {
                return BlockFace.UP;
            }
            case NORTH: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static Direction blockFaceToNotch(BlockFace face) {
        if (face == null) {
            return null;
        }
        switch (face) {
            case DOWN: {
                return Direction.DOWN;
            }
            case UP: {
                return Direction.UP;
            }
            case NORTH: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.EAST;
            }
        }
        return null;
    }

    public BlockState getState() {
        return CraftBlockStates.getBlockState(this);
    }

    public BlockState getState(boolean useSnapshot) {
        return CraftBlockStates.getBlockState(this, useSnapshot);
    }

    public Biome getBiome() {
        return this.getWorld().getBiome(this.getX(), this.getY(), this.getZ());
    }

    public Biome getComputedBiome() {
        return this.getWorld().getComputedBiome(this.getX(), this.getY(), this.getZ());
    }

    public void setBiome(Biome bio) {
        this.getWorld().setBiome(this.getX(), this.getY(), this.getZ(), bio);
    }

    public double getTemperature() {
        return this.world.getBiome(this.position).value().getTemperature(this.position, this.world.getSeaLevel());
    }

    public double getHumidity() {
        return this.getWorld().getHumidity(this.getX(), this.getY(), this.getZ());
    }

    public boolean isBlockPowered() {
        return this.world.getMinecraftWorld().getDirectSignalTo(this.position) > 0;
    }

    public boolean isBlockIndirectlyPowered() {
        return this.world.getMinecraftWorld().hasNeighborSignal(this.position);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o;
        return this.position.equals(other.position) && this.getWorld().equals((Object)other.getWorld());
    }

    public int hashCode() {
        return this.position.hashCode() ^ this.getWorld().hashCode();
    }

    public boolean isBlockFacePowered(BlockFace face) {
        return this.world.getMinecraftWorld().hasSignal(this.position, CraftBlock.blockFaceToNotch(face));
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        int power = this.world.getMinecraftWorld().getSignal(this.position, CraftBlock.blockFaceToNotch(face));
        org.bukkit.block.Block relative = this.getRelative(face);
        if (relative.getType() == Material.REDSTONE_WIRE) {
            return Math.max(power, relative.getData()) > 0;
        }
        return power > 0;
    }

    public int getBlockPower(BlockFace face) {
        int power = 0;
        ServerLevel world = this.world.getMinecraftWorld();
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.hasSignal(new BlockPos(x, y - 1, z), Direction.DOWN)) {
            power = CraftBlock.getPower(power, world.getBlockState(new BlockPos(x, y - 1, z)));
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.hasSignal(new BlockPos(x, y + 1, z), Direction.UP)) {
            power = CraftBlock.getPower(power, world.getBlockState(new BlockPos(x, y + 1, z)));
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.hasSignal(new BlockPos(x + 1, y, z), Direction.EAST)) {
            power = CraftBlock.getPower(power, world.getBlockState(new BlockPos(x + 1, y, z)));
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.hasSignal(new BlockPos(x - 1, y, z), Direction.WEST)) {
            power = CraftBlock.getPower(power, world.getBlockState(new BlockPos(x - 1, y, z)));
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.hasSignal(new BlockPos(x, y, z - 1), Direction.NORTH)) {
            power = CraftBlock.getPower(power, world.getBlockState(new BlockPos(x, y, z - 1)));
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.hasSignal(new BlockPos(x, y, z + 1), Direction.SOUTH)) {
            power = CraftBlock.getPower(power, world.getBlockState(new BlockPos(x, y, z + 1)));
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    private static int getPower(int i, net.minecraft.world.level.block.state.BlockState iblockdata) {
        if (!iblockdata.is(Blocks.REDSTONE_WIRE)) {
            return i;
        }
        int j = iblockdata.getValue(RedStoneWireBlock.POWER);
        return j > i ? j : i;
    }

    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    public boolean isEmpty() {
        return this.getNMS().isAir();
    }

    public boolean isLiquid() {
        return this.getNMS().liquid();
    }

    public boolean isBuildable() {
        return this.getNMS().isSolid();
    }

    public boolean isBurnable() {
        return this.getNMS().ignitedByLava();
    }

    public boolean isReplaceable() {
        return this.getNMS().canBeReplaced();
    }

    public boolean isSolid() {
        return this.getNMS().blocksMotion();
    }

    public boolean isCollidable() {
        return this.getNMS().getBlock().hasCollision;
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.getNMS().getPistonPushReaction().ordinal());
    }

    public boolean breakNaturally() {
        return this.breakNaturally(null);
    }

    public boolean breakNaturally(ItemStack item) {
        return this.breakNaturally(item, false);
    }

    public boolean breakNaturally(boolean triggerEffect, boolean dropExperience) {
        return this.breakNaturally(null, triggerEffect, dropExperience);
    }

    public boolean breakNaturally(ItemStack item, boolean triggerEffect, boolean dropExperience) {
        boolean destroyed;
        net.minecraft.world.level.block.state.BlockState iblockdata = this.getNMS();
        Block block = iblockdata.getBlock();
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy(item);
        boolean result = false;
        if (block != Blocks.AIR && (item == null || !iblockdata.requiresCorrectToolForDrops() || nmsItem.isCorrectToolForDrops(iblockdata))) {
            Block.dropResources(iblockdata, this.world.getMinecraftWorld(), this.position, this.world.getBlockEntity(this.position), null, nmsItem, false);
            if (triggerEffect) {
                if (iblockdata.getBlock() instanceof BaseFireBlock) {
                    this.world.levelEvent(1009, this.position, 0);
                } else {
                    this.world.levelEvent(2001, this.position, Block.getId(iblockdata));
                }
            }
            if (dropExperience) {
                block.popExperience(this.world.getMinecraftWorld(), this.position, block.getExpDrop(iblockdata, this.world.getMinecraftWorld(), this.position, nmsItem, true));
            }
            result = true;
        }
        if (destroyed = this.world.removeBlock(this.position, false)) {
            block.destroy(this.world, this.position, iblockdata);
        }
        if (result) {
            if (block instanceof IceBlock) {
                IceBlock iceBlock = (IceBlock)block;
                iceBlock.afterDestroy(this.world.getMinecraftWorld(), this.position, nmsItem);
            } else if (block instanceof TurtleEggBlock) {
                TurtleEggBlock turtleEggBlock = (TurtleEggBlock)block;
                turtleEggBlock.decreaseEggs(this.world.getMinecraftWorld(), this.position, iblockdata);
            }
        }
        return destroyed && result;
    }

    public boolean applyBoneMeal(BlockFace face) {
        Direction direction = CraftBlock.blockFaceToNotch(face);
        BlockFertilizeEvent event = null;
        ServerLevel world = this.getCraftWorld().getHandle();
        UseOnContext context = new UseOnContext(world, null, InteractionHand.MAIN_HAND, Items.BONE_MEAL.getDefaultInstance(), new BlockHitResult(Vec3.ZERO, direction, this.getPosition(), false));
        world.captureTreeGeneration = true;
        InteractionResult result = BoneMealItem.applyBonemeal(context);
        world.captureTreeGeneration = false;
        if (world.capturedBlockStates.size() > 0) {
            TreeType treeType = SaplingBlock.treeType;
            SaplingBlock.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                structureEvent = new StructureGrowEvent(this.getLocation(), treeType, true, null, blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            event = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, this.getPosition()), null, blocks);
            event.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                for (BlockState blockState : blocks) {
                    blockState.update(true);
                    world.checkCapturedTreeStateForObserverNotify(this.position, (CraftBlockState)blockState);
                }
            }
        }
        return result == InteractionResult.CONSUME && (event == null || !event.isCancelled());
    }

    public Collection<ItemStack> getDrops() {
        return this.getDrops(null);
    }

    public Collection<ItemStack> getDrops(ItemStack item) {
        return this.getDrops(item, null);
    }

    public Collection<ItemStack> getDrops(ItemStack item, Entity entity) {
        net.minecraft.world.level.block.state.BlockState iblockdata = this.getNMS();
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(item);
        if (item == null || CraftBlockData.isPreferredTool(iblockdata, nms)) {
            return Block.getDrops(iblockdata, this.world.getMinecraftWorld(), this.position, this.world.getBlockEntity(this.position), entity == null ? null : ((CraftEntity)entity).getHandle(), nms).stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean isPreferredTool(ItemStack item) {
        net.minecraft.world.level.block.state.BlockState iblockdata = this.getNMS();
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(item);
        return CraftBlockData.isPreferredTool(iblockdata, nms);
    }

    public float getBreakSpeed(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        return this.getNMS().getDestroyProgress(((CraftPlayer)player).getHandle(), this.world, this.position);
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.getCraftWorld().getBlockMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.getCraftWorld().getBlockMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.getCraftWorld().getBlockMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.getCraftWorld().getBlockMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public boolean isPassable() {
        return this.getNMS().getCollisionShape(this.world, this.position).isEmpty();
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((boolean)this.getWorld().equals((Object)start.getWorld()), (Object)"Location start cannot be a different world");
        start.checkFinite();
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) must be greater than 0", (Object)direction.lengthSquared());
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"FluidCollisionMode cannot be null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vec3 startPos = CraftLocation.toVec3D(start);
        Vec3 endPos = startPos.add(dir.getX(), dir.getY(), dir.getZ());
        BlockHitResult nmsHitResult = this.world.clip(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, CraftFluidCollisionMode.toNMS(fluidCollisionMode), CollisionContext.empty()), this.position);
        return CraftRayTraceResult.fromNMS(this.getWorld(), nmsHitResult);
    }

    public BoundingBox getBoundingBox() {
        VoxelShape shape = this.getNMS().getShape(this.world, this.position);
        if (shape.isEmpty()) {
            return new BoundingBox();
        }
        AABB aabb = shape.bounds();
        return new BoundingBox((double)this.getX() + aabb.minX, (double)this.getY() + aabb.minY, (double)this.getZ() + aabb.minZ, (double)this.getX() + aabb.maxX, (double)this.getY() + aabb.maxY, (double)this.getZ() + aabb.maxZ);
    }

    public org.bukkit.util.VoxelShape getCollisionShape() {
        VoxelShape shape = this.getNMS().getCollisionShape(this.world, this.position);
        return new CraftVoxelShape(shape);
    }

    public boolean canPlace(BlockData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        net.minecraft.world.level.block.state.BlockState iblockdata = ((CraftBlockData)data).getState();
        ServerLevel world = this.world.getMinecraftWorld();
        return iblockdata.canSurvive(world, this.position);
    }

    public String getTranslationKey() {
        return this.getNMS().getBlock().getDescriptionId();
    }

    public BlockSoundGroup getSoundGroup() {
        return new CraftBlockSoundGroup(this.getNMS().getBlock().defaultBlockState().getSoundType());
    }

    public SoundGroup getBlockSoundGroup() {
        return CraftSoundGroup.getSoundGroup(this.getNMS().getSoundType());
    }

    public String translationKey() {
        return this.getNMS().getBlock().getDescriptionId();
    }

    public boolean isValidTool(ItemStack itemStack) {
        return this.getDrops(itemStack).size() != 0;
    }

    public void tick() {
        ServerLevel level = this.world.getMinecraftWorld();
        this.getNMS().tick(level, this.position, level.random);
    }

    public void fluidTick() {
        this.getNMSFluid().tick(this.world.getMinecraftWorld(), this.position, this.getNMS());
    }

    public void randomTick() {
        ServerLevel level = this.world.getMinecraftWorld();
        this.getNMS().randomTick(level, this.position, level.random);
    }
}

