/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.entity.CraftMinecart;
import org.bukkit.craftbukkit.spawner.PaperSharedSpawnerLogic;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.minecart.SpawnerMinecart;

final class CraftMinecartMobSpawner
extends CraftMinecart
implements SpawnerMinecart,
PaperSharedSpawnerLogic {
    CraftMinecartMobSpawner(CraftServer server, MinecartSpawner entity) {
        super(server, entity);
    }

    public EntityType getSpawnedType() {
        SpawnData spawnData = this.getHandle().getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        Optional<net.minecraft.world.entity.EntityType<?>> type = net.minecraft.world.entity.EntityType.by(spawnData.getEntityToSpawn());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            this.getHandle().getSpawner().spawnPotentials = SimpleWeightedRandomList.empty();
            this.getHandle().getSpawner().nextSpawnData = new SpawnData();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.getHandle().level().getRandom();
        this.getHandle().getSpawner().setEntityId(CraftEntityType.bukkitToMinecraft(entityType), this.getHandle().level(), rand, this.getHandle().blockPosition());
    }

    public EntitySnapshot getSpawnedEntity() {
        SpawnData spawnData = this.getHandle().getSpawner().nextSpawnData;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.getEntityToSpawn());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(this.getHandle().getSpawner(), snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(this.getHandle().getSpawner(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(this.getHandle().getSpawner(), snapshot, weight, spawnRule, null);
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.addPotentialSpawn(this.getHandle().getSpawner(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(this.getHandle().getSpawner(), entries);
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(this.getHandle().getSpawner());
    }

    public int getDelay() {
        return this.getHandle().getSpawner().spawnDelay;
    }

    public void setDelay(int delay) {
        this.getHandle().getSpawner().spawnDelay = delay;
    }

    public int getMinSpawnDelay() {
        return this.getHandle().getSpawner().minSpawnDelay;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        this.getHandle().getSpawner().minSpawnDelay = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return this.getHandle().getSpawner().maxSpawnDelay;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        this.getHandle().getSpawner().maxSpawnDelay = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return this.getHandle().getSpawner().maxNearbyEntities;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.getHandle().getSpawner().maxNearbyEntities = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return this.getHandle().getSpawner().spawnCount;
    }

    public void setSpawnCount(int count) {
        this.getHandle().getSpawner().spawnCount = count;
    }

    public int getRequiredPlayerRange() {
        return this.getHandle().getSpawner().requiredPlayerRange;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.getHandle().getSpawner().requiredPlayerRange = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return this.getHandle().getSpawner().spawnRange;
    }

    public void setSpawnRange(int spawnRange) {
        this.getHandle().getSpawner().spawnRange = spawnRange;
    }

    @Override
    public MinecartSpawner getHandle() {
        return (MinecartSpawner)this.entity;
    }

    @Override
    public String toString() {
        return "CraftMinecartMobSpawner";
    }

    @Override
    public BaseSpawner getSpawner() {
        return this.getHandle().getSpawner();
    }

    @Override
    public Level getInternalWorld() {
        return this.getHandle().level();
    }

    @Override
    public BlockPos getInternalPosition() {
        return this.getHandle().blockPosition();
    }
}

