/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.bukkit.Art;
import org.bukkit.Registry;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftArt;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftHanging;
import org.bukkit.entity.Painting;

public class CraftPainting
extends CraftHanging
implements Painting {
    public CraftPainting(CraftServer server, net.minecraft.world.entity.decoration.Painting entity) {
        super(server, entity);
    }

    public Art getArt() {
        return (Art)CraftRegistry.unwrapAndConvertHolder(Registry.ART, this.getHandle().getVariant()).orElseThrow(() -> new IllegalStateException("Inlined painting variants are not supported yet in the API!"));
    }

    public boolean setArt(Art art) {
        return this.setArt(art, false);
    }

    public boolean setArt(Art art, boolean force) {
        net.minecraft.world.entity.decoration.Painting painting = this.getHandle();
        Object oldArt = painting.getVariant();
        painting.setVariant(CraftArt.bukkitToMinecraftHolder(art));
        painting.setDirection(painting.getDirection());
        if (!(force || this.getHandle().generation || painting.survives())) {
            painting.setVariant((Holder<PaintingVariant>)oldArt);
            painting.setDirection(painting.getDirection());
            return false;
        }
        return true;
    }

    @Override
    public boolean setFacingDirection(BlockFace face, boolean force) {
        if (super.setFacingDirection(face, force)) {
            this.update();
            return true;
        }
        return false;
    }

    @Override
    public net.minecraft.world.entity.decoration.Painting getHandle() {
        return (net.minecraft.world.entity.decoration.Painting)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPainting{art=" + String.valueOf(this.getArt()) + "}";
    }
}

