/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.Optional;
import java.util.Random;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.craftbukkit.inventory.components.CraftEquippableComponent;
import org.bukkit.craftbukkit.inventory.components.CraftFoodComponent;
import org.bukkit.craftbukkit.inventory.components.CraftJukeboxComponent;
import org.bukkit.craftbukkit.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.inventory.components.CraftUseCooldownComponent;
import org.bukkit.craftbukkit.util.CraftLegacy;
import org.bukkit.craftbukkit.util.RandomSourceWrapper;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public final class CraftItemFactory
implements ItemFactory {
    static final Color DEFAULT_LEATHER_COLOR = Color.fromRGB((int)10511680);
    private static final CraftItemFactory instance;
    private static final RandomSource randomSource;

    private CraftItemFactory() {
    }

    public boolean isApplicable(ItemMeta meta, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return this.isApplicable(meta, itemstack.getType());
    }

    public boolean isApplicable(ItemMeta meta, Material type) {
        if ((type = CraftLegacy.fromLegacy(type)) == null || meta == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(meta instanceof CraftMetaItem), (String)"Meta of %s not created by %s", (Object)meta.getClass().toString(), (Object)CraftItemFactory.class.getName());
        return ((CraftMetaItem)meta).applicableTo(type);
    }

    public ItemMeta getItemMeta(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.getItemMeta(material, null);
    }

    private ItemMeta getItemMeta(Material material, CraftMetaItem meta) {
        if (!(material = CraftLegacy.fromLegacy(material)).isItem()) {
            return new CraftMetaItem(meta);
        }
        return ((CraftItemType)material.asItemType()).getItemMeta(meta);
    }

    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        if (meta1 == meta2) {
            return true;
        }
        if (meta1 == null) {
            return ((CraftMetaItem)meta2).isEmpty();
        }
        Preconditions.checkArgument((boolean)(meta1 instanceof CraftMetaItem), (String)"First meta of %s does not belong to %s", (Object)meta1.getClass().getName(), (Object)CraftItemFactory.class.getName());
        if (meta2 == null) {
            return ((CraftMetaItem)meta1).isEmpty();
        }
        Preconditions.checkArgument((boolean)(meta2 instanceof CraftMetaItem), (String)"Second meta of %s does not belong to %s", (Object)meta2.getClass().getName(), (Object)CraftItemFactory.class.getName());
        return this.equals((CraftMetaItem)meta1, (CraftMetaItem)meta2);
    }

    boolean equals(CraftMetaItem meta1, CraftMetaItem meta2) {
        return meta1.equalsCommon(meta2) && meta1.notUncommon(meta2) && meta2.notUncommon(meta1);
    }

    public static CraftItemFactory instance() {
        return instance;
    }

    public ItemMeta asMetaFor(ItemMeta meta, ItemStack stack) {
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"ItemStack stack cannot be null");
        return this.asMetaFor(meta, stack.getType());
    }

    public ItemMeta asMetaFor(ItemMeta meta, Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)(meta instanceof CraftMetaItem), (String)"ItemMeta of %s not created by %s", (Object)(meta != null ? meta.getClass().toString() : "null"), (Object)CraftItemFactory.class.getName());
        return this.getItemMeta(material, (CraftMetaItem)meta);
    }

    public Color getDefaultLeatherColor() {
        return DEFAULT_LEATHER_COLOR;
    }

    public ItemStack createItemStack(String input) throws IllegalArgumentException {
        try {
            ItemParser.ItemResult arg = new ItemParser(MinecraftServer.getDefaultRegistryAccess()).parse(new StringReader(input));
            Item item = arg.item().value();
            net.minecraft.world.item.ItemStack nmsItemStack = new net.minecraft.world.item.ItemStack(item);
            DataComponentPatch nbt = arg.components();
            if (nbt != null) {
                nmsItemStack.applyComponents(nbt);
            }
            return CraftItemStack.asCraftMirror(nmsItemStack);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse ItemStack: " + input, ex);
        }
    }

    public Material getSpawnEgg(EntityType type) {
        if (type == EntityType.UNKNOWN) {
            return null;
        }
        net.minecraft.world.entity.EntityType<?> nmsType = CraftEntityType.bukkitToMinecraft(type);
        SpawnEggItem nmsItem = SpawnEggItem.byId(nmsType);
        if (nmsItem == null) {
            return null;
        }
        return CraftItemType.minecraftToBukkit(nmsItem);
    }

    public ItemStack enchantItem(org.bukkit.entity.Entity entity, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"The entity must not be null");
        return CraftItemFactory.enchantItem(((CraftEntity)entity).getHandle().random, itemStack, level, allowTreasures);
    }

    public ItemStack enchantItem(World world, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"The world must not be null");
        return CraftItemFactory.enchantItem(((CraftWorld)world).getHandle().random, itemStack, level, allowTreasures);
    }

    public ItemStack enchantItem(ItemStack itemStack, int level, boolean allowTreasures) {
        return CraftItemFactory.enchantItem(randomSource, itemStack, level, allowTreasures);
    }

    private static ItemStack enchantItem(RandomSource source, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"ItemStack must not be null");
        Preconditions.checkArgument((!itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"ItemStack must not be air");
        itemStack = CraftItemStack.asCraftCopy(itemStack);
        CraftItemStack craft = (CraftItemStack)itemStack;
        RegistryAccess registry = CraftRegistry.getMinecraftRegistry();
        Optional optional = allowTreasures ? Optional.empty() : registry.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.IN_ENCHANTING_TABLE);
        return CraftItemStack.asCraftMirror(EnchantmentHelper.enchantItem(source, craft.handle, level, registry, optional));
    }

    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(ItemStack item, UnaryOperator<HoverEvent.ShowItem> op) {
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.showItem((Keyed)item.getType().getKey(), (int)item.getAmount(), PaperAdventure.asAdventure(CraftItemStack.unwrap(item).getComponentsPatch())))));
    }

    public @NotNull Component displayName(@NotNull ItemStack itemStack) {
        return PaperAdventure.asAdventure(CraftItemStack.asNMSCopy(itemStack).getDisplayName());
    }

    public ItemStack ensureServerConversions(ItemStack item) {
        return CraftItemStack.asCraftMirror(CraftItemStack.asNMSCopy(item));
    }

    public String getI18NDisplayName(ItemStack item) {
        net.minecraft.world.item.ItemStack nms = null;
        if (item instanceof CraftItemStack) {
            nms = ((CraftItemStack)item).handle;
        }
        if (nms == null) {
            nms = CraftItemStack.asNMSCopy(item);
        }
        return nms != null ? nms.getItem().getName(nms).getString() : null;
    }

    public Content hoverContentOf(ItemStack itemStack) {
        throw new UnsupportedOperationException("BungeeCord Chat API does not support data components");
    }

    public Content hoverContentOf(org.bukkit.entity.Entity entity) {
        return this.hoverContentOf(entity, (BaseComponent)(StringUtils.isBlank((CharSequence)entity.getCustomName()) ? null : new TextComponent(entity.getCustomName())));
    }

    public Content hoverContentOf(org.bukkit.entity.Entity entity, String customName) {
        return this.hoverContentOf(entity, (BaseComponent)(StringUtils.isBlank((CharSequence)customName) ? null : new TextComponent(customName)));
    }

    public Content hoverContentOf(org.bukkit.entity.Entity entity, BaseComponent customName) {
        return new Entity(entity.getType().getKey().toString(), entity.getUniqueId().toString(), customName);
    }

    public Content hoverContentOf(org.bukkit.entity.Entity entity, BaseComponent[] customName) {
        return new Entity(entity.getType().getKey().toString(), entity.getUniqueId().toString(), (BaseComponent)new TextComponent(customName));
    }

    @Deprecated
    public ItemStack getSpawnEgg0(EntityType type) {
        if (type == null) {
            return null;
        }
        String typeId = type.getKey().toString();
        ResourceLocation typeKey = ResourceLocation.parse(typeId);
        net.minecraft.world.entity.EntityType<?> nmsType = BuiltInRegistries.ENTITY_TYPE.getValue(typeKey);
        SpawnEggItem eggItem = SpawnEggItem.byId(nmsType);
        return eggItem == null ? null : new net.minecraft.world.item.ItemStack(eggItem).asBukkitMirror();
    }

    public ItemStack enchantWithLevels(ItemStack itemStack, int levels, boolean allowTreasure, Random random) {
        return this.enchantWithLevels(itemStack, levels, allowTreasure ? Optional.empty() : MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.IN_ENCHANTING_TABLE), random);
    }

    public ItemStack enchantWithLevels(ItemStack itemStack, int levels, RegistryKeySet<org.bukkit.enchantments.Enchantment> keySet, Random random) {
        return this.enchantWithLevels(itemStack, levels, Optional.of(PaperRegistrySets.convertToNms(Registries.ENCHANTMENT, MinecraftServer.getServer().registryAccess().createSerializationContext(NbtOps.INSTANCE).lookupProvider, keySet)), random);
    }

    private ItemStack enchantWithLevels(ItemStack itemStack, int levels, Optional<? extends HolderSet<Enchantment>> possibleEnchantments, Random random) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Argument 'itemStack' must not be null");
        Preconditions.checkArgument((!itemStack.isEmpty() ? 1 : 0) != 0, (Object)"Argument 'itemStack' cannot be empty");
        Preconditions.checkArgument((levels > 0 && levels <= 30 ? 1 : 0) != 0, (Object)("Argument 'levels' must be in range [1, 30] (attempted " + levels + ")"));
        Preconditions.checkArgument((random != null ? 1 : 0) != 0, (Object)"Argument 'random' must not be null");
        net.minecraft.world.item.ItemStack internalStack = CraftItemStack.asNMSCopy(itemStack);
        if (internalStack.isEnchanted()) {
            internalStack.set(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        }
        RegistryAccess.Frozen registryAccess = MinecraftServer.getServer().registryAccess();
        net.minecraft.world.item.ItemStack enchanted = EnchantmentHelper.enchantItem(new RandomSourceWrapper(random), internalStack, levels, registryAccess, possibleEnchantments);
        return CraftItemStack.asCraftMirror(enchanted);
    }

    static {
        randomSource = RandomSource.create();
        instance = new CraftItemFactory();
        ConfigurationSerialization.registerClass(SerializableMeta.class);
        ConfigurationSerialization.registerClass(CraftEquippableComponent.class);
        ConfigurationSerialization.registerClass(CraftFoodComponent.class);
        ConfigurationSerialization.registerClass(CraftToolComponent.class);
        ConfigurationSerialization.registerClass(CraftToolComponent.CraftToolRule.class);
        ConfigurationSerialization.registerClass(CraftJukeboxComponent.class);
        ConfigurationSerialization.registerClass(CraftUseCooldownComponent.class);
    }
}

