/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.destroystokyo.paper.Namespaced;
import com.destroystokyo.paper.NamespacedTag;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.papermc.paper.adventure.PaperAdventure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.JukeboxSongs;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.Overridden;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.inventory.CraftItemFlag;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftMetaArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.inventory.CraftMetaColorableArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.inventory.CraftMetaMusicInstrument;
import org.bukkit.craftbukkit.inventory.CraftMetaOminousBottle;
import org.bukkit.craftbukkit.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.inventory.CraftMetaShield;
import org.bukkit.craftbukkit.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.craftbukkit.inventory.components.CraftEquippableComponent;
import org.bukkit.craftbukkit.inventory.components.CraftFoodComponent;
import org.bukkit.craftbukkit.inventory.components.CraftJukeboxComponent;
import org.bukkit.craftbukkit.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.inventory.components.CraftUseCooldownComponent;
import org.bukkit.craftbukkit.inventory.tags.DeprecatedCustomTagContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.tag.CraftDamageTag;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNBTTagConfigSerializer;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.tag.DamageTypeTags;
import org.jetbrains.annotations.VisibleForTesting;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaItem
implements ItemMeta,
Damageable,
Repairable,
BlockDataMeta {
    static final ItemMetaKeyType<net.minecraft.network.chat.Component> NAME = new ItemMetaKeyType<net.minecraft.network.chat.Component>(DataComponents.CUSTOM_NAME, "display-name");
    static final ItemMetaKeyType<net.minecraft.network.chat.Component> ITEM_NAME = new ItemMetaKeyType<net.minecraft.network.chat.Component>(DataComponents.ITEM_NAME, "item-name");
    static final ItemMetaKeyType<ItemLore> LORE = new ItemMetaKeyType<ItemLore>(DataComponents.LORE, "lore");
    static final ItemMetaKeyType<CustomModelData> CUSTOM_MODEL_DATA = new ItemMetaKeyType<CustomModelData>(DataComponents.CUSTOM_MODEL_DATA, "custom-model-data");
    static final ItemMetaKeyType<Enchantable> ENCHANTABLE = new ItemMetaKeyType<Enchantable>(DataComponents.ENCHANTABLE, "enchantable");
    static final ItemMetaKeyType<ItemEnchantments> ENCHANTMENTS = new ItemMetaKeyType<ItemEnchantments>(DataComponents.ENCHANTMENTS, "enchants");
    static final ItemMetaKeyType<Integer> REPAIR = new ItemMetaKeyType<Integer>(DataComponents.REPAIR_COST, "repair-cost");
    static final ItemMetaKeyType<ItemAttributeModifiers> ATTRIBUTES = new ItemMetaKeyType<ItemAttributeModifiers>(DataComponents.ATTRIBUTE_MODIFIERS, "attribute-modifiers");
    static final ItemMetaKey ATTRIBUTES_IDENTIFIER = new ItemMetaKey("AttributeName");
    static final ItemMetaKey ATTRIBUTES_SLOT = new ItemMetaKey("Slot");
    static final ItemMetaKey HIDEFLAGS = new ItemMetaKey("ItemFlags");
    static final ItemMetaKeyType<Unit> HIDE_TOOLTIP = new ItemMetaKeyType<Unit>(DataComponents.HIDE_TOOLTIP, "hide-tool-tip");
    static final ItemMetaKeyType<ResourceLocation> TOOLTIP_STYLE = new ItemMetaKeyType<ResourceLocation>(DataComponents.TOOLTIP_STYLE, "tool-tip-style");
    static final ItemMetaKeyType<ResourceLocation> ITEM_MODEL = new ItemMetaKeyType<ResourceLocation>(DataComponents.ITEM_MODEL, "item-model");
    static final ItemMetaKeyType<Unbreakable> UNBREAKABLE = new ItemMetaKeyType<Unbreakable>(DataComponents.UNBREAKABLE, "Unbreakable");
    static final ItemMetaKeyType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = new ItemMetaKeyType<Boolean>(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, "enchantment-glint-override");
    static final ItemMetaKeyType<Unit> GLIDER = new ItemMetaKeyType<Unit>(DataComponents.GLIDER, "glider");
    static final ItemMetaKeyType<DamageResistant> DAMAGE_RESISTANT = new ItemMetaKeyType<DamageResistant>(DataComponents.DAMAGE_RESISTANT, "damage-resistant");
    static final ItemMetaKeyType<Integer> MAX_STACK_SIZE = new ItemMetaKeyType<Integer>(DataComponents.MAX_STACK_SIZE, "max-stack-size");
    static final ItemMetaKeyType<Rarity> RARITY = new ItemMetaKeyType<Rarity>(DataComponents.RARITY, "rarity");
    static final ItemMetaKeyType<UseRemainder> USE_REMAINDER = new ItemMetaKeyType<UseRemainder>(DataComponents.USE_REMAINDER, "use-remainder");
    static final ItemMetaKeyType<UseCooldown> USE_COOLDOWN = new ItemMetaKeyType<UseCooldown>(DataComponents.USE_COOLDOWN, "use-cooldown");
    static final ItemMetaKeyType<FoodProperties> FOOD = new ItemMetaKeyType<FoodProperties>(DataComponents.FOOD, "food");
    static final ItemMetaKeyType<Tool> TOOL = new ItemMetaKeyType<Tool>(DataComponents.TOOL, "tool");
    static final ItemMetaKeyType<Equippable> EQUIPPABLE = new ItemMetaKeyType<Equippable>(DataComponents.EQUIPPABLE, "equippable");
    static final ItemMetaKeyType<JukeboxPlayable> JUKEBOX_PLAYABLE = new ItemMetaKeyType<JukeboxPlayable>(DataComponents.JUKEBOX_PLAYABLE, "jukebox-playable");
    static final ItemMetaKeyType<Integer> DAMAGE = new ItemMetaKeyType<Integer>(DataComponents.DAMAGE, "Damage");
    static final ItemMetaKeyType<Integer> MAX_DAMAGE = new ItemMetaKeyType<Integer>(DataComponents.MAX_DAMAGE, "max-damage");
    static final ItemMetaKeyType<BlockItemStateProperties> BLOCK_DATA = new ItemMetaKeyType<BlockItemStateProperties>(DataComponents.BLOCK_STATE, "BlockStateTag");
    static final ItemMetaKey BUKKIT_CUSTOM_TAG = new ItemMetaKey("PublicBukkitValues");
    static final ItemMetaKeyType<Unit> HIDE_ADDITIONAL_TOOLTIP = new ItemMetaKeyType<Unit>(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
    static final ItemMetaKeyType<CustomData> CUSTOM_DATA = new ItemMetaKeyType<CustomData>(DataComponents.CUSTOM_DATA);
    static final ItemMetaKeyType<AdventureModePredicate> CAN_PLACE_ON = new ItemMetaKeyType<AdventureModePredicate>(DataComponents.CAN_PLACE_ON);
    static final ItemMetaKeyType<AdventureModePredicate> CAN_BREAK = new ItemMetaKeyType<AdventureModePredicate>(DataComponents.CAN_BREAK);
    private List<BlockPredicate> canPlaceOnPredicates;
    private List<BlockPredicate> canBreakPredicates;
    private net.minecraft.network.chat.Component displayName;
    private net.minecraft.network.chat.Component itemName;
    private List<net.minecraft.network.chat.Component> lore;
    private Integer customModelData;
    private Integer enchantableValue;
    private Map<String, String> blockData;
    private EnchantmentMap enchantments;
    private Multimap<Attribute, org.bukkit.attribute.AttributeModifier> attributeModifiers;
    private int repairCost;
    private int hideFlag;
    private boolean hideTooltip;
    private NamespacedKey tooltipStyle;
    private NamespacedKey itemModel;
    private boolean unbreakable;
    private Boolean enchantmentGlintOverride;
    private boolean glider;
    private TagKey<DamageType> damageResistant;
    private Integer maxStackSize;
    private ItemRarity rarity;
    private ItemStack useRemainder;
    private CraftUseCooldownComponent useCooldown;
    private CraftFoodComponent food;
    private CraftToolComponent tool;
    private CraftEquippableComponent equippable;
    private CraftJukeboxComponent jukebox;
    private Integer damage;
    private Integer maxDamage;
    private static final Set<DataComponentType> HANDLED_TAGS = Sets.newHashSet();
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private CompoundTag customTag;
    protected DataComponentPatch.Builder unhandledTags = DataComponentPatch.builder();
    private Set<DataComponentType<?>> removedTags = Sets.newHashSet();
    private CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private int version = CraftMagicNumbers.INSTANCE.getDataVersion();
    @VisibleForTesting
    public static final Map<Class<? extends CraftMetaItem>, Set<DataComponentType<?>>> HANDLED_DCTS_PER_TYPE = new HashMap();
    protected static final Set<DataComponentType<?>> DEFAULT_HANDLED_DCTS = Set.of(CraftMetaItem.NAME.TYPE, CraftMetaItem.ITEM_NAME.TYPE, CraftMetaItem.LORE.TYPE, CraftMetaItem.CUSTOM_MODEL_DATA.TYPE, CraftMetaItem.ENCHANTABLE.TYPE, CraftMetaItem.BLOCK_DATA.TYPE, CraftMetaItem.REPAIR.TYPE, CraftMetaItem.ENCHANTMENTS.TYPE, CraftMetaItem.HIDE_ADDITIONAL_TOOLTIP.TYPE, CraftMetaItem.HIDE_TOOLTIP.TYPE, CraftMetaItem.TOOLTIP_STYLE.TYPE, CraftMetaItem.ITEM_MODEL.TYPE, CraftMetaItem.UNBREAKABLE.TYPE, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.TYPE, CraftMetaItem.GLIDER.TYPE, CraftMetaItem.DAMAGE_RESISTANT.TYPE, CraftMetaItem.MAX_STACK_SIZE.TYPE, CraftMetaItem.RARITY.TYPE, CraftMetaItem.USE_REMAINDER.TYPE, CraftMetaItem.USE_COOLDOWN.TYPE, CraftMetaItem.FOOD.TYPE, CraftMetaItem.TOOL.TYPE, CraftMetaItem.EQUIPPABLE.TYPE, CraftMetaItem.JUKEBOX_PLAYABLE.TYPE, CraftMetaItem.DAMAGE.TYPE, CraftMetaItem.MAX_DAMAGE.TYPE, CraftMetaItem.CUSTOM_DATA.TYPE, CraftMetaItem.ATTRIBUTES.TYPE, CraftMetaItem.CAN_PLACE_ON.TYPE, CraftMetaItem.CAN_BREAK.TYPE);

    CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            return;
        }
        this.displayName = meta.displayName;
        this.itemName = meta.itemName;
        if (meta.lore != null) {
            this.lore = new ArrayList<net.minecraft.network.chat.Component>(meta.lore);
        }
        this.customModelData = meta.customModelData;
        this.enchantableValue = meta.enchantableValue;
        this.blockData = meta.blockData;
        if (meta.enchantments != null) {
            this.enchantments = new EnchantmentMap(meta.enchantments);
        }
        if (meta.attributeModifiers != null) {
            this.attributeModifiers = LinkedHashMultimap.create(meta.attributeModifiers);
        }
        this.repairCost = meta.repairCost;
        this.hideFlag = meta.hideFlag;
        this.hideTooltip = meta.hideTooltip;
        this.tooltipStyle = meta.tooltipStyle;
        this.itemModel = meta.itemModel;
        this.unbreakable = meta.unbreakable;
        this.enchantmentGlintOverride = meta.enchantmentGlintOverride;
        this.glider = meta.glider;
        this.damageResistant = meta.damageResistant;
        this.maxStackSize = meta.maxStackSize;
        this.rarity = meta.rarity;
        if (meta.hasUseRemainder()) {
            this.useRemainder = meta.useRemainder.clone();
        }
        if (meta.hasUseCooldown()) {
            this.useCooldown = new CraftUseCooldownComponent(meta.useCooldown);
        }
        if (meta.hasFood()) {
            this.food = new CraftFoodComponent(meta.food);
        }
        if (meta.hasTool()) {
            this.tool = new CraftToolComponent(meta.tool);
        }
        if (meta.hasEquippable()) {
            this.equippable = new CraftEquippableComponent(meta.equippable);
        }
        if (meta.hasJukeboxPlayable()) {
            this.jukebox = new CraftJukeboxComponent(meta.jukebox);
        }
        this.damage = meta.damage;
        this.maxDamage = meta.maxDamage;
        this.unhandledTags.copy(meta.unhandledTags.build());
        this.removedTags.addAll(meta.removedTags);
        this.persistentDataContainer.putAll(meta.persistentDataContainer.getTagsCloned());
        this.customTag = meta.customTag;
        this.version = meta.version;
        this.canPlaceOnPredicates = meta.canPlaceOnPredicates;
        this.canBreakPredicates = meta.canBreakPredicates;
    }

    CraftMetaItem(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledTags) {
        this.updateFromPatch(tag, extraHandledTags);
    }

    protected final void updateFromPatch(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledTags) {
        CraftMetaItem.getOrEmpty(tag, NAME).ifPresent(component -> {
            this.displayName = component;
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_NAME).ifPresent(component -> {
            this.itemName = component;
        });
        CraftMetaItem.getOrEmpty(tag, LORE).ifPresent(l -> {
            List<net.minecraft.network.chat.Component> list = l.lines();
            this.lore = new ArrayList<net.minecraft.network.chat.Component>(list.size());
            for (int index = 0; index < list.size(); ++index) {
                net.minecraft.network.chat.Component line = list.get(index);
                this.lore.add(line);
            }
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_MODEL_DATA).ifPresent(i -> {
            this.customModelData = i.value();
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTABLE).ifPresent(i -> {
            this.enchantableValue = i.value();
        });
        CraftMetaItem.getOrEmpty(tag, BLOCK_DATA).ifPresent(t -> {
            this.blockData = t.properties();
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENTS).ifPresent(en -> {
            this.enchantments = CraftMetaItem.buildEnchantments(en);
            if (!en.showInTooltip) {
                this.addItemFlags(ItemFlag.HIDE_ENCHANTS);
            }
        });
        CraftMetaItem.getOrEmpty(tag, ATTRIBUTES).ifPresent(en -> {
            this.attributeModifiers = CraftMetaItem.buildModifiers(en);
            if (!en.showInTooltip()) {
                this.addItemFlags(ItemFlag.HIDE_ATTRIBUTES);
            }
        });
        CraftMetaItem.getOrEmpty(tag, REPAIR).ifPresent(i -> {
            this.repairCost = i;
        });
        CraftMetaItem.getOrEmpty(tag, HIDE_ADDITIONAL_TOOLTIP).ifPresent(h -> this.addItemFlags(ItemFlag.HIDE_ADDITIONAL_TOOLTIP));
        CraftMetaItem.getOrEmpty(tag, HIDE_TOOLTIP).ifPresent(u -> {
            this.hideTooltip = true;
        });
        CraftMetaItem.getOrEmpty(tag, TOOLTIP_STYLE).ifPresent(key -> {
            this.tooltipStyle = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_MODEL).ifPresent(key -> {
            this.itemModel = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, UNBREAKABLE).ifPresent(u -> {
            this.unbreakable = true;
            if (!u.showInTooltip()) {
                this.addItemFlags(ItemFlag.HIDE_UNBREAKABLE);
            }
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENT_GLINT_OVERRIDE).ifPresent(override -> {
            this.enchantmentGlintOverride = override;
        });
        CraftMetaItem.getOrEmpty(tag, GLIDER).ifPresent(u -> {
            this.glider = true;
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE_RESISTANT).ifPresent(tags -> {
            this.damageResistant = tags.types();
        });
        CraftMetaItem.getOrEmpty(tag, MAX_STACK_SIZE).ifPresent(i -> {
            this.maxStackSize = i;
        });
        CraftMetaItem.getOrEmpty(tag, RARITY).ifPresent(enumItemRarity -> {
            this.rarity = ItemRarity.valueOf((String)enumItemRarity.name());
        });
        CraftMetaItem.getOrEmpty(tag, USE_REMAINDER).ifPresent(remainder -> {
            this.useRemainder = CraftItemStack.asCraftMirror(remainder.convertInto());
        });
        CraftMetaItem.getOrEmpty(tag, USE_COOLDOWN).ifPresent(cooldown -> {
            this.useCooldown = new CraftUseCooldownComponent((UseCooldown)cooldown);
        });
        CraftMetaItem.getOrEmpty(tag, FOOD).ifPresent(foodInfo -> {
            this.food = new CraftFoodComponent((FoodProperties)foodInfo);
        });
        CraftMetaItem.getOrEmpty(tag, TOOL).ifPresent(toolInfo -> {
            this.tool = new CraftToolComponent((Tool)toolInfo);
        });
        CraftMetaItem.getOrEmpty(tag, EQUIPPABLE).ifPresent(equippableInfo -> {
            this.equippable = new CraftEquippableComponent((Equippable)equippableInfo);
        });
        CraftMetaItem.getOrEmpty(tag, JUKEBOX_PLAYABLE).ifPresent(jukeboxPlayable -> {
            this.jukebox = new CraftJukeboxComponent((JukeboxPlayable)jukeboxPlayable);
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE).ifPresent(i -> {
            this.damage = i;
        });
        CraftMetaItem.getOrEmpty(tag, MAX_DAMAGE).ifPresent(i -> {
            this.maxDamage = i;
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_DATA).ifPresent(customData -> {
            this.customTag = customData.copyTag();
            if (this.customTag.contains(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT)) {
                CompoundTag compound = this.customTag.getCompound(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
                Set<String> keys = compound.getAllKeys();
                for (String key : keys) {
                    this.persistentDataContainer.put(key, compound.get(key).copy());
                }
                this.customTag.remove(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
            }
            if (this.customTag.isEmpty()) {
                this.customTag = null;
            }
        });
        CraftMetaItem.getOrEmpty(tag, CAN_PLACE_ON).ifPresent(data -> {
            this.canPlaceOnPredicates = List.copyOf(data.predicates);
            if (!data.showInTooltip()) {
                this.addItemFlags(ItemFlag.HIDE_PLACED_ON);
            }
        });
        CraftMetaItem.getOrEmpty(tag, CAN_BREAK).ifPresent(data -> {
            this.canBreakPredicates = List.copyOf(data.predicates);
            if (!data.showInTooltip()) {
                this.addItemFlags(ItemFlag.HIDE_DESTROYS);
            }
        });
        Set<DataComponentType<?>> handledTags = CraftMetaItem.getTopLevelHandledDcts(this.getClass());
        if (extraHandledTags != null) {
            extraHandledTags.addAll(handledTags);
            handledTags = extraHandledTags;
        }
        Set<Map.Entry<DataComponentType<?>, Optional<?>>> keys = tag.entrySet();
        for (Map.Entry<DataComponentType<?>, Optional<?>> key2 : keys) {
            if (!handledTags.contains(key2.getKey())) {
                key2.getValue().ifPresent(value -> this.unhandledTags.set((DataComponentType)key2.getKey(), value));
            }
            if (!key2.getValue().isEmpty()) continue;
            this.removedTags.add(key2.getKey());
        }
    }

    static EnchantmentMap buildEnchantments(ItemEnchantments tag) {
        EnchantmentMap enchantments = new EnchantmentMap();
        tag.entrySet().forEach(entry -> {
            Holder id = (Holder)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CraftEnchantment.minecraftHolderToBukkit(id);
            if (enchant != null) {
                enchantments.put(enchant, level);
            }
        });
        return enchantments;
    }

    static Multimap<Attribute, org.bukkit.attribute.AttributeModifier> buildModifiers(ItemAttributeModifiers tag) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        List<ItemAttributeModifiers.Entry> mods = tag.modifiers();
        int size = mods.size();
        for (int i = 0; i < size; ++i) {
            ItemAttributeModifiers.Entry entry = mods.get(i);
            AttributeModifier nmsModifier = entry.modifier();
            if (nmsModifier == null) continue;
            org.bukkit.attribute.AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            Attribute attribute = CraftAttribute.minecraftHolderToBukkit(entry.attribute());
            if (attribute == null) continue;
            if (entry.slot() != null) {
                EquipmentSlotGroup slotName = entry.slot();
                if (slotName == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                org.bukkit.inventory.EquipmentSlotGroup slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlot(slotName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new org.bukkit.attribute.AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot);
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    CraftMetaItem(Map<String, Object> map) {
        String custom;
        Object nbtMap;
        Iterable removed;
        String unhandled;
        String internal;
        Integer maxDamage;
        Integer damage;
        CraftJukeboxComponent jukeboxPlayable;
        CraftEquippableComponent equippable;
        CraftToolComponent tool;
        CraftFoodComponent food;
        CraftUseCooldownComponent cooldown;
        ItemStack remainder;
        String rarity;
        Integer maxStackSize;
        Tag tag;
        String damageResistant;
        Boolean glider;
        Boolean enchantmentGlintOverride;
        Boolean unbreakable;
        String itemModel;
        String tooltipStyle;
        Boolean bl;
        Iterable hideFlags;
        Object blockData;
        Integer enchantmentValue;
        Integer customModelData;
        this.displayName = CraftChatMessage.fromJSONOrString(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true), true, false);
        this.itemName = CraftChatMessage.fromJSONOrNull(SerializableMeta.getString(map, CraftMetaItem.ITEM_NAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<net.minecraft.network.chat.Component>();
            CraftMetaItem.safelyAdd(lore, this.lore, true);
        }
        if ((customModelData = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, true)) != null) {
            this.setCustomModelData(customModelData);
        }
        if ((enchantmentValue = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.ENCHANTABLE.BUKKIT, true)) != null) {
            this.setEnchantable(enchantmentValue);
        }
        if ((blockData = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BLOCK_DATA.BUKKIT, true)) != null) {
            HashMap<String, String> mapBlockData = new HashMap<String, String>();
            if (blockData instanceof Map) {
                for (Map.Entry entry : ((Map)blockData).entrySet()) {
                    mapBlockData.put(entry.getKey().toString(), entry.getValue().toString());
                }
            } else {
                CompoundTag nbtBlockData = (CompoundTag)CraftNBTTagConfigSerializer.deserialize(blockData);
                for (String key : nbtBlockData.getAllKeys()) {
                    mapBlockData.put(key, nbtBlockData.getString(key));
                }
            }
            this.blockData = mapBlockData;
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        this.attributeModifiers = CraftMetaItem.buildModifiers(map, ATTRIBUTES);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
        if ((hideFlags = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.HIDEFLAGS.BUKKIT, true)) != null) {
            for (Object hideFlagObject : hideFlags) {
                String hideFlagString = (String)hideFlagObject;
                try {
                    ItemFlag hideFlatEnum = CraftItemFlag.stringToBukkit(hideFlagString);
                    this.addItemFlags(hideFlatEnum);
                }
                catch (IllegalArgumentException hideFlatEnum) {}
            }
        }
        if ((bl = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.HIDE_TOOLTIP.BUKKIT, true)) != null) {
            this.setHideTooltip(bl);
        }
        if ((tooltipStyle = SerializableMeta.getString(map, CraftMetaItem.TOOLTIP_STYLE.BUKKIT, true)) != null) {
            this.setTooltipStyle(NamespacedKey.fromString((String)tooltipStyle));
        }
        if ((itemModel = SerializableMeta.getString(map, CraftMetaItem.ITEM_MODEL.BUKKIT, true)) != null) {
            this.setItemModel(NamespacedKey.fromString((String)itemModel));
        }
        if ((unbreakable = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.UNBREAKABLE.BUKKIT, true)) != null) {
            this.setUnbreakable(unbreakable);
        }
        if ((enchantmentGlintOverride = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, true)) != null) {
            this.setEnchantmentGlintOverride(enchantmentGlintOverride);
        }
        if ((glider = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.GLIDER.BUKKIT, true)) != null) {
            this.setGlider(glider);
        }
        if ((damageResistant = SerializableMeta.getString(map, CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, true)) != null && (tag = Bukkit.getTag((String)"damage_types", (NamespacedKey)NamespacedKey.fromString((String)damageResistant), org.bukkit.damage.DamageType.class)) != null) {
            this.setDamageResistant((Tag<org.bukkit.damage.DamageType>)tag);
        }
        if ((maxStackSize = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_STACK_SIZE.BUKKIT, true)) != null) {
            this.setMaxStackSize(maxStackSize);
        }
        if ((rarity = SerializableMeta.getString(map, CraftMetaItem.RARITY.BUKKIT, true)) != null) {
            this.setRarity(ItemRarity.valueOf((String)rarity));
        }
        if ((remainder = SerializableMeta.getObject(ItemStack.class, map, CraftMetaItem.USE_REMAINDER.BUKKIT, true)) != null) {
            this.setUseRemainder(remainder);
        }
        if ((cooldown = SerializableMeta.getObject(CraftUseCooldownComponent.class, map, CraftMetaItem.USE_COOLDOWN.BUKKIT, true)) != null) {
            this.setUseCooldown(cooldown);
        }
        if ((food = SerializableMeta.getObject(CraftFoodComponent.class, map, CraftMetaItem.FOOD.BUKKIT, true)) != null) {
            this.setFood(food);
        }
        if ((tool = SerializableMeta.getObject(CraftToolComponent.class, map, CraftMetaItem.TOOL.BUKKIT, true)) != null) {
            this.setTool(tool);
        }
        if ((equippable = SerializableMeta.getObject(CraftEquippableComponent.class, map, CraftMetaItem.EQUIPPABLE.BUKKIT, true)) != null) {
            this.setEquippable(equippable);
        }
        if ((jukeboxPlayable = SerializableMeta.getObject(CraftJukeboxComponent.class, map, CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, true)) != null) {
            this.setJukeboxPlayable(jukeboxPlayable);
        }
        if ((damage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.DAMAGE.BUKKIT, true)) != null) {
            this.setDamage(damage);
        }
        if ((maxDamage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_DAMAGE.BUKKIT, true)) != null) {
            this.setMaxDamage(maxDamage);
        }
        if ((internal = SerializableMeta.getString(map, "internal", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(internal));
            try {
                CompoundTag internalTag = NbtIo.readCompressed(buf, NbtAccounter.unlimitedHeap());
                this.deserializeInternal(internalTag, map);
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((unhandled = SerializableMeta.getString(map, "unhandled", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(unhandled));
            try {
                CompoundTag unhandledTag = NbtIo.readCompressed(buf, NbtAccounter.unlimitedHeap());
                DataComponentPatch unhandledPatch = (DataComponentPatch)DataComponentPatch.CODEC.parse(MinecraftServer.getDefaultRegistryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)unhandledTag).result().get();
                CraftMetaItem.getOrEmpty(unhandledPatch, CAN_PLACE_ON).ifPresent(data -> {
                    this.canPlaceOnPredicates = List.copyOf(data.predicates);
                });
                CraftMetaItem.getOrEmpty(unhandledPatch, CAN_BREAK).ifPresent(data -> {
                    this.canBreakPredicates = List.copyOf(data.predicates);
                });
                this.unhandledTags.copy(unhandledPatch.forget(type -> type == CraftMetaItem.CAN_PLACE_ON.TYPE || type == CraftMetaItem.CAN_BREAK.TYPE));
                for (Map.Entry entry : unhandledPatch.entrySet()) {
                    if (((Optional)entry.getValue()).isPresent()) continue;
                    DataComponentType key = (DataComponentType)entry.getKey();
                    this.unhandledTags.clear(key);
                    this.removedTags.add(key);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((removed = SerializableMeta.getObject(Iterable.class, map, "removed", true)) != null) {
            RegistryAccess registryAccess = CraftRegistry.getMinecraftRegistry();
            HolderLookup.RegistryLookup componentTypeRegistry = registryAccess.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
            for (Object t : removed) {
                String removedString = (String)t;
                DataComponentType component = (DataComponentType)componentTypeRegistry.getValue(ResourceLocation.parse(removedString));
                if (component == null) continue;
                this.removedTags.add(component);
            }
        }
        if ((nbtMap = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, true)) != null) {
            this.persistentDataContainer.putAll((CompoundTag)CraftNBTTagConfigSerializer.deserialize(nbtMap));
        }
        if ((custom = SerializableMeta.getString(map, "custom", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(custom));
            try {
                this.customTag = NbtIo.readCompressed(buf, NbtAccounter.unlimitedHeap());
            }
            catch (IOException iOException) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    void deserializeInternal(CompoundTag tag, Object context) {
        if (tag.contains(CraftMetaItem.ATTRIBUTES.NBT, 9)) {
            this.attributeModifiers = CraftMetaItem.buildModifiersLegacy(tag, ATTRIBUTES);
        }
    }

    private static Multimap<Attribute, org.bukkit.attribute.AttributeModifier> buildModifiersLegacy(CompoundTag tag, ItemMetaKey key) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        if (!tag.contains(key.NBT, 9)) {
            return modifiers;
        }
        ListTag mods = tag.getList(key.NBT, 10);
        int size = mods.size();
        for (int i = 0; i < size; ++i) {
            Attribute attribute;
            AttributeModifier nmsModifier;
            CompoundTag entry = mods.getCompound(i);
            if (entry.isEmpty() || (nmsModifier = AttributeModifier.load(entry)) == null) continue;
            org.bukkit.attribute.AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            String attributeName = CraftAttributeMap.convertIfNeeded(entry.getString(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT));
            if (attributeName == null || attributeName.isEmpty() || (attribute = CraftAttribute.stringToBukkit(attributeName)) == null) continue;
            if (entry.contains(CraftMetaItem.ATTRIBUTES_SLOT.NBT, 8)) {
                String slotName = entry.getString(CraftMetaItem.ATTRIBUTES_SLOT.NBT);
                if (slotName == null || slotName.isEmpty()) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                EquipmentSlot slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlot(net.minecraft.world.entity.EquipmentSlot.byName(slotName.toLowerCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new org.bukkit.attribute.AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot.getGroup());
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    static EnchantmentMap buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        EnchantmentMap enchantments = new EnchantmentMap();
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment = CraftEnchantment.stringToBukkit(entry.getKey().toString());
            if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    static Multimap<Attribute, org.bukkit.attribute.AttributeModifier> buildModifiers(Map<String, Object> map, ItemMetaKey key) {
        Map mods = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        if (mods == null) {
            return null;
        }
        for (Object obj : mods.keySet()) {
            String attributeName;
            if (!(obj instanceof String) || Strings.isNullOrEmpty((String)(attributeName = (String)obj))) continue;
            List list = SerializableMeta.getObject(List.class, mods, attributeName, true);
            if (list == null || list.isEmpty()) {
                return result;
            }
            for (Object o : list) {
                if (!(o instanceof org.bukkit.attribute.AttributeModifier)) continue;
                org.bukkit.attribute.AttributeModifier modifier = (org.bukkit.attribute.AttributeModifier)o;
                Attribute attribute = CraftAttribute.stringToBukkit(attributeName);
                if (attribute == null) continue;
                result.put((Object)attribute, (Object)modifier);
            }
        }
        return result;
    }

    @Overridden
    void applyToItem(Applicator itemTag) {
        CompoundTag customTag;
        if (this.hasDisplayName()) {
            itemTag.put(NAME, this.displayName);
        }
        if (this.hasItemName()) {
            itemTag.put(ITEM_NAME, this.itemName);
        }
        if (this.lore != null) {
            itemTag.put(LORE, new ItemLore(this.lore));
        }
        if (this.hasCustomModelData()) {
            itemTag.put(CUSTOM_MODEL_DATA, new CustomModelData(this.customModelData));
        }
        if (this.hasEnchantable()) {
            itemTag.put(ENCHANTABLE, new Enchantable(this.enchantableValue));
        }
        if (this.hasBlockData()) {
            itemTag.put(BLOCK_DATA, new BlockItemStateProperties(this.blockData));
        }
        if (this.hideFlag != 0 && this.hasItemFlag(ItemFlag.HIDE_ADDITIONAL_TOOLTIP)) {
            itemTag.put(HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
        }
        this.applyEnchantments(this.enchantments, itemTag, ENCHANTMENTS, ItemFlag.HIDE_ENCHANTS);
        this.applyModifiers(this.attributeModifiers, itemTag);
        if (this.hasRepairCost()) {
            itemTag.put(REPAIR, this.repairCost);
        }
        if (this.isHideTooltip()) {
            itemTag.put(HIDE_TOOLTIP, Unit.INSTANCE);
        }
        if (this.hasTooltipStyle()) {
            itemTag.put(TOOLTIP_STYLE, CraftNamespacedKey.toMinecraft(this.getTooltipStyle()));
        }
        if (this.hasItemModel()) {
            itemTag.put(ITEM_MODEL, CraftNamespacedKey.toMinecraft(this.getItemModel()));
        }
        if (this.isUnbreakable()) {
            itemTag.put(UNBREAKABLE, new Unbreakable(!this.hasItemFlag(ItemFlag.HIDE_UNBREAKABLE)));
        }
        if (this.hasEnchantmentGlintOverride()) {
            itemTag.put(ENCHANTMENT_GLINT_OVERRIDE, this.getEnchantmentGlintOverride());
        }
        if (this.isGlider()) {
            itemTag.put(GLIDER, Unit.INSTANCE);
        }
        if (this.hasDamageResistant()) {
            itemTag.put(DAMAGE_RESISTANT, new DamageResistant(this.damageResistant));
        }
        if (this.hasMaxStackSize()) {
            itemTag.put(MAX_STACK_SIZE, this.maxStackSize);
        }
        if (this.hasRarity()) {
            itemTag.put(RARITY, Rarity.valueOf(this.rarity.name()));
        }
        if (this.hasUseRemainder()) {
            itemTag.put(USE_REMAINDER, new UseRemainder(CraftItemStack.asNMSCopy(this.useRemainder)));
        }
        if (this.hasUseCooldown()) {
            itemTag.put(USE_COOLDOWN, this.useCooldown.getHandle());
        }
        if (this.hasFood()) {
            itemTag.put(FOOD, this.food.getHandle());
        }
        if (this.hasTool()) {
            itemTag.put(TOOL, this.tool.getHandle());
        }
        if (this.hasEquippable()) {
            itemTag.put(EQUIPPABLE, this.equippable.getHandle());
        }
        if (this.hasJukeboxPlayable()) {
            itemTag.put(JUKEBOX_PLAYABLE, this.jukebox.getHandle());
        }
        if (this.hasDamageValue()) {
            itemTag.put(DAMAGE, this.damage);
        }
        if (this.hasMaxDamage()) {
            itemTag.put(MAX_DAMAGE, this.maxDamage);
        }
        if (this.canPlaceOnPredicates != null && !this.canPlaceOnPredicates.isEmpty()) {
            itemTag.put(CAN_PLACE_ON, new AdventureModePredicate(this.canPlaceOnPredicates, !this.hasItemFlag(ItemFlag.HIDE_PLACED_ON)));
        }
        if (this.canBreakPredicates != null && !this.canBreakPredicates.isEmpty()) {
            itemTag.put(CAN_BREAK, new AdventureModePredicate(this.canBreakPredicates, !this.hasItemFlag(ItemFlag.HIDE_DESTROYS)));
        }
        for (Map.Entry<DataComponentType<?>, Optional<?>> entry : this.unhandledTags.build().entrySet()) {
            entry.getValue().ifPresent(value -> itemTag.builder.set((DataComponentType)e.getKey(), value));
        }
        for (DataComponentType dataComponentType : this.removedTags) {
            if (itemTag.builder.isSet(dataComponentType)) continue;
            itemTag.builder.remove(dataComponentType);
        }
        CompoundTag compoundTag = customTag = this.customTag != null ? this.customTag.copy() : null;
        if (!this.persistentDataContainer.isEmpty()) {
            CompoundTag compoundTag2 = new CompoundTag();
            Map<String, net.minecraft.nbt.Tag> rawPublicMap = this.persistentDataContainer.getRaw();
            for (Map.Entry<String, net.minecraft.nbt.Tag> nbtBaseEntry : rawPublicMap.entrySet()) {
                compoundTag2.put(nbtBaseEntry.getKey(), nbtBaseEntry.getValue());
            }
            if (customTag == null) {
                customTag = new CompoundTag();
            }
            customTag.put(CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, compoundTag2);
        }
        if (customTag != null) {
            itemTag.put(CUSTOM_DATA, CustomData.of(customTag));
        }
    }

    void applyEnchantments(Map<Enchantment, Integer> enchantments, Applicator tag, ItemMetaKeyType<ItemEnchantments> key, ItemFlag itemFlag) {
        if (enchantments == null) {
            return;
        }
        ItemEnchantments.Mutable list = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        if (enchantments != null) {
            for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
                list.set(CraftEnchantment.bukkitToMinecraftHolder(entry.getKey()), entry.getValue());
            }
        }
        list.showInTooltip = !this.hasItemFlag(itemFlag);
        tag.put(key, list.toImmutable());
    }

    void applyModifiers(Multimap<Attribute, org.bukkit.attribute.AttributeModifier> modifiers, Applicator tag) {
        if (modifiers == null) {
            return;
        }
        ItemAttributeModifiers.Builder list = ItemAttributeModifiers.builder();
        for (Map.Entry entry : modifiers.entries()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            AttributeModifier nmsModifier = CraftAttributeInstance.convert((org.bukkit.attribute.AttributeModifier)entry.getValue());
            Holder<net.minecraft.world.entity.ai.attributes.Attribute> name = CraftAttribute.bukkitToMinecraftHolder((Attribute)entry.getKey());
            if (name == null) continue;
            EquipmentSlotGroup group = CraftEquipmentSlot.getNMSGroup(((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlotGroup());
            list.add(name, nmsModifier, group);
        }
        tag.put(ATTRIBUTES, list.build().withTooltip(!this.hasItemFlag(ItemFlag.HIDE_ATTRIBUTES)));
    }

    boolean applicableTo(Material type) {
        if (type == Material.AIR || !type.isItem()) {
            return false;
        }
        if (this.getClass() == CraftMetaItem.class) {
            return true;
        }
        return type.asItemType().getItemMetaClass() == this.getClass().getInterfaces()[0];
    }

    @Overridden
    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasItemName() && !this.hasLocalizedName() && !this.hasEnchants() && this.lore == null && !this.hasCustomModelData() && !this.hasEnchantable() && !this.hasBlockData() && !this.hasRepairCost() && this.unhandledTags.build().isEmpty() && this.removedTags.isEmpty() && this.persistentDataContainer.isEmpty() && this.hideFlag == 0 && !this.isHideTooltip() && !this.hasTooltipStyle() && !this.hasItemModel() && !this.isUnbreakable() && !this.hasEnchantmentGlintOverride() && !this.isGlider() && !this.hasDamageResistant() && !this.hasMaxStackSize() && !this.hasRarity() && !this.hasUseRemainder() && !this.hasUseCooldown() && !this.hasFood() && !this.hasTool() && !this.hasJukeboxPlayable() && !this.hasEquippable() && !this.hasDamageValue() && !this.hasMaxDamage() && !this.hasAttributeModifiers() && this.customTag == null && this.canPlaceOnPredicates == null && this.canBreakPredicates == null;
    }

    public Component displayName() {
        return this.displayName == null ? null : PaperAdventure.asAdventure(this.displayName);
    }

    public void displayName(Component displayName) {
        this.displayName = displayName == null ? null : PaperAdventure.asVanilla(displayName);
    }

    public String getDisplayName() {
        return CraftChatMessage.fromComponent(this.displayName);
    }

    public BaseComponent[] getDisplayNameComponent() {
        return this.displayName == null ? new BaseComponent[]{} : ComponentSerializer.parse((String)CraftChatMessage.toJSON(this.displayName));
    }

    public final void setDisplayName(String name) {
        this.displayName = CraftChatMessage.fromStringOrNull(name);
    }

    public void setDisplayNameComponent(BaseComponent[] component) {
        this.displayName = CraftChatMessage.fromJSON(ComponentSerializer.toString((BaseComponent[])component));
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public String getItemName() {
        return CraftChatMessage.fromComponent(this.itemName);
    }

    public final void setItemName(String name) {
        this.itemName = CraftChatMessage.fromStringOrNull(name);
    }

    public boolean hasItemName() {
        return this.itemName != null;
    }

    public Component itemName() {
        return PaperAdventure.asAdventure(this.itemName);
    }

    public void itemName(Component name) {
        this.itemName = PaperAdventure.asVanilla(name);
    }

    public String getLocalizedName() {
        return this.getDisplayName();
    }

    public void setLocalizedName(String name) {
    }

    public boolean hasLocalizedName() {
        return false;
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public List<Component> lore() {
        return this.lore != null ? PaperAdventure.asAdventure(this.lore) : null;
    }

    public void lore(List<? extends Component> lore) {
        Preconditions.checkArgument((lore == null || lore.size() <= 256 ? 1 : 0) != 0, (String)"lore cannot have more than %s lines", (int)256);
        this.lore = lore != null ? PaperAdventure.asVanilla(lore) : null;
    }

    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    public boolean hasEnchant(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        return this.hasEnchants() && this.enchantments.containsKey(ench);
    }

    public int getEnchantLevel(Enchantment ench) {
        Integer level;
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        Integer n = level = this.hasEnchants() ? (Integer)this.enchantments.get(ench) : null;
        if (level == null) {
            return 0;
        }
        return level;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableSortedMap.copyOfSorted((SortedMap)this.enchantments) : ImmutableMap.of();
    }

    public boolean addEnchant(Enchantment ench, int level, boolean ignoreRestrictions) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.enchantments == null) {
            this.enchantments = new EnchantmentMap();
        }
        if (ignoreRestrictions || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            Integer old = this.enchantments.put(ench, level);
            return old == null || old != level;
        }
        return false;
    }

    public boolean removeEnchant(Enchantment ench) {
        boolean enchantmentRemoved;
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        boolean bl = enchantmentRemoved = this.hasEnchants() && this.enchantments.remove(ench) != null;
        if (enchantmentRemoved && this.enchantments.isEmpty()) {
            this.enchantments = null;
        }
        return enchantmentRemoved;
    }

    public void removeEnchantments() {
        if (this.hasEnchants()) {
            this.enchantments = null;
        }
    }

    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    public boolean hasConflictingEnchant(Enchantment ench) {
        return CraftMetaItem.checkConflictingEnchants(this.enchantments, ench);
    }

    public void addItemFlags(ItemFlag ... hideFlags) {
        for (ItemFlag f : hideFlags) {
            this.hideFlag |= this.getBitModifier(f);
        }
    }

    public void removeItemFlags(ItemFlag ... hideFlags) {
        for (ItemFlag f : hideFlags) {
            this.hideFlag &= ~this.getBitModifier(f);
        }
    }

    public Set<ItemFlag> getItemFlags() {
        EnumSet<ItemFlag> currentFlags = EnumSet.noneOf(ItemFlag.class);
        for (ItemFlag f : ItemFlag.values()) {
            if (!this.hasItemFlag(f)) continue;
            currentFlags.add(f);
        }
        return currentFlags;
    }

    public boolean hasItemFlag(ItemFlag flag) {
        int bitModifier = this.getBitModifier(flag);
        return (this.hideFlag & bitModifier) == bitModifier;
    }

    private int getBitModifier(ItemFlag hideFlag) {
        return 1 << hideFlag.ordinal();
    }

    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList(Lists.transform(this.lore, CraftChatMessage::fromComponent));
    }

    public List<BaseComponent[]> getLoreComponents() {
        return this.lore == null ? null : new ArrayList(this.lore.stream().map(entry -> ComponentSerializer.parse((String)CraftChatMessage.toJSON(entry))).collect(Collectors.toList()));
    }

    public void setLore(List<String> lore) {
        Preconditions.checkArgument((lore == null || lore.size() <= 256 ? 1 : 0) != 0, (String)"lore cannot have more than %s lines", (int)256);
        if (lore == null || lore.isEmpty()) {
            this.lore = null;
        } else {
            if (this.lore == null) {
                this.lore = new ArrayList<net.minecraft.network.chat.Component>(lore.size());
            } else {
                this.lore.clear();
            }
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        }
    }

    public void setLoreComponents(List<BaseComponent[]> lore) {
        Preconditions.checkArgument((lore == null || lore.size() <= 256 ? 1 : 0) != 0, (String)"lore cannot have more than %s lines", (int)256);
        if (lore == null) {
            this.lore = null;
        } else if (this.lore == null) {
            this.lore = new ArrayList<net.minecraft.network.chat.Component>(lore.size());
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        } else {
            this.lore.clear();
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        }
    }

    public boolean hasCustomModelData() {
        return this.customModelData != null;
    }

    public int getCustomModelData() {
        Preconditions.checkState((boolean)this.hasCustomModelData(), (Object)"We don't have CustomModelData! Check hasCustomModelData first!");
        return this.customModelData;
    }

    public void setCustomModelData(Integer data) {
        this.customModelData = data;
    }

    public boolean hasEnchantable() {
        return this.enchantableValue != null;
    }

    public int getEnchantable() {
        Preconditions.checkState((boolean)this.hasEnchantable(), (Object)"We don't have Enchantable! Check hasEnchantable first!");
        return this.enchantableValue;
    }

    public void setEnchantable(Integer data) {
        Preconditions.checkArgument((data == null || data > 0 ? 1 : 0) != 0, (Object)"Enchantability must be positive");
        this.enchantableValue = data;
    }

    public boolean hasBlockData() {
        return this.blockData != null;
    }

    public BlockData getBlockData(Material material) {
        BlockState defaultData = CraftBlockType.bukkitToMinecraft(material).defaultBlockState();
        return CraftBlockData.fromData(this.hasBlockData() ? new BlockItemStateProperties(this.blockData).apply(defaultData) : defaultData);
    }

    public void setBlockData(BlockData blockData) {
        this.blockData = blockData == null ? null : ((CraftBlockData)blockData).toStates(true);
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    public boolean isHideTooltip() {
        return this.hideTooltip;
    }

    public void setHideTooltip(boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
    }

    public boolean hasTooltipStyle() {
        return this.tooltipStyle != null;
    }

    public NamespacedKey getTooltipStyle() {
        return this.tooltipStyle;
    }

    public void setTooltipStyle(NamespacedKey tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
    }

    public boolean hasItemModel() {
        return this.itemModel != null;
    }

    public NamespacedKey getItemModel() {
        return this.itemModel;
    }

    public void setItemModel(NamespacedKey itemModel) {
        this.itemModel = itemModel;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean hasEnchantmentGlintOverride() {
        return this.enchantmentGlintOverride != null;
    }

    public Boolean getEnchantmentGlintOverride() {
        Preconditions.checkState((boolean)this.hasEnchantmentGlintOverride(), (Object)"We don't have enchantment_glint_override! Check hasEnchantmentGlintOverride first!");
        return this.enchantmentGlintOverride;
    }

    public void setEnchantmentGlintOverride(Boolean override) {
        this.enchantmentGlintOverride = override;
    }

    public boolean isGlider() {
        return this.glider;
    }

    public void setGlider(boolean glider) {
        this.glider = glider;
    }

    public boolean isFireResistant() {
        return this.hasDamageResistant() && DamageTypeTags.IS_FIRE.equals(this.getDamageResistant());
    }

    public void setFireResistant(boolean fireResistant) {
        this.setDamageResistant((Tag<org.bukkit.damage.DamageType>)DamageTypeTags.IS_FIRE);
    }

    public boolean hasDamageResistant() {
        return this.damageResistant != null;
    }

    public Tag<org.bukkit.damage.DamageType> getDamageResistant() {
        return this.hasDamageResistant() ? Bukkit.getTag((String)"damage_types", (NamespacedKey)CraftNamespacedKey.fromMinecraft(this.damageResistant.location()), org.bukkit.damage.DamageType.class) : null;
    }

    public void setDamageResistant(Tag<org.bukkit.damage.DamageType> tag) {
        this.damageResistant = tag != null ? ((CraftDamageTag)tag).getHandle().key() : null;
    }

    public boolean hasMaxStackSize() {
        return this.maxStackSize != null;
    }

    public int getMaxStackSize() {
        Preconditions.checkState((boolean)this.hasMaxStackSize(), (Object)"We don't have max_stack_size! Check hasMaxStackSize first!");
        return this.maxStackSize;
    }

    public void setMaxStackSize(Integer max) {
        Preconditions.checkArgument((max == null || max > 0 ? 1 : 0) != 0, (Object)"max_stack_size must be > 0");
        Preconditions.checkArgument((max == null || max <= 99 ? 1 : 0) != 0, (Object)"max_stack_size must be <= 99");
        this.maxStackSize = max;
    }

    public boolean hasRarity() {
        return this.rarity != null;
    }

    public ItemRarity getRarity() {
        Preconditions.checkState((boolean)this.hasRarity(), (Object)"We don't have rarity! Check hasRarity first!");
        return this.rarity;
    }

    public void setRarity(ItemRarity rarity) {
        this.rarity = rarity;
    }

    public boolean hasUseRemainder() {
        return this.useRemainder != null;
    }

    public ItemStack getUseRemainder() {
        return this.useRemainder;
    }

    public void setUseRemainder(ItemStack useRemainder) {
        Preconditions.checkArgument((useRemainder == null || !useRemainder.isEmpty() ? 1 : 0) != 0, (Object)"Item cannot be empty");
        this.useRemainder = useRemainder;
    }

    public boolean hasUseCooldown() {
        return this.useCooldown != null;
    }

    public UseCooldownComponent getUseCooldown() {
        return this.hasUseCooldown() ? new CraftUseCooldownComponent(this.useCooldown) : new CraftUseCooldownComponent(new UseCooldown(1.0f));
    }

    public void setUseCooldown(UseCooldownComponent cooldown) {
        this.useCooldown = cooldown == null ? null : new CraftUseCooldownComponent((CraftUseCooldownComponent)cooldown);
    }

    public boolean hasFood() {
        return this.food != null;
    }

    public FoodComponent getFood() {
        return this.hasFood() ? new CraftFoodComponent(this.food) : new CraftFoodComponent(new FoodProperties(0, 0.0f, false));
    }

    public void setFood(FoodComponent food) {
        this.food = food == null ? null : new CraftFoodComponent((CraftFoodComponent)food);
    }

    public boolean hasTool() {
        return this.tool != null;
    }

    public ToolComponent getTool() {
        return this.hasTool() ? new CraftToolComponent(this.tool) : new CraftToolComponent(new Tool(Collections.emptyList(), 1.0f, 0));
    }

    public void setTool(ToolComponent tool) {
        this.tool = tool == null ? null : new CraftToolComponent((CraftToolComponent)tool);
    }

    public boolean hasEquippable() {
        return this.equippable != null;
    }

    public EquippableComponent getEquippable() {
        return this.hasEquippable() ? new CraftEquippableComponent(this.equippable) : new CraftEquippableComponent(Equippable.builder(net.minecraft.world.entity.EquipmentSlot.HEAD).build());
    }

    public void setEquippable(EquippableComponent equippable) {
        this.equippable = equippable == null ? null : new CraftEquippableComponent((CraftEquippableComponent)equippable);
    }

    public boolean hasJukeboxPlayable() {
        return this.jukebox != null;
    }

    public JukeboxPlayableComponent getJukeboxPlayable() {
        return this.hasJukeboxPlayable() ? new CraftJukeboxComponent(this.jukebox) : new CraftJukeboxComponent(new JukeboxPlayable(new EitherHolder<JukeboxSong>(JukeboxSongs.THIRTEEN), true));
    }

    public void setJukeboxPlayable(JukeboxPlayableComponent jukeboxPlayable) {
        this.jukebox = jukeboxPlayable == null ? null : new CraftJukeboxComponent((CraftJukeboxComponent)jukeboxPlayable);
    }

    public boolean hasAttributeModifiers() {
        return this.attributeModifiers != null && !this.attributeModifiers.isEmpty();
    }

    public Multimap<Attribute, org.bukkit.attribute.AttributeModifier> getAttributeModifiers() {
        return this.hasAttributeModifiers() ? ImmutableMultimap.copyOf(this.attributeModifiers) : null;
    }

    private void checkAttributeList() {
        if (this.attributeModifiers == null) {
            this.attributeModifiers = LinkedHashMultimap.create();
        }
    }

    public Multimap<Attribute, org.bukkit.attribute.AttributeModifier> getAttributeModifiers(@Nullable EquipmentSlot slot) {
        if (this.attributeModifiers == null) {
            return LinkedHashMultimap.create();
        }
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            if (!((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlotGroup().test(slot)) continue;
            result.put((Object)((Attribute)entry.getKey()), (Object)((org.bukkit.attribute.AttributeModifier)entry.getValue()));
        }
        return result;
    }

    public Collection<org.bukkit.attribute.AttributeModifier> getAttributeModifiers(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        if (this.attributeModifiers == null) {
            return null;
        }
        return this.attributeModifiers.containsKey((Object)attribute) ? ImmutableList.copyOf((Collection)this.attributeModifiers.get((Object)attribute)) : null;
    }

    public boolean addAttributeModifier(@Nonnull Attribute attribute, @Nonnull org.bukkit.attribute.AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        if (this.attributeModifiers != null) {
            for (Map.Entry entry : this.attributeModifiers.entries()) {
                Preconditions.checkArgument((!((org.bukkit.attribute.AttributeModifier)entry.getValue()).getKey().equals((Object)modifier.getKey()) || entry.getKey() != attribute ? 1 : 0) != 0, (String)"Cannot register AttributeModifier. Modifier is already applied! %s", (Object)modifier);
            }
        }
        this.checkAttributeList();
        return this.attributeModifiers.put((Object)attribute, (Object)modifier);
    }

    public void setAttributeModifiers(@Nullable Multimap<Attribute, org.bukkit.attribute.AttributeModifier> attributeModifiers) {
        if (attributeModifiers == null) {
            this.attributeModifiers = null;
            return;
        }
        if (attributeModifiers.isEmpty()) {
            this.attributeModifiers = LinkedHashMultimap.create();
            return;
        }
        if (this.attributeModifiers != null) {
            this.attributeModifiers.clear();
        }
        Iterator iterator = attributeModifiers.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (next.getKey() == null || next.getValue() == null) {
                iterator.remove();
                continue;
            }
            this.checkAttributeList();
            this.attributeModifiers.put((Object)((Attribute)next.getKey()), (Object)((org.bukkit.attribute.AttributeModifier)next.getValue()));
        }
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        if (this.attributeModifiers == null) {
            return false;
        }
        return !this.attributeModifiers.removeAll((Object)attribute).isEmpty();
    }

    public boolean removeAttributeModifier(@Nullable EquipmentSlot slot) {
        if (this.attributeModifiers == null) {
            return false;
        }
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlotGroup().test(slot)) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute, @Nonnull org.bukkit.attribute.AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        if (this.attributeModifiers == null) {
            return false;
        }
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (entry.getKey() == null || entry.getValue() == null) {
                iter.remove();
                ++removed;
                continue;
            }
            if (entry.getKey() != attribute || !((org.bukkit.attribute.AttributeModifier)entry.getValue()).getKey().equals((Object)modifier.getKey())) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public String getAsString() {
        Applicator tag = new Applicator(this){};
        this.applyToItem(tag);
        DataComponentPatch patch = tag.build();
        net.minecraft.nbt.Tag nbt = (net.minecraft.nbt.Tag)DataComponentPatch.CODEC.encodeStart(MinecraftServer.getDefaultRegistryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)patch).getOrThrow();
        return nbt.toString();
    }

    public String getAsComponentString() {
        Applicator tag = new Applicator(this){};
        this.applyToItem(tag);
        DataComponentPatch patch = tag.build();
        RegistryAccess registryAccess = CraftRegistry.getMinecraftRegistry();
        RegistryOps<net.minecraft.nbt.Tag> ops = registryAccess.createSerializationContext(NbtOps.INSTANCE);
        HolderLookup.RegistryLookup componentTypeRegistry = registryAccess.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
        StringJoiner componentString = new StringJoiner(",", "[", "]");
        for (Map.Entry<DataComponentType<?>, Optional<?>> entry : patch.entrySet()) {
            DataComponentType<?> componentType = entry.getKey();
            Optional<?> componentValue = entry.getValue();
            String componentKey = componentTypeRegistry.getResourceKey(componentType).orElseThrow().location().toString();
            if (componentValue.isPresent()) {
                net.minecraft.nbt.Tag componentValueAsNBT = (net.minecraft.nbt.Tag)componentType.codecOrThrow().encodeStart(ops, componentValue.get()).getOrThrow();
                String componentValueAsNBTString = new SnbtPrinterTagVisitor("", 0, new ArrayList<String>()).visit(componentValueAsNBT);
                componentString.add(componentKey + "=" + componentValueAsNBTString);
                continue;
            }
            componentString.add("!" + componentKey);
        }
        return componentString.toString();
    }

    public CustomItemTagContainer getCustomTagContainer() {
        return new DeprecatedCustomTagContainer(this.getPersistentDataContainer());
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    private static boolean compareModifiers(Multimap<Attribute, org.bukkit.attribute.AttributeModifier> first, Multimap<Attribute, org.bukkit.attribute.AttributeModifier> second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.isEmpty() && second.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : first.entries()) {
            if (second.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : second.entries()) {
            if (first.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean hasDamage() {
        return this.damage != null && this.damage > 0;
    }

    public int getDamage() {
        return this.damage == null ? 0 : this.damage;
    }

    public void setDamage(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (Object)"Damage cannot be negative");
        Preconditions.checkArgument((!this.hasMaxDamage() || damage <= this.maxDamage ? 1 : 0) != 0, (Object)"Damage cannot exceed max damage");
        this.damage = damage;
    }

    public boolean hasDamageValue() {
        return this.damage != null;
    }

    public void resetDamage() {
        this.damage = null;
    }

    public boolean hasMaxDamage() {
        return this.maxDamage != null;
    }

    public int getMaxDamage() {
        Preconditions.checkState((boolean)this.hasMaxDamage(), (Object)"We don't have max_damage! Check hasMaxDamage first!");
        return this.maxDamage;
    }

    public void setMaxDamage(Integer maxDamage) {
        Preconditions.checkArgument((maxDamage == null || maxDamage > 0 ? 1 : 0) != 0, (Object)"Max damage should be positive");
        this.maxDamage = maxDamage;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    @Overridden
    boolean equalsCommon(CraftMetaItem that) {
        return (this.hasDisplayName() ? that.hasDisplayName() && this.displayName.equals(that.displayName) : !that.hasDisplayName()) && (this.hasItemName() ? that.hasItemName() && this.itemName.equals(that.itemName) : !that.hasItemName()) && (this.hasEnchants() ? that.hasEnchants() && this.enchantments.equals(that.enchantments) : !that.hasEnchants()) && Objects.equals(this.lore, that.lore) && (this.hasCustomModelData() ? that.hasCustomModelData() && this.customModelData.equals(that.customModelData) : !that.hasCustomModelData()) && (this.hasEnchantable() ? that.hasEnchantable() && this.enchantableValue.equals(that.enchantableValue) : !that.hasEnchantable()) && (this.hasBlockData() ? that.hasBlockData() && this.blockData.equals(that.blockData) : !that.hasBlockData()) && (this.hasRepairCost() ? that.hasRepairCost() && this.repairCost == that.repairCost : !that.hasRepairCost()) && (this.attributeModifiers != null ? that.attributeModifiers != null && CraftMetaItem.compareModifiers(this.attributeModifiers, that.attributeModifiers) : that.attributeModifiers == null) && this.unhandledTags.equals(that.unhandledTags) && this.removedTags.equals(that.removedTags) && Objects.equals(this.customTag, that.customTag) && this.persistentDataContainer.equals(that.persistentDataContainer) && this.hideFlag == that.hideFlag && this.isHideTooltip() == that.isHideTooltip() && (this.hasTooltipStyle() ? that.hasTooltipStyle() && this.tooltipStyle.equals((Object)that.tooltipStyle) : !that.hasTooltipStyle()) && (this.hasItemModel() ? that.hasItemModel() && this.itemModel.equals((Object)that.itemModel) : !that.hasItemModel()) && this.isUnbreakable() == that.isUnbreakable() && (this.hasEnchantmentGlintOverride() ? that.hasEnchantmentGlintOverride() && this.enchantmentGlintOverride.equals(that.enchantmentGlintOverride) : !that.hasEnchantmentGlintOverride()) && this.glider == that.glider && (this.hasDamageResistant() ? that.hasDamageResistant() && this.damageResistant.equals(that.damageResistant) : !that.hasDamageResistant()) && (this.hasMaxStackSize() ? that.hasMaxStackSize() && this.maxStackSize.equals(that.maxStackSize) : !that.hasMaxStackSize()) && this.rarity == that.rarity && (this.hasUseRemainder() ? that.hasUseRemainder() && this.useRemainder.equals((Object)that.useRemainder) : !that.hasUseRemainder()) && (this.hasUseCooldown() ? that.hasUseCooldown() && this.useCooldown.equals(that.useCooldown) : !that.hasUseCooldown()) && (this.hasFood() ? that.hasFood() && this.food.equals(that.food) : !that.hasFood()) && (this.hasTool() ? that.hasTool() && this.tool.equals(that.tool) : !that.hasTool()) && (this.hasEquippable() ? that.hasEquippable() && this.equippable.equals(that.equippable) : !that.hasEquippable()) && (this.hasJukeboxPlayable() ? that.hasJukeboxPlayable() && this.jukebox.equals(that.jukebox) : !that.hasJukeboxPlayable()) && Objects.equals(this.damage, that.damage) && (this.hasMaxDamage() ? that.hasMaxDamage() && this.maxDamage.equals(that.maxDamage) : !that.hasMaxDamage()) && (this.canPlaceOnPredicates != null ? that.canPlaceOnPredicates != null && this.canPlaceOnPredicates.equals(that.canPlaceOnPredicates) : that.canPlaceOnPredicates == null) && (this.canBreakPredicates != null ? that.canBreakPredicates != null && this.canBreakPredicates.equals(that.canBreakPredicates) : that.canBreakPredicates == null) && this.version == that.version;
    }

    @Overridden
    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    @Overridden
    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasItemName() ? this.itemName.hashCode() : 0);
        hash = 61 * hash + (this.lore != null ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasCustomModelData() ? this.customModelData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchantable() ? this.enchantableValue.hashCode() : 0);
        hash = 61 * hash + (this.hasBlockData() ? this.blockData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        hash = 61 * hash + this.unhandledTags.hashCode();
        hash = 61 * hash + this.removedTags.hashCode();
        hash = 61 * hash + (this.customTag != null ? this.customTag.hashCode() : 0);
        hash = 61 * hash + (!this.persistentDataContainer.isEmpty() ? this.persistentDataContainer.hashCode() : 0);
        hash = 61 * hash + this.hideFlag;
        hash = 61 * hash + (this.isHideTooltip() ? 1231 : 1237);
        hash = 61 * hash + (this.hasTooltipStyle() ? this.tooltipStyle.hashCode() : 0);
        hash = 61 * hash + (this.hasItemModel() ? this.itemModel.hashCode() : 0);
        hash = 61 * hash + (this.isUnbreakable() ? 1231 : 1237);
        hash = 61 * hash + (this.hasEnchantmentGlintOverride() ? this.enchantmentGlintOverride.hashCode() : 0);
        hash = 61 * hash + (this.isGlider() ? 1231 : 1237);
        hash = 61 * hash + (this.hasDamageResistant() ? this.damageResistant.hashCode() : 0);
        hash = 61 * hash + (this.hasMaxStackSize() ? this.maxStackSize.hashCode() : 0);
        hash = 61 * hash + (this.hasRarity() ? this.rarity.hashCode() : 0);
        hash = 61 * hash + (this.hasUseRemainder() ? this.useRemainder.hashCode() : 0);
        hash = 61 * hash + (this.hasUseCooldown() ? this.useCooldown.hashCode() : 0);
        hash = 61 * hash + (this.hasFood() ? this.food.hashCode() : 0);
        hash = 61 * hash + (this.hasTool() ? this.tool.hashCode() : 0);
        hash = 61 * hash + (this.hasJukeboxPlayable() ? this.jukebox.hashCode() : 0);
        hash = 61 * hash + (this.hasEquippable() ? this.equippable.hashCode() : 0);
        hash = 61 * hash + (this.hasDamageValue() ? this.damage : -1);
        hash = 61 * hash + (this.hasMaxDamage() ? this.maxDamage.hashCode() : 0);
        hash = 61 * hash + (this.attributeModifiers != null ? this.attributeModifiers.hashCode() : 0);
        hash = 61 * hash + (this.canPlaceOnPredicates != null ? this.canPlaceOnPredicates.hashCode() : 0);
        hash = 61 * hash + (this.canBreakPredicates != null ? this.canBreakPredicates.hashCode() : 0);
        hash = 61 * hash + this.version;
        return hash;
    }

    @Overridden
    public CraftMetaItem clone() {
        try {
            CraftMetaItem clone = (CraftMetaItem)super.clone();
            if (this.lore != null) {
                clone.lore = new ArrayList<net.minecraft.network.chat.Component>(this.lore);
            }
            clone.customModelData = this.customModelData;
            clone.enchantableValue = this.enchantableValue;
            clone.blockData = this.blockData;
            if (this.enchantments != null) {
                clone.enchantments = new EnchantmentMap(this.enchantments);
            }
            if (this.attributeModifiers != null) {
                clone.attributeModifiers = LinkedHashMultimap.create(this.attributeModifiers);
            }
            if (this.customTag != null) {
                clone.customTag = this.customTag.copy();
            }
            clone.removedTags = Sets.newHashSet(this.removedTags);
            clone.persistentDataContainer = new CraftPersistentDataContainer(this.persistentDataContainer.getTagsCloned(), DATA_TYPE_REGISTRY);
            clone.hideFlag = this.hideFlag;
            clone.hideTooltip = this.hideTooltip;
            clone.tooltipStyle = this.tooltipStyle;
            clone.itemModel = this.itemModel;
            clone.unbreakable = this.unbreakable;
            clone.enchantmentGlintOverride = this.enchantmentGlintOverride;
            clone.glider = this.glider;
            clone.damageResistant = this.damageResistant;
            clone.maxStackSize = this.maxStackSize;
            clone.rarity = this.rarity;
            if (this.hasUseRemainder()) {
                clone.useRemainder = this.useRemainder.clone();
            }
            if (this.hasUseCooldown()) {
                clone.useCooldown = new CraftUseCooldownComponent(this.useCooldown);
            }
            if (this.hasFood()) {
                clone.food = new CraftFoodComponent(this.food);
            }
            if (this.hasTool()) {
                clone.tool = new CraftToolComponent(this.tool);
            }
            if (this.hasEquippable()) {
                clone.equippable = new CraftEquippableComponent(this.equippable);
            }
            if (this.hasJukeboxPlayable()) {
                clone.jukebox = new CraftJukeboxComponent(this.jukebox);
            }
            clone.damage = this.damage;
            clone.maxDamage = this.maxDamage;
            clone.version = this.version;
            if (this.canPlaceOnPredicates != null) {
                clone.canPlaceOnPredicates = List.copyOf(this.canPlaceOnPredicates);
            }
            if (this.canBreakPredicates != null) {
                clone.canBreakPredicates = List.copyOf(this.canBreakPredicates);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    @Overridden
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        boolean canPlaceOnAddToUnhandled;
        boolean canBreakAddToUnhandled;
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.displayName));
        }
        if (this.hasItemName()) {
            builder.put((Object)CraftMetaItem.ITEM_NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.itemName));
        }
        if (this.hasLore()) {
            ArrayList<String> jsonLore = new ArrayList<String>();
            for (net.minecraft.network.chat.Component component : this.lore) {
                jsonLore.add(CraftChatMessage.toJSON(component));
            }
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, jsonLore);
        }
        if (this.hasCustomModelData()) {
            builder.put((Object)CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, (Object)this.customModelData);
        }
        if (this.hasEnchantable()) {
            builder.put((Object)CraftMetaItem.ENCHANTABLE.BUKKIT, (Object)this.enchantableValue);
        }
        if (this.hasBlockData()) {
            builder.put((Object)CraftMetaItem.BLOCK_DATA.BUKKIT, this.blockData);
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        CraftMetaItem.serializeModifiers(this.attributeModifiers, builder, ATTRIBUTES);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        ArrayList<String> hideFlags = new ArrayList<String>();
        for (ItemFlag hideFlagEnum : this.getItemFlags()) {
            hideFlags.add(CraftItemFlag.bukkitToString(hideFlagEnum));
        }
        if (!hideFlags.isEmpty()) {
            builder.put((Object)CraftMetaItem.HIDEFLAGS.BUKKIT, hideFlags);
        }
        if (this.isHideTooltip()) {
            builder.put((Object)CraftMetaItem.HIDE_TOOLTIP.BUKKIT, (Object)this.hideTooltip);
        }
        if (this.hasTooltipStyle()) {
            builder.put((Object)CraftMetaItem.TOOLTIP_STYLE.BUKKIT, (Object)this.tooltipStyle.toString());
        }
        if (this.hasItemModel()) {
            builder.put((Object)CraftMetaItem.ITEM_MODEL.BUKKIT, (Object)this.itemModel.toString());
        }
        if (this.isUnbreakable()) {
            builder.put((Object)CraftMetaItem.UNBREAKABLE.BUKKIT, (Object)this.unbreakable);
        }
        if (this.hasEnchantmentGlintOverride()) {
            builder.put((Object)CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, (Object)this.enchantmentGlintOverride);
        }
        if (this.isGlider()) {
            builder.put((Object)CraftMetaItem.GLIDER.BUKKIT, (Object)this.glider);
        }
        if (this.hasDamageResistant()) {
            builder.put((Object)CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, (Object)this.damageResistant.location().toString());
        }
        if (this.hasMaxStackSize()) {
            builder.put((Object)CraftMetaItem.MAX_STACK_SIZE.BUKKIT, (Object)this.maxStackSize);
        }
        if (this.hasRarity()) {
            builder.put((Object)CraftMetaItem.RARITY.BUKKIT, (Object)this.rarity.name());
        }
        if (this.hasUseRemainder()) {
            builder.put((Object)CraftMetaItem.USE_REMAINDER.BUKKIT, (Object)this.useRemainder);
        }
        if (this.hasUseCooldown()) {
            builder.put((Object)CraftMetaItem.USE_COOLDOWN.BUKKIT, (Object)this.useCooldown);
        }
        if (this.hasFood()) {
            builder.put((Object)CraftMetaItem.FOOD.BUKKIT, (Object)this.food);
        }
        if (this.hasTool()) {
            builder.put((Object)CraftMetaItem.TOOL.BUKKIT, (Object)this.tool);
        }
        if (this.hasEquippable()) {
            builder.put((Object)CraftMetaItem.EQUIPPABLE.BUKKIT, (Object)this.equippable);
        }
        if (this.hasJukeboxPlayable()) {
            builder.put((Object)CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, (Object)this.jukebox);
        }
        if (this.hasDamageValue()) {
            builder.put((Object)CraftMetaItem.DAMAGE.BUKKIT, (Object)this.damage);
        }
        if (this.hasMaxDamage()) {
            builder.put((Object)CraftMetaItem.MAX_DAMAGE.BUKKIT, (Object)this.maxDamage);
        }
        HashMap<String, net.minecraft.nbt.Tag> internalTags = new HashMap<String, net.minecraft.nbt.Tag>();
        this.serializeInternal(internalTags);
        if (!internalTags.isEmpty()) {
            CompoundTag internal = new CompoundTag();
            for (Map.Entry e : internalTags.entrySet()) {
                internal.put((String)e.getKey(), (net.minecraft.nbt.Tag)e.getValue());
            }
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                NbtIo.writeCompressed(internal, buf);
                builder.put((Object)"internal", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        boolean bl = canBreakAddToUnhandled = this.canBreakPredicates != null && !this.canBreakPredicates.isEmpty();
        if (canBreakAddToUnhandled) {
            this.unhandledTags.set(DataComponents.CAN_BREAK, new AdventureModePredicate(this.canBreakPredicates, !this.hasItemFlag(ItemFlag.HIDE_DESTROYS)));
        }
        boolean bl2 = canPlaceOnAddToUnhandled = this.canPlaceOnPredicates != null && !this.canPlaceOnPredicates.isEmpty();
        if (canPlaceOnAddToUnhandled) {
            this.unhandledTags.set(DataComponents.CAN_PLACE_ON, new AdventureModePredicate(this.canPlaceOnPredicates, !this.hasItemFlag(ItemFlag.HIDE_PLACED_ON)));
        }
        if (!this.unhandledTags.isEmpty()) {
            net.minecraft.nbt.Tag unhandled = (net.minecraft.nbt.Tag)DataComponentPatch.CODEC.encodeStart(MinecraftServer.getDefaultRegistryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)this.unhandledTags.build()).getOrThrow(IllegalStateException::new);
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                NbtIo.writeCompressed((CompoundTag)unhandled, buf);
                builder.put((Object)"unhandled", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (canBreakAddToUnhandled) {
            this.unhandledTags.clear(DataComponents.CAN_BREAK);
        }
        if (canPlaceOnAddToUnhandled) {
            this.unhandledTags.clear(DataComponents.CAN_PLACE_ON);
        }
        if (!this.removedTags.isEmpty()) {
            RegistryAccess registryAccess = CraftRegistry.getMinecraftRegistry();
            HolderLookup.RegistryLookup componentTypeRegistry = registryAccess.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
            ArrayList<String> removedTags = new ArrayList<String>();
            for (DataComponentType<?> removed : this.removedTags) {
                String componentKey = componentTypeRegistry.getResourceKey(removed).orElseThrow().location().toString();
                removedTags.add(componentKey);
            }
            builder.put((Object)"removed", removedTags);
        }
        if (!this.persistentDataContainer.isEmpty()) {
            builder.put((Object)CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, (Object)this.persistentDataContainer.serialize());
        }
        if (this.customTag != null) {
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                NbtIo.writeCompressed(this.customTag, buf);
                builder.put((Object)"custom", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return builder;
    }

    void serializeInternal(Map<String, net.minecraft.nbt.Tag> unhandledTags) {
    }

    static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)CraftEnchantment.bukkitToString(enchant.getKey()), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    static void serializeModifiers(Multimap<Attribute, org.bukkit.attribute.AttributeModifier> modifiers, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (modifiers == null) {
            return;
        }
        LinkedHashMap mods = new LinkedHashMap();
        for (Map.Entry entry : modifiers.entries()) {
            Collection modCollection;
            if (entry.getKey() == null || (modCollection = modifiers.get((Object)((Attribute)entry.getKey()))) == null || modCollection.isEmpty()) continue;
            mods.put(CraftAttribute.bukkitToString((Attribute)entry.getKey()), new ArrayList(modCollection));
        }
        builder.put((Object)key.BUKKIT, mods);
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<net.minecraft.network.chat.Component> addTo, boolean possiblyJsonInput) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            net.minecraft.network.chat.Component component;
            if (object instanceof BaseComponent[]) {
                BaseComponent[] baseComponentArr = (BaseComponent[])object;
                addTo.add(CraftChatMessage.fromJSON(ComponentSerializer.toString((BaseComponent[])baseComponentArr)));
                continue;
            }
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(String.valueOf(addFrom) + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add(net.minecraft.network.chat.Component.empty());
                continue;
            }
            String entry = object.toString();
            net.minecraft.network.chat.Component component2 = component = possiblyJsonInput ? CraftChatMessage.fromJSONOrString(entry) : CraftChatMessage.fromStringOrNull(entry);
            if (component != null) {
                addTo.add(component);
                continue;
            }
            addTo.add(net.minecraft.network.chat.Component.empty());
        }
    }

    static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        for (Enchantment enchant : enchantments.keySet()) {
            if (!enchant.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return (String)SerializableMeta.classMap.get(this.getClass()) + "_META:" + String.valueOf(this.serialize());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<DataComponentType<?>> getTopLevelHandledDcts(Class<? extends CraftMetaItem> clazz) {
        Map<Class<? extends CraftMetaItem>, Set<DataComponentType<?>>> map = HANDLED_DCTS_PER_TYPE;
        synchronized (map) {
            if (HANDLED_DCTS_PER_TYPE.isEmpty()) {
                HashMap map2 = new HashMap();
                map2.put(CraftMetaArmor.class, Set.of(CraftMetaArmor.TRIM.TYPE));
                map2.put(CraftMetaArmorStand.class, Set.of(CraftMetaArmorStand.ENTITY_TAG.TYPE));
                map2.put(CraftMetaAxolotlBucket.class, Set.of(CraftMetaAxolotlBucket.ENTITY_TAG.TYPE, CraftMetaAxolotlBucket.BUCKET_ENTITY_TAG.TYPE));
                map2.put(CraftMetaBanner.class, Set.of(CraftMetaBanner.PATTERNS.TYPE));
                map2.put(CraftMetaShield.class, Set.of(CraftMetaShield.BASE_COLOR.TYPE, CraftMetaBanner.PATTERNS.TYPE));
                map2.put(CraftMetaBlockState.class, Set.of(CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE));
                map2.put(CraftMetaBook.class, Set.of(CraftMetaBook.BOOK_CONTENT.TYPE));
                map2.put(CraftMetaBookSigned.class, Set.of(CraftMetaBookSigned.BOOK_CONTENT.TYPE));
                map2.put(CraftMetaBundle.class, Set.of(CraftMetaBundle.ITEMS.TYPE));
                map2.put(CraftMetaCharge.class, Set.of(CraftMetaCharge.EXPLOSION.TYPE));
                map2.put(CraftMetaColorableArmor.class, Set.of(CraftMetaArmor.TRIM.TYPE, CraftMetaLeatherArmor.COLOR.TYPE));
                map2.put(CraftMetaCompass.class, Set.of(CraftMetaCompass.LODESTONE_TARGET.TYPE));
                map2.put(CraftMetaCrossbow.class, Set.of(CraftMetaCrossbow.CHARGED_PROJECTILES.TYPE));
                map2.put(CraftMetaEnchantedBook.class, Set.of(CraftMetaEnchantedBook.STORED_ENCHANTMENTS.TYPE));
                map2.put(CraftMetaEntityTag.class, Set.of(CraftMetaEntityTag.ENTITY_TAG.TYPE));
                map2.put(CraftMetaFirework.class, Set.of(CraftMetaFirework.FIREWORKS.TYPE));
                map2.put(CraftMetaKnowledgeBook.class, Set.of(CraftMetaKnowledgeBook.BOOK_RECIPES.TYPE));
                map2.put(CraftMetaLeatherArmor.class, Set.of(CraftMetaLeatherArmor.COLOR.TYPE));
                map2.put(CraftMetaMap.class, Set.of(CraftMetaMap.MAP_COLOR.TYPE, CraftMetaMap.MAP_POST_PROCESSING.TYPE, CraftMetaMap.MAP_ID.TYPE));
                map2.put(CraftMetaMusicInstrument.class, Set.of(CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.TYPE));
                map2.put(CraftMetaOminousBottle.class, Set.of(CraftMetaOminousBottle.OMINOUS_BOTTLE_AMPLIFIER.TYPE));
                map2.put(CraftMetaPotion.class, Set.of(CraftMetaPotion.POTION_CONTENTS.TYPE));
                map2.put(CraftMetaSkull.class, Set.of(CraftMetaSkull.SKULL_PROFILE.TYPE, CraftMetaSkull.NOTE_BLOCK_SOUND.TYPE));
                map2.put(CraftMetaSpawnEgg.class, Set.of(CraftMetaSpawnEgg.ENTITY_TAG.TYPE));
                map2.put(CraftMetaSuspiciousStew.class, Set.of(CraftMetaSuspiciousStew.EFFECTS.TYPE));
                map2.put(CraftMetaTropicalFishBucket.class, Set.of(CraftMetaTropicalFishBucket.ENTITY_TAG.TYPE, CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.TYPE));
                for (Map.Entry entry : map2.entrySet()) {
                    ArrayList topLevelTags = new ArrayList((Collection)entry.getValue());
                    topLevelTags.addAll(DEFAULT_HANDLED_DCTS);
                    HANDLED_DCTS_PER_TYPE.put((Class)entry.getKey(), Set.copyOf(topLevelTags));
                }
            }
            return HANDLED_DCTS_PER_TYPE.getOrDefault(clazz, DEFAULT_HANDLED_DCTS);
        }
    }

    protected static <T> Optional<? extends T> getOrEmpty(DataComponentPatch tag, ItemMetaKeyType<T> type) {
        return CraftMetaItem.getOrEmpty(tag, type.TYPE);
    }

    protected static <T> Optional<? extends T> getOrEmpty(DataComponentPatch tag, DataComponentType<T> type) {
        Optional<T> result = tag.get(type);
        return result != null ? result : Optional.empty();
    }

    public Set<Material> getCanDestroy() {
        return !this.hasDestroyableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyMaterial(this.canBreakPredicates);
    }

    public void setCanDestroy(Set<Material> canDestroy) {
        Preconditions.checkArgument((canDestroy != null ? 1 : 0) != 0, (Object)"Cannot replace with null set!");
        this.canBreakPredicates = CraftMetaItem.convertFromLegacyMaterial(canDestroy);
    }

    public Set<Material> getCanPlaceOn() {
        return !this.hasPlaceableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyMaterial(this.canPlaceOnPredicates);
    }

    public void setCanPlaceOn(Set<Material> canPlaceOn) {
        Preconditions.checkArgument((canPlaceOn != null ? 1 : 0) != 0, (Object)"Cannot replace with null set!");
        this.canPlaceOnPredicates = CraftMetaItem.convertFromLegacyMaterial(canPlaceOn);
    }

    private static List<BlockPredicate> convertFromLegacyMaterial(Collection<Material> materials) {
        HolderLookup.RegistryLookup blockRegistry = MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.BLOCK);
        return materials.stream().map(arg_0 -> CraftMetaItem.lambda$convertFromLegacyMaterial$37((net.minecraft.core.Registry)blockRegistry, arg_0)).toList();
    }

    private static Set<Material> convertToLegacyMaterial(List<BlockPredicate> predicates) {
        return predicates.stream().flatMap(p -> p.blocks().map(HolderSet::stream).orElse(Stream.empty())).map(holder -> CraftBlockType.minecraftToBukkit((Block)holder.value())).collect(Collectors.toSet());
    }

    public Set<Namespaced> getDestroyableKeys() {
        return !this.hasDestroyableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyNamespaced(this.canBreakPredicates);
    }

    public void setDestroyableKeys(Collection<Namespaced> canDestroy) {
        Preconditions.checkArgument((canDestroy != null ? 1 : 0) != 0, (Object)"Cannot replace with null collection!");
        Preconditions.checkArgument((boolean)CraftMetaItem.ofAcceptableType(canDestroy), (Object)"Can only use NamespacedKey or NamespacedTag objects!");
        this.canBreakPredicates = CraftMetaItem.convertFromLegacyNamespaced(canDestroy);
    }

    public Set<Namespaced> getPlaceableKeys() {
        return !this.hasPlaceableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyNamespaced(this.canPlaceOnPredicates);
    }

    public void setPlaceableKeys(Collection<Namespaced> canPlaceOn) {
        Preconditions.checkArgument((canPlaceOn != null ? 1 : 0) != 0, (Object)"Cannot replace with null collection!");
        Preconditions.checkArgument((boolean)CraftMetaItem.ofAcceptableType(canPlaceOn), (Object)"Can only use NamespacedKey or NamespacedTag objects!");
        this.canPlaceOnPredicates = CraftMetaItem.convertFromLegacyNamespaced(canPlaceOn);
    }

    private static List<BlockPredicate> convertFromLegacyNamespaced(Collection<Namespaced> namespaceds) {
        ArrayList<BlockPredicate> predicates = new ArrayList<BlockPredicate>();
        HolderLookup.RegistryLookup blockRegistry = MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.BLOCK);
        for (Namespaced namespaced : namespaceds) {
            if (namespaced instanceof NamespacedKey) {
                NamespacedKey key = (NamespacedKey)namespaced;
                predicates.add(BlockPredicate.Builder.block().of((HolderGetter<Block>)blockRegistry, CraftBlockType.bukkitToMinecraft(Objects.requireNonNull((Material)Registry.MATERIAL.get(key)))).build());
                continue;
            }
            if (!(namespaced instanceof NamespacedTag)) continue;
            NamespacedTag tag = (NamespacedTag)namespaced;
            predicates.add(BlockPredicate.Builder.block().of((HolderGetter<Block>)blockRegistry, TagKey.create(Registries.BLOCK, ResourceLocation.fromNamespaceAndPath(tag.getNamespace(), tag.getKey()))).build());
        }
        return predicates;
    }

    private static Set<Namespaced> convertToLegacyNamespaced(Collection<BlockPredicate> predicates) {
        HashSet namespaceds = Sets.newHashSet();
        for (BlockPredicate predicate : predicates) {
            if (predicate.blocks().isEmpty()) continue;
            HolderSet<Block> holders = predicate.blocks().get();
            if (holders instanceof HolderSet.Named) {
                HolderSet.Named named = (HolderSet.Named)holders;
                namespaceds.add(new NamespacedTag(named.key().location().getNamespace(), named.key().location().getPath()));
                continue;
            }
            holders.forEach(h -> h.unwrapKey().ifPresent(key -> namespaceds.add(new NamespacedKey(key.location().getNamespace(), key.location().getPath()))));
        }
        return namespaceds;
    }

    public boolean hasPlaceableKeys() {
        return this.canPlaceOnPredicates != null;
    }

    public boolean hasDestroyableKeys() {
        return this.canBreakPredicates != null;
    }

    private static boolean ofAcceptableType(Collection<Namespaced> namespacedResources) {
        for (Namespaced resource : namespacedResources) {
            if (resource instanceof NamespacedKey || resource instanceof NamespacedTag) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ BlockPredicate lambda$convertFromLegacyMaterial$37(net.minecraft.core.Registry blockRegistry, Material m) {
        return BlockPredicate.Builder.block().of((HolderGetter<Block>)blockRegistry, CraftBlockType.bukkitToMinecraft(m)).build();
    }

    private static class EnchantmentMap
    extends TreeMap<Enchantment, Integer> {
        private EnchantmentMap(Map<Enchantment, Integer> enchantments) {
            this();
            this.putAll(enchantments);
        }

        private EnchantmentMap() {
            super(Comparator.comparing(o -> o.getKey().toString()));
        }

        @Override
        public EnchantmentMap clone() {
            return (EnchantmentMap)super.clone();
        }
    }

    static final class ItemMetaKeyType<T>
    extends ItemMetaKey {
        final DataComponentType<T> TYPE;

        ItemMetaKeyType(DataComponentType<T> type) {
            this(type, null, null);
        }

        ItemMetaKeyType(DataComponentType<T> type, String both) {
            this(type, both, both);
        }

        ItemMetaKeyType(DataComponentType<T> type, String nbt, String bukkit) {
            super(nbt, bukkit);
            this.TYPE = type;
        }
    }

    static class ItemMetaKey {
        final String BUKKIT;
        final String NBT;

        ItemMetaKey(String both) {
            this(both, both);
        }

        ItemMetaKey(String nbt, String bukkit) {
            this.NBT = nbt;
            this.BUKKIT = bukkit;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.FIELD})
        static @interface Specific {
            public To value();

            public static enum To {
                BUKKIT,
                NBT;

            }
        }
    }

    static abstract class Applicator {
        final DataComponentPatch.Builder builder = DataComponentPatch.builder();

        Applicator() {
        }

        void skullCallback(ResolvableProfile resolvableProfile) {
        }

        <T> Applicator put(ItemMetaKeyType<T> key, T value) {
            this.builder.set(key.TYPE, value);
            return this;
        }

        <T> Applicator putIfAbsent(TypedDataComponent<?> component) {
            if (!this.builder.isSet(component.type())) {
                this.builder.set(component);
            }
            return this;
        }

        DataComponentPatch build() {
            return this.builder.build();
        }
    }
}

